/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.pay.PayConstant;
import com.xunlei.niux.center.so.pay.PayUtil;
import com.xunlei.niux.center.util.FileUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PayGatewayCallBackCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PayGatewayCallBackCmd.class.getName());
    private static SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMddHHmmss");
    private static String gamedatafilepath = EnvPropertyUtil.loadProperty("niux", "gamedatafilepath");
    private static String rsyncgamedata = EnvPropertyUtil.loadProperty("niux", "rsyncgamedata");
    private static final String SUCCESS = "<xlresult>Y</xlresult>";
    private static final String FAILURE = "<xlresult>N</xlresult>";

    @CmdMapper(value={"/pay/paygatewaycallback.do"})
    public Object payCallBack(XLHttpRequest request, XLHttpResponse response) {
        String version = request.getParameter("version");
        String orderId = request.getParameter("orderId");
        Long orderAmt = request.getParameterLong("orderAmt");
        String orderTime = request.getParameter("orderTime");
        String xlpayId = request.getParameter("xlpayId");
        String xlpayTime = request.getParameter("xlpayTime", "");
        String ext1 = request.getParameter("ext1", "");
        String ext2 = request.getParameter("ext2", "");
        String payResult = request.getParameter("payResult", "");
        String signMsg = request.getParameter("signMsg");
        Long fareamt = request.getParameterLong("fareamt", 0L);
        String bizpwd = PayConstant.whitevipbizpwd;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        param.put("orderId", orderId);
        param.put("orderAmt", orderAmt + "");
        param.put("orderTime", orderTime);
        param.put("xlpayId", xlpayId);
        param.put("xlpayTime", xlpayTime);
        param.put("ext1", ext1);
        param.put("ext2", ext2);
        param.put("payResult", payResult);
        String newSignMsg = PayUtil.sign(PayUtil.getSignatureContent(param), bizpwd);
        if (!signMsg.equals(newSignMsg)) {
            logger.error("\u65e7\u5bc6\u6587{}\u4e0e\u65b0\u5bc6\u6587{}\u4e0d\u4e00\u81f4", (Object)signMsg, (Object)newSignMsg);
            return FAILURE;
        }
        try {
            PayOrder payOrder = FacadeFactory.INSTANCE.getPayOrderBo().findByOrderNo(orderId);
            String rechargeTime = this.formatTime(xlpayTime);
            rechargeTime = "".equals(rechargeTime) ? sdf1.format(new Date()) : rechargeTime;
            payOrder.setPayTime(rechargeTime);
            if ("00".equals(payResult)) {
                if ("3".equals(payOrder.getOrderStatus())) {
                    return SUCCESS;
                }
                if (payOrder.getOrderAmt() != (double)orderAmt.longValue() * 0.01) {
                    throw new Exception("\u8ba2\u5355[" + orderId + "]\u7684\u56de\u8c03\u91d1\u989d" + orderAmt + "\u5206\u4e0e\u5b9e\u9645\u91d1\u989d" + payOrder.getOrderAmt() + "\u5143\u4e0d\u4e00\u81f4");
                }
                Long factamt = orderAmt - fareamt;
                payOrder.setFactAmt((double)factamt.longValue() * 0.01);
                payOrder.setFareAmt((double)fareamt.longValue() * 0.01);
                payOrder.setOrderStatus("3");
                payOrder.setRechargeStatus("0");
                FacadeFactory.INSTANCE.getPayOrderBo().updateSuccessOrder(payOrder);
                this.countPayOrderSuccessNum();
            } else {
                payOrder.setOrderStatus("2");
            }
            FacadeFactory.INSTANCE.getPayOrderBo().update(payOrder);
            return SUCCESS;
        }
        catch (Exception e) {
            logger.error("\u56de\u8c03\u5f02\u5e38", e);
            return FAILURE;
        }
    }

    private String formatTime(String xlpaytime) {
        try {
            if (xlpaytime == null || "".equals(xlpaytime)) {
                return "";
            }
            return sdf1.format(sdf2.parse(xlpaytime));
        }
        catch (Exception e) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u95ee\u9898", e);
        }
    }

    private void countPayOrderSuccessNum() {
        try {
            PayOrder payOrder = new PayOrder();
            payOrder.setOrderStatus("3");
            int count = FacadeFactory.INSTANCE.getPayOrderBo().count(payOrder);
            String json = "{\"totalordernum\":" + count + "}";
            FileUtil.writeByChar(gamedatafilepath, "vippayorderstat.js", "vippayorderstat=" + json);
            Runtime.getRuntime().exec(rsyncgamedata);
        }
        catch (Exception e) {
            logger.error("\u7edf\u8ba1\u6210\u529f\u8ba2\u5355\u51fa\u73b0\u5f02\u5e38", e);
        }
    }
}

