/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.center.serviceutils.GiftUtils;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.LastBindUserRecord;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.util.Log;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FirstBindUserPaymentCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(FirstBindUserPaymentCmd.class);
    private static long cashGiftId = 1078L;
    private static String giftType = "niuxgift";
    private static String cashGiftActNo = "paymentcashgift";
    private String msg;

    @CmdMapper(value={"/firstbindpayment/isCanBePayment.do"})
    public Object isCanBePayment(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        if (userId <= 0L) {
            logger.error("\u7528\u6237\u767b\u9646\u4fe1\u606f\u9519\u8bef\uff01");
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.USERLOGINERROR, "\u7528\u6237\u767b\u9646\u4fe1\u606f\u9519\u8bef\uff01");
        }
        if (!this.isUserCanHasPayment(userId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.NODATAFOUND, "sorry\uff0c\u4f60\u4e0d\u80fd\u83b7\u5f97\u8d54\u507f\uff01");
        }
        if (GiftUtils.alreadyGotGiftCount(cashGiftActNo, cashGiftId, userId) > 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.ALREADYPAYEDERROR, "sorry\uff0c\u4f60\u5df2\u7ecf\u83b7\u5f97\u8d54\u507f\uff01");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, "\u606d\u559c\u4f60\uff0c\u53ef\u4ee5\u83b7\u5f97\u8d54\u507f\u54e6\uff5e");
    }

    @CmdMapper(value={"/firstbindpayment/doPayment.do"})
    public Object doPayment(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        if (userId <= 0L) {
            logger.error("\u7528\u6237\u767b\u9646\u4fe1\u606f\u9519\u8bef\uff01");
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.USERLOGINERROR, "\u7528\u6237\u767b\u9646\u4fe1\u606f\u9519\u8bef\uff01");
        }
        if (!this.isUserCanHasPayment(userId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.NODATAFOUND, "sorry\uff0c\u4f60\u4e0d\u80fd\u83b7\u5f97\u8d54\u507f\uff01");
        }
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, cashGiftId);
        if (gift == null) {
            this.msg = "\u793c\u5305\u4e0d\u5b58\u5728\uff01giftId=" + cashGiftId;
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOPAYMENTERROR, this.msg);
        }
        GiftRecord result = null;
        try {
            result = GiftUtils.releaseGift(cashGiftActNo, cashGiftId, giftType, userId, 1, 0);
            if (result == null) {
                throw new RuntimeException("\u83b7\u5f97\u793c\u5305\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            this.msg = "\u7528\u6237[" + userId + "]\u9886\u53d6\u73b0\u91d1\u793c\u5305\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOPAYMENTERROR, this.msg);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, "\u606d\u559c\u4f60\u83b7\u5f97\u4e86#" + gift.getGiftName() + "#");
    }

    private boolean isUserCanHasPayment(Long userId) {
        if (userId <= 0L) {
            return false;
        }
        LastBindUserRecord query = new LastBindUserRecord();
        query.setUserId(userId);
        List<LastBindUserRecord> userRecordList = FacadeFactory.INSTANCE.getBaseBo().findObjects(query, new Page());
        return !CollectionUtils.isEmpty(userRecordList);
    }
}

