/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.pay.BuyVipCmd;
import com.xunlei.niux.center.so.pay.PayRequest;
import com.xunlei.niux.center.so.pay.PayResponse;
import com.xunlei.niux.center.so.pay.channel.LeiDianDirectPay;
import com.xunlei.niux.center.so.pay.channel.NetBankRedirectPay;
import com.xunlei.niux.center.util.ErrorMsg;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BuyVipCmd_dpqk
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BuyVipCmd.class.getName());
    private static final String ISTEST = EnvPropertyUtil.loadProperty("pay", "istest_dpqk");
    private static final String TESTUSERNAME = EnvPropertyUtil.loadProperty("pay", "testusername");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String activityNo = "by_kfrbuyvip";

    @CmdMapper(value={"/pay/buyvipdpqk.do"})
    public Object buyVip(XLHttpRequest request, XLHttpResponse response) {
        try {
            String clientIp = request.getRemoteIP();
            MainParam mainParam = this.checkSession(request, response);
            BuyVipCmd_dpqk.checkActVaild();
            PayRequest payRequest = new PayRequest();
            payRequest.productName = "\u767d\u91d1\u4f1a\u5458";
            payRequest.productNo = "whitevip";
            payRequest.orderAmt = request.getParameterDouble("orderAmt", 0.0);
            payRequest.userName = this.getUserName(request);
            payRequest.orderAmt = "1".equals(ISTEST) && TESTUSERNAME.contains(payRequest.userName) ? Double.valueOf(1.0) : Double.valueOf(15.0);
            payRequest.productNum = 1;
            payRequest.payPwd = request.getParameter("payPwd", "");
            payRequest.userId = request.getCookieValue("userid");
            payRequest.payType = request.getParameter("payType", "");
            payRequest.bankNo = request.getParameter("bankNo", "");
            payRequest.tempOrderNo = request.getParameter("tempOrderNo", "");
            payRequest.clientIp = clientIp;
            payRequest.xlHttpResponse = response;
            payRequest.actNo = activityNo;
            PayResponse payResponse = this.dealPay(payRequest);
            if (payResponse == null) {
                payResponse = new PayResponse();
                payResponse.setCode("99");
                payResponse.setMsg("\u652f\u4ed8\u5931\u8d25");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, payResponse);
            }
            if ("00".equals(payResponse.getCode())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, payResponse);
            }
            payResponse.setMsg(ErrorMsg.getPayErrorMsg(payResponse.getCode()));
            return JsonObjectUtil.getRtnAndDataJsonObject(1, payResponse);
        }
        catch (NiuExceptionAndCode e) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", e.getMessage());
            rmap.put("code", e.code);
            logger.error("\u83b7\u53d6\u6e38\u620f\u5143\u5b9d\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
        catch (Exception e) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", e.getMessage());
            rmap.put("code", "99");
            logger.error("\u83b7\u53d6\u6e38\u620f\u5143\u5b9d\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
    }

    @CmdMapper(value={"/pay/countbuyvipnum.do"})
    public Object countbuyvipnum(XLHttpRequest request, XLHttpResponse response) {
        PayOrder qpayorder = new PayOrder();
        qpayorder.setOrderStatus("3");
        qpayorder.setActNo(activityNo);
        int count = FacadeFactory.INSTANCE.getPayOrderBo().count(qpayorder);
        HashMap<String, String> rmap = new HashMap<String, String>();
        rmap.put("num", count + "");
        rmap.put("code", "00");
        return JsonObjectUtil.getRtnAndDataJsonObject(0, rmap);
    }

    private PayResponse dealPay(PayRequest payRequest) {
        if ("A1".equals(payRequest.payType)) {
            return new LeiDianDirectPay().pay(payRequest);
        }
        if (payRequest.payType.startsWith("B")) {
            return new NetBankRedirectPay().pay(payRequest);
        }
        if ("E".equals(payRequest.payType)) {
            return new NetBankRedirectPay().pay(payRequest);
        }
        if ("E2".equals(payRequest.payType)) {
            return new NetBankRedirectPay().pay(payRequest);
        }
        PayResponse payResponse = new PayResponse();
        payResponse.setCode("13");
        payResponse.setMsg("\u652f\u4ed8\u65b9\u5f0f[" + payRequest.payType + "]\u4e0d\u5b58\u5728");
        return payResponse;
    }

    private MainParam checkSession(XLHttpRequest request, XLHttpResponse response) throws NiuExceptionAndCode {
        try {
            return this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            throw new NiuExceptionAndCode("99", "\u767b\u5f55\u6001\u5931\u6548", e);
        }
    }

    private static void checkActVaild() throws NiuExceptionAndCode, Exception {
        Date now = new Date();
        Date from = sdf.parse("2013-04-25 10:00:00");
        Date end = sdf.parse("2013-04-28 24:00:00");
        if (now.getTime() < from.getTime()) {
            throw new NiuExceptionAndCode("99", "\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb");
        }
        if (now.getTime() > end.getTime()) {
            throw new NiuExceptionAndCode("99", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
    }
}

