/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.pay.PayRequest;
import com.xunlei.niux.center.so.pay.PayResponse;
import com.xunlei.niux.center.so.pay.channel.LeiDianDirectPay;
import com.xunlei.niux.center.so.pay.channel.NetBankRedirectPay;
import com.xunlei.niux.center.util.ErrorMsg;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BuyVipCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BuyVipCmd.class.getName());
    private static final String ISTEST = EnvPropertyUtil.loadProperty("pay", "istest");
    private static final String TESTUSERNAME = EnvPropertyUtil.loadProperty("pay", "testusername");
    private static final String LASTTIME = "";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/pay/buyvip.do"})
    public Object buyVip(XLHttpRequest request, XLHttpResponse response) {
        if (!BuyVipCmd.checkActValidTime()) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("99");
            payResponse.setMsg("\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\uff0c\u8c22\u8c22\u53c2\u4e0e\uff01");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, payResponse);
        }
        String clientIp = request.getRemoteIP();
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            logger.error("ip[" + clientIp + "]\u8bf7\u6c42/pay/buyvip.do\u7684session\u9a8c\u8bc1\u5931\u8d25", e);
        }
        if (mainParam == null) {
            PayResponse payResponse = new PayResponse();
            payResponse.setCode("99");
            payResponse.setMsg("session\u9a8c\u8bc1\u5931\u8d25");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, payResponse);
        }
        PayRequest payRequest = new PayRequest();
        payRequest.productName = "\u767d\u91d1\u4f1a\u5458";
        payRequest.productNo = "whitevip";
        payRequest.orderAmt = request.getParameterDouble("orderAmt", 0.0);
        payRequest.userName = request.getCookieValue("usrname", LASTTIME);
        if (LASTTIME.equals(payRequest.userName)) {
            payRequest.userName = request.getCookieValue("usernewno", LASTTIME);
        }
        payRequest.orderAmt = "1".equals(ISTEST) && TESTUSERNAME.contains(payRequest.userName) ? Double.valueOf(1.0) : Double.valueOf(149.0);
        payRequest.payPwd = request.getParameter("payPwd", LASTTIME);
        payRequest.userId = request.getCookieValue("userid");
        payRequest.payType = request.getParameter("payType", LASTTIME);
        payRequest.bankNo = request.getParameter("bankNo", LASTTIME);
        payRequest.tempOrderNo = request.getParameter("tempOrderNo", LASTTIME);
        payRequest.clientIp = clientIp;
        payRequest.xlHttpResponse = response;
        PayResponse payResponse = this.dealPay(payRequest);
        if (payResponse == null) {
            payResponse = new PayResponse();
            payResponse.setCode("99");
            payResponse.setMsg("session\u9a8c\u8bc1\u5931\u8d25,\u8bf7\u91cd\u65b0\u767b\u5f55");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, payResponse);
        }
        if ("00".equals(payResponse.getCode())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, payResponse);
        }
        payResponse.setMsg(ErrorMsg.getPayErrorMsg(payResponse.getCode()));
        return JsonObjectUtil.getRtnAndDataJsonObject(1, payResponse);
    }

    private PayResponse dealPay(PayRequest payRequest) {
        if ("A1".equals(payRequest.payType)) {
            return new LeiDianDirectPay().pay(payRequest);
        }
        if (payRequest.payType.startsWith("B")) {
            return new NetBankRedirectPay().pay(payRequest);
        }
        if ("E".equals(payRequest.payType)) {
            return new NetBankRedirectPay().pay(payRequest);
        }
        if ("E2".equals(payRequest.payType)) {
            return new NetBankRedirectPay().pay(payRequest);
        }
        PayResponse payResponse = new PayResponse();
        payResponse.setCode("13");
        payResponse.setMsg("\u652f\u4ed8\u65b9\u5f0f[" + payRequest.payType + "]\u4e0d\u5b58\u5728");
        return payResponse;
    }

    public static boolean checkActValidTime() {
        String lasttime = "2012-12-31 23:59:59";
        String now = sdf.format(new Date());
        int flag = now.compareTo(lasttime);
        return flag <= 0;
    }
}

