/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.ActPayOrder;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import java.util.Date;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class ActPayOrderCmd
extends DefaultCmd {
    private static String proxyUrl = "http://proxy.pay.xunlei.com/newPayHandle?";
    private static String proxyCallBackUrl = "http://dy.niu.xunlei.com/pay/actPayCallBack.do";
    private static String bizNo = "000001056";
    private static String bizKey = "5Zaq_tx9pcvb74Wr";
    private static String actCallBackBizKey = "QOwqK0w3mmsr9AwT";

    @CmdMapper(value={"/pay/actPay.do"})
    public Object actPay(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String chargeUserName = request.getParameter("getUsername", "");
        String gameId = request.getParameter("gameid", "");
        String serverId = request.getParameter("serverid", "");
        String roleId = request.getParameter("roleId", "");
        String payType = request.getParameter("chargeType", "");
        double payMoney = request.getParameterDouble("unitPrice");
        String actNo = request.getParameter("niuxActNo", "");
        String payPwd = request.getParameter("payPwd", "");
        String bankNo = request.getParameter("bankno", "");
        String cookieprefix = request.getParameter("cookieprefix", "");
        String clientIp = request.getRemoteIP();
        String chargeUserId = UserUtility.getUserIdByUserName(chargeUserName);
        if (!this.checkMoneyValid(actNo, payMoney)) {
            ActPayOrderCmd.getResultStr("13", "", "\u91d1\u989d\u9519\u8bef");
        }
        if (chargeUserName.equals("youxiceshi")) {
            payMoney = 0.01;
        }
        ActPayOrder actPayOrder = new ActPayOrder();
        actPayOrder.setActNo(actNo);
        actPayOrder.setChargeUserId(chargeUserId);
        actPayOrder.setChargeUserName(chargeUserName);
        actPayOrder.setNoticeStatus("WAIT");
        actPayOrder.setNoticeTime("");
        actPayOrder.setPayMoney(payMoney);
        actPayOrder.setPayStatus("PAYING");
        actPayOrder.setPayOrderTime(sdf_time.format(new Date()));
        actPayOrder.setPayUserId(chargeUserId);
        actPayOrder.setPayUserName(chargeUserName);
        actPayOrder.setPayType(payType);
        actPayOrder.setPaySuccessTime("");
        actPayOrder.setGameId(gameId);
        actPayOrder.setServerId(serverId);
        actPayOrder.setRoleId(roleId);
        actPayOrder.setBankNo(bankNo);
        actPayOrder.setPayNo("20" + OrderNoUtil.getOrderNo() + "pay");
        actPayOrder.setPayPwd(payPwd);
        actPayOrder.setClientIp(clientIp);
        this.addCookie(cookieprefix + "_orderId", actPayOrder.getPayNo(), response);
        FacadeFactory.INSTANCE.getBaseSo().addObject(actPayOrder);
        String url = this.buildPayProxyUrl(actPayOrder);
        if (actPayOrder.getPayType().equals("A1")) {
            String returnCode = ActPayOrderCmd.directDealProxy(url);
            return ActPayOrderCmd.getResultStr(returnCode, actPayOrder.getPayNo(), returnCode);
        }
        response.redirect(url);
        return ActPayOrderCmd.getResultStr("1", actPayOrder.getPayNo(), "\u6210\u529f");
    }

    @CmdMapper(value={"/pay/actPayCallBack.do"})
    public Object actPayCallBack(XLHttpRequest request, XLHttpResponse response) {
        String version = request.getParameter("version");
        String orderId = request.getParameter("orderId");
        Long orderAmt = request.getParameterLong("orderAmt");
        String orderTime = request.getParameter("orderTime");
        String xlpayId = request.getParameter("xlpayId");
        String xlpayTime = request.getParameter("xlpayTime", "");
        String ext1 = request.getParameter("ext1", "");
        String ext2 = request.getParameter("ext2", "");
        String payResult = request.getParameter("payResult", "");
        String signMsg = request.getParameter("signMsg");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("version", version);
        param.put("orderId", orderId);
        param.put("orderAmt", orderAmt + "");
        param.put("orderTime", orderTime);
        param.put("xlpayId", xlpayId);
        param.put("xlpayTime", xlpayTime);
        param.put("ext1", ext1);
        param.put("ext2", ext2);
        param.put("payResult", payResult);
        String oldSignMsg = SignUtil.sign(param, bizKey);
        if (!oldSignMsg.equals(signMsg)) {
            return "<xlresult>N</xlresult>";
        }
        ActPayOrder actPayOrder = FacadeFactory.INSTANCE.getBaseSo().findById(ActPayOrder.class, orderId);
        if (actPayOrder == null) {
            return "<xlresult>N</xlresult>";
        }
        actPayOrder.setPayStatus("SUCCESS");
        actPayOrder.setPaySuccessTime(sdf_time.format(new Date()));
        actPayOrder.setNoticeStatus("WAIT");
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(actPayOrder);
        ActPayOrderCmd.noticAct(actPayOrder);
        return "<xlresult>Y</xlresult>";
    }

    @CmdMapper(value={"/pay/getActPayInfo.do"})
    public Object getActPayInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String orderId = request.getParameter("orderid", "");
        if (orderId.equals("")) {
            return "var chkOrderRtn = {code:-1,msg:'\u53c2\u6570\u4e3a\u7a7a'}";
        }
        ActPayOrder actPayOrder = FacadeFactory.INSTANCE.getBaseSo().findById(ActPayOrder.class, orderId);
        if (actPayOrder == null) {
            return "var chkOrderRtn = {code:-1,msg:'\u53c2\u6570\u975e\u6cd5'}";
        }
        if ("SUCCESS".equals(actPayOrder.getPayStatus())) {
            return "var chkOrderRtn = {code:0,msg:'\u5145\u503c\u6210\u529f'}";
        }
        return "var chkOrderRtn = {code:2,msg:'\u5145\u503c\u5931\u8d25'}";
    }

    private static void noticAct(ActPayOrder actPayOrder) {
        String payTime = System.currentTimeMillis() / 1000L + "";
        String totalMoney = (int)(actPayOrder.getPayMoney() * 100.0) + "";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("orderid", actPayOrder.getPayNo());
        paramMap.put("actno", actPayOrder.getActNo());
        paramMap.put("userid", actPayOrder.getChargeUserId());
        paramMap.put("totalmoney", totalMoney);
        paramMap.put("time", payTime);
        paramMap.put("gameid", actPayOrder.getGameId());
        paramMap.put("serverid", actPayOrder.getServerId());
        paramMap.put("roleid", actPayOrder.getRoleId());
        paramMap.put("rolename", "");
        paramMap.put("username", actPayOrder.getChargeUserName());
        paramMap.put("extparam", "");
        String sign = SignUtil.sign(actPayOrder.getActNo() + actPayOrder.getPayNo() + actPayOrder.getChargeUserId() + actPayOrder.getGameId() + actPayOrder.getServerId() + totalMoney + payTime, actCallBackBizKey);
        String url = ActPayOrderCmd.getNoticeUrl(actPayOrder.getActNo()) + "&" + SignUtil.getSignatureContent(paramMap) + "&sign=" + sign;
        String resp = URLUtil.get(url);
        actPayOrder.setNoticeTime(sdf_time.format(new Date()));
        if (resp.contains("\"code\":0")) {
            actPayOrder.setNoticeStatus("SUCCESS");
        } else {
            actPayOrder.setNoticeStatus("FAIL");
        }
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(actPayOrder);
    }

    private static String getResultStr(String code, String orderNo, String msg) {
        return "var  data = {code:" + code + ",orderid:'" + orderNo + "',msg:'" + msg + "'}";
    }

    private static String directDealProxy(String url) {
        String resp = HttpClientUtil.get(url);
        if (resp.contains("<payresult>00</payresult>")) {
            return "1";
        }
        String errorcode = "1";
        int startindex = resp.indexOf("<errcode>") + "<errocde>".length();
        int endindex = resp.indexOf("</errcode>");
        errorcode = endindex > startindex ? resp.substring(startindex, endindex) : "99";
        if ("1001".equals(errorcode)) {
            return "-21";
        }
        return errorcode;
    }

    private String buildPayProxyUrl(ActPayOrder actPayOrder) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("version", "v1.0");
        paramMap.put("pageCharset", "1");
        paramMap.put("bgUrl", proxyCallBackUrl);
        paramMap.put("fgUrl", "");
        paramMap.put("bizNo", bizNo);
        paramMap.put("orderId", actPayOrder.getPayNo());
        paramMap.put("orderAmt", (int)(actPayOrder.getPayMoney() * 100.0) + "");
        paramMap.put("orderTime", actPayOrder.getPayOrderTime().replaceAll("[ |:|-]", ""));
        paramMap.put("payType", actPayOrder.getPayType());
        paramMap.put("xunleiId", actPayOrder.getPayUserName());
        paramMap.put("xlnumId", actPayOrder.getPayUserId());
        paramMap.put("peerId", "");
        paramMap.put("productName", actPayOrder.getGameId());
        paramMap.put("productDesc", actPayOrder.getGameId());
        paramMap.put("bankNo", actPayOrder.getBankNo());
        paramMap.put("other1", actPayOrder.getPayPwd());
        paramMap.put("other2", "");
        paramMap.put("other3", "");
        paramMap.put("payerName", "");
        paramMap.put("payerContact", "");
        paramMap.put("ext1", "");
        paramMap.put("ext2", "");
        String signMsg = SignUtil.sign(paramMap, bizKey);
        paramMap.put("clientIp", actPayOrder.getClientIp());
        return proxyUrl + SignUtil.getSignatureContent(paramMap) + "&signMsg=" + signMsg;
    }

    private boolean checkMoneyValid(String advNo, double money) {
        if ("niuxchou".equals(advNo)) {
            return money >= 200.0;
        }
        return true;
    }

    private static String getNoticeUrl(String advNo) {
        if ("niuxchou".equals(advNo)) {
            return "http://dy.niu.xunlei.com/activity/giveOutCoupon.do?";
        }
        return "http://dyact.niu.xunlei.com/ahxyjfc/index.php?type=chongHook";
    }
}

