/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.pay.PayUtil;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.data.vipgame.vo.pay.RechargeRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AcceptGameGoldIngotCmd_dpqk
extends DefaultCmd {
    private static Logger logger = Log.getLogger(AcceptGameGoldIngotCmd_dpqk.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String acceptGameGoldIngotUrl = EnvPropertyUtil.loadProperty("pay", "acceptgamegoldingoturl");
    private static final String acceptGameGoldIngotKey = EnvPropertyUtil.loadProperty("pay", "acceptgamegoldingotkey");
    private static String activityNo = "by_kfrbuyvip";
    private static final int UNITPRICE = 10;
    private static final int GOODTIMES = 1;

    @CmdMapper(value={"/pay/acceptgamegoldingotdpqk.do"})
    public Object getGameGoldIngot(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.checkSession(request, response);
            AcceptGameGoldIngotCmd_dpqk.checkActVaild();
            this.checkRequestParamValid(request);
            String userId = mainParam.getUserid() + "";
            String gameId = request.getParameter("gameId");
            String serverId = request.getParameter("serverId");
            this.checkGameServerExisted(gameId, serverId, userId, activityNo);
            PayOrder payOrder = this.getGiveOutOrder(userId);
            ReqParam param = this.initParam(request, payOrder);
            this.sendAcceptGameGoldIngotReq(param);
            this.insertSuccessRechargeRecord(param);
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", "");
            rmap.put("code", "00");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, rmap);
        }
        catch (NiuExceptionAndCode e) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", e.getMessage());
            rmap.put("code", e.code);
            logger.error("\u83b7\u53d6\u6e38\u620f\u5143\u5b9d\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
        catch (Exception e) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", e.getMessage());
            rmap.put("code", "99");
            logger.error("\u83b7\u53d6\u6e38\u620f\u5143\u5b9d\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
    }

    private void insertSuccessRechargeRecord(ReqParam param) {
        RechargeRecord rr = new RechargeRecord();
        rr.setRechargeNo(OrderNoUtil.getOrderNo());
        rr.setRechargeTime(sdf.format(new Date()));
        rr.setRechargeStatus("3");
        rr.setProductName("\u5143\u5b9d");
        rr.setFailNum(0);
        rr.setRechargeType("3");
        rr.setOrderNo(param.orderNo);
        rr.setRechargeNum(10);
        rr.setGameId(param.gameId.length() == 5 ? "0" + param.gameId : param.gameId);
        rr.setRoleName(param.roleName);
        rr.setServerId(param.serverId);
        rr.setExt1("0");
        rr.setExt2(activityNo);
        rr.setUserId(param.userId);
        FacadeFactory.INSTANCE.getRechargeRecordBo().insert(rr);
    }

    private void sendAcceptGameGoldIngotReq(ReqParam param) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("gameid", param.gameId);
        paramMap.put("getusername", param.userName);
        paramMap.put("goodstimes", "1");
        paramMap.put("niuxactno", activityNo);
        paramMap.put("originalorderid", param.orderNo);
        paramMap.put("unitprice", "10");
        paramMap.put("roleid", param.roleId);
        paramMap.put("serverid", param.serverId);
        String content = PayUtil.getSignatureContent(paramMap);
        String signMsg = PayUtil.sign(content, acceptGameGoldIngotKey);
        logger.info("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content + " \u52a0\u5bc6\u4e32\uff1a" + signMsg);
        StringBuilder sb = new StringBuilder();
        sb.append(acceptGameGoldIngotUrl).append("/gamepaycenter/genorder?action=genorder").append("&gameid=").append(param.gameId).append("&getusername=").append(AcceptGameGoldIngotCmd_dpqk.twoEncode(param.userName)).append("&serverid=").append(param.serverId).append("&servername=").append(AcceptGameGoldIngotCmd_dpqk.twoEncode(param.serverName)).append("&roleid=").append(AcceptGameGoldIngotCmd_dpqk.twoEncode(param.roleId)).append("&rolename=").append(AcceptGameGoldIngotCmd_dpqk.twoEncode(param.roleName)).append("&paybiz=0&chargetype=").append(param.payType).append("&unitprice=").append(10).append("&goodstimes=").append(1).append("&bankno=").append("&niuxactno=").append(activityNo).append("&originalorderid=").append(param.orderNo).append("&signMsg=").append(signMsg);
        String respUrl = HttpClientUtil.get(sb.toString());
        if (!respUrl.contains("code:0") && !respUrl.contains("code:1")) {
            String msg = respUrl.substring(respUrl.indexOf("'"), respUrl.lastIndexOf("'"));
            msg = URLDecoder.decode(msg, "UTF-8");
            throw new Exception(msg);
        }
    }

    private void checkGameServerExisted(String gameId, String serverId, String userId, String actNo) throws NiuExceptionAndCode {
        RechargeRecord qrr = new RechargeRecord();
        qrr.setRechargeType("3");
        qrr.setRechargeStatus("3");
        qrr.setGameId(gameId);
        qrr.setServerId(serverId);
        qrr.setExt2(actNo);
        qrr.setUserId(userId);
        int count = FacadeFactory.INSTANCE.getRechargeRecordBo().count(qrr);
        if (count > 0) {
            throw new NiuExceptionAndCode("99", "\u5df2\u7ecf\u9886\u53d6\u8fc7");
        }
    }

    private PayOrder getGiveOutOrder(String userId) throws NiuExceptionAndCode {
        PayOrder qpayorder = new PayOrder();
        qpayorder.setUserId(userId);
        qpayorder.setOrderStatus("3");
        qpayorder.setActNo(activityNo);
        List<PayOrder> listPayOrder = FacadeFactory.INSTANCE.getPayOrderBo().find(qpayorder, new Page());
        if (listPayOrder == null || listPayOrder.size() == 0) {
            throw new NiuExceptionAndCode("99", "\u60a8\u6ca1\u6709\u53ef\u4ee5\u9886\u53d6\u7684\u8ba2\u5355\uff0c\u8bf7\u53c2\u4e0e\u6d3b\u52a8\u540e\u518d\u9886\u53d6");
        }
        RechargeRecord qrr = new RechargeRecord();
        qrr.setUserId(userId);
        qrr.setRechargeType("3");
        qrr.setRechargeStatus("3");
        List<RechargeRecord> rrlist = FacadeFactory.INSTANCE.getRechargeRecordBo().find(qrr, new Page());
        HashSet<String> rrOrderNoSet = new HashSet<String>();
        for (RechargeRecord rr : rrlist) {
            rrOrderNoSet.add(rr.getOrderNo());
        }
        for (PayOrder tpayorder : listPayOrder) {
            if (rrOrderNoSet.contains(tpayorder.getOrderNo())) continue;
            return tpayorder;
        }
        throw new NiuExceptionAndCode("99", "\u6240\u6709\u8ba2\u5355\u90fd\u5df2\u9886\u53d6");
    }

    private void checkRequestParamValid(XLHttpRequest request) throws NiuExceptionAndCode {
        String gameId = request.getParameter("gameId", "");
        if (!"000097".equals(gameId)) {
            throw new NiuExceptionAndCode("13", "\u975e\u6cd5\u6e38\u620f");
        }
        String serverId = request.getParameter("serverId", "");
        if (!"6".equals(serverId) && !"7".equals(serverId)) {
            throw new NiuExceptionAndCode("13", "\u975e\u6cd5\u533a\u670d");
        }
    }

    private static void checkActVaild() throws NiuExceptionAndCode, Exception {
        Date now = new Date();
        Date from = sdf.parse("2013-04-25 10:00:00");
        Date end = sdf.parse("2013-04-28 24:00:00");
        if (now.getTime() < from.getTime()) {
            throw new NiuExceptionAndCode("99", "\u6d3b\u52a8\u8fd8\u672a\u5f00\u59cb");
        }
        if (now.getTime() > end.getTime()) {
            throw new NiuExceptionAndCode("99", "\u6d3b\u52a8\u5df2\u7ed3\u675f");
        }
    }

    private MainParam checkSession(XLHttpRequest request, XLHttpResponse response) throws NiuExceptionAndCode {
        try {
            return this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            throw new NiuExceptionAndCode("99", "\u767b\u5f55\u6001\u5931\u6548", e);
        }
    }

    private ReqParam initParam(XLHttpRequest request, PayOrder payOrder) {
        ReqParam param = new ReqParam();
        param.gameId = request.getParameter("gameId", "");
        param.serverId = request.getParameter("serverId", "");
        param.serverName = request.getParameter("serverName", "");
        param.roleName = request.getParameter("roleName", "");
        param.roleId = request.getParameter("roleId", "");
        param.userId = request.getCookieValue("userid", "");
        param.userName = this.getUserName(request);
        param.orderNo = payOrder.getOrderNo();
        param.payType = payOrder.getPayType();
        return param;
    }

    private static String twoEncode(String value) {
        if (value == null || "".equals(value)) {
            return "";
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    private static class ReqParam {
        String gameId;
        String serverId;
        String serverName;
        String roleName;
        String roleId;
        String userId;
        String userName;
        String orderNo;
        String payType;

        private ReqParam() {
        }
    }
}

