/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.pay;

import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.pay.BuyVipCmd;
import com.xunlei.niux.center.so.pay.PayUtil;
import com.xunlei.niux.center.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.pay.PayOrder;
import com.xunlei.niux.data.vipgame.vo.pay.RechargeRecord;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class AcceptGameGoldIngotCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(AcceptGameGoldIngotCmd.class.getName());
    private static final String acceptGameGoldIngotUrl = EnvPropertyUtil.loadProperty("pay", "acceptgamegoldingoturl");
    private static final String acceptGameGoldIngotKey = EnvPropertyUtil.loadProperty("pay", "acceptgamegoldingotkey");
    private static final String activityNo = EnvPropertyUtil.loadProperty("pay", "openvipactivityno");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String ISTEST = EnvPropertyUtil.loadProperty("pay", "istest");
    private static final String TESTUSERNAME = EnvPropertyUtil.loadProperty("pay", "testusername");
    private static final int UNITPRICE = 100;
    private static final int GOODTIMES = 1;

    @CmdMapper(value={"/pay/acceptgamegoldingot.do"})
    public Object acceptGameGoldIngot(XLHttpRequest request, XLHttpResponse response) {
        if (!BuyVipCmd.checkActValidTime()) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", "99");
            rmap.put("code", "\u5f88\u62b1\u6b49\uff0c\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\uff0c\u8c22\u8c22\u53c2\u4e0e\uff01");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
        try {
            this.getMainParam(request, response, true);
            Param param = this.initParam(request);
            param.orderNo = this.getCanAcceptGameGoldIngotOrderNo(param);
            this.sendAcceptGameGoldIngotReq(param);
            this.insertSuccessRechargeRecord(param);
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", "");
            rmap.put("code", "00");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, rmap);
        }
        catch (Exception e) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", e.getMessage());
            rmap.put("code", "99");
            logger.error("\u83b7\u53d6\u6e38\u620f\u5143\u5b9d\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
    }

    @CmdMapper(value={"/pay/manacceptgamegoldingot.do"})
    public Object manAcceptGameGoldIngot(XLHttpRequest request, XLHttpResponse response) {
        try {
            if (!"vipkaifangripwd".equals(request.getParameter("pwd"))) {
                throw new Exception("\u4e34\u65f6\u5bc6\u7801\u9519\u8bef");
            }
            Param param = new Param();
            param.gameId = request.getParameter("gameId", "");
            param.serverId = request.getParameter("serverId", "");
            param.serverName = request.getParameter("serverName", "");
            param.roleName = request.getParameter("roleName", "");
            param.roleId = request.getParameter("roleId", "");
            param.userId = request.getParameter("userid", "");
            param.userName = UserUtility.getUserNameByUserId(param.userId);
            if (param.userName == null || "".equals(param.userName)) {
                throw new Exception("\u7528\u6237\u540d\u4e3a\u7a7a");
            }
            param.orderNo = this.getCanAcceptGameGoldIngotOrderNo(param);
            this.sendAcceptGameGoldIngotReq(param);
            this.insertSuccessRechargeRecord(param);
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", "");
            rmap.put("code", "00");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, rmap);
        }
        catch (Exception e) {
            HashMap<String, String> rmap = new HashMap<String, String>();
            rmap.put("msg", e.getMessage());
            rmap.put("code", "99");
            logger.error("\u83b7\u53d6\u6e38\u620f\u5143\u5b9d\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, rmap);
        }
    }

    private void insertSuccessRechargeRecord(Param param) {
        RechargeRecord rr = new RechargeRecord();
        rr.setRechargeNo(OrderNoUtil.getOrderNo());
        rr.setRechargeTime(sdf.format(new Date()));
        rr.setRechargeStatus("3");
        rr.setProductName("\u5143\u5b9d");
        rr.setFailNum(0);
        rr.setRechargeType("3");
        rr.setOrderNo(param.orderNo);
        rr.setRechargeNum(100);
        rr.setGameId(param.gameId.length() == 5 ? "0" + param.gameId : param.gameId);
        rr.setRoleName(param.roleName);
        rr.setServerId(param.serverId);
        rr.setExt1("0");
        rr.setUserId(param.userId);
        FacadeFactory.INSTANCE.getRechargeRecordBo().insert(rr);
    }

    private void sendAcceptGameGoldIngotReq(Param param) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("gameid", param.gameId);
        paramMap.put("getusername", param.userName);
        paramMap.put("goodstimes", "1");
        paramMap.put("niuxactno", activityNo);
        paramMap.put("originalorderid", param.orderNo);
        paramMap.put("unitprice", "100");
        paramMap.put("roleid", param.roleId);
        paramMap.put("serverid", param.serverId);
        String content = PayUtil.getSignatureContent(paramMap);
        String signMsg = PayUtil.sign(content, acceptGameGoldIngotKey);
        logger.info("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content + " \u52a0\u5bc6\u4e32\uff1a" + signMsg);
        StringBuilder sb = new StringBuilder();
        sb.append(acceptGameGoldIngotUrl).append("/gamepaycenter/genorder?action=genorder").append("&gameid=").append(param.gameId).append("&getusername=").append(AcceptGameGoldIngotCmd.twoEncode(param.userName)).append("&serverid=").append(param.serverId).append("&servername=").append(AcceptGameGoldIngotCmd.twoEncode(param.serverName)).append("&roleid=").append(AcceptGameGoldIngotCmd.twoEncode(param.roleId)).append("&rolename=").append(AcceptGameGoldIngotCmd.twoEncode(param.roleName)).append("&paybiz=0&chargetype=").append(param.payType).append("&unitprice=").append(100).append("&goodstimes=").append(1).append("&bankno=").append("&niuxactno=").append(activityNo).append("&originalorderid=").append(param.orderNo).append("&signMsg=").append(signMsg);
        String respUrl = HttpClientUtil.get(sb.toString());
        if (!respUrl.contains("code:0") && !respUrl.contains("code:1")) {
            String msg = respUrl.substring(respUrl.indexOf("'"), respUrl.lastIndexOf("'"));
            msg = URLDecoder.decode(msg, "UTF-8");
            throw new Exception(msg);
        }
    }

    private String getCanAcceptGameGoldIngotOrderNo(Param param) {
        PayOrder payOrder = new PayOrder();
        payOrder.setUserId(param.userId);
        payOrder.setOrderStatus("3");
        List<PayOrder> list = FacadeFactory.INSTANCE.getPayOrderBo().find(payOrder, new Page());
        if (list.size() == 0) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u53ef\u4ee5\u9886\u53d6\u7684\u8ba2\u5355\uff0c\u8bf7\u53c2\u4e0e\u6d3b\u52a8\u540e\u518d\u9886\u53d6");
        }
        RechargeRecord qrr = new RechargeRecord();
        qrr.setUserId(param.userId);
        qrr.setRechargeType("3");
        qrr.setRechargeStatus("3");
        List<RechargeRecord> rrlist = FacadeFactory.INSTANCE.getRechargeRecordBo().find(qrr, new Page());
        HashSet<String> rrOrderNoSet = new HashSet<String>();
        for (RechargeRecord rr : rrlist) {
            rrOrderNoSet.add(rr.getOrderNo());
        }
        for (PayOrder tpayorder : list) {
            if (rrOrderNoSet.contains(tpayorder.getOrderNo())) continue;
            param.payType = tpayorder.getPayType();
            return tpayorder.getOrderNo();
        }
        throw new RuntimeException("\u6240\u6709\u8ba2\u5355\u90fd\u5df2\u9886\u53d6");
    }

    private static String twoEncode(String value) {
        if (value == null || "".equals(value)) {
            return "";
        }
        try {
            value = URLEncoder.encode(value, "UTF-8");
            value = URLEncoder.encode(value, "UTF-8");
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    private Param initParam(XLHttpRequest request) {
        Param param = new Param();
        param.gameId = request.getParameter("gameId", "");
        param.serverId = request.getParameter("serverId", "");
        param.serverName = request.getParameter("serverName", "");
        param.roleName = request.getParameter("roleName", "");
        param.roleId = request.getParameter("roleId", "");
        param.userId = request.getCookieValue("userid", "");
        param.userName = request.getCookieValue("usrname", "");
        if ("".equals(param.userName)) {
            param.userName = request.getCookieValue("usernewno", "");
        }
        if ("1".equals(ISTEST)) {
            param.userName = "youxiceshi";
        }
        return param;
    }

    private static class Param {
        String gameId;
        String serverId;
        String serverName;
        String roleName;
        String roleId;
        String userId;
        String userName;
        String orderNo;
        String payType;

        private Param() {
        }
    }
}

