/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.onesign;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.bonus.thread.AfterSignUpdateThread;
import com.xunlei.niux.center.cmd.jinzuan.thread.AddSignInRecordThread;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.LogReportUtil;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.jinzuan.SignInClient;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.bonus.SignRecord;
import com.xunlei.niux.data.vipgame.vo.onesign.MonthSign;
import com.xunlei.niux.data.vipgame.vo.onesign.MonthSignConf;
import com.xunlei.niux.data.vipgame.vo.onesign.OneSignDaycount;
import com.xunlei.niux.data.vipgame.vo.onesign.OneSignLog;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class OneSignCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(OneSignCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static int IP_DAY_SIGN_MAX_TIMES = 10;
    private static final long signSeqId = 4L;

    @CmdMapper(value={"/onesign/sign.do"})
    public Object sign(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            int rtn = JinZuanClient.isJinZuanUser(mainParam.getUserid() + "");
            if (rtn != 0 && rtn != 3) {
                return this.signJifen(request, response);
            }
            return this.signJinzuan(request, response);
        }
        catch (Exception e) {
            logger.error("sign Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private Object signJifen(XLHttpRequest request, XLHttpResponse response) throws Exception {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            SignRecord signRecord = new SignRecord();
            signRecord.setSignIp(request.getRemoteIP());
            signRecord.setUserId(mainParam.getUserid() + "");
            signRecord.setUserName(this.getUserName(request));
            String daytime = sdf.format(new Date());
            OneSignLog one = new OneSignLog();
            one.setUid(mainParam.getUserid() + "");
            one.setSignDate(sdf.format(new Date()));
            if (FacadeFactory.INSTANCE.getBaseSo().countObject(one) > 0) {
                HashMap<String, String> resMap = new HashMap<String, String>();
                resMap.put("jz", "0");
                resMap.put("msg", "\u8be5\u65e5\u671f\u60a8\u5df2\u7ecf\u7b7e\u5230\u8fc7\u4e86\uff01");
                return JsonObjectUtil.getRtnAndDataJsonObject(90, resMap);
            }
            SignRecord todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().find(signRecord.getUserId(), daytime);
            if (todaySignRecord != null) {
                HashMap<String, String> resMap = new HashMap<String, String>();
                resMap.put("jz", "0");
                resMap.put("msg", "\u8be5\u65e5\u671f\u60a8\u5df2\u7ecf\u7b7e\u5230\u8fc7\u4e86\uff01");
                return JsonObjectUtil.getRtnAndDataJsonObject(90, resMap);
            }
            signRecord.setSignDate(daytime);
            todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().insert(signRecord, false);
            new Thread(new AfterSignUpdateThread(todaySignRecord, daytime, 4L, false)).start();
            this.report(todaySignRecord, request.getParameter("channelNo", ""));
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", "00");
            result.put("jz", "0");
            result.put("seriesSignDays", todaySignRecord.getSeriesSignDays());
            result.put("sumSignDays", todaySignRecord.getSignSumDays());
            result.put("todaySignIndex", todaySignRecord.getTodaySignIndex());
            result.put("totalSignBonusNum", todaySignRecord.getSignTotalBonusNum());
            result.put("msg", "\u7b7e\u5230\u6210\u529f");
            Map<String, Object> historyRecord = this.getSignMap(mainParam.getUserid());
            result.put("historyRecord", historyRecord);
            String actNo = request.getParameter("actNo", "signLottery");
            String moduleId = request.getParameter("moduleId", "sign1");
            this.oneSign(mainParam.getUserid() + "", daytime, 1, actNo, moduleId);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("sign error", e);
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("jz", "0");
            resMap.put("msg", "\u7f51\u7edc\u5f02\u5e38");
            return JsonObjectUtil.getRtnAndDataJsonObject(99, resMap);
        }
    }

    private void oneSign(String uid, String nowDate, int signType, String actNo, String moduleId) {
        BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
        OneSignLog one = new OneSignLog();
        one.setUid(uid);
        one.setSignDate(nowDate);
        one.setSignType(signType);
        baseSo.addObject(one);
        OneSignDaycount query = new OneSignDaycount();
        query.setSignDate(nowDate);
        OneSignDaycount daycount = baseSo.findObject(query);
        if (daycount == null) {
            query.setSignCount(1);
            baseSo.addObject(query);
        } else {
            daycount.setSignCount(daycount.getSignCount() + 1);
            baseSo.updateObjectById(daycount);
        }
        MonthSign queryMs = new MonthSign();
        queryMs.setUid(uid);
        Page page = new Page();
        page.addOrder("lastSignDate", OrderType.DESC);
        List<MonthSign> monthSignList = baseSo.findObjects(queryMs, page);
        if (monthSignList == null || monthSignList.size() == 0) {
            queryMs.setMonthSignDays(1);
            queryMs.setLastSignDate(nowDate);
            queryMs.setTicketNumber(0);
            baseSo.addObject(queryMs);
            return;
        }
        MonthSign monthSign = null;
        String nowMonth = nowDate.substring(0, 7);
        for (MonthSign ms : monthSignList) {
            String month;
            if (StringUtils.isEmpty(ms.getLastSignDate()) || ms.getLastSignDate().length() < 7 || !nowMonth.equals(month = ms.getLastSignDate().substring(0, 7))) continue;
            System.out.println(ms.getLastSignDate());
            monthSign = ms;
            break;
        }
        if (monthSign == null) {
            System.out.println("iiiinnnn");
            queryMs.setMonthSignDays(1);
            queryMs.setLastSignDate(nowDate);
            queryMs.setTicketNumber(0);
            baseSo.addObject(queryMs);
            return;
        }
        String sql = "select count(distinct uid,signDate) from onesign_log where uid=? and date_format(signDate,'%Y-%m')=?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(uid + "");
        params.add(nowMonth);
        int monthSignDays = baseSo.count(sql, params.toArray());
        monthSign.setMonthSignDays(monthSignDays);
        int ticketNumber = monthSign.getTicketNumber();
        MonthSignConf queryMSC = new MonthSignConf();
        queryMSC.setActNo(actNo);
        queryMSC.setModuleId(moduleId);
        MonthSignConf monthSignConf = baseSo.findObject(queryMSC);
        if (monthSignConf == null) {
            logger.error("MonthSignConf not found {},{}", (Object)actNo, (Object)moduleId);
            throw new XLRuntimeException("\u670d\u52a1\u5668\u9519\u8bef");
        }
        HashSet<String> jzDays = new HashSet<String>();
        HashSet<String> njzDays = new HashSet<String>();
        for (String days : monthSignConf.getJinzuanSignDays().split(",")) {
            jzDays.add(days);
        }
        for (String days : monthSignConf.getNotJinzuanSignDays().split(",")) {
            njzDays.add(days);
        }
        if (signType == 2) {
            if (jzDays.contains("99") && monthSignDays == OneSignCmd.getCurrentMonthLastDay()) {
                monthSign.setTicketNumber(++ticketNumber);
            } else if (jzDays.contains(monthSignDays + "")) {
                monthSign.setTicketNumber(++ticketNumber);
            }
        } else if (signType == 1) {
            if (njzDays.contains("99") && monthSignDays == OneSignCmd.getCurrentMonthLastDay()) {
                monthSign.setTicketNumber(++ticketNumber);
            } else if (njzDays.contains(monthSignDays + "")) {
                monthSign.setTicketNumber(++ticketNumber);
            }
        }
        monthSign.setLastSignDate(nowDate);
        baseSo.updateObjectById(monthSign);
    }

    private Object signJinzuan(XLHttpRequest request, XLHttpResponse response) throws Exception {
        int code;
        JsonObject jsonObject;
        logger.info("\u5f00\u59cb\u6267\u884c\u7528\u6237\u7b7e\u5230");
        boolean isReSign = false;
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String dayStr = request.getParameter("day", "");
        String remoteIp = request.getRemoteIP();
        String userIdStr = String.valueOf(userId);
        int day = 0;
        if (StringUtils.isNotEmpty(dayStr)) {
            day = Integer.parseInt(dayStr);
        }
        Calendar calendar = Calendar.getInstance();
        int curDay = calendar.get(5);
        if (day < 0 || day > curDay) {
            String msg = "day\u53c2\u6570\u9519\u8bef";
            return JsonObjectUtil.getRtnAndDataJsonObject(201, msg);
        }
        if (day > 0 && day < curDay) {
            isReSign = true;
        }
        OneSignLog one = new OneSignLog();
        one.setUid(mainParam.getUserid() + "");
        if (isReSign) {
            one.setSignDate(sdf.format(new Date()).substring(1, 8) + this.changeDay(dayStr));
        } else {
            one.setSignDate(sdf.format(new Date()));
        }
        if (FacadeFactory.INSTANCE.getBaseSo().countObject(one) > 0) {
            HashMap<String, String> resMap = new HashMap<String, String>();
            resMap.put("msg", "\u8be5\u65e5\u671f\u60a8\u5df2\u7ecf\u7b7e\u5230\u8fc7\u4e86\uff01");
            return JsonObjectUtil.getRtnAndDataJsonObject(90, resMap);
        }
        if (isReSign) {
            try {
                String result = PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.FillCheck, 1);
                jsonObject = new JsonParser().parse(result).getAsJsonObject();
                code = jsonObject.get("rtn").getAsInt();
                if (code != 0) {
                    String msg = "\u4f7f\u7528\u7279\u6743\u5931\u8d25\uff1a" + jsonObject.get("data").toString();
                    return JsonObjectUtil.getRtnAndDataJsonObject(code + 100, msg);
                }
            }
            catch (Exception e) {
                logger.error("usePrivilege\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                return JsonObjectUtil.getRtnAndDataJsonObject(302, "usePrivilege\u8c03\u7528\u5931\u8d25" + e.getMessage());
            }
        }
        String resp = "";
        try {
            resp = SignInClient.doSign(userIdStr, remoteIp, dayStr);
            jsonObject = new JsonParser().parse(resp).getAsJsonObject();
            code = jsonObject.get("rtn").getAsInt();
            if (code == 0) {
                Executors.newCachedThreadPool().submit(new AddSignInRecordThread(userId));
                String actNo = request.getParameter("actNo", "signLottery");
                String moduleId = request.getParameter("moduleId", "sign1");
                String toDate = sdf.format(new Date());
                if (isReSign) {
                    toDate = new SimpleDateFormat("yyyy-MM").format(new Date()) + "-" + this.changeDay(dayStr);
                }
                this.oneSign(mainParam.getUserid() + "", toDate, 2, actNo, moduleId);
            } else if (isReSign) {
                PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.FillCheck, -1);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("doSignIn Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private void report(SignRecord signRecord, String channelNo) {
        if (signRecord == null) {
            return;
        }
        LogReportUtil.LogReport logReport = new LogReportUtil.LogReport();
        logReport.logTime = new Date();
        logReport.actId = "nxqiandao";
        logReport.userId = signRecord.getUserId();
        logReport.operatorId = "4";
        logReport.productId = "bonus";
        logReport.bonusNum = signRecord.getBonusNum();
        logReport.str1 = signRecord.getSignTotalBonusNum() + "";
        logReport.str2 = channelNo == null ? "" : channelNo;
        LogReportUtil.report(logReport);
    }

    private Map<String, Object> getSignMap(long uid) {
        SignRecord signRecord = new SignRecord();
        signRecord.setUserId(uid + "");
        String nowShort = sdf.format(new Date());
        SignRecord todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().find(signRecord.getUserId(), nowShort);
        String daytime = DateUtil.getCurDateStr();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("daytime", daytime);
        if (todaySignRecord == null) {
            result.put("isSign", 0);
        } else {
            result.put("isSign", 1);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        String beforetime = sdf.format(cal.getTime());
        String beforeMonth = beforetime.substring(0, 7);
        String month = daytime.substring(0, 7);
        beforetime = beforeMonth + "-01";
        String sql = "select * from signrecord where userId=? and  signDate>=? and signDate<=?  order by signTime asc";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(uid);
        list.add(beforetime);
        list.add(daytime);
        List shlist = FacadeFactory.INSTANCE.getBaseSo().executeQuery(SignRecord.class, sql, list);
        ArrayList<Integer> beforeList = new ArrayList<Integer>();
        ArrayList<Integer> nowList = new ArrayList<Integer>();
        for (SignRecord sh : shlist) {
            String mydaytime = sh.getSignDate();
            if (mydaytime.indexOf(beforeMonth) != -1) {
                beforeList.add(this.getDays(mydaytime));
                continue;
            }
            nowList.add(this.getDays(mydaytime));
        }
        TreeMap<String, ArrayList<Integer>> monthMap = new TreeMap<String, ArrayList<Integer>>();
        monthMap.put(this.formatMonth(beforeMonth), beforeList);
        monthMap.put(this.formatMonth(month), nowList);
        result.put("signHistory", monthMap);
        return result;
    }

    private int getDays(String daytime) {
        if ((daytime = daytime.substring(8)).charAt(0) == '\u0000') {
            daytime = daytime.substring(1);
        }
        return Integer.parseInt(daytime);
    }

    private String formatMonth(String month) {
        if (StringTools.isEmpty(month)) {
            return "";
        }
        String[] strs = month.split("-");
        return "y" + strs[0] + strs[1];
    }

    @CmdMapper(value={"/onesign/getSignCount.do"})
    public Object getSignCount(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.getMainParam(request, response, true);
            String daytime = sdf.format(new Date());
            OneSignDaycount query = new OneSignDaycount();
            query.setSignDate(daytime);
            OneSignDaycount oneSignDaycount = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            HashMap<String, Object> result = new HashMap<String, Object>();
            int cnt = 0;
            if (oneSignDaycount != null) {
                cnt = oneSignDaycount.getSignCount();
            }
            result.put("date", daytime);
            result.put("count", cnt);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("sign Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/onesign/getUidTimes.do"})
    public Object getUidTimes(XLHttpRequest request, XLHttpResponse response) {
        try {
            long uid = this.getMainParam(request, response, true).getUserid();
            MonthSign query = new MonthSign();
            query.setUid(uid + "");
            HashedMap map = new HashedMap();
            MonthSign monthSign = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (monthSign == null) {
                map.put("times", 0);
            } else {
                map.put("times", monthSign.getMonthSignDays());
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            logger.error("sign Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    public static int getCurrentMonthLastDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    private String changeDay(String day) {
        int dayInt = Integer.parseInt(day);
        if (dayInt <= 9) {
            return "0" + day;
        }
        return day;
    }
}

