/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.moyu;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuExchangeBo;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuJiFenBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuAct;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuExchange;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuGift;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuJiFen;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuJiFenHistory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuServer;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MoyuExchangeCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(DefaultCmd.class);
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static String moyuUrl = EnvPropertyUtil.loadProperty("niux", "moyuUrl");
    private static String moyuGameId = EnvPropertyUtil.loadProperty("niux", "moyuGameId");

    @CmdMapper(value={"/moyu/exchange.do"})
    public Object exchange(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String sessionid = mainParam.getSessionid();
            String userAccount = mainParam.getUserAccount();
            String giftno = request.getParameter("giftno");
            String serverid = request.getParameter("serverid");
            if (StringUtil.isEmpty(giftno, serverid)) {
                return this.error("\u7f3a\u5c11\u53c2\u6570");
            }
            MoyuAct act = FacadeFactory.INSTANCE.getMoyuActBo().findInvalid();
            if (act == null) {
                return this.error("\u62b1\u6b49\uff0c\u672c\u6b21\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u6216\u5c1a\u672a\u5f00\u542f\uff0c\u8bf7\u53c2\u52a0\u6211\u4eec\u7684\u5176\u5b83\u6d3b\u52a8\uff01");
            }
            MoyuServer server = FacadeFactory.INSTANCE.getMoyoServerBo().findByServerId(serverid);
            if (server == null) {
                return this.error("\u62b1\u6b49\uff0c\u60a8\u6240\u9009\u670d\u52a1\u5668\u7684\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8\uff01");
            }
            if (new Date().getTime() - DATE_FORMAT.parse(server.getOpentime()).getTime() < 1296000000L) {
                return this.error("\u62b1\u6b49\uff0c\u60a8\u6240\u9009\u670d\u52a1\u5668\u7684\u5f00\u670d\u65f6\u95f4\u4e0d\u8db315\u5929\uff0c\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8\uff01");
            }
            String levelParams = "queryGameUserLevel.gameUserInfo?sessionid=" + sessionid + "&username=" + userAccount + "&serverid=" + serverid + "&gameid=" + moyuGameId;
            String levelResult = MoyuExchangeCmd.get(moyuUrl + levelParams);
            ObjectMapper levelMapper = new ObjectMapper();
            Map levelMap = levelMapper.readValue(levelResult, Map.class);
            Integer level = null;
            if (!"0".equals(levelMap.get("statues"))) {
                logger.error("\u83b7\u53d6\u4eba\u7269\u7b49\u7ea7\u63a5\u53e3\u5f02\u5e38\uff1a" + levelResult);
                return this.error(levelMap.get("msg").toString());
            }
            level = Integer.valueOf(levelMap.get("level").toString());
            if (level < 70) {
                return this.error("\u62b1\u6b49\uff0c\u60a8\u6240\u9009\u670d\u52a1\u5668\u7684\u89d2\u8272\u4e0d\u5b58\u5728\u6216\u89d2\u8272\u7b49\u7ea7\u4e0d\u8db370\u7ea7\uff0c\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8\uff01");
            }
            long userid = mainParam.getUserid();
            String actno = act.getActno();
            MoyuJiFenBo moyuJiFenBo = FacadeFactory.INSTANCE.getMoyuJiFenBo();
            MoyuJiFen jiFen = moyuJiFenBo.addJiFen(actno, String.valueOf(userid), serverid, 0, userAccount);
            MoyuExchange exchange = new MoyuExchange();
            exchange.setGiftno(giftno);
            exchange.setJifenid(jiFen.getJifenid());
            MoyuExchangeBo moyuExchangeBo = FacadeFactory.INSTANCE.getMoyuExchangeBo();
            List<MoyuExchange> exchanges = moyuExchangeBo.find(exchange, 1, 1);
            if (exchanges.size() > 0) {
                MoyuExchange ex = exchanges.get(0);
                if (ex.getStatus().booleanValue()) {
                    return this.error("\u62b1\u6b49\uff0c\u60a8\u5df2\u9886\u53d6\u8fc7\u8be5\u793c\u5305\uff0c\u4e0d\u53ef\u91cd\u590d\u9886\u53d6\uff01");
                }
                if (new Date().getTime() - DateUtil.parseByDefault(ex.getExchangetime()).getTime() <= 2000L) {
                    return this.error("\u62b1\u6b49\uff0c\u60a8\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                }
            }
            MoyuGift gift = FacadeFactory.INSTANCE.getMoyuGiftBo().findById(giftno);
            if (server.getNostalgiaqu().booleanValue() && !gift.getNostalgiaget().booleanValue()) {
                return this.error("\u62b1\u6b49\uff0c\u6000\u65e7\u7248\u4e0d\u53ef\u9886\u53d6\"\u52c7\u8005\u7279\u6743\u793c\u5305\"\uff0c\u8bf7\u9886\u53d6\u5176\u4ed6\u8fd4\u70b9\u793c\u5305\uff01");
            }
            Integer consumejifennum = gift.getConsumejifennum();
            if (jiFen.getRechargeMoney() < (long)gift.getMinmoney().intValue() || jiFen.getJifennum() < consumejifennum) {
                if ("1501499".equals(giftno) || "1501498".equals(giftno)) {
                    return this.error("\u62b1\u6b49\uff0c\u60a8\u7684\u5145\u503c\u91d1\u989d\u4e0d\u8db3\uff0c\u65e0\u6cd5\u9886\u53d6\u8be5\u793c\u5305\uff0c\u8bf7\u524d\u5f80\u5145\u503c\uff01");
                }
                return this.error("\u62b1\u6b49\uff0c\u60a8\u7684\u5145\u503c\u79ef\u5206\u4e0d\u8db3\uff0c\u65e0\u6cd5\u9886\u53d6\u8be5\u793c\u5305\uff0c\u8bf7\u524d\u5f80\u5145\u503c\uff01");
            }
            MoyuExchange nowExchange = new MoyuExchange();
            nowExchange.setActno(actno);
            nowExchange.setJifenid(jiFen.getJifenid());
            nowExchange.setStatus(false);
            String exchangetime = DATE_FORMAT.format(new Date());
            nowExchange.setExchangetime(exchangetime);
            nowExchange.setGiftno(giftno);
            nowExchange.setUsername(userAccount);
            String orderid = MoyuExchangeCmd.createSN();
            nowExchange.setOrderid(orderid);
            moyuExchangeBo.insert(nowExchange);
            String params = "gameUserGift.gameUserInfo?sessionid=" + sessionid + "&username=" + userAccount + "&serverid=" + serverid + "&gameid=" + moyuGameId + "&orderid=" + orderid + "&actionid=" + giftno;
            String result = MoyuExchangeCmd.get(moyuUrl + params);
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(result, Map.class);
            if (!"0".equals(map.get("statues"))) {
                logger.error("\u53d1\u5956\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
                return this.error(map.get("msg").toString());
            }
            if (consumejifennum > 0) {
                MoyuJiFenHistory moyuJiFenHistory = new MoyuJiFenHistory();
                moyuJiFenHistory.setJifenid(jiFen.getJifenid());
                moyuJiFenHistory.setThisjifennum(-consumejifennum.intValue());
                moyuJiFenHistory.setRecordtime(exchangetime);
                moyuJiFenHistory.setRemark("\u7528\u6237\u9886\u53d6\u5956\u54c1" + giftno + "\uff0c\u6d88\u8d39\u79ef\u5206" + consumejifennum);
                FacadeFactory.INSTANCE.getMoyuJiFenHistoryBo().insert(moyuJiFenHistory);
                ArrayList<Object> param = new ArrayList<Object>();
                param.add(consumejifennum);
                param.add(exchangetime);
                param.add(jiFen.getJifenid());
                moyuJiFenBo.execute("update myjifen set jifennum = jifennum - ? , edittime = ? where jifenid = ?", param);
            }
            moyuExchangeBo.updateStatus(orderid);
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            jiFen = moyuJiFenBo.addJiFen(actno, String.valueOf(userid), serverid, 0, userAccount);
            data.put("exchangenum", jiFen.getJifennum());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.error("exchange exception", e);
            return this.error("\u7f51\u7edc\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("errmsg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    private static String createSN() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String now = dateFormat.format(new Date());
        return now + MoyuExchangeCmd.getRandom();
    }

    private static String getRandom() {
        Random random = new Random();
        int num = random.nextInt(999999);
        DecimalFormat format = new DecimalFormat("000000");
        return format.format(num);
    }

    private static String get(String url) {
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet get = new HttpGet(url);
            HttpResponse response = client.execute(get);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString(entity, "UTF-8");
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        String sessionid = "AA503FF1ADE492FC65D724A559886A448A19C2F4E6A71BE38EE67DAEC7D6FCF16FA261934E30DF60A7D9817898445337B0A6E17B0565D31DECDF3D79ABDFF71A";
        String userAccount = "cl77730";
        String serverid = "102";
        String orderid = "20130424105512255900";
        String giftno = "1501499";
        String params = "gameUserGift.gameUserInfo?sessionid=" + sessionid + "&username=" + userAccount + "&serverid=" + serverid + "&gameid=" + moyuGameId + "&orderid=" + orderid + "&actionid=" + giftno;
        String url = moyuUrl + params;
        System.out.println(url);
        String result = MoyuExchangeCmd.get(url);
        ObjectMapper mapper = new ObjectMapper();
        Map map = mapper.readValue(result, Map.class);
        if (!"0".equals(map.get("statues"))) {
            logger.error("\u53d1\u5956\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
        }
    }
}

