/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.moyu;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyoServerBo;
import com.xunlei.niux.data.vipgame.bo.moyu.MoyuJiFenBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuAct;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuJiFen;
import com.xunlei.niux.data.vipgame.vo.moyu.MoyuServer;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MoyuCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(DefaultCmd.class);
    private static String moyuUrl = EnvPropertyUtil.loadProperty("niux", "moyuUrl");
    private static String moyuGameId = EnvPropertyUtil.loadProperty("niux", "moyuGameId");
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/moyu/login.do"})
    public Object login(XLHttpRequest request, XLHttpResponse response) throws Exception {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String sessionid = mainParam.getSessionid();
            long userid = mainParam.getUserid();
            String userAccount = mainParam.getUserAccount();
            String serverid = request.getParameter("serverid");
            if (StringUtil.isEmpty(serverid)) {
                return this.error("serverid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MoyuAct act = FacadeFactory.INSTANCE.getMoyuActBo().findInvalid();
            if (act == null) {
                return this.error("\u62b1\u6b49\uff0c\u672c\u6b21\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f\u6216\u5c1a\u672a\u5f00\u542f\uff0c\u8bf7\u53c2\u52a0\u6211\u4eec\u7684\u5176\u5b83\u6d3b\u52a8\uff01");
            }
            MoyuServer server = FacadeFactory.INSTANCE.getMoyoServerBo().findByServerId(serverid);
            if (server == null) {
                return this.error("\u62b1\u6b49\uff0c\u60a8\u6240\u9009\u670d\u52a1\u5668\u7684\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8\uff01");
            }
            if (new Date().getTime() - DATE_FORMAT.parse(server.getOpentime()).getTime() < 1296000000L) {
                return this.error("\u62b1\u6b49\uff0c\u60a8\u6240\u9009\u670d\u52a1\u5668\u7684\u5f00\u670d\u65f6\u95f4\u4e0d\u8db315\u5929\uff0c\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8\uff01");
            }
            String params = "queryGameUserLevel.gameUserInfo?sessionid=" + sessionid + "&username=" + userAccount + "&serverid=" + serverid + "&gameid=" + moyuGameId;
            String result = MoyuCmd.get(moyuUrl + params);
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(result, Map.class);
            Integer level = null;
            if (!"0".equals(map.get("statues"))) {
                logger.error("\u83b7\u53d6\u4eba\u7269\u7b49\u7ea7\u63a5\u53e3\u5f02\u5e38\uff1a" + result);
                return this.error(map.get("msg").toString());
            }
            level = Integer.valueOf(map.get("level").toString());
            if (level < 70) {
                return this.error("\u62b1\u6b49\uff0c\u60a8\u6240\u9009\u670d\u52a1\u5668\u7684\u89d2\u8272\u4e0d\u5b58\u5728\u6216\u89d2\u8272\u7b49\u7ea7\u4e0d\u8db370\u7ea7\uff0c\u6682\u65f6\u65e0\u6cd5\u53c2\u4e0e\u672c\u6b21\u6d3b\u52a8\uff01");
            }
            String actno = act.getActno();
            MoyuJiFenBo moyuJiFenBo = FacadeFactory.INSTANCE.getMoyuJiFenBo();
            MoyuJiFen jiFen = moyuJiFenBo.addJiFen(actno, String.valueOf(userid), serverid, 0, userAccount);
            if (!level.equals(jiFen.getLevelnum())) {
                ArrayList<Object> param = new ArrayList<Object>();
                param.add(level);
                param.add(DATE_FORMAT.format(new Date()));
                param.add(jiFen.getJifenid());
                moyuJiFenBo.execute("update myjifen set levelnum = ? , edittime = ? where jifenid = ?", param);
            }
            HashMap<String, Integer> data = new HashMap<String, Integer>();
            data.put("exchangenum", jiFen.getJifennum());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.error("moyulogin\u5f02\u5e38", e);
            return this.error("\u7f51\u7edc\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    @CmdMapper(value={"/moyu/getServersJs.do"})
    public Object getServersJs(XLHttpRequest request, XLHttpResponse response) {
        MoyoServerBo serverBo = FacadeFactory.INSTANCE.getMoyoServerBo();
        try {
            List<MoyuServer> server = serverBo.find(new MoyuServer(), 0, 0);
            LinkedHashMap map = new LinkedHashMap();
            for (MoyuServer s : server) {
                String areaname = s.getAreaname();
                ArrayList serverList = (ArrayList)map.get(areaname);
                if (serverList == null) {
                    ArrayList list = new ArrayList();
                    map.put(areaname, list);
                    serverList = list;
                }
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("serverid", s.getServerid());
                data.put("servername", s.getServername());
                serverList.add(data);
            }
            ArrayList date = new ArrayList();
            for (String key : map.keySet()) {
                HashMap<String, String> datemap = new HashMap<String, String>();
                datemap.put("areaname", key);
                datemap.put("servers", (String)map.get(key));
                date.add(datemap);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, date);
        }
        catch (Exception e) {
            HashMap<String, Exception> errorMap = new HashMap<String, Exception>();
            errorMap.put("errmsg", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, errorMap);
        }
    }

    private String error(String errmsg) {
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("errmsg", errmsg);
        return JsonObjectUtil.getRtnAndDataJsonObject(1, error);
    }

    private static String get(String url) {
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet get = new HttpGet(url);
            HttpResponse response = client.execute(get);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString(entity, "UTF-8");
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

