/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.message;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.proxy.JRedisProxy;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TriggerTips;
import com.xunlei.niux.data.vipgame.vo.TriggerTipsReader;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TriggerTipsCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(TriggerTipsCmd.class);
    private static SimpleDateFormat yyyyMMdd = new SimpleDateFormat("yyyyMMdd");

    private List<TriggerTips> getUnreadTriggerTips(Long uid, String dispalyPage, Integer jzLvl) {
        String curDt = TriggerTipsCmd.now();
        String sql = "select * from triggertips tt where tt.starttime<= ? and tt.endtime >= ? and tt.displayPage like ?  and (tt.jinzuanLevel like ? or (tt.jinzuanLevel='uid' and exists (select 1 from triggertips_uid ttu where tt.seqid=ttu.triggertipsid and ttu.uid=? ))) and not exists (select 1 from triggertipsreader ttr where tt.seqid=ttr.ttid and ttr.uid=? )  order by tt.startTime desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(curDt);
        params.add(curDt);
        params.add("%" + dispalyPage + "%");
        params.add("%" + jzLvl + "%");
        params.add(uid);
        params.add(uid);
        return FacadeFactory.INSTANCE.getBaseSo().executeQuery(TriggerTips.class, sql, params);
    }

    private List<TriggerTips> getReadTriggerTips(Long uid, String dispalyPage, Integer jzLvl) {
        String curDt = TriggerTipsCmd.now();
        String sql = "select * from triggertips tt where tt.starttime<= ? and tt.endtime >= ? and tt.displayPage like ?  and (tt.jinzuanLevel like ? or (tt.jinzuanLevel='uid' and exists (select 1 from triggertips_uid ttu where tt.seqid=ttu.triggertipsid and ttu.uid=? ))) and exists (select 1 from triggertipsreader ttr where tt.seqid=ttr.ttid and ttr.uid=? )  order by tt.startTime desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(curDt);
        params.add(curDt);
        params.add("%" + dispalyPage + "%");
        params.add("%" + jzLvl + "%");
        params.add(uid);
        params.add(uid);
        return FacadeFactory.INSTANCE.getBaseSo().executeQuery(TriggerTips.class, sql, params);
    }

    private List<TriggerTips> getAllUnreadTriggerTips(Long uid, Integer jzLvl) {
        String curDt = TriggerTipsCmd.now();
        String sql = "select * from triggertips tt where tt.starttime<= ? and tt.endtime >= ?  and (tt.jinzuanLevel like ? or (tt.jinzuanLevel='uid' and exists (select 1 from triggertips_uid ttu where tt.seqid=ttu.triggertipsid and ttu.uid=? ))) and not exists (select 1 from triggertipsreader ttr where tt.seqid=ttr.ttid and ttr.uid=? )  order by tt.startTime desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(curDt);
        params.add(curDt);
        params.add("%" + jzLvl + "%");
        params.add(uid);
        params.add(uid);
        return FacadeFactory.INSTANCE.getBaseSo().executeQuery(TriggerTips.class, sql, params);
    }

    private List<TriggerTips> getAllReadTriggerTips(Long uid, Integer jzLvl) {
        String curDt = TriggerTipsCmd.now();
        String sql = "select * from triggertips tt where tt.starttime<= ? and tt.endtime >= ?  and (tt.jinzuanLevel like ? or (tt.jinzuanLevel='uid' and exists (select 1 from triggertips_uid ttu where tt.seqid=ttu.triggertipsid and ttu.uid=? ))) and exists (select 1 from triggertipsreader ttr where tt.seqid=ttr.ttid and ttr.uid=? )  order by tt.startTime desc";
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(curDt);
        params.add(curDt);
        params.add("%" + jzLvl + "%");
        params.add(uid);
        params.add(uid);
        return FacadeFactory.INSTANCE.getBaseSo().executeQuery(TriggerTips.class, sql, params);
    }

    @CmdMapper(value={"/message/gettriggertips.do"})
    public Object gettriggertips(XLHttpRequest request, XLHttpResponse response) {
        try {
            String dispalyPage = request.getParameter("xsym");
            String isread = request.getParameter("type");
            if (StringUtils.isEmpty(dispalyPage) || StringUtils.isEmpty(isread)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            Long uid = this.getMainParam(request, response, true).getUserid();
            int jzLvl = JinZuanClient.getJinzuanLevel(uid + "");
            if ("1".equals(isread)) {
                List<TriggerTips> list = this.getReadTriggerTips(uid, dispalyPage, jzLvl);
                if (list == null || list.isEmpty()) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getRtnData(list));
            }
            if ("0".equals(isread)) {
                List<TriggerTips> list = this.getUnreadTriggerTips(uid, dispalyPage, jzLvl);
                if (list == null || list.isEmpty()) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getRtnData(list));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(98, "\u670d\u52a1\u5f02\u5e382");
        }
        catch (Exception e) {
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u670d\u52a1\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/message/gettriggermessages.do"})
    public Object gettriggertipsWithoutSession(XLHttpRequest request, XLHttpResponse response) {
        try {
            String dispalyPage = "2";
            String resptype = request.getParameter("resptype");
            Long uid = 0L;
            if (!StringTools.isEmpty(resptype) && "plain".equals(resptype)) {
                response.setInnerContentType(XLHttpResponse.ContentType.plain);
                uid = request.getParameterLong("userid");
            } else {
                uid = this.getMainParam(request, response, true).getUserid();
            }
            int jzLvl = JinZuanClient.getJinzuanLevel(uid + "");
            List<TriggerTips> list = this.getUnreadTriggerTips(uid, dispalyPage, jzLvl);
            if (list != null || list.size() > 0) {
                for (TriggerTips tt : list) {
                    if (!this.pullOK(uid, tt)) continue;
                    logger.info("[FOR BOX]pulling to uid=" + uid + ",msg: id=" + tt.getSeqid() + ", title=" + tt.getTitle());
                    HashMap<String, Serializable> backData = new HashMap<String, Serializable>();
                    backData.put("messageList", new ArrayList());
                    backData.put("totalcount", Integer.valueOf(list.size()));
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, backData);
                }
            }
            HashMap<String, Serializable> emptyData = new HashMap<String, Serializable>();
            emptyData.put("messageList", new ArrayList());
            emptyData.put("totalcount", Integer.valueOf(0));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, emptyData);
        }
        catch (Exception e) {
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u670d\u52a1\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/message/getalltriggertips.do"})
    public Object getalltriggertips(XLHttpRequest request, XLHttpResponse response) {
        try {
            String isread = request.getParameter("type");
            if (StringUtils.isEmpty(isread)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            Long uid = this.getMainParam(request, response, true).getUserid();
            int jzLvl = JinZuanClient.getJinzuanLevel(uid + "");
            if ("1".equals(isread)) {
                List<TriggerTips> list = this.getAllReadTriggerTips(uid, jzLvl);
                if (list == null || list.isEmpty()) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getRtnData(list));
            }
            if ("0".equals(isread)) {
                List<TriggerTips> list = this.getAllUnreadTriggerTips(uid, jzLvl);
                if (list == null || list.isEmpty()) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getRtnData(list));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(98, "\u670d\u52a1\u5f02\u5e382");
        }
        catch (Exception e) {
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u670d\u52a1\u5f02\u5e38");
        }
    }

    private Map<String, Object> getRtnData(List<TriggerTips> list) throws Exception {
        ArrayList data = new ArrayList();
        for (TriggerTips mes : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", mes.getSeqid() + "");
            map.put("title", mes.getTitle());
            map.put("inputTime", mes.getInputTime());
            map.put("content", mes.getContent());
            map.put("linkurl", mes.getLinkUrl());
            map.put("bgPicUrl", mes.getBgPicUrl());
            data.add(map);
        }
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        rtnMap.put("messageList", data);
        rtnMap.put("totalcount", data.size());
        return rtnMap;
    }

    @CmdMapper(value={"/message/readtriggertips.do"})
    public Object readtriggertips(XLHttpRequest request, XLHttpResponse response) {
        String seqid = request.getParameter("seqid");
        if (StringUtils.isEmpty(seqid)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        try {
            Long uid = this.getMainParam(request, response, true).getUserid();
            if (seqid.indexOf("_") > -1) {
                String[] sids;
                for (String id : sids = seqid.split("_")) {
                    if (this.addTriggerReader(uid, id)) continue;
                    return JsonObjectUtil.getRtnAndDataJsonObject(-1, id + ":\u66f4\u65b0\u5931\u8d25");
                }
                return JsonObjectUtil.getOnlyOkJson();
            }
            if (this.addTriggerReader(uid, seqid)) {
                return JsonObjectUtil.getOnlyOkJson();
            }
        }
        catch (Exception e) {
            logger.info("\u89e6\u8fbetips\u9605\u8bfb\u72b6\u6001\u66f4\u65b0\u5931\u8d25", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u670d\u52a1\u5f02\u5e38");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u66f4\u65b0\u5931\u8d25");
    }

    private boolean addTriggerReader(Long uid, String seqidStr) throws Exception {
        Long seqid = Long.valueOf(seqidStr);
        BaseSo bs = FacadeFactory.INSTANCE.getBaseSo();
        TriggerTips tt = new TriggerTips();
        tt.setSeqid(seqid);
        if (bs.countObject(tt) > 0) {
            TriggerTipsReader ttr = new TriggerTipsReader();
            ttr.setTtid(seqid);
            ttr.setUid(uid);
            if (bs.countObject(ttr) == 0) {
                bs.addObject(ttr);
            }
            return true;
        }
        return false;
    }

    @CmdMapper(value={"/message/pulltriggertips.do"})
    public Object pulltriggertips(XLHttpRequest request, XLHttpResponse response) {
        String dispalyPage = request.getParameter("xsym");
        if (StringUtils.isEmpty(dispalyPage)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            Long uid = this.getMainParam(request, response, true).getUserid();
            int jzLvl = JinZuanClient.getJinzuanLevel(uid + "");
            List<TriggerTips> list = this.getUnreadTriggerTips(uid, dispalyPage, jzLvl);
            if (list == null || list.isEmpty()) {
                return JsonObjectUtil.getOnlyRtnJson(2);
            }
            for (TriggerTips tt : list) {
                if (!this.pullOK(uid, tt)) continue;
                logger.info("pulling to uid=" + uid + ",msg: id=" + tt.getSeqid() + ", title=" + tt.getTitle());
                return JsonObjectUtil.getOnlyOkJson();
            }
            return JsonObjectUtil.getOnlyRtnJson(3);
        }
        catch (Exception e) {
            logger.info("\u89e6\u8fbetips\u9605\u8bfb\u72b6\u6001\u66f4\u65b0\u5931\u8d25", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u670d\u52a1\u5f02\u5e38");
        }
    }

    private boolean pullOK(Long uid, TriggerTips tt) throws Exception {
        String today = yyyyMMdd.format(new Date());
        String key = "TRIGGERTIPSCMD_PULLTRIGGERTIPS_" + uid + "_" + tt.getSeqid();
        String keyToday = "TRIGGERTIPSCMD_PULLTRIGGERTIPS_" + uid + "_" + tt.getSeqid() + "_" + today;
        Calendar calendar = Calendar.getInstance();
        Integer restSecondOfToday = 86400 - (calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13));
        Integer type = tt.getTriggerType();
        JRedisProxy redis = JRedisProxy.getInstance();
        if (type == 2) {
            return true;
        }
        if (type == 1) {
            if (redis.exists(keyToday)) {
                return false;
            }
            return redis.set(keyToday, "1", restSecondOfToday);
        }
        if (type == 3) {
            if (redis.exists(key)) {
                return false;
            }
            return redis.set(key, "1", Integer.MAX_VALUE);
        }
        return false;
    }
}

