/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.RetData;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.TriggerMessage;
import com.xunlei.niux.data.vipgame.vo.TriggerReader;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class TriggerMessageCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(TriggerMessageCmd.class);
    private static final String LOGINGAMEURL = "http://websvr.niu.xunlei.com/userGameServerList.gameUserInfo?records=1000&";

    private int getPageSize(String pagesizestr) {
        int pageSize = 0;
        if (StringTools.isEmpty(pagesizestr)) {
            pageSize = 5;
        } else {
            pageSize = Integer.parseInt(pagesizestr);
            if (pageSize <= 0) {
                pageSize = 0;
            }
        }
        return pageSize;
    }

    private int getPageNo(String pagenostr) {
        int pageNo = 0;
        if (StringTools.isEmpty(pagenostr)) {
            pageNo = 1;
        } else {
            pageNo = Integer.parseInt(pagenostr);
            if (pageNo <= 1) {
                pageNo = 1;
            }
        }
        return pageNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoginGames(String userName, String sessionid) {
        String gameNos = "'000',";
        try {
            StringBuilder builder = new StringBuilder(LOGINGAMEURL).append("username=").append(userName).append("&sessionid=").append(sessionid);
            System.out.println(builder);
            String responseText = HttpClientUtil.get(builder.toString());
            if (StringUtils.isEmpty(responseText)) {
                logger.error("getLoginGames\u8bbf\u95ee:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\u7a7a", (Object)builder.toString());
                String string = gameNos;
                return string;
            }
            JsonObject jsonObject = new JsonParser().parse(responseText).getAsJsonObject();
            if (jsonObject == null) {
                String string = gameNos;
                return string;
            }
            int code = jsonObject.get("rtn").getAsInt();
            HashSet<String> gameSet = new HashSet<String>();
            if (code == 0) {
                JsonObject data = jsonObject.get("data").getAsJsonObject();
                JsonArray array = data.getAsJsonArray("data");
                for (int i = 0; i < array.size(); ++i) {
                    JsonObject game = array.get(i).getAsJsonObject();
                    String gameNo = game.get("gamename").getAsString();
                    gameSet.add(gameNo);
                }
                for (String gameNo : gameSet) {
                    gameNos = gameNos + "'" + gameNo + "',";
                }
            }
        }
        catch (Throwable e) {
            logger.error("getLoginGames error:" + e.getMessage(), e);
        }
        finally {
            if (gameNos.indexOf(",") != -1) {
                gameNos = gameNos.substring(0, gameNos.length() - 1);
            }
        }
        return gameNos;
    }

    private Object[] initArraysAndList(String typestr, int type, String uid, String gameid, StringBuffer sb, StringBuffer countsb, List<String> params, int pageNo, int pageSize, boolean isLogin) throws Exception {
        boolean isreaded = !"0".equals(typestr);
        long start = (pageNo - 1) * pageSize;
        if (type == 2) {
            sb.append(this.jinKaSql(uid, gameid, isreaded, false, isLogin));
            countsb.append(this.jinKaSql(uid, gameid, isreaded, true, isLogin));
            sb.append("  limit ").append(start).append(",").append(pageSize);
        } else if (type == 3) {
            sb.append(this.gameSql(uid, gameid, isreaded, false, isLogin));
            countsb.append(this.gameSql(uid, gameid, isreaded, true, isLogin));
            sb.append("  limit ").append(start).append(",").append(pageSize);
        }
        return params.toArray();
    }

    private boolean checkLocationType(String locationType) {
        int type = 0;
        if (StringTools.isEmpty(locationType)) {
            type = 2;
        }
        return (type = Integer.parseInt(locationType)) == 2 || type == 3;
    }

    private boolean checkUid(String uid) {
        if (StringTools.isEmpty(uid)) {
            return false;
        }
        try {
            long userid = Long.parseLong(uid);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getUid(XLHttpRequest request, XLHttpResponse response) {
        String resptype = request.getParameter("resptype");
        String uid = "";
        if (!StringTools.isEmpty(resptype) && "plain".equals(resptype)) {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            uid = request.getParameter("userid");
        } else {
            MainParam param = this.checkMainParam(request, response, true);
            uid = param.getUserid() + "";
        }
        return uid;
    }

    private Map<String, Object> processData(boolean isLogin, XLHttpRequest request, XLHttpResponse response) throws XLRuntimeException, Exception {
        String uid = null;
        String locationType = request.getParameter("locationType");
        if (!this.checkLocationType(locationType)) {
            throw new XLRuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        String pagesizestr = request.getParameter("pagesize");
        String pagenostr = request.getParameter("pageno");
        String typestr = request.getParameter("type");
        int pageSize = this.getPageSize(pagesizestr);
        int pageNo = this.getPageNo(pagenostr);
        StringBuffer sb = new StringBuffer();
        StringBuffer countsb = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        String gameids = null;
        if (isLogin) {
            MainParam param = this.checkMainParam(request, response, true);
            String userName = param.getUserAccount();
            uid = param.getUserid() + "";
            String sessionid = param.getSessionid();
            gameids = this.getLoginGames(userName, sessionid);
        } else {
            uid = this.getUid(request, response);
        }
        if (!this.checkUid(uid)) {
            throw new XLRuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        Object[] objs = this.initArraysAndList(typestr, Integer.parseInt(locationType), uid, gameids, sb, countsb, params, pageNo, pageSize, isLogin);
        List tmlist = FacadeFactory.INSTANCE.getTriggerMessageBo().executeQuery(TriggerMessage.class, sb.toString(), params);
        List<Map<String, String>> resultlist = this.getResultList(tmlist, Integer.parseInt(locationType));
        int count = resultlist.size();
        HashMap<String, Object> backdata = new HashMap<String, Object>();
        backdata.put("messageList", resultlist);
        backdata.put("totalcount", count);
        return backdata;
    }

    public Object getTriggerMessages(XLHttpRequest request, XLHttpResponse response) {
        try {
            Map<String, Object> backdata = this.processData(false, request, response);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, backdata);
        }
        catch (XLRuntimeException e) {
            e.printStackTrace();
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
        }
        catch (Exception e) {
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5185\u90e8\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/message/getnewtriggermessages.do"})
    public Object getNewTriggerMessages(XLHttpRequest request, XLHttpResponse response) {
        try {
            Map<String, Object> backdata = this.processData(true, request, response);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, backdata);
        }
        catch (XLRuntimeException e) {
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u9519\u8bef");
        }
        catch (Exception e) {
            logger.info("\u7528\u6237\u89e6\u8fbe\u6d88\u606f\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5185\u90e8\u9519\u8bef");
        }
    }

    private List<Map<String, String>> getResultList(List<TriggerMessage> tmlist, int type) {
        ArrayList<Map<String, String>> resultlist = new ArrayList<Map<String, String>>();
        if (tmlist != null && tmlist.size() > 0) {
            boolean flag = true;
            if (type == 2 || type == 3) {
                flag = false;
            }
            for (TriggerMessage mes : tmlist) {
                if (!this.isMsgValidTime(mes)) continue;
                this.addResultList(resultlist, mes, flag);
            }
        }
        return resultlist;
    }

    private boolean isMsgValidTime(TriggerMessage msg) {
        String startTimeStr = msg.getStartTime();
        String endTimeStr = msg.getEndTime();
        Date startTime = null;
        Date endTime = null;
        Date now = new Date();
        if (StringUtils.isNotEmpty(startTimeStr)) {
            try {
                startTime = sdf_time.parse(startTimeStr);
                if (startTime.after(now)) {
                    return false;
                }
            }
            catch (ParseException e) {
                logger.error("isMsgValidTime parse startTime:{} Exception", (Object)startTimeStr);
                return false;
            }
        }
        if (StringUtils.isNotEmpty(endTimeStr)) {
            try {
                endTime = sdf_time.parse(endTimeStr);
                if (endTime.before(now)) {
                    return false;
                }
            }
            catch (ParseException e) {
                logger.error("isMsgValidTime parse startTime:{} Exception", (Object)startTimeStr);
                return false;
            }
        }
        return true;
    }

    private void addResultList(List<Map<String, String>> resultlist, TriggerMessage mes, boolean isType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", mes.getSeqid() + "");
        map.put("title", mes.getTitle());
        map.put("inputTime", mes.getInputTime());
        if (isType) {
            map.put("triggerType", mes.getTriggerType() != false ? "1" : "0");
        }
        map.put("content", mes.getContent());
        map.put("linkurl", mes.getLinkUrl());
        map.put("bgPicUrl", mes.getBgPicUrl());
        resultlist.add(map);
    }

    @Deprecated
    private String officalIndexSql(String uid, String gameid, String serverid, boolean iscount) throws Exception {
        String param = "";
        String nowtime = TriggerMessageCmd.now();
        String time = nowtime.split(" ")[0];
        param = param + " and startTime <'" + time + "' and endTime>='" + time + "'";
        StringBuffer sb = new StringBuffer();
        sb.append("  SELECT  " + (iscount ? "count(*)" : "*") + " FROM ").append(" ((SELECT * FROM triggermessage  WHERE locationtype=1  AND isuser=0 " + param + ") ").append(" UNION  ").append(" ((SELECT s1.*  FROM (SELECT * FROM triggermessage  WHERE locationtype=1 AND isuser=1 ) s1   ").append(" INNER JOIN (SELECT * FROM triggeruser WHERE uid='" + uid + "') s2  ").append("  ON s1.seqid = s2.tmid))) s3    ").append(" ORDER BY s3.displayOrder ASC, s3.inputTime DESC  ").append("  LIMIT 1; ");
        return sb.toString();
    }

    private String jinKaSql(String uid, String gameids, boolean isreaded, boolean iscount, boolean isGame) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("  SELECT  " + (iscount ? "count(*)" : "*") + "  from  ((SELECT s7.* FROM  ").append(" (SELECT * FROM triggermessage s8  WHERE locationtype=2 AND  isuser=0 )  s7 ").append(" LEFT JOIN (select  * from triggerreader where uid='" + uid + "') s6 ON s7.seqid = s6.tmid   ").append(" WHERE IFNULL(s6.seqid,0) " + (isreaded ? ">0" : "=0") + " )  ").append(" UNION  ").append(" (SELECT s1.*  FROM (SELECT * FROM triggermessage  WHERE locationtype=2 AND  isuser=1) s1   ").append(" INNER JOIN (SELECT * FROM triggeruser WHERE uid='" + uid + "') s2  ").append("  ON s1.seqid = s2.tmid   ").append("  LEFT JOIN (select * from triggerreader where uid='" + uid + "') s4 ON s1.seqid = s4.tmid   ").append("  WHERE IFNULL(s4.seqid,0) " + (isreaded ? ">0" : "=0") + " )");
        if (isGame) {
            this.getWhere(sb, uid, gameids, isreaded);
        }
        sb.append(") s5").append(" ORDER BY s5.displayOrder ASC, s5.inputTime DESC  ");
        return sb.toString();
    }

    private String gameSql(String uid, String gameids, boolean isreaded, boolean iscount, boolean isGame) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("  SELECT  " + (iscount ? "count(*)" : "*") + "  from  ((SELECT s7.* FROM  ").append(" (SELECT * FROM triggermessage s8  WHERE locationtype=3 AND isuser=0)  s7 ").append(" LEFT JOIN (select * from triggerreader where uid = '" + uid + "') s6 ON s7.seqid = s6.tmid   ").append(" WHERE IFNULL(s6.seqid,0) " + (isreaded ? ">0" : "=0") + " )  ").append(" UNION  ").append(" (SELECT s1.*  FROM (SELECT * FROM triggermessage  WHERE locationtype=3 AND isuser=1) s1   ").append(" INNER JOIN (SELECT * FROM triggeruser WHERE uid='" + uid + "') s2  ").append("  ON s1.seqid = s2.tmid   ").append("  LEFT JOIN (select * from triggerreader where uid='" + uid + "') s4 ON s1.seqid = s4.tmid   ").append("  WHERE IFNULL(s4.seqid,0) " + (isreaded ? ">0" : "=0") + " )");
        if (isGame) {
            this.getWhere(sb, uid, gameids, isreaded);
        }
        sb.append(" ) s5").append(" ORDER BY s5.displayOrder ASC, s5.inputTime DESC  ");
        return sb.toString();
    }

    private void getWhere(StringBuilder sb, String uid, String gameids, boolean isreaded) {
        sb.append(" UNION ").append(" (SELECT s9.* FROM ").append("  (SELECT * FROM triggermessage  WHERE locationtype=1 AND  isuser=0 AND gameid IN (" + gameids + "))  s9  ").append("  LEFT JOIN (SELECT  * FROM triggerreader WHERE uid='" + uid + "') s10 ON s9.seqid = s10.tmid   ").append("  WHERE IFNULL(s10.seqid,0) " + (isreaded ? ">0" : "=0") + ")").append(" UNION  ").append(" (SELECT s11.*  FROM (SELECT * FROM triggermessage  WHERE locationtype=1 AND isuser=1 and  gameid IN (" + gameids + "))  s11   ").append(" INNER JOIN (SELECT * FROM triggeruser WHERE uid='" + uid + "') s12  ").append("  ON s11.seqid = s12.tmid   ").append("  LEFT JOIN (select * from triggerreader where uid='" + uid + "') s14 ON s11.seqid = s14.tmid   ").append("  WHERE IFNULL(s14.seqid,0) " + (isreaded ? ">0" : "=0") + " )");
    }

    @CmdMapper(value={"/message/updatetriggerstatus.do"})
    public Object updateTriggerStatus(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u89e6\u8fbe\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u66f4\u65b0");
        MainParam param = this.checkMainParam(request, response, true);
        String seqid = request.getParameter("seqid");
        if (StringUtils.isEmpty(seqid)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        String uid = param.getUserid() + "";
        try {
            if (seqid.indexOf("_") > -1) {
                String[] sids;
                for (String id : sids = seqid.split("_")) {
                    if (!this.addTriggerReader(uid, id)) continue;
                    return JsonObjectUtil.getOnlyOkJson();
                }
            } else if (this.addTriggerReader(uid, seqid)) {
                return JsonObjectUtil.getOnlyOkJson();
            }
        }
        catch (Exception e) {
            logger.info("\u89e6\u8fbe\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u66f4\u65b0\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
            RetData data = new RetData();
            data.setErrmsg("\u5185\u90e8\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, data);
        }
        return JsonObjectUtil.getOnlyOkJson();
    }

    private boolean addTriggerReader(String uid, String seqid) {
        TriggerReader reader = new TriggerReader();
        reader.setUid(uid);
        reader.setTmid(Long.parseLong(seqid));
        TriggerReader tr = FacadeFactory.INSTANCE.getBaseSo().findObject(reader);
        if (tr != null) {
            return true;
        }
        FacadeFactory.INSTANCE.getBaseSo().addObject(reader);
        return false;
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) {
        try {
            return this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

