/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.message;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.MultimediaTips;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MultimediaTipsCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(MultimediaTipsCmd.class);
    private static final long CACHE_TIME = 180000L;
    private AtomicLong lastUpdateCacheTime = new AtomicLong(0L);
    private ConcurrentHashMap<String, MultimediaTips> displayMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, MultimediaTips> gameDisplayMap = new ConcurrentHashMap();

    @CmdMapper(value={"/message/multimediatips.do"})
    public Object multimediaTips(XLHttpRequest request, XLHttpResponse response) {
        try {
            String displayPage = request.getParameter("xsym");
            if (StringUtils.isEmpty(displayPage)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            MultimediaTips mt = null;
            if ("4".equals(displayPage)) {
                String gameId = request.getParameter("gameid");
                if (StringUtils.isEmpty(gameId)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
                }
                this.checkCache();
                if (!this.gameDisplayMap.containsKey(gameId)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
                }
                mt = this.gameDisplayMap.get(gameId);
            } else {
                this.checkCache();
                if (!this.displayMap.containsKey(displayPage)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
                }
                mt = this.displayMap.get(displayPage);
            }
            if (mt == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, "");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("title", mt.getTitle());
            map.put("url", mt.getJumpToUrl());
            map.put("sc", mt.getSucai());
            map.put("content", mt.getNeirong());
            map.put("display", mt.getInitDisplay());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            logger.info("\u5bcc\u5a92\u4f53tips\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u5185\u90e8\u9519\u8bef");
        }
    }

    private void checkCache() {
        long cur = System.currentTimeMillis();
        long nextUpdateCacheTimes = this.lastUpdateCacheTime.get() + 180000L;
        if (nextUpdateCacheTimes < cur) {
            this.updateCache();
            this.updateGameCache();
            this.lastUpdateCacheTime.set(cur);
        }
    }

    private synchronized void updateCache() {
        logger.info("###\u66f4\u65b0\u5bcc\u5a92\u4f53\u7f13\u5b58###");
        this.displayMap.clear();
        String curDt = MultimediaTipsCmd.now();
        String sql = "select * from multimedia_tips where starttime<= ? and endtime >= ? and displayPage like ? order by starttime desc limit 1";
        for (int i = 1; i <= 3; ++i) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(curDt);
            params.add(curDt);
            params.add("%" + i + "%");
            List list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(MultimediaTips.class, sql, params);
            if (list == null || list.size() <= 0) continue;
            this.displayMap.put(i + "", (MultimediaTips)list.get(0));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, MultimediaTips> e : this.displayMap.entrySet()) {
            sb.append(e.getKey() + "=" + e.getValue().getTitle() + ", ");
        }
        logger.info("[updateGameCache:]" + sb.toString());
    }

    private synchronized void updateGameCache() {
        logger.info("###\u66f4\u65b0\u5bcc\u5a92\u4f53\u6e38\u620f\u5b98\u7f51\u7f13\u5b58###");
        this.gameDisplayMap.clear();
        String curDt = MultimediaTipsCmd.now();
        String sql = "select * from multimedia_tips where starttime<= ? and endtime >= ? and displayPage like '%4%' order by starttime desc limit 1";
        ArrayList<String> params = new ArrayList<String>();
        params.add(curDt);
        params.add(curDt);
        List list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(MultimediaTips.class, sql, params);
        for (MultimediaTips mt : list) {
            String[] gameids;
            for (String gameid : gameids = mt.getGamesIndexPage().split(",")) {
                this.gameDisplayMap.put(gameid.trim(), mt);
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, MultimediaTips> e : this.gameDisplayMap.entrySet()) {
            sb.append(e.getKey() + "=" + e.getValue().getTitle() + ", ");
        }
        logger.info("[updateGameCache:]" + sb.toString());
    }
}

