/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.message;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.RetData;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.Message;
import com.xunlei.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MessageCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(MessageCmd.class);

    @Deprecated
    @CmdMapper(value={"/message/getmessages.do"})
    public Object getMessages(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam param = this.checkMainParam(request, response, true);
            String uid = param.getUserid() + "";
            String pagesizestr = request.getParameter("pagesize");
            String pagenostr = request.getParameter("pageno");
            String typestr = request.getParameter("type");
            int pageSize = 0;
            int pageNo = 0;
            int status = -1;
            pageSize = pagesizestr == null || "".equals(pagesizestr) ? 5 : Integer.parseInt(pagesizestr);
            pageNo = pagenostr == null || "".equals(pagenostr) ? 1 : Integer.parseInt(pagenostr);
            if (typestr != null && !"".equals(typestr)) {
                status = Integer.parseInt(typestr);
            }
            Message message = new Message();
            if (status != -1) {
                message.setStatus(status);
            }
            message.setUid(uid);
            CustomerDetailQuery customer = new CustomerDetailQuery();
            customer.setUid(uid);
            List<CustomerDetailQuery> cdqlist = FacadeFactory.INSTANCE.getCustomerDetailQueryBo().find(customer, new Page());
            StringBuffer csb = new StringBuffer();
            csb.append("SELECT count(*)  FROM ( ").append(" (SELECT * FROM message WHERE messageType = 1 AND uid = ? and status=?)").append("  ) s").append(" ORDER BY s.inputTime DESC ");
            int count = FacadeFactory.INSTANCE.getMessageBo().getMessageCount(csb.toString(), new Object[]{uid, status});
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            long start = (pageNo - 1) * pageSize;
            long end = pageNo * pageSize;
            page.addOrder("inputTime", OrderType.DESC);
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT *  FROM ( ").append(" (SELECT * FROM message WHERE messageType = 1 AND uid = ? and status=?)").append("  ) s").append(" ORDER BY s.inputTime DESC ").append("  limit ?,?");
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(0, uid);
            paramList.add(1, status);
            paramList.add(2, start);
            paramList.add(3, pageSize);
            List list = FacadeFactory.INSTANCE.getMessageBo().findBySql(Message.class, sb.toString(), paramList);
            ArrayList resultlist = new ArrayList();
            if (cdqlist != null || cdqlist.size() > 0) {
                for (Message mes : list) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("id", mes.getSeqid());
                    map.put("title", mes.getTitle());
                    map.put("inputTime", mes.getInputTime().split(" ")[0]);
                    map.put("status", mes.getStatus());
                    resultlist.add(map);
                }
            } else {
                count = 0;
            }
            HashMap<String, Serializable> backdata = new HashMap<String, Serializable>();
            backdata.put("messageList", resultlist);
            backdata.put("totalcount", Integer.valueOf(count));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, backdata);
        }
        catch (Exception e) {
            logger.info("\u83b7\u5f97VIP\u7279\u6743\u6d88\u606f\u5217\u8868\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
            RetData data = new RetData();
            data.setErrmsg("\u5185\u90e8\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, data);
        }
    }

    @CmdMapper(value={"/message/updatestatus.do"})
    public Object updateStatus(XLHttpRequest request, XLHttpResponse response) {
        MainParam param = this.checkMainParam(request, response, true);
        String seqid = request.getParameter("seqid");
        String uid = param.getUserid() + "";
        try {
            String sql = "update message set status = 1 where seqid=? and uid=?";
            ArrayList<Object> paramList = new ArrayList<Object>();
            if (seqid.indexOf("_") > -1) {
                String[] sids;
                for (String id : sids = seqid.split("_")) {
                    paramList.clear();
                    paramList.add(id);
                    paramList.add(uid);
                    FacadeFactory.INSTANCE.getMessageBo().execute(sql, paramList);
                }
            } else {
                paramList.add(seqid);
                paramList.add(uid);
                FacadeFactory.INSTANCE.getMessageBo().execute(sql, paramList);
            }
        }
        catch (Exception e) {
            logger.info("\u6d88\u606f\u9605\u8bfb\u72b6\u6001\u66f4\u65b0\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            e.printStackTrace();
            RetData data = new RetData();
            data.setErrmsg("\u5185\u90e8\u9519\u8bef");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, data);
        }
        return JsonObjectUtil.getOnlyOkJson();
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) {
        try {
            return this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

