/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.lottery.thread;

import com.xunlei.niux.center.enums.MemberShipType;
import com.xunlei.niux.center.so.gift.GiftFlowSo;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftFlow;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import com.xunlei.util.Log;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class ReleaseGiftThread
implements Runnable {
    private static Logger logger = Log.getLogger(ReleaseGiftThread.class);
    private LotteryRecord lotteryRecord;
    private MemberShipType memberShipType;
    private Gift gift;

    public ReleaseGiftThread(LotteryRecord lotteryRecord, MemberShipType memberShipType, Gift gift) {
        this.lotteryRecord = lotteryRecord;
        this.memberShipType = memberShipType;
        this.gift = gift;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            try {
                if (this.lotteryRecord == null) {
                    logger.error("lotteryRecord is null!");
                    return;
                }
                if (this.lotteryRecord.getGiftType().equals("NoGift")) break block16;
                GiftFlow giftFlow = new GiftFlow();
                giftFlow.setActNo(this.lotteryRecord.getActNo());
                giftFlow.setGameId("");
                giftFlow.setServerId("");
                giftFlow.setRoleId("");
                giftFlow.setGiftId(Long.parseLong(this.lotteryRecord.getGiftId()));
                giftFlow.setUserId(this.lotteryRecord.getUserId());
                giftFlow.setGiftNum(1);
                giftFlow.setThirdOrderNo(this.lotteryRecord.getRecordId().toString());
                if (this.memberShipType == MemberShipType.JinZuan) {
                    if (this.gift != null && this.gift.getGiftType().equals("product")) {
                        giftFlow.setShowLocNo("jinzuan_product");
                    } else {
                        giftFlow.setShowLocNo("jinzuan");
                    }
                }
                try {
                    giftFlow = GiftFlowSo.addFlow(giftFlow, true);
                }
                catch (NiuExceptionAndCode e) {
                    logger.error("NiuExceptionAndCode when addFlow to GiftFlow: ", e);
                    if (this.lotteryRecord.getIsProvided().booleanValue()) {
                        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(this.lotteryRecord);
                    }
                    return;
                }
                catch (Exception e) {
                    logger.error("normal Exception when addFlow to GiftFlow: ", e);
                    if (this.lotteryRecord.getIsProvided().booleanValue()) {
                        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(this.lotteryRecord);
                    }
                    return;
                }
                this.lotteryRecord.setIsProvided(true);
                this.countDownGiftLeftCount(this.lotteryRecord);
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.lotteryRecord.getIsProvided().booleanValue()) {
                    FacadeFactory.INSTANCE.getBaseSo().updateObjectById(this.lotteryRecord);
                }
            }
        }
    }

    private void countDownGiftLeftCount(LotteryRecord lotteryRecord) {
        LotteryGift query = new LotteryGift();
        query.setActNo(lotteryRecord.getActNo());
        if (StringUtils.isNotEmpty(lotteryRecord.getModuleId())) {
            query.setActNo(lotteryRecord.getActNo());
        }
        query.setGiftId(lotteryRecord.getGiftId());
        LotteryGift lotteryGift = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        lotteryGift.setLeftCount(lotteryGift.getLeftCount() - 1);
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(lotteryGift);
    }
}

