/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.lottery;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cache.GameCache;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.lottery.LotteryUtil;
import com.xunlei.niux.center.cmd.lottery.thread.AddLotterRecordThread;
import com.xunlei.niux.center.enums.MemberShipType;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.dto.ActivityNGiftNGiftRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import com.xunlei.niux.data.vipgame.vo.onesign.MonthSign;
import com.xunlei.niux.data.vipgame.vo.onesign.MonthSignConf;
import com.xunlei.niux.data.vipgame.vo.onesign.OneSignDaycount;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SignLotteryCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SignLotteryCmd.class);
    private static String separator = ",";
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static ExecutorService executorService = Executors.newCachedThreadPool();

    @CmdMapper(value={"/lottery/signLottery.do"})
    public Object signLottery(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.setInnerContentType(request, response);
            MainParam mainParam = this.getMainParamSafe(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            String userName = UserUtility.getUserNameByUserId(userId);
            String actNo = request.getParameter("actNo", "signLottery");
            String moduleId = request.getParameter("moduleId", "sign1");
            String giftIds = request.getParameter("giftids");
            String remoteIp = request.getRemoteIP();
            logger.info("signLottery request url:" + request.getUrl());
            StringBuilder sb = new StringBuilder();
            int resultcode = -1;
            MonthSignConf query = new MonthSignConf();
            query.setActNo(actNo);
            query.setModuleId(moduleId);
            MonthSignConf monthSignConf = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (monthSignConf == null) {
                logger.error("signLottery Conf not found:" + actNo + "," + moduleId);
                return JsonObjectUtil.getRtnAndDataJsonObject(10, "\u670d\u52a1\u5668\u5f02\u5e38");
            }
            MonthSign query2 = new MonthSign();
            query2.setUid(userId);
            MonthSign monthSign = FacadeFactory.INSTANCE.getBaseSo().findObject(query2);
            if (monthSign == null) {
                logger.error("signLottery continueSign not found:" + actNo + "," + moduleId);
                return JsonObjectUtil.getRtnAndDataJsonObject(11, "\u670d\u52a1\u5668\u5f02\u5e38");
            }
            resultcode = SignLotteryCmd.valid(monthSignConf, monthSign, userId, remoteIp);
            if (resultcode != ResultCode.SUCCESS) {
                sb.append(ResultCode.resultContent.get(resultcode));
                return JsonObjectUtil.getRtnAndDataJsonObject(resultcode, sb.toString());
            }
            Map<String, Object> map = this.doLottery(actNo, moduleId, giftIds, userId, userName, remoteIp);
            String codeStr = map.get("code").toString();
            Object result = map.get("result");
            int code = Integer.parseInt(codeStr);
            if (code != ResultCode.SUCCESS) {
                sb.append(ResultCode.resultContent.get(code) + ": " + result.toString());
                return JsonObjectUtil.getRtnAndDataJsonObject(code, sb.toString());
            }
            LotteryRecord lotteryRecord = (LotteryRecord)result;
            if (lotteryRecord == null) {
                logger.error("doLottery get lotteryRecord result null");
                sb.append(ResultCode.resultContent.get(ResultCode.DOLOTTERYERROR));
                return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOLOTTERYERROR, sb.toString() + ": doLottery get lotteryRecord result null");
            }
            Gift gift = LotteryUtil.getGiftByGiftId(lotteryRecord.getGiftId());
            LotteryUtil.releaseGift(lotteryRecord, MemberShipType.JinZuan, gift);
            monthSign.setTicketNumber(monthSign.getTicketNumber() - 1);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(monthSign);
            Map resultMap = lotteryRecord.toMap();
            if (gift != null) {
                resultMap.put("giftType", gift.getGiftType());
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, resultMap);
        }
        catch (Exception e) {
            logger.error("signLottery Error\uff1a", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, " \u670d\u52a1\u5f02\u5e38");
        }
    }

    private Map<String, Object> doLottery(String actNo, String moduleId, String giftIds, String userId, String userName, String ip) {
        List<LotteryGift> lotteryGifts = LotteryUtil.getGiftsByActNo(actNo, "all", moduleId);
        if (CollectionUtils.isEmpty(lotteryGifts)) {
            logger.error("Activity[ActNo: " + actNo + "]don't has any valid lotteryGifts");
            return SignLotteryCmd.formatMap(ResultCode.NOVALIDLOTTERYGIFTS, "Activity[ActNo: " + actNo + "] don't has any valid lotteryGifts");
        }
        if (StringUtils.isNotEmpty(giftIds)) {
            boolean diffGiftFlag = false;
            List<String> giftIdList = StringUtil.getListFromString(giftIds, separator);
            if (giftIdList.size() != lotteryGifts.size()) {
                diffGiftFlag = true;
            } else {
                for (LotteryGift gift : lotteryGifts) {
                    if (giftIdList.contains(gift.getGiftId())) continue;
                    diffGiftFlag = true;
                    break;
                }
            }
            if (diffGiftFlag) {
                String msg = "Activity[ActNo: " + actNo;
                if (StringUtils.isNotEmpty(moduleId)) {
                    msg = msg + ", moduleId: " + moduleId;
                }
                msg = msg + "] different gifts Error!";
                logger.error(msg);
                return SignLotteryCmd.formatMap(ResultCode.VALIDDIFFGIFTSERROR, msg);
            }
        }
        ArrayList<LotteryGift> validGifts = new ArrayList<LotteryGift>();
        for (LotteryGift gift : lotteryGifts) {
            int giftGotDayNum;
            int giftGotWeekNum;
            int giftGotMonthNum;
            if (gift.getLeftCount() <= 0) {
                logger.warn("Activity[ActNo: " + actNo + ", giftID:" + gift.getGiftId() + "]  LeftCount already used out: ");
                continue;
            }
            if (gift.getMaxNumPerMonth() > 0 && (giftGotMonthNum = SignLotteryCmd.getGiftDrawedCountInPeriod(gift, "month")) >= gift.getMaxNumPerMonth()) {
                logger.warn("Activity[ActNo: " + actNo + "] MaxNumPerMonth\uff1a" + gift.getMaxNumPerMonth() + ", already used num: " + giftGotMonthNum + "; \u5f53\u6708\u5df2\u7ecf\u6d88\u8017\u5b8c\uff01");
                continue;
            }
            if (gift.getMaxNumPerWeek() > 0 && (giftGotWeekNum = SignLotteryCmd.getGiftDrawedCountInPeriod(gift, "week")) >= gift.getMaxNumPerWeek()) {
                logger.warn("Activity[ActNo: " + actNo + "] MaxNumPerWeek\uff1a" + gift.getMaxNumPerWeek() + ", already used num: " + giftGotWeekNum + "; \u5f53\u524d\u661f\u671f\u5df2\u7ecf\u6d88\u8017\u5b8c\uff01");
                continue;
            }
            if (gift.getMaxNumPerDay() > 0 && (giftGotDayNum = SignLotteryCmd.getGiftDrawedCountInPeriod(gift, "day")) >= gift.getMaxNumPerDay()) {
                logger.warn("Activity[ActNo: " + actNo + "] MaxNumPerDay\uff1a" + gift.getMaxNumPerDay() + ", already used num: " + giftGotDayNum + "; \u5f53\u65e5\u5df2\u7ecf\u6d88\u8017\u5b8c\uff01");
                continue;
            }
            validGifts.add(gift);
        }
        if (CollectionUtils.isEmpty(validGifts)) {
            return SignLotteryCmd.formatMap(ResultCode.LOTTERYGIFTSUSEDOUT, "Activity[ActNo: " + actNo + "] Gifts Used Out");
        }
        LotteryGift winGift = SignLotteryCmd.RandomGift(validGifts);
        if (winGift == null) {
            return SignLotteryCmd.formatMap(ResultCode.DOLOTTERYERROR, "Gift Lottery Error, Lottery Result Is null");
        }
        LotteryRecord lotteryRecord = SignLotteryCmd.createLotteryRecord(userId, userName, ip, winGift, false);
        executorService.submit(new AddLotterRecordThread(lotteryRecord));
        return SignLotteryCmd.formatMap(ResultCode.SUCCESS, lotteryRecord);
    }

    private static int valid(MonthSignConf monthSignConf, MonthSign monthSign, String userId, String remoteIp) throws XLRuntimeException {
        Date now = new Date();
        if (StringUtils.isNotEmpty(monthSignConf.getStartTime().trim())) {
            try {
                Date startTime = sdf_time.parse(monthSignConf.getStartTime());
                if (now.before(startTime)) {
                    return ResultCode.ACTIVITYNOTSTART;
                }
            }
            catch (ParseException e) {
                return ResultCode.ACTIVITYDATEPARAMERROR;
            }
        }
        if (StringUtils.isNotEmpty(monthSignConf.getEndTime().trim())) {
            try {
                Date endTime = sdf_time.parse(monthSignConf.getEndTime());
                if (now.after(endTime)) {
                    return ResultCode.ACTIVITYFINISHED;
                }
            }
            catch (ParseException e) {
                return ResultCode.ACTIVITYDATEPARAMERROR;
            }
        }
        if (monthSignConf.getIsValid() != 1) {
            return ResultCode.ACTIVITYINVALID;
        }
        if (monthSign.getTicketNumber() <= 0) {
            return ResultCode.DAYMAXDRAWTIMEERROR;
        }
        return ResultCode.SUCCESS;
    }

    private static int getGiftDrawedCountInPeriod(LotteryGift gift, String timeType) {
        Calendar calendar = Calendar.getInstance();
        int days = 0;
        if (timeType.equals("month")) {
            days = calendar.get(5);
        } else if (timeType.equals("week")) {
            days = calendar.get(7);
        }
        Date curTime = calendar.getTime();
        if (days >= 0) {
            calendar.add(6, days * -1);
        }
        Date startTime = calendar.getTime();
        String startDate = sdf_date.format(startTime);
        LotteryRecord query = new LotteryRecord();
        query.setActNo(gift.getActNo());
        if (StringUtils.isNotEmpty(gift.getModuleId())) {
            query.setModuleId(gift.getModuleId());
        }
        query.setGiftId(gift.getGiftId());
        query.setFromTime(startDate + " 00:00:00");
        query.setToTime(sdf_time.format(curTime));
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        return count;
    }

    private static LotteryGift RandomGift(List<LotteryGift> giftList) {
        if (CollectionUtils.isEmpty(giftList)) {
            return null;
        }
        long totalCount = 0L;
        for (LotteryGift gift : giftList) {
            totalCount += gift.getWinRate().longValue();
        }
        Random random = new Random(new Date().getTime());
        long result = (long)(random.nextDouble() * (double)totalCount) + 1L;
        LotteryGift winGift = null;
        long startIndex = 0L;
        long endIndex = 0L;
        for (LotteryGift gift : giftList) {
            if (result > startIndex && result <= (endIndex += gift.getWinRate().longValue())) {
                winGift = gift;
                break;
            }
            startIndex = endIndex;
        }
        return winGift;
    }

    private static Map<String, Object> formatMap(int code, Object result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("result", result);
        return map;
    }

    public static LotteryRecord createLotteryRecord(String userId, String userName, String remoteIp, LotteryGift winGift, boolean useFreeChanceFlag) {
        Date now = new Date();
        String nowStr = sdf_time.format(now);
        long recordId = now.getTime();
        LotteryRecord lotteryRecord = new LotteryRecord();
        lotteryRecord.setRecordId(recordId);
        lotteryRecord.setActNo(winGift.getActNo());
        lotteryRecord.setModuleId(winGift.getModuleId());
        lotteryRecord.setGiftId(winGift.getGiftId());
        lotteryRecord.setGiftName(winGift.getGiftName());
        lotteryRecord.setGiftType(winGift.getGiftType());
        lotteryRecord.setUserId(userId);
        if (userName == null) {
            userName = "";
        }
        lotteryRecord.setUserName(userName);
        lotteryRecord.setRecordTime(nowStr);
        lotteryRecord.setIp(remoteIp);
        lotteryRecord.setIsProvided(false);
        lotteryRecord.setIsFreeChanceGift(useFreeChanceFlag);
        return lotteryRecord;
    }

    @CmdMapper(value={"/lottery/getSignLottery.do"})
    public Object getSignLottery(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String uid = mainParam.getUserid() + "";
            int rtn = JinZuanClient.isJinZuanUser(mainParam.getUserid() + "");
            if (rtn == 0 || rtn == 3) {
                this.jinzuanSignOneTime(uid);
            }
            int ticketNumber = 0;
            MonthSign queryMS = new MonthSign();
            queryMS.setUid(uid);
            Page page = new Page();
            page.addOrder("lastSignDate", OrderType.DESC);
            List<MonthSign> monthSignList = FacadeFactory.INSTANCE.getBaseSo().findObjects(queryMS, page);
            if (monthSignList != null && monthSignList.size() > 0) {
                ticketNumber = monthSignList.get(0).getTicketNumber();
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, ticketNumber);
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u5f02\u5e38,", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, " \u670d\u52a1\u5f02\u5e38");
        }
    }

    private void jinzuanSignOneTime(String uid) {
        String now = sdf_date.format(new Date());
        MonthSign queryMS = new MonthSign();
        queryMS.setUid(uid);
        MonthSign monthSign = FacadeFactory.INSTANCE.getBaseSo().findObject(queryMS);
        if (monthSign == null) {
            queryMS.setTicketNumber(1);
            queryMS.setMonthSignDays(0);
            queryMS.setLastSignDate("");
            queryMS.setJinzuanGiveDate(now);
            FacadeFactory.INSTANCE.getBaseSo().addObject(queryMS);
            return;
        }
        String jzgd = monthSign.getJinzuanGiveDate();
        if (jzgd == null || DateUtil.compareTime(now, jzgd) > 0L) {
            monthSign.setTicketNumber(monthSign.getTicketNumber() + 1);
            monthSign.setJinzuanGiveDate(now);
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById(monthSign);
        }
    }

    @CmdMapper(value={"/lottery/getSignDayCount.do"})
    public Object getSignDayCount(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String today = sdf_date.format(new Date());
            int count = 0;
            OneSignDaycount query = new OneSignDaycount();
            query.setSignDate(today);
            OneSignDaycount osd = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (osd != null) {
                count = osd.getSignCount();
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, count);
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u5f02\u5e38,", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, " \u670d\u52a1\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/lottery/getSignGiftRecord.do"})
    public Object getSignGiftRecord(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String sql = "SELECT activity.*, gift.* , giftrecord.*, giftshopreleaserecord.*, 0 AS goodId FROM giftrecord \nLEFT JOIN giftshopreleaserecord ON giftrecord.recordId = giftshopreleaserecord.giftRecordId \nLEFT JOIN gift ON giftrecord.giftId = gift.giftId \nLEFT JOIN activity ON giftrecord.actno = activity.actno\nWHERE giftrecord.userid=?  AND giftrecord.actNo='signLottery' AND giftrecord.isshow='1' \nORDER BY giftrecord.recordTime DESC LIMIT 10";
            ArrayList<String> params = new ArrayList<String>();
            params.add(mainParam.getUserid() + "");
            List recordDTOs = FacadeFactory.INSTANCE.getBaseSo().executeQuery(ActivityNGiftNGiftRecordDTO.class, sql, params);
            List<Object> mapList = this.ConvertList(recordDTOs);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, mapList);
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u5f02\u5e38,", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, " \u670d\u52a1\u5f02\u5e38");
        }
    }

    private List<Object> ConvertList(List<?> gflist) {
        ArrayList<Object> mapList = new ArrayList<Object>();
        for (int i = 0; i < gflist.size(); ++i) {
            ActivityNGiftNGiftRecordDTO gr = (ActivityNGiftNGiftRecordDTO)gflist.get(i);
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("thirdRecordId", gr.getRecordId());
            map1.put("actName", gr.getTitle() == null ? "" : gr.getTitle());
            map1.put("productId", gr.getGiftId());
            map1.put("productType", gr.getGiftType());
            map1.put("productNum", gr.getGiftNum());
            map1.put("reportId", gr.getRecordId());
            map1.put("giveOutTime", gr.getRecordTime().substring(0, 10));
            map1.put("productName", gr.getGiftName());
            map1.put("picUrl", gr.getGiftPic());
            map1.put("useExpireDate", gr.getExpireDate());
            map1.put("simpleDesc", gr.getSimpleDesc());
            map1.put("serialNumber", gr.getSerialNumber() == null ? "" : gr.getSerialNumber());
            map1.put("serverName", gr.getServerName() == null ? "" : gr.getServerName());
            this.formatJumpInfo(map1, gr.getGiftType(), gr.getGameid());
            if (!gr.getGiftStatus().equals("WAIT")) {
                map1.put("status", "USED");
            } else {
                String nowDate = sdf_date.format(new Date());
                if (nowDate.compareTo(gr.getExpireDate()) > 0) {
                    map1.put("status", "EXPIRED");
                } else {
                    map1.put("status", "CANUSE");
                }
            }
            if (gr.getReleaseStatus() != null && gr.getReleaseStatus().booleanValue()) {
                map1.put("expressStatus", 1);
            }
            mapList.add(map1);
        }
        return mapList;
    }

    private void formatJumpInfo(Map<String, Object> map, String giftType, String gameid) {
        if ("niuxcash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://niu.xunlei.com/order.html");
            return;
        }
        if ("cash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("baijinvip".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("bjtyhy".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/orderlist.html");
            return;
        }
        if ("gstdll".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/freedom/gstdll.html");
            return;
        }
        if ("jshytyk".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://jsq.xunlei.com/");
            return;
        }
        if ("yuanbao".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("bonus".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("xiubi".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("gift".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            String officialUrl = "";
            Games game = null;
            if (gameid != null && !"".equals(gameid)) {
                game = GameCache.getInstance().getGameById(gameid);
            }
            if (game != null) {
                officialUrl = game.getOfficialWebSite() + "/server.shtml";
            }
            map.put("linkUrl", officialUrl);
            return;
        }
        if ("fortune".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("product".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u7531\u5ba2\u670d\u4eba\u5458\u7ebf\u4e0b\u53d1\u653e");
            map.put("linkUrl", "");
            return;
        }
    }

    @CmdMapper(value={"/lottery/getSignGift.do"})
    public Object getSignGift(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            LotteryGift query = new LotteryGift();
            query.setActNo("signLottery");
            query.setIsValid(true);
            List<LotteryGift> lotteryGifts = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
            ArrayList data = new ArrayList();
            for (LotteryGift gift : lotteryGifts) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("giftName", gift.getGiftName());
                map.put("photo", gift.getPhoto());
                data.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, data);
        }
        catch (Exception e) {
            logger.error("\u670d\u52a1\u5f02\u5e38,", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, " \u670d\u52a1\u5f02\u5e38");
        }
    }
}

