/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.lottery;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.lottery.thread.AddLotterRecordThread;
import com.xunlei.niux.center.cmd.lottery.thread.ReleaseGiftThread;
import com.xunlei.niux.center.enums.MemberShipType;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.jinzuan.MemberInfoClient;
import com.xunlei.niux.client.jinzuan.dto.MemberShipDTO;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.FreeLotteryChance;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import com.xunlei.niux.easyutils.html.HtmlUtil;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class LotteryUtil {
    private static Logger logger = Log.getLogger(LotteryUtil.class);
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static String separator = ",";
    private static final int timeOut = 10;
    private static ExecutorService executorService = Executors.newCachedThreadPool();

    public static int validActivity(LotteryActivity activity, String userId, String remoteIp, boolean useFreeChanceFlag, MemberShipType memberType) {
        int IpDrwaCount;
        int userDrawedCount;
        Date now = new Date();
        String actNo = activity.getActNo();
        if (StringUtils.isNotEmpty(activity.getStartTime().trim())) {
            try {
                Date startTime = sdf_time.parse(activity.getStartTime());
                if (now.before(startTime)) {
                    return ResultCode.ACTIVITYNOTSTART;
                }
            }
            catch (ParseException e) {
                logger.error("Oops, parsing String to Date Exception!", e);
                return ResultCode.ACTIVITYDATEPARAMERROR;
            }
        }
        if (StringUtils.isNotEmpty(activity.getEndTime().trim())) {
            try {
                Date endTime = sdf_time.parse(activity.getEndTime());
                if (now.after(endTime)) {
                    return ResultCode.ACTIVITYFINISHED;
                }
            }
            catch (ParseException e) {
                logger.error("Oops, parsing String to Date Exception!", e);
                return ResultCode.ACTIVITYDATEPARAMERROR;
            }
        }
        if (!activity.getIsValid().booleanValue()) {
            return ResultCode.ACTIVITYINVALID;
        }
        if (useFreeChanceFlag) {
            int chanceCount = LotteryUtil.getFreeChanceCount(Long.parseLong(userId));
            if (chanceCount > 0) {
                return ResultCode.SUCCESS;
            }
            return ResultCode.NOFREECHANCEERROR;
        }
        if (activity.getBonusNum() > 0) {
            BonusClient.UserBonus bonus = BonusClient.queryBonus(userId);
            if (bonus == null) {
                return ResultCode.NOUSERBONUSDATA;
            }
            if (bonus.getBonusNum() < activity.getBonusNum()) {
                return ResultCode.NOTENOUGHBONUS;
            }
        }
        int level = 0;
        if (memberType == MemberShipType.JinKa) {
            level = LotteryUtil.getJinKaLevelNum(Long.parseLong(userId));
        } else if (memberType == MemberShipType.JinZuan) {
            try {
                Map<String, Object> resultMap = MemberInfoClient.getBasicMemberInfo(userId);
                int rtncode = Integer.parseInt(resultMap.get("code").toString());
                if (rtncode != 0) {
                    String msgStr = resultMap.get("data").toString();
                    if (rtncode == 3) {
                        return ResultCode.USERNOTOPENJINZUANYET;
                    }
                    return ResultCode.GETJINZUANMEMBERSHIPERROR;
                }
                MemberShipDTO memberShipDTO = (MemberShipDTO)resultMap.get("data");
                if (memberShipDTO == null) {
                    logger.error("LotteryUtil.validActivity call MemberInfoClient.getMemberInfo result null");
                    return ResultCode.GETJINZUANMEMBERSHIPNULL;
                }
                switch (memberShipDTO.getMemberStatus()) {
                    case 1: {
                        int n = level = memberShipDTO.getLevelNum() == null ? 0 : memberShipDTO.getLevelNum();
                        if (level < 0) {
                            level = 1;
                        }
                        break;
                    }
                    case 0: {
                        if (memberShipDTO.getDuobaoStatus() == 1) {
                            level = 1;
                            break;
                        }
                        return ResultCode.USERJINZUANEXPIRED;
                    }
                    default: {
                        return ResultCode.UNKNOWNJINZUANSTATUS;
                    }
                }
            }
            catch (RuntimeException e) {
                logger.error("LotteryUtil.validActivity call MemberInfoClient.getMemberInfo Exception:", e);
                return ResultCode.GETJINZUANMEMBERSHIPERROR;
            }
        }
        if (activity.getJinKaVipNum() > 0 && level < activity.getJinKaVipNum()) {
            return ResultCode.JINKAVIPLEVEERROR;
        }
        if (activity.getMaxDrawNumEveryday() > 0 && (userDrawedCount = LotteryUtil.getTodayUserDrawedCount(actNo, activity.getModuleId(), userId)) >= activity.getMaxDrawNumEveryday()) {
            return ResultCode.DAYMAXDRAWTIMEERROR;
        }
        if (activity.getMaxIpDrawNumEveryDay() > 0 && (IpDrwaCount = LotteryUtil.getTodayIpDrawedCount(actNo, activity.getModuleId(), remoteIp)) >= activity.getMaxIpDrawNumEveryDay()) {
            return ResultCode.DAYMAXIPDRAWERROR;
        }
        return ResultCode.SUCCESS;
    }

    public static int jinZuanIsUserUsedToday(LotteryActivity activity, String userId, String remoteIp, boolean useFreeChanceFlag, MemberShipType memberType) {
        int userDrawedCount;
        Date now = new Date();
        String actNo = activity.getActNo();
        if (activity.getMaxDrawNumEveryday() > 0 && (userDrawedCount = LotteryUtil.getTodayUserDrawedCount(actNo, activity.getModuleId(), userId)) >= activity.getMaxDrawNumEveryday()) {
            return ResultCode.DAYMAXDRAWTIMEERROR;
        }
        return ResultCode.SUCCESS;
    }

    private static int getJinKaLevelNum(long userId) {
        UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(userId);
        return userVip == null ? 0 : userVip.getVipLervelNum();
    }

    public static Map<String, Object> doLottery(String actNo, String moduleId, String giftIds, String userId, String userName, int bonusNum, String ip, boolean useFreeChanceFlag) {
        List<LotteryGift> lotteryGifts = LotteryUtil.getGiftsByActNo(actNo, "all", moduleId);
        if (CollectionUtils.isEmpty(lotteryGifts)) {
            logger.error("Activity[ActNo: " + actNo + "]don't has any valid lotteryGifts");
            return LotteryUtil.formatMap(ResultCode.NOVALIDLOTTERYGIFTS, "Activity[ActNo: " + actNo + "] don't has any valid lotteryGifts");
        }
        if (StringUtils.isNotEmpty(giftIds)) {
            boolean diffGiftFlag = false;
            List<String> giftIdList = StringUtil.getListFromString(giftIds, separator);
            if (giftIdList.size() != lotteryGifts.size()) {
                diffGiftFlag = true;
            } else {
                for (LotteryGift gift : lotteryGifts) {
                    if (giftIdList.contains(gift.getGiftId())) continue;
                    diffGiftFlag = true;
                    break;
                }
            }
            if (diffGiftFlag) {
                String msg = "Activity[ActNo: " + actNo;
                if (StringUtils.isNotEmpty(moduleId)) {
                    msg = msg + ", moduleId: " + moduleId;
                }
                msg = msg + "] different gifts Error!";
                logger.error(msg);
                return LotteryUtil.formatMap(ResultCode.VALIDDIFFGIFTSERROR, msg);
            }
        }
        ArrayList<LotteryGift> validGifts = new ArrayList<LotteryGift>();
        for (LotteryGift gift : lotteryGifts) {
            int giftGotDayNum;
            int giftGotWeekNum;
            int giftGotMonthNum;
            if (gift.getLeftCount() <= 0) {
                logger.warn("Activity[ActNo: " + actNo + ", giftID:" + gift.getGiftId() + "]  LeftCount already used out: ");
                continue;
            }
            if (gift.getMaxNumPerMonth() > 0 && (giftGotMonthNum = LotteryUtil.getGiftDrawedCountInPeriod(gift, "month")) >= gift.getMaxNumPerMonth()) {
                logger.warn("Activity[ActNo: " + actNo + "] MaxNumPerMonth\uff1a" + gift.getMaxNumPerMonth() + ", already used num: " + giftGotMonthNum + "; \u5f53\u6708\u5df2\u7ecf\u6d88\u8017\u5b8c\uff01");
                continue;
            }
            if (gift.getMaxNumPerWeek() > 0 && (giftGotWeekNum = LotteryUtil.getGiftDrawedCountInPeriod(gift, "week")) >= gift.getMaxNumPerWeek()) {
                logger.warn("Activity[ActNo: " + actNo + "] MaxNumPerWeek\uff1a" + gift.getMaxNumPerWeek() + ", already used num: " + giftGotWeekNum + "; \u5f53\u524d\u661f\u671f\u5df2\u7ecf\u6d88\u8017\u5b8c\uff01");
                continue;
            }
            if (gift.getMaxNumPerDay() > 0 && (giftGotDayNum = LotteryUtil.getGiftDrawedCountInPeriod(gift, "day")) >= gift.getMaxNumPerDay()) {
                logger.warn("Activity[ActNo: " + actNo + "] MaxNumPerDay\uff1a" + gift.getMaxNumPerDay() + ", already used num: " + giftGotDayNum + "; \u5f53\u65e5\u5df2\u7ecf\u6d88\u8017\u5b8c\uff01");
                continue;
            }
            validGifts.add(gift);
        }
        if (CollectionUtils.isEmpty(validGifts)) {
            return LotteryUtil.formatMap(ResultCode.LOTTERYGIFTSUSEDOUT, "Activity[ActNo: " + actNo + "] Gifts Used Out");
        }
        LotteryGift winGift = LotteryUtil.RandomGift(validGifts);
        if (winGift == null) {
            return LotteryUtil.formatMap(ResultCode.DOLOTTERYERROR, "Gift Lottery Error, Lottery Result Is null");
        }
        LotteryRecord lotteryRecord = LotteryUtil.createLotteryRecord(userId, userName, ip, winGift, useFreeChanceFlag);
        if (useFreeChanceFlag) {
            List<FreeLotteryChance> freeChanceList = LotteryUtil.getUnusedFreeChanceList(actNo, userId);
            if (CollectionUtils.isEmpty(freeChanceList)) {
                String msg = "\u6ca1\u6709\u53ef\u7528\u7684\u514d\u8d39\u62bd\u5956\u673a\u4f1a\uff01";
                return LotteryUtil.formatMap(ResultCode.NOUNUSEDFREECHANCEERROR, msg);
            }
            FreeLotteryChance curChance = freeChanceList.get(0);
            curChance.setUsedFlag(true);
            com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(curChance);
        } else if (bonusNum > 0) {
            try {
                String resultCode = BonusClient.consume(userId, userName, bonusNum, lotteryRecord.getRecordId().toString(), sdf_date.format(new Date()), actNo, "");
                if (!resultCode.equals("00")) {
                    return LotteryUtil.formatMap(ResultCode.CONSUMEBONUSERROR, "Bonus Consume Result Code: " + resultCode);
                }
            }
            catch (Exception e) {
                logger.error("Exception when consume bonus ", e);
                return LotteryUtil.formatMap(ResultCode.CONSUMEBONUSERROR, e);
            }
        }
        executorService.submit(new AddLotterRecordThread(lotteryRecord));
        return LotteryUtil.formatMap(ResultCode.SUCCESS, lotteryRecord);
    }

    private static int getGiftDrawedCountInPeriod(LotteryGift gift, String timeType) {
        Calendar calendar = Calendar.getInstance();
        int days = 0;
        if (timeType.equals("month")) {
            days = calendar.get(5);
        } else if (timeType.equals("week")) {
            days = calendar.get(7);
        }
        Date curTime = calendar.getTime();
        if (days >= 0) {
            calendar.add(6, days * -1);
        }
        Date startTime = calendar.getTime();
        String startDate = sdf_date.format(startTime);
        LotteryRecord query = new LotteryRecord();
        query.setActNo(gift.getActNo());
        if (StringUtils.isNotEmpty(gift.getModuleId())) {
            query.setModuleId(gift.getModuleId());
        }
        query.setGiftId(gift.getGiftId());
        query.setFromTime(startDate + " 00:00:00");
        query.setToTime(sdf_time.format(curTime));
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        return count;
    }

    private static LotteryGift RandomGift(List<LotteryGift> giftList) {
        if (CollectionUtils.isEmpty(giftList)) {
            return null;
        }
        long totalCount = 0L;
        for (LotteryGift gift : giftList) {
            totalCount += gift.getWinRate().longValue();
        }
        Random random = new Random(new Date().getTime());
        long result = (long)(random.nextDouble() * (double)totalCount) + 1L;
        LotteryGift winGift = null;
        long startIndex = 0L;
        long endIndex = 0L;
        for (LotteryGift gift : giftList) {
            if (result > startIndex && result <= (endIndex += gift.getWinRate().longValue())) {
                winGift = gift;
                break;
            }
            startIndex = endIndex;
        }
        return winGift;
    }

    private static Map<String, Object> formatMap(int code, Object result) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("result", result);
        return map;
    }

    public static LotteryRecord createLotteryRecord(String userId, String userName, String remoteIp, LotteryGift winGift, boolean useFreeChanceFlag) {
        Date now = new Date();
        String nowStr = sdf_time.format(now);
        long recordId = now.getTime();
        LotteryRecord lotteryRecord = new LotteryRecord();
        lotteryRecord.setRecordId(recordId);
        lotteryRecord.setActNo(winGift.getActNo());
        lotteryRecord.setModuleId(winGift.getModuleId());
        lotteryRecord.setGiftId(winGift.getGiftId());
        lotteryRecord.setGiftName(winGift.getGiftName());
        lotteryRecord.setGiftType(winGift.getGiftType());
        lotteryRecord.setUserId(userId);
        if (userName == null) {
            userName = "";
        }
        lotteryRecord.setUserName(userName);
        lotteryRecord.setRecordTime(nowStr);
        lotteryRecord.setIp(remoteIp);
        lotteryRecord.setIsProvided(false);
        lotteryRecord.setIsFreeChanceGift(useFreeChanceFlag);
        return lotteryRecord;
    }

    public static void deleteLotteryRecord(LotteryRecord lotteryRecord) {
        if (lotteryRecord == null) {
            return;
        }
        List<LotteryRecord> list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(lotteryRecord, new Page());
        if (CollectionUtils.isNotEmpty(list)) {
            for (LotteryRecord record : list) {
                com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().deleteById(LotteryRecord.class, record.getSeqid());
            }
        }
    }

    public static void consumeGiftLeftCount(LotteryGift winGift) {
        LotteryUtil.updateGiftLeftCount(winGift, -1);
    }

    public static void resumeGiftLeftCount(LotteryGift winGift) {
        LotteryUtil.updateGiftLeftCount(winGift, 1);
    }

    private static void updateGiftLeftCount(LotteryGift lotteryGift, int num) {
        lotteryGift.setLeftCount(lotteryGift.getLeftCount() - 1);
        com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(lotteryGift);
    }

    public static void releaseGift(LotteryRecord lotteryRecord, MemberShipType memberShipType, Gift gift) {
        executorService.submit(new ReleaseGiftThread(lotteryRecord, memberShipType, gift));
    }

    private static void setLotteryRecordProvided(LotteryRecord lotteryRecord) {
        if (lotteryRecord == null) {
            return;
        }
        List<LotteryRecord> recordList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(lotteryRecord, new Page());
        if (CollectionUtils.isEmpty(recordList)) {
            return;
        }
        for (LotteryRecord record : recordList) {
            record.setIsProvided(true);
            com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(record);
        }
    }

    public static LotteryActivity getActivityByActNo(String actNo, String moduleId) {
        LotteryActivity activity = null;
        String cacheKey = LotteryUtil.class + "actNo_moduleId" + actNo + moduleId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            LotteryActivity query = new LotteryActivity();
            query.setActNo(actNo);
            if (StringUtils.isNotEmpty(moduleId)) {
                query.setModuleId(moduleId);
            }
            query.setIsValid(true);
            List<LotteryActivity> activities = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
            if (CollectionUtils.isEmpty(activities)) {
                activity = null;
            }
            if ((activity = activities.get(0)) != null) {
                cacheManager.put(cacheKey, activity, 10L);
            }
        } else {
            activity = (LotteryActivity)object;
        }
        return activity;
    }

    public static List<LotteryActivity> getActivityListByActNo(String actNo, String moduleId) {
        LotteryActivity query = new LotteryActivity();
        query.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            query.setModuleId(moduleId);
        }
        query.setIsValid(true);
        List<LotteryActivity> activities = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        if (CollectionUtils.isEmpty(activities)) {
            return null;
        }
        return activities;
    }

    public static int getTodayUserDrawedCount(String actNo, String moduleId, String userId) {
        Date now = new Date();
        LotteryRecord recordQuery = new LotteryRecord();
        String curDate = sdf_date.format(now);
        String fromTime = curDate + " 00:00:00";
        String toTime = sdf_time.format(now);
        recordQuery.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            recordQuery.setModuleId(moduleId);
        }
        recordQuery.setUserId(userId);
        recordQuery.setIsFreeChanceGift(false);
        recordQuery.setFromTime(fromTime);
        recordQuery.setToTime(toTime);
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(recordQuery);
        return count;
    }

    private static int getTodayIpDrawedCount(String actNo, String moduleId, String remoteIp) {
        Date now = new Date();
        LotteryRecord recordQuery = new LotteryRecord();
        String curDate = sdf_date.format(now);
        String fromTime = curDate + " 00:00:00";
        String toTime = sdf_time.format(now);
        recordQuery.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            recordQuery.setModuleId(moduleId);
        }
        recordQuery.setIp(remoteIp);
        recordQuery.setIsFreeChanceGift(false);
        recordQuery.setFromTime(fromTime);
        recordQuery.setToTime(toTime);
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(recordQuery);
        return count;
    }

    public static List<LotteryGift> getGiftsByActNo(String actNo, String giftType) {
        return LotteryUtil.getGiftsByActNo(actNo, giftType, "");
    }

    public static List<LotteryGift> getGiftsByActNo(String actNo, String giftType, String moduleId) {
        LotteryGift giftQuery = new LotteryGift();
        giftQuery.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            giftQuery.setModuleId(moduleId);
        }
        if (StringUtils.isNotEmpty(giftType) && !giftType.equals("all")) {
            giftQuery.setGiftType(giftType);
        }
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.ESC);
        List<LotteryGift> lotteryGifts = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(giftQuery, page);
        return lotteryGifts;
    }

    public static List<LotteryRecord> getLatestLotteryGiftRecord(String actNo, int max) {
        LotteryRecord recordQuery = new LotteryRecord();
        recordQuery.setActNo(actNo);
        recordQuery.setGiftType("GotGift");
        Page page = new Page();
        page.addOrder("recordTime", OrderType.DESC);
        if (max <= 0) {
            max = 20;
        }
        page.setPageNo(1);
        page.setPageSize(max);
        List<LotteryRecord> recordList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(recordQuery, page);
        return recordList;
    }

    public static Gift getGiftById(String giftId) {
        if (StringUtils.isEmpty(giftId)) {
            return null;
        }
        Gift query = new Gift();
        query.setGiftId(Long.parseLong(giftId));
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return gift;
    }

    public static int getFreeChanceCount(Long userId) {
        int leftFreeCount = 0;
        if (userId <= 0L) {
            return leftFreeCount;
        }
        List<FreeLotteryChance> freeChanceList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getFreeLotteryChanceBo().getValidFreeLotteryChanceList(userId, 1);
        if (CollectionUtils.isEmpty(freeChanceList)) {
            return leftFreeCount;
        }
        leftFreeCount = freeChanceList.size();
        return leftFreeCount;
    }

    private static List<FreeLotteryChance> getUnusedFreeChanceList(String actNo, String userId) {
        List<FreeLotteryChance> resultList = new ArrayList<FreeLotteryChance>();
        if (StringUtils.isEmpty(actNo) || StringUtils.isEmpty(userId)) {
            return resultList;
        }
        List<FreeLotteryChance> freeChanceList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getFreeLotteryChanceBo().getValidFreeLotteryChanceList(Long.parseLong(userId), 1);
        if (CollectionUtils.isNotEmpty(freeChanceList)) {
            resultList = freeChanceList;
        }
        return resultList;
    }

    public static int getParttakeCount(String actNo, String moduleId) {
        int count;
        CacheManager cacheManager;
        Object object;
        String cacheKey = LotteryUtil.class.getName();
        cacheKey = cacheKey + actNo;
        LotteryRecord query = new LotteryRecord();
        query.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            query.setModuleId(moduleId);
            cacheKey = cacheKey + "_" + moduleId;
        }
        if ((object = (cacheManager = CacheManager.GetInstance()).get(cacheKey)) == null) {
            count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(query);
            if (count <= 0) {
                count = 0;
            }
            cacheManager.put(cacheKey, count, 10L);
        } else {
            count = Integer.parseInt(object.toString());
        }
        return count;
    }

    public static Gift getGiftByGiftId(String giftId) {
        Gift gift = null;
        String cacheKey = LotteryUtil.class + "GiftId_" + giftId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, giftId);
            if (gift != null) {
                cacheManager.put(cacheKey, gift, 180L);
            }
        } else {
            gift = (Gift)object;
        }
        return gift;
    }

    public static List<Map<String, Object>> getLotteryRecordAllOrder(List<String> actNoList) {
        List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isEmpty(actNoList)) {
            return data;
        }
        String cacheKey = LotteryUtil.class + "getLotteryRecordAllOrder" + LotteryUtil.getStringfromList(actNoList);
        CacheManager cacheManager = CacheManager.GetInstance();
        Object object = cacheManager.get(cacheKey);
        if (object == null) {
            data = LotteryUtil.doGetLotteryRecordAllOrder(actNoList);
            if (CollectionUtils.isNotEmpty(data)) {
                cacheManager.put(cacheKey, data, 10L);
            }
        } else {
            data = (List)object;
        }
        return data;
    }

    private static String getStringfromList(List<String> stringList) {
        String result = "";
        for (String str : stringList) {
            if (!result.equals("")) {
                result = result + ",";
            }
            result = result + str;
        }
        return result;
    }

    private static List<Map<String, Object>> doGetLotteryRecordAllOrder(List<String> actNoList) {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        ArrayList<LotteryRecord> allRecord = new ArrayList<LotteryRecord>();
        for (String actNo : actNoList) {
            List<LotteryRecord> lotteryRecordList = LotteryUtil.getLatestLotteryGiftRecord(actNo, 20);
            if (!CollectionUtils.isNotEmpty(lotteryRecordList)) continue;
            allRecord.addAll(lotteryRecordList);
        }
        if (CollectionUtils.isNotEmpty(allRecord)) {
            Collections.sort(allRecord, new Comparator<LotteryRecord>(){

                @Override
                public int compare(LotteryRecord o1, LotteryRecord o2) {
                    return o2.getRecordId().compareTo(o1.getRecordId());
                }
            });
            for (LotteryRecord record : allRecord) {
                String vagueUserName = HtmlUtil.vagueString(record.getUserName());
                Map map = record.toMap();
                map.put("userName", vagueUserName);
                data.add(map);
            }
        }
        return data;
    }
}

