/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.lottery;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.lottery.LotteryUtil;
import com.xunlei.niux.center.dto.ipinfo.IpInfoDTO;
import com.xunlei.niux.center.enums.MemberShipType;
import com.xunlei.niux.center.enums.ResultCode;
import com.xunlei.niux.center.thirdclient.ipinfoclient.IPInfoLookUpClient;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.bo.lottery.dto.LotteryRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryActivity;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryRecord;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class LotteryCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(LotteryCmd.class);
    private static String separator = ",";
    private static String userImgUrl = "http://img.user.kanimg.com/usrimg/%s/100x100";
    private static String JifenLotteryActNo = "jifenshoplottery";
    private String msg = "";

    @CmdMapper(value={"/lottery/getLotteryActInfo.do"})
    public Object getLotteryActInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String actNos = request.getParameter("actno");
        StringBuilder sb = new StringBuilder();
        String msg = "";
        if (StringUtils.isEmpty(actNos)) {
            msg = "Param actNo can't be empty!";
            logger.error(msg);
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM) + ":" + msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        List<String> actNoList = StringUtil.getListFromString(actNos, separator);
        if (CollectionUtils.isEmpty(actNoList)) {
            msg = ResultCode.resultContent.get(ResultCode.SEPARATORGETACTNOERROR);
            logger.error(msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SEPARATORGETACTNOERROR, msg);
        }
        HashMap data = new HashMap();
        for (String actNo : actNoList) {
            int usedDrawCount;
            HashMap<String, Object> actMap = new HashMap<String, Object>();
            LotteryActivity activity = LotteryUtil.getActivityByActNo(actNo, null);
            if (activity == null) continue;
            int todayTotalDrawCount = activity.getMaxDrawNumEveryday();
            int leftCount = todayTotalDrawCount - (usedDrawCount = LotteryUtil.getTodayUserDrawedCount(actNo, activity.getModuleId(), String.valueOf(userId)));
            if (leftCount <= 0) {
                leftCount = 0;
            }
            actMap.putAll(activity.toMap());
            int freeChanceCount = LotteryUtil.getFreeChanceCount(userId);
            actMap.put("leftCount", leftCount + freeChanceCount);
            if (activity.getHasFreeChance().booleanValue()) {
                actMap.put("freeChanceType", freeChanceCount > 0 ? 1 : 0);
            }
            data.put(actNo, actMap);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, data);
    }

    @CmdMapper(value={"/lottery/getLotteryGiftsInfo.do"})
    public Object getLotteryGiftsInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNos = request.getParameter("actno");
        StringBuilder sb = new StringBuilder();
        String msg = "";
        if (StringUtils.isEmpty(actNos)) {
            msg = "Param actNo can't be empty!";
            logger.error(msg);
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM) + ":" + msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        List<String> actNoList = StringUtil.getListFromString(actNos, separator);
        if (CollectionUtils.isEmpty(actNoList)) {
            msg = ResultCode.resultContent.get(ResultCode.SEPARATORGETACTNOERROR);
            logger.error(msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SEPARATORGETACTNOERROR, msg);
        }
        HashMap data = new HashMap();
        for (String actNo : actNoList) {
            HashMap<String, Object> actMap = new HashMap<String, Object>();
            actMap.put("actNo", actNo);
            ArrayList<Map<String, Object>> giftsList = new ArrayList<Map<String, Object>>();
            List<LotteryGift> lotteryGiftList = LotteryUtil.getGiftsByActNo(actNo, "GotGift");
            if (CollectionUtils.isNotEmpty(lotteryGiftList)) {
                for (LotteryGift lotterygift : lotteryGiftList) {
                    giftsList.add(lotterygift.toMap());
                }
            }
            actMap.put("gifts", giftsList);
            data.put(actNo, actMap);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, data);
    }

    @CmdMapper(value={"/lottery/doLottery.do"})
    public Object doLottery(XLHttpRequest request, XLHttpResponse response) {
        LotteryActivity activity;
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String userName = UserUtility.getUserNameByUserId(userId);
        String actNo = request.getParameter("actno");
        String moduleId = request.getParameter("moduleid");
        String giftIds = request.getParameter("giftids");
        String useFreeChance = request.getParameter("userfreechance");
        String remoteIp = request.getRemoteIP();
        String msg = "Current URL: /lottery/doLottery.do?actno=" + actNo;
        if (StringUtils.isNotEmpty(moduleId)) {
            msg = msg + "&moduleid=" + moduleId;
        }
        if (StringUtils.isNotEmpty(giftIds)) {
            msg = msg + "&giftids=" + giftIds;
        }
        logger.info(msg);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(actNo) || StringUtils.isEmpty(userId)) {
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        int resultcode = -1;
        boolean useFreeChanceFlag = false;
        if (StringUtils.isNotEmpty(useFreeChance) && Integer.parseInt(useFreeChance) > 0) {
            useFreeChanceFlag = true;
        }
        if ((activity = LotteryUtil.getActivityByActNo(actNo, moduleId)) == null) {
            sb.append(ResultCode.resultContent.get(ResultCode.ACTIVITYNOTFOUND));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.ACTIVITYNOTFOUND, sb.toString());
        }
        resultcode = LotteryUtil.validActivity(activity, userId, remoteIp, useFreeChanceFlag, MemberShipType.JinKa);
        if (resultcode != ResultCode.SUCCESS) {
            sb.append(ResultCode.resultContent.get(resultcode));
            return JsonObjectUtil.getRtnAndDataJsonObject(resultcode, sb.toString());
        }
        LotteryRecord lotteryRecord = null;
        try {
            Map<String, Object> map = LotteryUtil.doLottery(actNo, moduleId, giftIds, userId, userName, activity.getBonusNum(), remoteIp, useFreeChanceFlag);
            String codeStr = map.get("code").toString();
            Object result = map.get("result");
            int code = Integer.parseInt(codeStr);
            if (code != ResultCode.SUCCESS) {
                sb.append(ResultCode.resultContent.get(code) + ": " + result.toString());
                return JsonObjectUtil.getRtnAndDataJsonObject(code, sb.toString());
            }
            lotteryRecord = (LotteryRecord)result;
            if (lotteryRecord == null) {
                logger.error("doLottery get lotteryRecord result null");
                sb.append(ResultCode.resultContent.get(ResultCode.DOLOTTERYERROR));
                return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOLOTTERYERROR, sb.toString() + ": doLottery get lotteryRecord result null");
            }
        }
        catch (Exception e) {
            logger.error("doLottery Error\uff1a", e);
            sb.append(ResultCode.resultContent.get(ResultCode.DOLOTTERYERROR));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOLOTTERYERROR, sb.toString() + ": " + e.getMessage());
        }
        Gift gift = LotteryUtil.getGiftByGiftId(lotteryRecord.getGiftId());
        LotteryUtil.releaseGift(lotteryRecord, MemberShipType.JinKa, gift);
        Map resultMap = lotteryRecord.toMap();
        if (gift != null) {
            resultMap.put("giftType", gift.getGiftType());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, resultMap);
    }

    @CmdMapper(value={"/lottery/getLotteryRecord.do"})
    public Object getLotteryRecord(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNos = request.getParameter("actno");
        StringBuilder sb = new StringBuilder();
        String msg = "";
        if (StringUtils.isEmpty(actNos)) {
            msg = "Param actNo can't be empty!";
            logger.error(msg);
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM) + ":" + msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        List<String> actNoList = StringUtil.getListFromString(actNos, separator);
        if (CollectionUtils.isEmpty(actNoList)) {
            msg = ResultCode.resultContent.get(ResultCode.SEPARATORGETACTNOERROR);
            logger.error(msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SEPARATORGETACTNOERROR, msg);
        }
        ArrayList data = new ArrayList();
        for (String actNo : actNoList) {
            HashMap<String, Object> actMap = new HashMap<String, Object>();
            actMap.put("actNo", actNo);
            ArrayList<Map> recordList = new ArrayList<Map>();
            List<LotteryRecord> lotteryRecordList = LotteryUtil.getLatestLotteryGiftRecord(actNo, 10);
            int getCount = 0;
            if (CollectionUtils.isNotEmpty(lotteryRecordList)) {
                getCount = lotteryRecordList.size();
                for (LotteryRecord record : lotteryRecordList) {
                    recordList.add(record.toMap());
                }
            }
            actMap.put("gotCount", getCount);
            actMap.put("lotteryrecords", recordList);
            data.add(actMap);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, data);
    }

    @CmdMapper(value={"/lottery/getLotteryRecord_AllOrder.do"})
    public Object getLotteryRecord_AllOrder(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNos = request.getParameter("actno");
        StringBuilder sb = new StringBuilder();
        String msg = "";
        if (StringUtils.isEmpty(actNos)) {
            msg = "Param actNo can't be empty!";
            logger.error(msg);
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM) + ":" + msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        List<String> actNoList = StringUtil.getListFromString(actNos, separator);
        if (CollectionUtils.isEmpty(actNoList)) {
            msg = ResultCode.resultContent.get(ResultCode.SEPARATORGETACTNOERROR);
            logger.error(msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SEPARATORGETACTNOERROR, msg);
        }
        List<Map<String, Object>> data = LotteryUtil.getLotteryRecordAllOrder(actNoList);
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, data);
    }

    @CmdMapper(value={"/lottery/jinzuanLottery.do"})
    public Object jinZuanLottery(XLHttpRequest request, XLHttpResponse response) {
        LotteryActivity activity;
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String userName = UserUtility.getUserNameByUserId(userId);
        String actNo = request.getParameter("actno");
        String moduleId = request.getParameter("moduleid");
        String giftIds = request.getParameter("giftids");
        String useFreeChance = request.getParameter("userfreechance");
        String remoteIp = request.getRemoteIP();
        logger.info("jinZuanLottery request url:" + request.getUrl());
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(actNo) || StringUtils.isEmpty(userId)) {
            sb.append(ResultCode.resultContent.get(ResultCode.INVALIDPARAM));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, sb.toString());
        }
        int resultcode = -1;
        boolean useFreeChanceFlag = false;
        if (StringUtils.isNotEmpty(useFreeChance) && Integer.parseInt(useFreeChance) > 0) {
            useFreeChanceFlag = true;
        }
        if ((activity = LotteryUtil.getActivityByActNo(actNo, moduleId)) == null) {
            sb.append(ResultCode.resultContent.get(ResultCode.ACTIVITYNOTFOUND));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.ACTIVITYNOTFOUND, sb.toString());
        }
        resultcode = LotteryUtil.validActivity(activity, userId, remoteIp, useFreeChanceFlag, MemberShipType.JinZuan);
        if (resultcode != ResultCode.SUCCESS) {
            sb.append(ResultCode.resultContent.get(resultcode));
            return JsonObjectUtil.getRtnAndDataJsonObject(resultcode, sb.toString());
        }
        LotteryRecord lotteryRecord = null;
        try {
            Map<String, Object> map = LotteryUtil.doLottery(actNo, moduleId, giftIds, userId, userName, activity.getBonusNum(), remoteIp, useFreeChanceFlag);
            String codeStr = map.get("code").toString();
            Object result = map.get("result");
            int code = Integer.parseInt(codeStr);
            if (code != ResultCode.SUCCESS) {
                sb.append(ResultCode.resultContent.get(code) + ": " + result.toString());
                return JsonObjectUtil.getRtnAndDataJsonObject(code, sb.toString());
            }
            lotteryRecord = (LotteryRecord)result;
            if (lotteryRecord == null) {
                logger.error("doLottery get lotteryRecord result null");
                sb.append(ResultCode.resultContent.get(ResultCode.DOLOTTERYERROR));
                return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOLOTTERYERROR, sb.toString() + ": doLottery get lotteryRecord result null");
            }
        }
        catch (Exception e) {
            logger.error("doLottery Error\uff1a", e);
            sb.append(ResultCode.resultContent.get(ResultCode.DOLOTTERYERROR));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.DOLOTTERYERROR, sb.toString() + ": " + e.getMessage());
        }
        Gift gift = LotteryUtil.getGiftByGiftId(lotteryRecord.getGiftId());
        LotteryUtil.releaseGift(lotteryRecord, MemberShipType.JinZuan, gift);
        Map resultMap = lotteryRecord.toMap();
        if (gift != null) {
            resultMap.put("giftType", gift.getGiftType());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, resultMap);
    }

    @CmdMapper(value={"/lottery/getlotteryinfo.do"})
    public Object getLotteryInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNo = request.getParameter("actno");
        String moduleId = request.getParameter("moduleid");
        if (StringUtils.isEmpty(actNo)) {
            this.msg = "\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!";
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.INVALIDPARAM, this.msg);
        }
        List<LotteryGift> lotteryGiftList = LotteryUtil.getGiftsByActNo(actNo, "GotGift");
        if (CollectionUtils.isEmpty(lotteryGiftList)) {
            this.msg = "\u6ca1\u6709\u5bf9\u5e94\u7684\u5956\u54c1\u6570\u636e\uff01";
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(2, this.msg);
        }
        boolean isHasModule = false;
        List<String> moduleList = StringUtil.getListFromString(moduleId, ",");
        if (CollectionUtils.isNotEmpty(moduleList)) {
            isHasModule = true;
        }
        ArrayList resultList = new ArrayList();
        for (LotteryGift gift : lotteryGiftList) {
            if (isHasModule && !moduleList.contains(gift.getModuleId())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("actNo", actNo);
            map.put("moduleId", gift.getModuleId());
            map.put("giftId", gift.getGiftId());
            map.put("giftName", gift.getGiftName());
            map.put("leftCount", gift.getLeftCount());
            map.put("partakeCount", LotteryUtil.getParttakeCount(gift.getActNo(), gift.getModuleId()));
            resultList.add(map);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, resultList);
    }

    @CmdMapper(value={"/lottery/isUserCanLottery.do"})
    public Object isUserCanLottery(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String actNo = request.getParameter("actno");
        String moduleId = request.getParameter("moduleid");
        String remoteIp = request.getRemoteIP();
        boolean useFreeChanceFlag = false;
        StringBuilder sb = new StringBuilder();
        List<LotteryActivity> activityList = LotteryUtil.getActivityListByActNo(actNo, null);
        if (CollectionUtils.isEmpty(activityList)) {
            sb.append(ResultCode.resultContent.get(ResultCode.ACTIVITYNOTFOUND));
            return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.ACTIVITYNOTFOUND, sb.toString());
        }
        ArrayList resultList = new ArrayList();
        boolean isHasModule = false;
        List<String> moduleList = StringUtil.getListFromString(moduleId, ",");
        if (CollectionUtils.isNotEmpty(moduleList)) {
            isHasModule = true;
        }
        for (LotteryActivity activity : activityList) {
            if (isHasModule && !moduleList.contains(activity.getModuleId())) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("moduleId", activity.getModuleId());
            int resultcode = LotteryUtil.jinZuanIsUserUsedToday(activity, userId, remoteIp, useFreeChanceFlag, MemberShipType.JinZuan);
            if (resultcode != ResultCode.SUCCESS) {
                map.put("isUse", false);
            } else {
                map.put("isUse", true);
            }
            resultList.add(map);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(ResultCode.SUCCESS, resultList);
    }

    @CmdMapper(value={"/lottery/getLotteryRecordWithUserInfo.do"})
    public Object getLotteryRecordWithUserInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String actNo = request.getParameter("actno");
        int productType = request.getParameterInteger("producttype", 0);
        if (StringUtils.isEmpty(actNo)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570actno\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String giftType = "";
        if (productType == 1) {
            giftType = "product";
        }
        List<Map> resultList = null;
        String cacheKey = "getLotteryRecordWithUserInfo_" + actNo + giftType;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey);
        if (obj == null) {
            resultList = this.getLotteryRecordWithUserInfo(actNo, giftType);
            if (CollectionUtils.isNotEmpty(resultList)) {
                cacheManager.put(cacheKey, resultList, 30L);
            }
        } else {
            resultList = (List<Map>)obj;
        }
        if (CollectionUtils.isEmpty(resultList)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u6ca1\u6709\u4e2d\u5956\u8bb0\u5f55");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
    }

    @CmdMapper(value={"/lottery/isLotteryEnoughTimesToday.do"})
    public Object isLotteryEnoughTimesToday(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String userId = request.getParameter("userId", "");
        Integer expectCount = request.getParameterInteger("count");
        if (StringUtils.isEmpty(userId)) {
            logger.error("isLotteryEnoughTimesOneDay params invalid!");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        int recordCount = LotteryUtil.getTodayUserDrawedCount("", "", userId);
        boolean isGetGiftEnought = recordCount >= expectCount;
        map.put("result", isGetGiftEnought);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    private List<Map> getLotteryRecordWithUserInfo(String actNo, String giftType) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        List<LotteryRecordDTO> lotteryProductRecordList = FacadeFactory.INSTANCE.getLotteryRecordBo().getLotteryRecordByActNoAndGiftType(JifenLotteryActNo, giftType, 30);
        if (CollectionUtils.isEmpty(lotteryProductRecordList)) {
            return resultList;
        }
        List<LotteryGift> lotteryGiftList = LotteryUtil.getGiftsByActNo(actNo, "GotGift");
        if (CollectionUtils.isEmpty(lotteryGiftList)) {
            return resultList;
        }
        HashMap<String, LotteryGift> lotteryGiftMap = new HashMap<String, LotteryGift>();
        for (LotteryGift lotteryGift : lotteryGiftList) {
            lotteryGiftMap.put(lotteryGift.getGiftId(), lotteryGift);
        }
        for (LotteryRecordDTO lotteryRecordDTO : lotteryProductRecordList) {
            LotteryGift lotteryGift = (LotteryGift)lotteryGiftMap.get(lotteryRecordDTO.getGiftId());
            if (lotteryGift == null) {
                logger.error("giftId:{} not exist in actNo:{} lotteryGift config", (Object)lotteryRecordDTO.getGiftId(), (Object)lotteryRecordDTO.getActNo());
                continue;
            }
            try {
                String userName = UserUtility.getUserNameByUserId(lotteryRecordDTO.getUserId());
                lotteryRecordDTO.setUserName(userName);
            }
            catch (Exception e) {
                logger.error("UserUtility.getUserNameByUserId Exception", e);
            }
            lotteryRecordDTO.setGiftPicUrl(lotteryGift.getPhoto());
            lotteryRecordDTO.setUserImgUrl(String.format(userImgUrl, lotteryRecordDTO.getUserId()));
            IPInfoLookUpClient ininfolookup = new IPInfoLookUpClient();
            IpInfoDTO ipInfoDTO = ininfolookup.getIpInfo(lotteryRecordDTO.getIp());
            lotteryRecordDTO.setProvince(ipInfoDTO == null ? "\\u4e2d\\u56fd" : ipInfoDTO.getProvince());
            resultList.add(lotteryRecordDTO.toMap());
        }
        return resultList;
    }

    @CmdMapper(value={"/commonactivity/hastodaylottery.do"})
    public Object hastodaylottery(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String actno = request.getParameter("actno");
        if (StringUtils.isEmpty(actno)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u9519\u8bef");
        }
        String userid = request.getParameter("userid");
        try {
            if (StringUtils.isEmpty(userid)) {
                userid = this.getMainParam(request, response, true).getUserid() + "";
            }
            LotteryRecord query = new LotteryRecord();
            query.setUserId(userid);
            query.setActNo(actno);
            String curDate = DateUtil.formatNow("yyyy-MM-dd");
            query.setFromTime(curDate);
            query.setToTime(curDate + " 23:59:59");
            int count = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
            if (count > 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4eca\u5929\u5df2\u62bd\u5956");
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u4eca\u5929\u672a\u62bd\u5956");
        }
        catch (Throwable e) {
            logger.error("isGameHasGiftPackage Exception", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u7f51\u7edc\u9519\u8bef!");
        }
    }
}

