/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.lottery;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.gift.GiftFlowSo;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.FortuneGift;
import com.xunlei.niux.data.vipgame.vo.FortuneGiftLot;
import com.xunlei.niux.data.vipgame.vo.FortuneGiftRecord;
import com.xunlei.niux.data.vipgame.vo.FortuneInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftFlow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class FortuneCmd
extends DefaultCmd {
    private static final String ACT_FORTUNEGIFT = "fortunegift";

    @CmdMapper(value={"/fortune/getfortunegiftinfo.do"})
    public Object getFortuneGiftInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String fortuneGiftIds = request.getParameter("fortuneGiftIds", "");
        String[] fortuneGiftIdArray = fortuneGiftIds.split("_");
        FortuneInfo fortuneInfo = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneInfo.class, mainParam.getUserid());
        int fortunePoint = fortuneInfo == null ? 0 : fortuneInfo.getFortunePoint().intValue();
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        resultMap.put("fortunePoint", Integer.valueOf(fortunePoint));
        ArrayList fortuenGiftList = new ArrayList();
        for (String fortuneGiftId : fortuneGiftIdArray) {
            FortuneGift fortuneGift;
            if (fortuneGiftId == null || "".equals(fortuneGiftId) || (fortuneGift = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneGift.class, fortuneGiftId)) == null) continue;
            HashMap<String, String> tempMap = new HashMap<String, String>();
            tempMap.put("fortuneGiftId", fortuneGiftId);
            if (fortunePoint < fortuneGift.getFortunePoint()) {
                tempMap.put("status", "0");
                fortuenGiftList.add(tempMap);
                continue;
            }
            String fortuneGiftRecordNo = mainParam.getUserid() + "_" + fortuneGift.getFortuneGiftLotId() + "_" + fortuneGift.getGiftId();
            FortuneGiftRecord fortuneGiftRecord = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneGiftRecord.class, fortuneGiftRecordNo);
            String status = fortuneGiftRecord == null ? "1" : "2";
            tempMap.put("status", status);
            fortuenGiftList.add(tempMap);
        }
        resultMap.put("fortuenGiftList", fortuenGiftList);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/fortune/getfortunegift.do"})
    public Object getFortuneGift(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        long fortuneGiftId = request.getParameterLong("fortuneGiftId");
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        FortuneGift fortuneGift = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneGift.class, fortuneGiftId);
        try {
            this.checkFortuneGiftValid(fortuneGift);
        }
        catch (NiuExceptionAndCode e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage(), null);
        }
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, fortuneGift.getGiftId());
        try {
            this.checkGiftValid(gift);
        }
        catch (NiuExceptionAndCode e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage(), null);
        }
        String recordNo = mainParam.getUserid() + "_" + fortuneGift.getFortuneGiftLotId() + "_" + fortuneGift.getGiftId();
        FortuneGiftRecord fortuneGiftRecord = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneGiftRecord.class, recordNo);
        if (fortuneGiftRecord != null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(3031, "\u5df2\u7ecf\u9886\u53d6\u4eba\u54c1\u5956\u54c1", null);
        }
        FortuneInfo fortuneInfo = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneInfo.class, mainParam.getUserid());
        try {
            this.checkFortuneInfoEnough(fortuneGift.getFortunePoint(), fortuneInfo);
        }
        catch (NiuExceptionAndCode e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage(), null);
        }
        try {
            fortuneGiftRecord = new FortuneGiftRecord();
            fortuneGiftRecord.setFortuneNum(fortuneGift.getFortunePoint());
            fortuneGiftRecord.setGiftId(fortuneGift.getGiftId());
            fortuneGiftRecord.setRecordNo(recordNo);
            fortuneGiftRecord.setRecordStatus("WAIT");
            fortuneGiftRecord.setRecordTime(sdf_time.format(new Date()));
            fortuneGiftRecord.setUserId(String.valueOf(mainParam.getUserid()));
            FacadeFactory.INSTANCE.getBaseSo().addObject(fortuneGiftRecord);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.getMessage(), null);
        }
        fortuneGiftRecord = this.giveOutGift(fortuneGiftRecord);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("giftType", gift.getGiftType());
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u9886\u53d6\u6210\u529f", resultMap);
    }

    private FortuneGiftRecord giveOutGift(FortuneGiftRecord giftRecord) {
        GiftFlow giftFlow = new GiftFlow();
        giftFlow.setActNo(ACT_FORTUNEGIFT);
        giftFlow.setGameId("");
        giftFlow.setServerId("");
        giftFlow.setRoleId("");
        giftFlow.setGiftId(giftRecord.getGiftId());
        giftFlow.setUserId(giftRecord.getUserId());
        giftFlow.setGiftNum(1);
        giftFlow.setThirdOrderNo(giftRecord.getRecordNo());
        String recordStatus = "FAIL";
        try {
            giftFlow = GiftFlowSo.addFlow(giftFlow, true);
            recordStatus = "S".equals(giftFlow.getFlowStatus()) ? "SUCCESS" : "FAIL";
        }
        catch (NiuExceptionAndCode e) {
            recordStatus = "FAIL";
        }
        giftRecord.setRecordStatus(recordStatus);
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(giftRecord);
        return giftRecord;
    }

    private void checkFortuneInfoEnough(int fortuneNum, FortuneInfo fortuneInfo) throws NiuExceptionAndCode {
        if (fortuneNum == 0) {
            return;
        }
        if (fortuneInfo == null) {
            throw new NiuExceptionAndCode("3030", "\u4eba\u54c1\u503c\u4e0d\u591f");
        }
        if ((long)fortuneNum > fortuneInfo.getFortunePoint()) {
            throw new NiuExceptionAndCode("3030", "\u4eba\u54c1\u503c\u4e0d\u591f");
        }
    }

    private void checkGiftValid(Gift gift) throws NiuExceptionAndCode {
        if (gift == null) {
            throw new NiuExceptionAndCode("3000", "\u793c\u5305\u4e0d\u5b58\u5728");
        }
        if (!gift.getIsValid().booleanValue()) {
            throw new NiuExceptionAndCode("3001", "\u65e0\u6548\u793c\u5305");
        }
    }

    private void checkFortuneGiftValid(FortuneGift fortuneGift) throws NiuExceptionAndCode {
        if (fortuneGift == null) {
            throw new NiuExceptionAndCode("3000", "\u793c\u5305\u4e0d\u5b58\u5728");
        }
        if (!fortuneGift.getIsValid().booleanValue()) {
            throw new NiuExceptionAndCode("3001", "\u65e0\u6548\u793c\u5305");
        }
        FortuneGiftLot fortuneGiftLot = FacadeFactory.INSTANCE.getBaseSo().findById(FortuneGiftLot.class, fortuneGift.getFortuneGiftLotId());
        if (fortuneGiftLot == null) {
            throw new NiuExceptionAndCode("3000", "\u793c\u5305\u6279\u53f7" + fortuneGift.getFortuneGiftLotId() + "\u4e0d\u5b58\u5728");
        }
        if (!fortuneGiftLot.getIsValid().booleanValue()) {
            throw new NiuExceptionAndCode("3001", "\u793c\u5305\u6279\u53f7" + fortuneGift.getFortuneGiftLotId() + "\u65e0\u6548");
        }
        String now = sdf_time.format(new Date());
        if (now.compareTo(fortuneGiftLot.getBeginTime()) < 0) {
            throw new NiuExceptionAndCode("3001", "\u793c\u5305\u6279\u53f7" + fortuneGift.getFortuneGiftLotId() + "\u672a\u5f00\u542f");
        }
        if (now.compareTo(fortuneGiftLot.getEndTime()) > 0) {
            throw new NiuExceptionAndCode("3001", "\u793c\u5305\u6279\u53f7" + fortuneGift.getFortuneGiftLotId() + "\u5df2\u7ed3\u675f");
        }
    }
}

