/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan.thread;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.niux.client.bonus.BonusClient;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.data.jinzuanbiz.enums.BonusExStatusEnum;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuanbiz.vo.BonusExchangeCoin;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;

public class RollBackBonusExThread
implements Runnable {
    private static Logger logger = Log.getLogger(RollBackBonusExThread.class);
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static final String actNo = "BonusExchangeCoin";
    private static final int TotalTryTimes = 3;
    private BonusExchangeCoin exchangeCoin;

    public RollBackBonusExThread(BonusExchangeCoin exchangeCoin) {
        this.exchangeCoin = exchangeCoin;
    }

    @Override
    public void run() {
        logger.info("start RollBack BonusExchangeCoin: " + this.exchangeCoin.toString());
        for (int tryTime = 1; tryTime <= 3 && this.exchangeCoin.getStatus().intValue() != BonusExStatusEnum.NotConsumePrivilege.getValue(); ++tryTime) {
            String userName = UserUtility.getUserNameByUserId(this.exchangeCoin.getUserId().toString());
            if (this.exchangeCoin.getStatus().intValue() == BonusExStatusEnum.ConsumedBonusNotPay.getValue() && this.rollBackBonus(this.exchangeCoin, userName)) {
                this.exchangeCoin.setStatus(BonusExStatusEnum.NotConsumeBonus.getValue());
            }
            if (this.exchangeCoin.getStatus().intValue() != BonusExStatusEnum.NotConsumeBonus.getValue() || !this.rollBackPrivilege(this.exchangeCoin)) continue;
            this.exchangeCoin.setStatus(BonusExStatusEnum.NotConsumePrivilege.getValue());
        }
        if (this.exchangeCoin.getStatus().intValue() != BonusExStatusEnum.NotConsumePrivilege.getValue()) {
            FacadeFactory.INSTANCE.getBaseSo().addObject(this.exchangeCoin);
        }
        logger.info("end RollBack BonusExchangeCoin: " + this.exchangeCoin.toString());
    }

    private boolean rollBackBonus(BonusExchangeCoin exchangeCoin, String userName) {
        Date now = new Date();
        long time = now.getTime();
        Random random = new Random(System.currentTimeMillis());
        String orderId = "BExRoll" + time + random.nextInt(10000);
        try {
            BonusClient.recharge(exchangeCoin.getUserId().toString(), userName, exchangeCoin.getConsumeBonusPoint(), orderId, sdf_date.format(now), actNo);
        }
        catch (Exception e) {
            logger.error("rollBackBonus recharge Exception:", e);
            return false;
        }
        return true;
    }

    private boolean rollBackPrivilege(BonusExchangeCoin exchangeCoin) {
        try {
            String result = PrivilegeClient.usePrivilege(exchangeCoin.getUserId().toString(), PrivilegeType.BonusExchangeCoin, exchangeCoin.getConsumeBonusPoint() * -1);
            JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            if (code != 0) {
                logger.error("rollBackPrivilege usePrivilege Error: " + result);
                return false;
            }
        }
        catch (Exception e) {
            logger.error("rollBackPrivilege usePrivilege Exception:", e);
            return false;
        }
        return true;
    }
}

