/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan.thread;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuanbiz.vo.SignInRecord;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;

public class AddSignInRecordThread
implements Runnable {
    private static Logger logger = Log.getLogger(AddSignInRecordThread.class);
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static final String actNo = "JinZuanSignIn";
    private long userId;
    private String msg;

    public AddSignInRecordThread(long userId) {
        this.userId = userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SignInRecord signInRecord = null;
        try {
            String userIdStr = String.valueOf(this.userId);
            String userName = UserUtility.getUserNameByUserId(userIdStr);
            Date now = new Date();
            signInRecord = new SignInRecord();
            signInRecord.setUserId(this.userId);
            signInRecord.setSignDate(now);
            signInRecord.setRecordTime(now);
            signInRecord.setBonusNum(-1);
            signInRecord.setStatus(false);
            signInRecord.setSucessTime(null);
            Map<String, Object> bonusResult = PrivilegeClient.signInGetBonusNum(userIdStr);
            if (Integer.parseInt(bonusResult.get("code").toString()) != 0) {
                this.msg = "\u8c03\u7528\u83b7\u53d6\u7b7e\u5230\u79ef\u5206\u63a5\u53e3\u9519\u8bef" + bonusResult.get("data").toString();
                logger.error(this.msg);
            }
            int bonusNum = Integer.parseInt(bonusResult.get("data").toString());
            signInRecord.setBonusNum(bonusNum);
            if (bonusNum > 0) {
                try {
                    String transNo = "JZSign_" + now.getTime();
                    BonusClient.recharge(userIdStr, userName, bonusNum, transNo, sdf_date.format(now), actNo);
                }
                catch (Exception e) {
                    this.msg = "\u7ed9\u7528\u6237\u589e\u52a0\u79ef\u5206\u9519\u8bef" + e.getMessage();
                    logger.error("\u7ed9\u7528\u6237\u589e\u52a0\u79ef\u5206\u9519\u8bef", e);
                }
            }
            signInRecord.setStatus(true);
            signInRecord.setSucessTime(new Date());
        }
        catch (Exception e) {
            logger.error("AddSignInRecordThread Exception", e);
        }
        finally {
            FacadeFactory.INSTANCE.getBaseSo().addObject(signInRecord);
        }
    }
}

