/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserRebateInfo;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.proxy.ProxyFactory;
import com.xunlei.proxy.socket.UserInfoProxy;
import com.xunlei.proxy.socket.bin.resp.Resp_getuserinfo_base;
import com.xunlei.util.StringTools;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class UserInfoCmd
extends DefaultCmd {
    private static String MAXBONUSE = EnvPropertyUtil.loadProperty("niux", "maxUsedBonus");
    private static String MAXREBATEMONEY = EnvPropertyUtil.loadProperty("niux", "maxrebateMoney");
    private static int maxBonus = 0;
    private static long maxRebateMoney = 0L;
    private static final Page page = new Page();

    @CmdMapper(value={"/user/getuserinfo.do"})
    public Object doSignIn(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>();
        String username = request.getParameter("username");
        if (StringTools.isEmpty(username)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        String userid = this.getUserIdByName(username);
        if (StringTools.isEmpty(userid) || "0".equals(userid)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            int level = this.getJinZuanMemberInfo(userid);
            if (level == 0) {
                result.put("isVip", Boolean.valueOf(true));
                result.put("bonus", Integer.valueOf(0));
                result.put("rebate", Integer.valueOf(0));
            } else {
                result.put("isVip", Boolean.valueOf(false));
                int bonus = this.getBonus(userid);
                if (bonus < maxBonus) {
                    long money = this.getRebateMoney(userid);
                    if (money < maxRebateMoney) {
                        result.put("bonus", Integer.valueOf(0));
                        result.put("rebate", Integer.valueOf(0));
                    } else {
                        result.put("bonus", Integer.valueOf(0));
                        result.put("rebate", Long.valueOf(money));
                    }
                } else {
                    result.put("bonus", Integer.valueOf(bonus));
                    result.put("rebate", Integer.valueOf(0));
                }
            }
        }
        catch (NumberFormatException nfe) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    private String getUserIdByName(String username) {
        UserInfoProxy userInfoProxy = ProxyFactory.getInstance().getUserInfoProxy();
        String userid = null;
        try {
            Resp_getuserinfo_base userInfo = userInfoProxy.getuserinfo_base(username, (byte)-1);
            if (userInfo.isOk()) {
                userid = String.valueOf(userInfo.getUserno());
            }
        }
        catch (Exception e) {
            throw new XLRuntimeException(e);
        }
        return userid;
    }

    private int getJinZuanMemberInfo(String userid) throws Exception {
        return JinZuanClient.isJinZuanUser(userid);
    }

    private int getBonus(String userid) {
        BonusClient.UserBonus userBonus = BonusClient.queryBonus(userid);
        if (userBonus == null) {
            return 0;
        }
        return userBonus.getBonusNum();
    }

    private long getRebateMoney(String userid) {
        UserRebateInfo queryRebateInfo = new UserRebateInfo();
        queryRebateInfo.setUserId(String.valueOf(userid));
        UserRebateInfo rebateInfo = FacadeFactory.INSTANCE.getBaseBo().findObject(queryRebateInfo);
        if (rebateInfo == null || rebateInfo.getCanUseRebateSum() == null) {
            return 0L;
        }
        return rebateInfo.getCanUseRebateSum().intValue();
    }

    static {
        maxBonus = Integer.parseInt(MAXBONUSE);
        maxRebateMoney = Long.parseLong(MAXREBATEMONEY);
    }
}

