/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.jinzuan.thread.AddSignInRecordThread;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.jinzuan.SignInClient;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.util.Log;
import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SignInCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SignInCmd.class);
    protected ExecutorService executor = Executors.newCachedThreadPool();

    @CmdMapper(value={"/signin/dosignin.do"})
    public Object doSignIn(XLHttpRequest request, XLHttpResponse response) {
        int code;
        JsonObject jsonObject;
        logger.info("\u5f00\u59cb\u6267\u884c\u7528\u6237\u7b7e\u5230");
        boolean isReSign = false;
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String dayStr = request.getParameter("day", "");
        String remoteIp = request.getRemoteIP();
        String userIdStr = String.valueOf(userId);
        int day = 0;
        if (StringUtils.isNotEmpty(dayStr)) {
            day = Integer.parseInt(dayStr);
        }
        Calendar calendar = Calendar.getInstance();
        int curDay = calendar.get(5);
        if (day < 0 || day > curDay) {
            String msg = "day\u53c2\u6570\u9519\u8bef";
            return JsonObjectUtil.getRtnAndDataJsonObject(201, msg);
        }
        if (day > 0 && day < curDay) {
            isReSign = true;
        }
        if (isReSign) {
            try {
                String result = PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.FillCheck, 1);
                jsonObject = new JsonParser().parse(result).getAsJsonObject();
                code = jsonObject.get("rtn").getAsInt();
                if (code != 0) {
                    String msg = "\u4f7f\u7528\u7279\u6743\u5931\u8d25\uff1a" + jsonObject.get("data").toString();
                    return JsonObjectUtil.getRtnAndDataJsonObject(code + 100, msg);
                }
            }
            catch (Exception e) {
                logger.error("usePrivilege\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                return JsonObjectUtil.getRtnAndDataJsonObject(302, "usePrivilege\u8c03\u7528\u5931\u8d25" + e.getMessage());
            }
        }
        String resp = "";
        try {
            resp = SignInClient.doSign(userIdStr, remoteIp, dayStr);
            jsonObject = new JsonParser().parse(resp).getAsJsonObject();
            code = jsonObject.get("rtn").getAsInt();
            if (code == 0) {
                this.executor.submit(new AddSignInRecordThread(userId));
            } else if (isReSign) {
                PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.FillCheck, -1);
            }
            return resp;
        }
        catch (Exception e) {
            logger.error("doSignIn Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }
}

