/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.ferret.common.dao.vo.Page;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cache.GameCache;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.client.daijinquan.NiuXCashClient;
import com.xunlei.niux.client.jinzuan.MemberInfoClient;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.jinzuan.dto.MemberShipDTO;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class JinZuanLeaguePrivilegeCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(JinZuanLeaguePrivilegeCmd.class);
    private static final String JZSYPRIVILEGE_GENERATENO = EnvPropertyUtil.loadProperty("jinzuan", "jzsyPrivilegeGenerateNo");

    @CmdMapper(value={"/jinzuan/getjzsycashprivilege.do"})
    public Object getJzsyCashPrivilege(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u6267\u884c\u7528\u6237\u67e5\u8be2\u91d1\u94bb\u6210\u957f\u4efb\u52a1\u503c");
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String generateNo = JZSYPRIVILEGE_GENERATENO;
        HashMap<String, Integer> retMap = new HashMap<String, Integer>();
        try {
            MemberShipDTO memberShip = MemberInfoClient.getMemberInfo(userId.toString());
            if (!this.isJinzuanUser(memberShip)) {
                logger.info("getjzsycashprivilege.do\uff0c\u4e0d\u662f\u91d1\u94bb\u7528\u6237\u6216\u8005\u91d1\u94bb\u5df2\u8fc7\u671f,userId:{}, memberStatus:{}", userId, memberShip == null ? "" : memberShip.getMemberStatus());
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u4e0d\u662f\u91d1\u94bb\u7528\u6237\u6216\u8005\u91d1\u94bb\u5df2\u8fc7\u671f");
            }
            int receivedCounts = this.getReceivedCount(userId.toString(), generateNo);
            int totalCounts = this.getTotalCount(memberShip);
            int leftCounts = totalCounts - receivedCounts;
            retMap.put("receivedCounts", receivedCounts);
            retMap.put("leftCounts", leftCounts);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, retMap);
        }
        catch (Exception e) {
            logger.error("getJzsyCashPrivilege Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u83b7\u53d6\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/jinzuan/generatejzsycash.do"})
    public Object generateJzsyCash(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u6267\u884c\u7528\u6237\u67e5\u8be2\u91d1\u94bb\u6210\u957f\u4efb\u52a1\u503c");
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        try {
            String gameId = request.getParameter("gameid", "");
            String actNo = request.getParameter("actNo", "jzsyprivilege");
            if (StringUtils.isEmpty(gameId)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-4, "\u53c2\u6570\u9519\u8bef");
            }
            String generateNo = JZSYPRIVILEGE_GENERATENO;
            MemberShipDTO memberShip = MemberInfoClient.getMemberInfo(userId.toString());
            if (!this.isJinzuanUser(memberShip)) {
                logger.info("generatejzsycash.do\uff0c\u4e0d\u662f\u91d1\u94bb\u7528\u6237\u6216\u8005\u91d1\u94bb\u5df2\u8fc7\u671f,userId:{}, memberStatus:{}", userId, memberShip == null ? "" : memberShip.getMemberStatus());
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u4e0d\u662f\u91d1\u94bb\u7528\u6237\u6216\u8005\u91d1\u94bb\u5df2\u8fc7\u671f");
            }
            try {
                String result = PrivilegeClient.usePrivilege(userId.toString(), PrivilegeType.ShouYouLeague, 1);
                JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
                int code = jsonObject.get("rtn").getAsInt();
                if (code != 0) {
                    String msg = "\u4f7f\u7528\u7279\u6743\u5931\u8d25\uff1a" + jsonObject.get("data").toString();
                    return JsonObjectUtil.getRtnAndDataJsonObject(code, msg);
                }
            }
            catch (Exception e) {
                logger.error("usePrivilege\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                return JsonObjectUtil.getRtnAndDataJsonObject(302, "usePrivilege\u8c03\u7528\u5931\u8d25" + e.getMessage());
            }
            String resp = NiuXCashClient.generateCash(generateNo, userId.toString(), actNo, gameId);
            return resp;
        }
        catch (Exception e) {
            logger.error("generatejzsycash Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/jinzuan/getjzsycashrecord.do"})
    public Object getJzsyCashRecord(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u6267\u884c\u7528\u6237\u67e5\u8be2\u91d1\u94bb\u6210\u957f\u4efb\u52a1\u503c");
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String generateNo = JZSYPRIVILEGE_GENERATENO;
        ArrayList retList = new ArrayList();
        try {
            NiuxCash query = new NiuxCash();
            query.setGenerateNo(generateNo);
            query.setReceiveUserId(userId.toString());
            List<NiuxCash> cashs = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
            for (NiuxCash niuxCash : cashs) {
                HashMap<String, String> retMap = new HashMap<String, String>();
                retMap.put("receiveTime", niuxCash.getReceiveTime());
                retMap.put("parValue", niuxCash.getParValue() + "\u5143");
                Games game = GameCache.getInstance().getGameById(niuxCash.getLimitedgameid());
                retMap.put("game", game == null ? "" : game.getGameName());
                retList.add(retMap);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, retList);
        }
        catch (Exception e) {
            logger.error("getjzsycashrecord Error:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private int getTotalCount(MemberShipDTO memberShipDTO) {
        int result = 0;
        int levelNum = memberShipDTO.getLevelNum();
        int isAnnualMember = memberShipDTO.getIsAnnualMember();
        if (levelNum == 1) {
            result = 5;
        } else if (levelNum == 2) {
            result = 5;
        } else if (levelNum == 3) {
            result = 8;
        } else if (levelNum == 4) {
            result = 8;
        } else if (levelNum == 5) {
            result = 10;
        } else if (levelNum == 6) {
            result = 10;
        } else if (levelNum == 7) {
            result = 15;
        }
        if (isAnnualMember == 1) {
            result += 5;
        }
        return result;
    }

    private int getReceivedCount(String userId, String generateNo) {
        NiuxCash query = new NiuxCash();
        query.setGenerateNo(generateNo);
        query.setReceiveUserId(userId.toString());
        int receivedCounts = FacadeFactory.INSTANCE.getNiuxCashBo().getCashReceivedTimesCurMonth(userId.toString(), generateNo);
        return receivedCounts;
    }

    private boolean isJinzuanUser(MemberShipDTO memberShip) {
        if (memberShip == null) {
            return false;
        }
        int memberStatus = memberShip.getMemberStatus();
        return memberStatus == 2;
    }
}

