/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.proxy.JRedisProxy;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.lottery.LotteryGift;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GiftUpdateCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GiftUpdateCmd.class);
    private static String lotteryActNo = "JinZuanLottery";
    private static String giftPachageActNo = "JinZuanGiftPackage";

    @CmdMapper(value={"/giftupdate/getLatestJinzuanGiftInfo.do"})
    public Object getLatestJinzuanGiftInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        try {
            HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
            resultMap.put("lastestLotteryOrder", this.getLatestLotteryOrder());
            resultMap.put("lastestGiftPackageOrder", this.getLatestGiftPackageOrder());
            resultMap.put("lastestActivityOrder", this.getLatestActivityOrder());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        catch (Exception e) {
            logger.error("getLatestJinzuanGiftInfo Exception", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u83b7\u53d6\u4fe1\u606f\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/giftupdate/getLatestActivityInfo.do"})
    public Object getLatestActivityInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String cacheKey = this.getClass().getName() + "getLatestActivityInfo";
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey);
        LinkInfo info = null;
        if (obj == null) {
            List<LinkInfo> linkInfoList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("283", 1, false);
            if (CollectionUtils.isNotEmpty(linkInfoList)) {
                info = linkInfoList.get(0);
                cacheManager.put(cacheKey, info, 10L);
            }
        } else {
            info = (LinkInfo)obj;
        }
        if (info == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u6ca1\u6709\u91d1\u94bb\u6d3b\u52a8\u6570\u636e");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", info.getLinktitle());
        map.put("content", info.getLinkdesc());
        map.put("url", info.getLinkurl());
        map.put("img", info.getPicurl());
        map.put("date", info.getInvaliddatetime());
        map.put("level", info.getExt1());
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    private int getLatestLotteryOrder() {
        int lastestOrder = 0;
        String cacheKey = GiftUpdateCmd.class.getName() + "LatestLotteryOrder";
        String lastestOrderStr = JRedisProxy.getInstance().get(cacheKey);
        if (StringUtils.isEmpty(lastestOrderStr)) {
            List<LotteryGift> lotteryGifts = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLotteryGiftBo().getValidLotteryGiftListByDisplayOrderDescLimit(lotteryActNo, 1);
            if (CollectionUtils.isEmpty(lotteryGifts)) {
                return 0;
            }
            LotteryGift lastLotteryGift = lotteryGifts.get(0);
            lastestOrder = lastLotteryGift.getDisplayOrder();
            JRedisProxy.getInstance().set(cacheKey, String.valueOf(lastestOrder), 600);
        } else {
            lastestOrder = Integer.parseInt(lastestOrderStr);
        }
        return lastestOrder;
    }

    private int getLatestGiftPackageOrder() {
        int lastestOrder = 0;
        String cacheKey = GiftUpdateCmd.class.getName() + "LatestGiftPackageOrder";
        String lastestOrderStr = JRedisProxy.getInstance().get(cacheKey);
        if (StringUtils.isEmpty(lastestOrderStr)) {
            List<ActivityGiftInfoDTO> activityGiftInfoDTOList = FacadeFactory.INSTANCE.getActivityGiftBo().getActivityGiftList(giftPachageActNo, "", 0, 1);
            if (CollectionUtils.isEmpty(activityGiftInfoDTOList)) {
                return 0;
            }
            ActivityGiftInfoDTO lastActivityGift = activityGiftInfoDTOList.get(0);
            lastestOrder = lastActivityGift.getDisplayOrder();
            JRedisProxy.getInstance().set(cacheKey, String.valueOf(lastestOrder), 600);
        } else {
            lastestOrder = Integer.parseInt(lastestOrderStr);
        }
        return lastestOrder;
    }

    private int getLatestActivityOrder() {
        int lastestOrder = 0;
        String cacheKey = GiftUpdateCmd.class.getName() + "LatestActivityOrder";
        String lastestOrderStr = JRedisProxy.getInstance().get(cacheKey);
        if (StringUtils.isEmpty(lastestOrderStr)) {
            List<LinkInfo> lilist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("283", 1, false);
            if (CollectionUtils.isEmpty(lilist)) {
                return 0;
            }
            LinkInfo linkInfo = lilist.get(0);
            lastestOrder = linkInfo.getLinkid();
            JRedisProxy.getInstance().set(cacheKey, String.valueOf(lastestOrder), 600);
        } else {
            lastestOrder = Integer.parseInt(lastestOrderStr);
        }
        return lastestOrder;
    }
}

