/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuanbiz.vo.GameJiaChengRecord;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GameJiaChengCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GameJiaChengCmd.class);
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/jinzuan/addJiaChengRecord.do"})
    public Object addJiaChengRecord(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        try {
            String rewardIdStr = request.getParameter("id");
            if (StringUtils.isEmpty(rewardIdStr)) {
                String msg = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
                logger.error(msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, msg);
            }
            int rewardId = Integer.parseInt(rewardIdStr);
            GameJiaChengRecord record = new GameJiaChengRecord();
            record.setRewardId(rewardId);
            record.setUserId(userId);
            record.setRecordTime(sdf_time.format(new Date()));
            FacadeFactory.INSTANCE.getBaseSo().addObject(record);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("addJiaChengRecord Exception", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/jinzuan/queryJiaChengCount.do"})
    public Object queryJiaChengCount(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        try {
            String idsStr = request.getParameter("ids");
            if (StringUtils.isEmpty(idsStr)) {
                String msg = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
                logger.error(msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, msg);
            }
            ArrayList result = new ArrayList();
            List<String> idList = Arrays.asList(idsStr.split(","));
            for (String idStr : idList) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                int id = Integer.parseInt(idStr);
                int count = this.getUserCountByRewardId(id);
                map.put("id", id);
                map.put("num", count);
                result.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("addJiaChengRecord Exception", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    private int getUserCountByRewardId(int rewardId) {
        int count;
        String cacheKey;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey = "gamejiachengrecord_rewardId_" + rewardId);
        if (obj == null) {
            count = FacadeFactory.INSTANCE.getGameJiaChengBo().getUserCountByRewardId(rewardId);
            if (count > 0) {
                cacheManager.put(cacheKey, count, 5L);
            }
        } else {
            count = Integer.parseInt(obj.toString());
        }
        return count;
    }
}

