/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.paysvr.PayServerClient;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.data.jinzuanbiz.enums.TimePeriodEnum;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuanbiz.vo.GameFirstPay;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GameFirstPayCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GameFirstPayCmd.class);
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static final String actNo = "gameFirstPay";
    private String msg = "";

    @CmdMapper(value={"/gamefirstpay/dogamefirstpay.do"})
    public Object doGameFirstPay(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u9886\u53d6\u6e38\u620f\u9996\u5145");
        try {
            this.setInnerContentType(request, response);
            MainParam mainParam = this.getMainParam(request, response, true);
            Long userId = mainParam.getUserid();
            String userIdStr = String.valueOf(userId);
            String gameId = request.getParameter("gameid");
            String serverId = request.getParameter("serverid");
            String roleId = request.getParameter("roleid");
            String userName = UserUtility.getUserNameByUserId(userIdStr);
            if (userId == -1L) {
                this.msg = "\u7528\u6237\u672a\u767b\u9646\uff01";
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(101, this.msg);
            }
            if (StringUtils.isEmpty(gameId)) {
                this.msg = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1agameid=" + gameId + ",serverid=" + serverId;
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(102, this.msg);
            }
            Map checkResult = (Map)PayServerClient.checkcharge(userIdStr, gameId, userName, serverId);
            logger.info("PayServerClient.checkcharge result: " + checkResult.toString());
            int checkCode = Integer.parseInt(checkResult.get("code").toString());
            String checkData = checkResult.get("data").toString();
            if (checkCode != -1) {
                if (checkCode == 0) {
                    this.msg = "\u7528\u6237\u5df2\u7ecf\u6709\u8be5\u6e38\u620f\u533a\u670d\u7684\u5145\u503c\u8bb0\u5f55\uff0c\u65e0\u6cd5\u8fdb\u884c\u9996\u5145";
                    logger.info(this.msg);
                    return JsonObjectUtil.getRtnAndDataJsonObject(103, this.msg);
                }
                this.msg = "\u5145\u503c\u8bb0\u5f55\u67e5\u8be2\u9519\u8bef\uff1a" + checkData;
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(104, this.msg);
            }
            if (!this.checkTotalLimit()) {
                this.msg = "\u9886\u53d6\u9996\u5145\u8d85\u8fc7\u6bcf\u65e5\u9650\u989d";
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(205, this.msg);
            }
            try {
                String result = PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.FreeFirstGamePay, 1);
                JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
                int code = jsonObject.get("rtn").getAsInt();
                if (code != 0) {
                    this.msg = "\u4f7f\u7528\u7279\u6743\u5931\u8d25\uff1a" + jsonObject.get("data").toString();
                    return JsonObjectUtil.getRtnAndDataJsonObject(code, this.msg);
                }
            }
            catch (Exception e) {
                logger.error("usePrivilege\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                return JsonObjectUtil.getRtnAndDataJsonObject(302, "usePrivilege\u8c03\u7528\u5931\u8d25" + e.getMessage());
            }
            Date now = new Date();
            Random random = new Random(System.currentTimeMillis());
            String orderId = "FP" + now.getTime() + random.nextInt(10000);
            int money = 1;
            try {
                YuanBaoClient.giveOutYuanBao(userIdStr, userName, gameId, serverId, roleId, orderId, actNo, money);
            }
            catch (Exception e) {
                logger.error("doGameFirstPay \u53d1\u653e\u6e38\u620f\u5e01\u51fa\u73b0\u51fa\u9519", e);
                PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.FreeFirstGamePay, -1);
                return JsonObjectUtil.getRtnAndDataJsonObject(310, "\u53d1\u653e\u6e38\u620f\u5e01\u51fa\u73b0\u51fa\u9519:" + e.getMessage());
            }
            GameFirstPay firstPay = new GameFirstPay();
            firstPay.setUserId(userId);
            firstPay.setGameId(gameId);
            firstPay.setServerId(serverId);
            firstPay.setRoleId(roleId);
            firstPay.setMoney(money);
            firstPay.setOrderId(orderId);
            firstPay.setRecordTime(sdf_time.format(now));
            FacadeFactory.INSTANCE.getBaseSo().addObject(firstPay);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u9996\u5145\u53d1\u653e\u6210\u529f");
        }
        catch (Exception e) {
            logger.error("doGameFirstPay Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private boolean checkTotalLimit() {
        int totalLimit = 0;
        try {
            String totalLimitStr = EnvPropertyUtil.loadProperty("jinzuan", "gameFirstPayTotalDayLimit");
            if (StringUtils.isNotEmpty(totalLimitStr)) {
                totalLimit = Integer.parseInt(totalLimitStr);
            }
        }
        catch (Exception e) {
            logger.error("checkTotalLimit Exception", e);
            return true;
        }
        int firstPayTotal = FacadeFactory.INSTANCE.getGameFirstPayBo().getTotalFirstPayMoney(TimePeriodEnum.Day);
        return totalLimit <= 0 || firstPayTotal <= totalLimit;
    }

    @CmdMapper(value={"/gamefirstpay/getfirstpayrecord.do"})
    public Object getFirstPayRecord(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u9886\u53d6\u6e38\u620f\u9996\u5145");
        try {
            this.setInnerContentType(request, response);
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            GameFirstPay query = new GameFirstPay();
            query.setUserId(Long.parseLong(userId));
            Page page = new Page();
            page.addOrder("recordTime", OrderType.DESC);
            List<GameFirstPay> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
        }
        catch (Exception e) {
            logger.error("getFirstPayRecord Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/gamefirstpay/getgiftpackagedescinfo.do"})
    public Object getGiftPackageDescInfo(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u83b7\u53d6\u6e38\u620f\u9996\u5145\u793c\u5305\u4fe1\u606f");
        try {
            this.setInnerContentType(request, response);
            String gameId = request.getParameter("gameid");
            if (StringUtils.isEmpty(gameId)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(102, "\u53c2\u6570gameid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String packageDesc = "";
            Map packageDescMap = null;
            String cacheKey = this.getClass().getName() + "AllFirstPayPackageDesc";
            CacheManager cacheManager = CacheManager.GetInstance();
            Object object = cacheManager.get(cacheKey);
            if (object == null) {
                packageDescMap = this.getPackageDescMap();
                cacheManager.put(cacheKey, packageDescMap, 10L);
            } else {
                packageDescMap = (Map)object;
            }
            if (!packageDescMap.containsKey(gameId)) {
                logger.error("\u4e0d\u5b58\u5728\u5bf9\u5e94\u6e38\u620f{}\u7684\u9996\u5145\u793c\u5305\u914d\u7f6e", (Object)gameId);
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u4e0d\u5b58\u5728\u5bf9\u5e94\u6e38\u620f\u7684\u9996\u5145\u793c\u5305\u914d\u7f6e\uff01");
            }
            packageDesc = ((String)packageDescMap.get(gameId)).toString();
            return JsonObjectUtil.getRtnAndDataJsonObject(0, packageDesc);
        }
        catch (Exception e) {
            logger.error("getGiftPackageDescInfo Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private Map<String, String> getPackageDescMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        LinkInfo query = new LinkInfo();
        query.setLinklocid("668");
        List<LinkInfo> linkinfoList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getLinkInfoBo().find(query);
        if (CollectionUtils.isEmpty(linkinfoList)) {
            return map;
        }
        for (LinkInfo linkInfo : linkinfoList) {
            if (map.containsKey(linkInfo.getGameid())) continue;
            map.put(linkInfo.getGameid(), linkInfo.getExt1());
        }
        return map;
    }
}

