/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.jinzuan.CommonActivityClient;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.util.Log;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CommonActivityCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(CommonActivityCmd.class);
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String msg;

    @CmdMapper(value={"/commonactivity/isUserCanTakeInAct.do"})
    public Object isUserCanTakeInAct(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String actNo = request.getParameter("actno");
        String moduleId = request.getParameter("moduleId");
        logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + request.getUrl());
        if (StringUtils.isEmpty(actNo)) {
            this.msg = "\u53c2\u6570actno\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(101, this.msg);
        }
        String result = CommonActivityClient.isUserCanUseActAllModule(actNo, moduleId, String.valueOf(userId));
        return result;
    }

    @CmdMapper(value={"/commonactivity/getGift.do"})
    public Object getGift(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String userIdStr = String.valueOf(userId);
        String actNo = request.getParameter("actno");
        String moduelId = request.getParameter("moduleid");
        String giftId = request.getParameter("giftid");
        String remoteIp = request.getRemoteIP();
        String isJinzuanLimit = request.getParameter("isjinzuanlimit", "");
        logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + request.getUrl());
        if (StringUtils.isEmpty(actNo) || StringUtils.isEmpty(giftId)) {
            this.msg = "\u53c2\u6570actno,giftId\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, this.msg);
        }
        String result = "";
        result = "false".equals(isJinzuanLimit) ? CommonActivityClient.getGift(actNo, moduelId, userIdStr, giftId, remoteIp, false) : CommonActivityClient.getGift(actNo, moduelId, userIdStr, giftId, remoteIp);
        logger.info("CommonActivityClient.getGift \u7684\u7ed3\u679c\u4e3a\uff1a" + result);
        return result;
    }

    @CmdMapper(value={"/commonactivity/getActPartakeInfo.do"})
    public Object getActPartakeInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        try {
            String actNo = request.getParameter("actno");
            String moduleId = request.getParameter("moduleid");
            logger.info("\u8bf7\u6c42URL\uff1a" + request.getUrl());
            if (StringUtils.isEmpty(actNo)) {
                this.msg = "\u53c2\u6570actno\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, this.msg);
            }
            String resp = CommonActivityClient.getGiftInfoList(actNo, null);
            JsonObject jsonObject = new JsonParser().parse(resp).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            if (code != 0) {
                String msg = jsonObject.get("data").getAsString();
                logger.error(request.getUrl() + "\u67e5\u8be2\u9519\u8bef\uff1a" + msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(code, msg);
            }
            Gson gson = new Gson();
            Type type = new TypeToken<List<ActivityGiftInfoDTO>>(){}.getType();
            List actGiftDTOList = (List)gson.fromJson(jsonObject.get("data"), type);
            if (CollectionUtils.isEmpty(actGiftDTOList)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u5bf9\u5e94\u5956\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            }
            boolean isHasModule = false;
            List<String> moduleList = StringUtil.getListFromString(moduleId, ",");
            if (CollectionUtils.isNotEmpty(moduleList)) {
                isHasModule = true;
            }
            ArrayList resultList = new ArrayList();
            for (ActivityGiftInfoDTO actGiftDTO : actGiftDTOList) {
                if (isHasModule && !moduleList.contains(actGiftDTO.getModuleId())) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("moduleId", actGiftDTO.getModuleId());
                map.put("giftId", actGiftDTO.getGiftId());
                Gift gift = FacadeFactory.INSTANCE.getGiftBo().getGiftByGiftID(actGiftDTO.getGiftId());
                if (gift != null) {
                    map.put("giftName", gift.getGiftName());
                } else {
                    map.put("giftName", "");
                }
                map.put("leftCount", actGiftDTO.getLeftCount());
                map.put("partakeCount", actGiftDTO.getTotalCount() - actGiftDTO.getLeftCount());
                resultList.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        catch (JsonSyntaxException e) {
            logger.error("getActPartakeInfo Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef\uff01");
        }
    }

    @CmdMapper(value={"/commonactivity/isGameHasGiftPackage.do"})
    public Object isGameHasGiftPackage(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        try {
            String gameId = request.getParameter("gameid");
            logger.info("\u8bf7\u6c42URL\uff1a" + request.getUrl());
            if (StringUtils.isEmpty(gameId)) {
                this.msg = "\u53c2\u6570gameid\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(101, this.msg);
            }
            String resp = CommonActivityClient.isGameHasGiftPackage(gameId);
            logger.info("CommonActivityClient.isGameHasGiftPackage \u7684\u7ed3\u679c\u4e3a\uff1a" + resp);
            return resp;
        }
        catch (JsonSyntaxException e) {
            logger.error("getActPartakeInfo Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef\uff01");
        }
    }

    @CmdMapper(value={"/commonactivity/getUserGiftRecordsByActNo.do"})
    public Object getGiftRecordByActNo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String userIdStr = String.valueOf(userId);
        String actNo = request.getParameter("actno");
        String moduelId = request.getParameter("moduleid");
        int max = request.getParameterInteger("max", 20);
        logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + request.getUrl());
        if (StringUtils.isEmpty(actNo)) {
            this.msg = "\u53c2\u6570actno\u4e0d\u80fd\u4e3a\u7a7a";
            logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, this.msg);
        }
        String result = CommonActivityClient.getGiftRecordsWithPhoto(actNo, moduelId, userIdStr, max);
        logger.info("CommonActivityClient.getGift \u7684\u7ed3\u679c\u4e3a\uff1a" + result);
        return result;
    }
}

