/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.client.jinzuan.JinZuanPayClient;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuanbiz.vo.FreeGive;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ChargeJinZuanCmd
extends DefaultCmd {
    public static Logger logger = Logger.getLogger(ChargeJinZuanCmd.class);
    public static List<Long> chargedUserList = new ArrayList<Long>();
    private static final String actNo = "JinKaFreeCharge";

    @CmdMapper(value={"/chargejinzuan/freeChargeJinZuan.do"})
    public Object freeChargeJinZuan(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        if (chargedUserList.contains(userId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7528\u6237\u5df2\u7ecf\u5145\u503c\u8fc7\u91d1\u94bb");
        }
        FreeGive freeGive = this.getFreeGiveByUserId(userId);
        if (freeGive == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7528\u6237\u6ca1\u6709\u514d\u8d39\u5145\u503c\u6743\u5229");
        }
        if (freeGive.isGiveStatus()) {
            chargedUserList.add(userId);
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7528\u6237\u5df2\u7ecf\u5145\u503c\u8fc7\u91d1\u94bb");
        }
        int monthNum = 1;
        String resp = JinZuanPayClient.FreeCharge(actNo, userId, 2, monthNum);
        logger.info("JinZuanPayClient.FreeCharge response: " + resp);
        JsonObject resultJson = new JsonParser().parse(resp).getAsJsonObject();
        int code = resultJson.get("rtn").getAsInt();
        if (code != 0) {
            String msg = resultJson.get("data").getAsString();
            return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u91d1\u94bb\u5145\u503c\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + msg);
        }
        freeGive.setGiveStatus(true);
        this.updateFreeGive(freeGive);
        chargedUserList.add(userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u5145\u503c\u6210\u529f");
    }

    private FreeGive getFreeGiveByUserId(long userId) {
        FreeGive query = new FreeGive();
        query.setUserId(userId);
        FreeGive freeGive = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return freeGive;
    }

    private void updateFreeGive(FreeGive freeGive) {
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(freeGive);
    }
}

