/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.facade.IFacadeCommon;
import com.xunlei.common.vo.LibClassD;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.gift.UseGiftPackageSo;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.jinzuan.CommonActivityClient;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityExtendInfoDTO;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.active.facade.FacadeFactory;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityExtendInfo;
import com.xunlei.niux.data.active.vo.commonactivity.ActivityGiftInfo;
import com.xunlei.niux.data.vipgame.dto.BoxGiftRecordDTO;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class BoxCommonActivityCmd
extends DefaultCmd {
    private static DateFormat sdf_time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Logger logger = Log.getLogger(this.getClass());
    private String msg = "";
    private static final String actNo = "heziquanfuGift";
    private static final String userGameUrl = "http://websvr.niu.xunlei.com/userGameServerList.gameUserInfo";
    private static final Map<String, String> typeNameMap = new HashMap<String, String>();
    private static final Map<Integer, String> featureMap = new HashMap<Integer, String>();
    private static Date date = new Date();

    @CmdMapper(value={"/boxcommonactivity/getGiftInfo.do"})
    public Object getGiftInfo(XLHttpRequest request, XLHttpResponse response) {
        boolean giftId = false;
        int pageSize = 0;
        String userId = "";
        try {
            userId = request.getParameter("userId");
            pageSize = request.getParameterInteger("pageSize", 0);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u9519\u8bef");
        }
        List<Map<String, Object>> productList = this.getProductList(0, pageSize, userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, productList);
    }

    @CmdMapper(value={"/boxcommonactivity/getOneGiftInfo.do"})
    public Object getOneGiftInfo(XLHttpRequest request, XLHttpResponse response) {
        String giftIdStr = request.getParameter("giftId");
        int giftId = 0;
        String userId = "";
        userId = request.getParameter("userId");
        if (StringUtil.isEmpty(giftIdStr)) {
            String msg = "\u793c\u54c1\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a";
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, msg);
        }
        try {
            giftId = Integer.valueOf(giftIdStr);
        }
        catch (Exception e) {
            String msg = "\u793c\u54c1\u6807\u8bc6\u4e0d\u6b63\u786e";
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, msg);
        }
        List<Map<String, Object>> productList = this.getProductList(giftId, 0, userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, productList);
    }

    public List<Map<String, Object>> getResult(long parentRecordId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        GiftRecord query = new GiftRecord();
        query.setParentRecordId(parentRecordId);
        List<GiftRecord> grList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for (int i = 0; i < grList.size(); ++i) {
            GiftRecord gr = grList.get(i);
            Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, gr.getGiftId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("giftType", gift.getGiftType());
            map.put("giftNum", gr.getGiftNum());
            map.put("giftName", gift.getGiftName());
            map.put("serialNumber", gr.getSerialNumber());
            list.add(map);
        }
        return list;
    }

    private String getModules(Map<String, ActivityExtendInfoDTO> map) {
        StringBuilder modules = new StringBuilder();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            modules.append("'" + iterator.next() + "',");
        }
        return modules.substring(0, modules.length() - 1);
    }

    private List<ActivityGiftInfoDTO> getActivityGiftList(String actNo, String moduleId, int giftId, int limit) {
        List<ActivityGiftInfo> list;
        ArrayList<ActivityGiftInfoDTO> dtolist = new ArrayList<ActivityGiftInfoDTO>();
        if (StringUtils.isEmpty(actNo)) {
            throw new RuntimeException("actNo can't be empty!");
        }
        ActivityGiftInfo query = new ActivityGiftInfo();
        query.setActNo(actNo);
        if (StringUtils.isNotEmpty(moduleId)) {
            query.setModuleId(moduleId);
        }
        if (giftId > 0) {
            query.setGiftId(giftId);
        }
        query.setIsValid(true);
        Page page = new Page();
        page.addOrder("displayOrder", OrderType.DESC);
        if (limit > 0) {
            page.setPageNo(1);
            page.setPageSize(limit);
        }
        if (CollectionUtils.isEmpty(list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page))) {
            return dtolist;
        }
        for (ActivityGiftInfo giftInfo : list) {
            ActivityGiftInfoDTO dto = new ActivityGiftInfoDTO();
            BeanUtils.copyProperties(giftInfo, dto);
            dtolist.add(dto);
        }
        return dtolist;
    }

    private List<Map<String, Object>> getProductList(Integer sendGiftId, int pageSize, String userId) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        Map<String, ActivityExtendInfoDTO> activityMap = this.getActivityMap(actNo, false);
        ActivityGiftInfo query = new ActivityGiftInfo();
        query.setActNo(actNo);
        query.setIsValid(true);
        List<ActivityGiftInfoDTO> actGiftList = null;
        if (sendGiftId > 0) {
            query.setGiftId(sendGiftId);
            actGiftList = FacadeFactory.INSTANCE.getActivityGiftBo().getActivityGiftList(query);
        } else {
            actGiftList = this.getActivityGiftList(actNo, "", 0, pageSize + 8);
        }
        if (CollectionUtils.isEmpty(actGiftList)) {
            return null;
        }
        Map<String, BoxGiftRecordDTO> recordMap = null;
        if (StringUtils.isNotEmpty(userId)) {
            recordMap = this.getGiftRecordMap(actGiftList, userId);
        }
        for (ActivityGiftInfoDTO activityGiftInfoDTO : actGiftList) {
            BoxGiftRecordDTO record;
            int giftId;
            Gift gift;
            ActivityExtendInfoDTO activityDTO;
            String moduleId = activityGiftInfoDTO.getModuleId();
            if (StringUtils.isEmpty(moduleId)) continue;
            if (!activityMap.containsKey(moduleId)) {
                activityMap = this.getActivityMap(actNo, true);
            }
            if (!activityMap.containsKey(moduleId) || (activityDTO = activityMap.get(moduleId)) == null || (gift = this.getGiftByGiftId(giftId = activityGiftInfoDTO.getGiftId().intValue())) == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("moduleId", moduleId);
            map.put("giftId", giftId);
            map.put("giftType", gift.getGiftType());
            map.put("giftName", gift.getGiftName());
            map.put("price", gift.getProductTotalPrice() == null ? 0.0 : gift.getProductTotalPrice());
            map.put("photo_list", activityGiftInfoDTO.getPhoto() == null ? "" : activityGiftInfoDTO.getPhoto());
            map.put("photo_left", activityGiftInfoDTO.getSmallPic() == null ? "" : activityGiftInfoDTO.getSmallPic());
            map.put("photo_index1", activityGiftInfoDTO.getExt1() == null ? "" : activityGiftInfoDTO.getExt1());
            map.put("photo_index2", activityGiftInfoDTO.getExt2() == null ? "" : activityGiftInfoDTO.getExt2());
            map.put("desc", gift.getSimpleDesc());
            map.put("detailUrl", activityGiftInfoDTO.getDetailUrl() == null ? "" : activityGiftInfoDTO.getDetailUrl());
            map.put("leftCount", activityGiftInfoDTO.getLeftCount());
            map.put("totalCount", activityGiftInfoDTO.getTotalCount());
            map.put("orderNum", activityGiftInfoDTO.getDisplayOrder());
            String rule = gift.getExt1() == null ? "" : gift.getExt1();
            rule = rule.replaceAll("\\n", "").replaceAll("\\|", "<br>");
            map.put("rule", rule);
            String gameId = gift.getGameId();
            CacheManager cacheManager = CacheManager.GetInstance();
            Games game = (Games)cacheManager.get("boxcommonactivity_" + gameId);
            if (game == null) {
                game = new Games();
                game.setGameId(gameId);
                game = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(game);
                cacheManager.put("boxcommonactivity_" + gameId, game);
            }
            if (game != null) {
                map.put("gameType", game.getGameType());
                map.put("gameName", game.getGameName());
                map.put("gameSimpleName", game.getSimpleName());
                map.put("gameScore", game.getRecommendIndex());
                map.put("gameDesc", game.getGameDesc());
            }
            map.put("gameId", gameId);
            if (recordMap != null && (record = recordMap.get(giftId + "_" + moduleId)) != null) {
                map.put("giftStatus", this.getGiftStatus(record.getGiftStatus()));
                map.put("giftSerialNumber", record.getSerialNumber() != null ? record.getSerialNumber() : "");
            }
            resultList.add(map);
            if (resultList.size() < pageSize + 8) continue;
            break;
        }
        return resultList;
    }

    private int getGiftStatus(String giftStatus) {
        if (giftStatus.equals("SUCCESS")) {
            return 1;
        }
        if (giftStatus.equals("WAIT")) {
            return 0;
        }
        if (giftStatus.equals("FAIL")) {
            return -1;
        }
        return -2;
    }

    private Gift getGiftByGiftId(int giftId) {
        Gift query = new Gift();
        query.setGiftId(Long.valueOf(giftId));
        query.setIsValid(true);
        List<Gift> giftList = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        if (CollectionUtils.isEmpty(giftList)) {
            return null;
        }
        return giftList.get(0);
    }

    private List<ActivityExtendInfoDTO> getActivityInfoList(String actNo) {
        if (StringUtils.isEmpty(actNo)) {
            return null;
        }
        ArrayList<ActivityExtendInfoDTO> activityExtendInfoDTOs = null;
        String cacheKey = "com.xunlei.niux.data.active.bo.impl.ActivityExtendBoImplgetActivityInfoListactNo" + actNo;
        CacheManager cacheManager = CacheManager.GetInstance();
        ActivityExtendInfo query = new ActivityExtendInfo();
        query.setActNo(actNo);
        List<ActivityExtendInfo> activityInfoList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        if (CollectionUtils.isEmpty(activityInfoList)) {
            return null;
        }
        activityExtendInfoDTOs = new ArrayList<ActivityExtendInfoDTO>();
        ActivityExtendInfoDTO dto = null;
        for (ActivityExtendInfo activityInfo : activityInfoList) {
            dto = new ActivityExtendInfoDTO();
            BeanUtils.copyProperties(activityInfo, dto);
            activityExtendInfoDTOs.add(dto);
        }
        cacheManager.put(cacheKey, activityExtendInfoDTOs, 600000L);
        return activityExtendInfoDTOs;
    }

    private Map<String, ActivityExtendInfoDTO> getActivityMap(String actNo, boolean flag) {
        HashMap<String, ActivityExtendInfoDTO> resultMap = new HashMap<String, ActivityExtendInfoDTO>();
        ActivityExtendInfo query = new ActivityExtendInfo();
        query.setActNo(actNo);
        List<ActivityExtendInfoDTO> list = null;
        list = !flag ? FacadeFactory.INSTANCE.getActivityExtendBo().getActivityInfoList(actNo) : this.getActivityInfoList(actNo);
        if (CollectionUtils.isEmpty(list)) {
            return resultMap;
        }
        Date now = new Date();
        for (ActivityExtendInfoDTO activityDTO : list) {
            if (StringUtils.isEmpty(activityDTO.getModuleId())) continue;
            if (StringUtils.isNotEmpty(activityDTO.getStartTime())) {
                try {
                    Date startTime = sdf_time.parse(activityDTO.getStartTime());
                    if (startTime.after(now)) {
                        continue;
                    }
                }
                catch (ParseException e) {
                    this.logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef", e);
                }
            }
            if (StringUtils.isNotEmpty(activityDTO.getEndTime())) {
                try {
                    Date endTime = sdf_time.parse(activityDTO.getEndTime());
                    if (endTime.before(now)) {
                        continue;
                    }
                }
                catch (ParseException e) {
                    this.logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u9519\u8bef", e);
                }
            }
            resultMap.put(activityDTO.getModuleId(), activityDTO);
        }
        return resultMap;
    }

    @CmdMapper(value={"/boxgift/useGift.do"})
    public Object useGift(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        Long recordId = request.getParameterLong("recordId");
        String gameId = request.getParameter("gameId", "");
        return this.userboxGift(userId, recordId, gameId);
    }

    private Object userboxGift(String userId, Long recordId, String gameId) {
        try {
            UseGiftPackageSo.useBoxGift(recordId, userId, gameId);
            UseGiftPackageSo.userBoxPackageDetail(recordId);
            List<Map<String, Object>> resultlist = this.getResult(recordId);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultlist);
        }
        catch (NiuExceptionAndCode e) {
            this.logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.code + "-" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage());
        }
        catch (NiuRuntimeException e) {
            this.logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.code + "-" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage());
        }
        catch (Exception e) {
            this.logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.getMessage());
        }
    }

    @CmdMapper(value={"/boxcommonactivity/getGift.do"})
    public Object getGift(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        Long userId = mainParam.getUserid();
        String userIdStr = String.valueOf(userId);
        String moduelId = request.getParameter("moduleid");
        String giftId = request.getParameter("giftid");
        String gameId = request.getParameter("gameId");
        String remoteIp = request.getRemoteIP();
        String isJinzuanLimit = request.getParameter("isjinzuanlimit", "");
        this.logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + request.getUrl());
        if (StringUtils.isEmpty(giftId)) {
            this.msg = "\u53c2\u6570giftId\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            this.logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, this.msg);
        }
        if (StringUtils.isEmpty(gameId)) {
            this.msg = "\u53c2\u6570gameId\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            this.logger.error(this.msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, this.msg);
        }
        String result = "";
        result = "false".equals(isJinzuanLimit) ? CommonActivityClient.getGift(actNo, moduelId, userIdStr, giftId, remoteIp, false) : CommonActivityClient.getGift(actNo, moduelId, userIdStr, giftId, remoteIp);
        this.logger.info("CommonActivityClient.getGift \u7684\u7ed3\u679c\u4e3a\uff1a" + result);
        try {
            JSONObject returnObject = new JSONObject(result);
            if (returnObject.getInt("rtn") == 0) {
                GiftRecord giftRecord = this.getGiftRecord(giftId, userIdStr);
                if (giftRecord == null) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(-4, "\u8fde\u63a5\u8d85\u65f6");
                }
                return this.userboxGift(userIdStr, giftRecord.getRecordId(), gameId);
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(-5, "\u5df2\u9886\u53d6\u793c\u5305\uff0c\u6fc0\u6d3b\u7801\u9886\u53d6\u5931\u8d25");
    }

    private GiftRecord getGiftRecord(String giftId, String userId) {
        String sql = "select * from giftrecord where giftId = '" + giftId + "' and userid ='" + userId + "' and giftStatus = " + "'WAIT' and actNo='heziquanfuGift' and recordTime >= DATE_ADD(NOW(),INTERVAL -5 MINUTE) ";
        ArrayList list = new ArrayList();
        List query = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(GiftRecord.class, sql, list);
        if (query == null || query.size() == 0) {
            return null;
        }
        return (GiftRecord)query.get(0);
    }

    public Map<String, BoxGiftRecordDTO> getGiftRecordMap(List<ActivityGiftInfoDTO> actGiftList, String userId) {
        HashMap<String, BoxGiftRecordDTO> map = new HashMap<String, BoxGiftRecordDTO>();
        HashMap<String, ActivityGiftInfoDTO> infoDTOMap = new HashMap<String, ActivityGiftInfoDTO>();
        StringBuilder gameIds = new StringBuilder();
        if (actGiftList == null || actGiftList.size() == 0) {
            return map;
        }
        for (ActivityGiftInfoDTO dto : actGiftList) {
            gameIds.append("'" + dto.getGiftId() + "',");
            infoDTOMap.put(dto.getGiftId() + "", dto);
        }
        String ids = gameIds.substring(0, gameIds.length() - 1);
        String sql = "SELECT giftrecord.*,g.giftId as niuxGiftId,'' as moduleId from giftrecord \ninner join gift on giftrecord.giftId = gift.giftId and gift.giftType = 'gift' \ninner join giftpackagedetail on gift.giftId = giftpackagedetail.productId\ninner join giftpackage on giftpackagedetail.packageId =giftpackage.packageId\ninner join gift g on g.giftlot = giftpackage.packageId  and g.giftType = 'niuxgift'\nwhere  actNo='heziquanfuGift'and userid = '" + userId + "' AND g.giftid in (" + ids + ")  ";
        List list = new ArrayList();
        list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(BoxGiftRecordDTO.class, sql, list);
        if (list != null && list.size() > 0) {
            for (BoxGiftRecordDTO gr : list) {
                String gameId = gr.getGameId();
                ActivityGiftInfoDTO activityGiftInfoDTO = (ActivityGiftInfoDTO)infoDTOMap.get(gr.getNiuxGiftId());
                gr.setModuleId(activityGiftInfoDTO.getModuleId());
                map.put(gr.getNiuxGiftId() + "_" + gr.getModuleId(), gr);
            }
        }
        return map;
    }

    @CmdMapper(value={"/guess/getgames.do"})
    public Object getThinkGames(XLHttpRequest request, XLHttpResponse response) {
        String username = request.getParameter("username");
        String sessionid = request.getParameter("sessionid");
        String gameIds = this.getUserGameIds(username, sessionid);
        String rankGames = this.getRankGameType(gameIds);
        return rankGames;
    }

    public String getUserGameIds(String username, String sessionid) {
        if (StringUtils.isEmpty(username) || StringUtils.isEmpty(sessionid)) {
            return "";
        }
        StringBuilder ids = new StringBuilder();
        StringBuilder url = new StringBuilder(userGameUrl);
        url.append("?username=" + username);
        url.append("&sessionid=" + sessionid);
        String content = HttpClientUtil.get(url.toString());
        try {
            JSONObject returnObject = new JSONObject(content);
            if (returnObject.getInt("rtn") == 0) {
                JSONObject data = new JSONObject(returnObject.getString("data"));
                JSONArray array = data.getJSONArray("data");
                if (array == null || array.length() == 0) {
                    return "";
                }
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    ids.append("'" + object.getString("gameid") + "',");
                }
                return ids.substring(0, ids.length() - 1).toString();
            }
        }
        catch (JSONException e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u73a9\u8fc7\u6e38\u620f\u5217\u8868\uff0c\u8f6c\u6362\u4e3ajson\u5bf9\u8c61\u65f6\u51fa\u9519\uff01");
            return "";
        }
        return ids.toString();
    }

    public String getRankGameType(String gameIds) {
        boolean flag = gameIds == null || gameIds.trim().length() == 0;
        String sql = "select  games.* from games \ninner join \n(\nselect count(*) as count ,gameFeature from games where 1=1 " + (flag ? "" : " and  gameid in (" + gameIds + ") ") + "GROUP BY gameFeature  order by count desc) as tt on tt.gameFeature = games.gameFeature\n" + "INNER JOIN gameservers on games.gameId = gameservers.gameId \n" + "INNER JOIN\n" + "(SELECT MIN(gms.openTime) AS opentime, gms.gameid, gms.seqId FROM gameservers gms\n" + "\t\t\t\tINNER JOIN games ON games. STATUS = 1 AND ( games.clientType = 0 OR games.clientType = 1 ) AND games.gameid = gms.gameid\n" + "\t\t\t\tWHERE openstatus = 1 GROUP BY gameid) gs on gs.seqId = gameservers.seqId \n" + "where games.clientType in (0,1) and games.status = 1\n" + "order by tt.gameFeature desc ,gs.opentime DESC\n";
        List list = new ArrayList();
        list = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(Games.class, sql, list);
        if (list == null || list.size() == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u6ca1\u6709\u627e\u5230\u6570\u636e");
        }
        ArrayList result = new ArrayList();
        Map<Integer, String> feature = this.getFeature();
        Map<String, String> typeName = this.getTypeName();
        Integer gameFeature = -100;
        ArrayList<HashMap<String, String>> gamesList = null;
        for (Games games : list) {
            HashMap<String, String> dtoMap = new HashMap<String, String>();
            if (games.getGameFeature().intValue() != gameFeature.intValue()) {
                gameFeature = games.getGameFeature();
                gamesList = new ArrayList<HashMap<String, String>>();
                result.add(gamesList);
            }
            gamesList.add(dtoMap);
            dtoMap.put("type", feature.get(gameFeature));
            dtoMap.put("gameId", games.getGameId());
            dtoMap.put("gameName", games.getGameName());
            dtoMap.put("GameType", typeName.get(games.getGameType() + ""));
            dtoMap.put("gameDesc", games.getGameDesc() == null ? "" : games.getGameDesc());
            dtoMap.put("summary", games.getSummary() == null ? "" : games.getSummary());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    public Map<Integer, String> getFeature() {
        Date now = new Date();
        if (now.getTime() - date.getTime() > 86400000L || featureMap == null || featureMap.size() == 0) {
            date = now;
            LibClassD lcd = new LibClassD();
            lcd.setClassno("gameFeatures");
            List list = (List)IFacadeCommon.INSTANCE.queryLibClassds(lcd, null).getDatas();
            for (int i = 0; i < list.size(); ++i) {
                featureMap.put(Integer.parseInt(((LibClassD)list.get(i)).getItemno()), ((LibClassD)list.get(i)).getItemname());
            }
        }
        return featureMap;
    }

    public Map<String, String> getTypeName() {
        Date now = new Date();
        if (now.getTime() - date.getTime() > 86400000L || typeNameMap == null || typeNameMap.size() == 0) {
            date = now;
            LibClassD lcd = new LibClassD();
            lcd.setClassno("gamecategory");
            List list = (List)IFacadeCommon.INSTANCE.queryLibClassds(lcd, null).getDatas();
            for (int i = 0; i < list.size(); ++i) {
                LibClassD libClassD = (LibClassD)list.get(i);
                typeNameMap.put(libClassD.getItemno(), libClassD.getItemname());
            }
        }
        return typeNameMap;
    }
}

