/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jinzuan;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.jinzuan.thread.AddBonusExCoinThread;
import com.xunlei.niux.center.cmd.jinzuan.thread.RollBackBonusExThread;
import com.xunlei.niux.client.bonus.BonusClient;
import com.xunlei.niux.client.jinzuan.PrivilegeClient;
import com.xunlei.niux.client.util.MapEasyUtils;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.data.jinzuan.enums.PrivilegeType;
import com.xunlei.niux.data.jinzuanbiz.enums.BonusExStatusEnum;
import com.xunlei.niux.data.jinzuanbiz.enums.TimePeriodEnum;
import com.xunlei.niux.data.jinzuanbiz.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuanbiz.vo.BonusExchangeCoin;
import com.xunlei.niux.dto.UserBonus;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BonusExchangeCoinCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BonusExchangeCoinCmd.class);
    private static DateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");
    private static final int exchangeRate = 20;
    private static final String actNo = "BonusExchangeCoin";
    protected ExecutorService executor = Executors.newCachedThreadPool();
    private String msg;

    @CmdMapper(value={"/bonusexchange/dobonusexchange.do"})
    public Object doBonusExchange(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u79ef\u5206\u5151\u6362");
        logger.info(request.getUrl());
        try {
            int bonusPoint;
            this.setInnerContentType(request, response);
            MainParam mainParam = this.getMainParam(request, response, true);
            String userIdStr = mainParam.getUserid() + "";
            String exchangeMoneyValue = request.getParameter("exchangemoney");
            String gameId = request.getParameter("gameid");
            String serverId = request.getParameter("serverid");
            String roleId = request.getParameter("roleid");
            Long userId = Long.parseLong(userIdStr);
            String userName = UserUtility.getUserNameByUserId(userIdStr);
            if (userId == -1L) {
                this.msg = "\u7528\u6237\u672a\u767b\u9646\uff01";
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(101, this.msg);
            }
            if (StringUtils.isEmpty(exchangeMoneyValue) || StringUtils.isEmpty(gameId)) {
                this.msg = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff1aexchangemoney=" + exchangeMoneyValue + ",gameid=" + gameId + ",serverid=" + serverId;
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(102, this.msg);
            }
            int exchangeMoney = Integer.parseInt(exchangeMoneyValue);
            Map<String, Object> validResult = this.validateExchange(userIdStr, exchangeMoney, bonusPoint = exchangeMoney * 20);
            int validCode = Integer.parseInt(validResult.get("code").toString());
            if (validCode != 0) {
                this.msg = validResult.get("data").toString();
                logger.error(this.msg);
                return JsonObjectUtil.getRtnAndDataJsonObject(validCode, this.msg);
            }
            try {
                String result = PrivilegeClient.usePrivilege(userIdStr, PrivilegeType.BonusExchangeCoin, bonusPoint);
                JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
                int code = jsonObject.get("rtn").getAsInt();
                if (code != 0) {
                    this.msg = "\u4f7f\u7528\u7279\u6743\u5931\u8d25\uff1a" + jsonObject.get("data").toString();
                    return JsonObjectUtil.getRtnAndDataJsonObject(code, this.msg);
                }
            }
            catch (Exception e) {
                logger.error("usePrivilege\u8c03\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                return JsonObjectUtil.getRtnAndDataJsonObject(302, "usePrivilege\u8c03\u7528\u5931\u8d25" + e.getMessage());
            }
            Date now = new Date();
            long time = now.getTime();
            Random random = new Random(System.currentTimeMillis());
            String orderId = "BEx" + time + random.nextInt(10000);
            BonusExchangeCoin exchangeCoin = new BonusExchangeCoin();
            exchangeCoin.setUserId(userId);
            exchangeCoin.setConsumeBonusPoint(bonusPoint);
            exchangeCoin.setGameId(gameId);
            exchangeCoin.setServerId(serverId);
            exchangeCoin.setRoleId(roleId);
            exchangeCoin.setExchangeMoney(exchangeMoney);
            exchangeCoin.setStatus(BonusExStatusEnum.NotConsumeBonus.getValue());
            exchangeCoin.setRecordTime(sdf_time.format(now));
            try {
                String resultCode = BonusClient.consume(userIdStr, userName, bonusPoint, orderId, sdf_date.format(now), actNo, "");
                if (!resultCode.equals("00")) {
                    this.msg = "\u6d88\u8017\u79ef\u5206\u5931\u8d25\uff0cResult Code:" + resultCode;
                    logger.error(this.msg);
                    return JsonObjectUtil.getRtnAndDataJsonObject(303, this.msg);
                }
            }
            catch (Exception e) {
                logger.error("Exception when doBonusExchange consume bonus\uff1a", e);
                this.executor.submit(new RollBackBonusExThread(exchangeCoin));
                return JsonObjectUtil.getRtnAndDataJsonObject(304, "\u6d88\u8017\u79ef\u5206\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            }
            exchangeCoin.setStatus(BonusExStatusEnum.ConsumedBonusNotPay.getValue());
            try {
                YuanBaoClient.giveOutYuanBao(userIdStr, userName, gameId, serverId, roleId, orderId, actNo, exchangeMoney);
            }
            catch (Exception e) {
                logger.error("doBonusExchange \u53d1\u653e\u6e38\u620f\u5e01\u51fa\u73b0\u51fa\u9519", e);
                this.executor.submit(new RollBackBonusExThread(exchangeCoin));
                return JsonObjectUtil.getRtnAndDataJsonObject(310, "doBonusExchange \u53d1\u653e\u6e38\u620f\u5e01\u51fa\u73b0\u51fa\u9519" + e.getMessage());
            }
            exchangeCoin.setStatus(BonusExStatusEnum.PayCompleted.getValue());
            this.executor.submit(new AddBonusExCoinThread(exchangeCoin));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, exchangeCoin);
        }
        catch (Exception e) {
            logger.error("doBonusExchange Exception", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private Map<String, Object> validateExchange(String userIdStr, int exchangeMoney, int bonusPoint) {
        if (exchangeMoney <= 0 || exchangeMoney >= 0xCCCCCCC) {
            return MapEasyUtils.generateMap(103, "\u5151\u6362\u91d1\u989d\u4e0d\u5408\u6cd5");
        }
        UserBonus bonus = BonusClient.queryBonus(userIdStr);
        if (bonus == null) {
            return MapEasyUtils.generateMap(201, "userId=" + userIdStr + "\u7528\u6237\u79ef\u5206\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (bonusPoint <= 0 || bonusPoint > bonus.getBonusNum()) {
            return MapEasyUtils.generateMap(202, "\u5151\u6362\u79ef\u5206\u4e0d\u80fd\u8d85\u8fc7\u7528\u6237\u6240\u62e5\u6709\u7684\u79ef\u5206");
        }
        if (!this.checkTotalLimit()) {
            return MapEasyUtils.generateMap(205, "\u79ef\u5206\u5151\u6362\u8d85\u8fc7\u6bcf\u65e5\u9650\u989d");
        }
        return MapEasyUtils.generateMap(0, "\u53ef\u4ee5\u8fdb\u884c\u79ef\u5206\u5151\u6362");
    }

    private boolean checkTotalLimit() {
        int totalLimit = 0;
        try {
            String totalLimitStr = EnvPropertyUtil.loadProperty("jinzuan", "bonuxExchangeTotalDayLimit");
            if (StringUtils.isNotEmpty(totalLimitStr)) {
                totalLimit = Integer.parseInt(totalLimitStr);
            }
        }
        catch (Exception e) {
            logger.error("checkTotalLimit Exception", e);
            return true;
        }
        int exchangeTotal = FacadeFactory.INSTANCE.getBonusExchangeCoinBo().getTotalExchangeMoney(TimePeriodEnum.Day);
        return totalLimit <= 0 || exchangeTotal <= totalLimit;
    }

    @CmdMapper(value={"/bonusexchange/getexchangerecord.do"})
    public Object getExchangeRecord(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u83b7\u53d6\u79ef\u5206\u5151\u6362\u8bb0\u5f55");
        try {
            this.setInnerContentType(request, response);
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            BonusExchangeCoin query = new BonusExchangeCoin();
            query.setUserId(Long.parseLong(userId));
            Page page = new Page();
            page.addOrder("recordTime", OrderType.DESC);
            List<BonusExchangeCoin> list = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, page);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u79ef\u5206\u5151\u6362\u8bb0\u5f55\u5f02\u5e38\uff1a", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u5f02\u5e38");
        }
    }
}

