/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jifenshop;

import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.lottery.LotteryUtil;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.center.util.VerifyCodeUtil;
import com.xunlei.niux.client.gameinfo.UserGameInfo;
import com.xunlei.niux.client.gameinfo.UserGamePay;
import com.xunlei.niux.data.vipgame.enums.jifenshop.JiFenRewardType;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.jifenshop.JiFenRewardRecord;
import com.xunlei.niux.easyutils.commonutils.DateUtil;
import com.xunlei.niux.easyutils.commonutils.OrderNoUtil;
import com.xunlei.util.Log;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class JiFenRewardCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(JiFenRewardCmd.class);
    private static final String ActNo = "JiFenTaskReward";
    private static final String Prefix = "JFReward";

    @CmdMapper(value={"/jifenreward/getUserJiFenRewardInfo.do"})
    public Object getUserJiFenRewardInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        Map<Integer, Boolean> resultMap = this.getUserJifenRewardMap(userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/jifenreward/getUnReceivedJiFenReward.do"})
    public Object getUnReceivedJiFenReward(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String sessionId = mainParam.getSessionid();
        String userIdStr = Long.toString(userId);
        String userName = UserUtility.getUserNameByUserId(userIdStr);
        Map<Integer, Boolean> receivedJiFenRewardMap = this.getUserJifenRewardMap(userId);
        HashMap<Integer, Boolean> resultMap = new HashMap<Integer, Boolean>();
        if (receivedJiFenRewardMap.get(JiFenRewardType.RegisterReward.getValue()) == null) {
            resultMap.put(JiFenRewardType.RegisterReward.getValue(), true);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        if (receivedJiFenRewardMap.get(JiFenRewardType.BindMobileReward.getValue()) == null && this.hasUserBindPhone(userIdStr)) {
            resultMap.put(JiFenRewardType.BindMobileReward.getValue(), true);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        if (receivedJiFenRewardMap.get(JiFenRewardType.GameReward.getValue()) == null && this.hasUserPlayedGame(sessionId, userName)) {
            resultMap.put(JiFenRewardType.GameReward.getValue(), true);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        if (receivedJiFenRewardMap.get(JiFenRewardType.ChargeReward.getValue()) == null && this.hasUserPayed(userId)) {
            resultMap.put(JiFenRewardType.ChargeReward.getValue(), true);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        if (receivedJiFenRewardMap.get(JiFenRewardType.JinZuanReward.getValue()) == null && this.isJinzuanUser(userIdStr)) {
            resultMap.put(JiFenRewardType.JinZuanReward.getValue(), true);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4efb\u52a1\u5956\u52b1\u5df2\u5168\u90e8\u9886\u53d6");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CmdMapper(value={"/jifenreward/doJiFenReward.do"})
    public Object doJiFenReward(XLHttpRequest request, XLHttpResponse response) {
        int REWARDBONUS = 0;
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String userIdStr = String.valueOf(userId);
        String userName = UserUtility.getUserNameByUserId(userIdStr);
        int rewardType = request.getParameterInteger("rewardType");
        String verifycode = request.getParameter("verifycode", "");
        String verifykey = request.getCookieValue("VERIFY_KEY");
        String verifytype = "MVA";
        if (this.needCheckVerifyCode(rewardType) && !VerifyCodeUtil.isVerify(verifykey, verifytype, verifycode)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(99, "\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        Map<Integer, Boolean> rewardMap = this.getUserJifenRewardMap(userId);
        if (rewardMap != null && rewardMap.get(rewardType) != null && rewardMap.get(rewardType).booleanValue()) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5df2\u7ecf\u9886\u53d6\u8be5\u5956\u52b1");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("recgameId", "000202");
        resultMap.put("recgameNo", "dts");
        if (rewardType == JiFenRewardType.RegisterReward.getValue()) {
            REWARDBONUS = 10;
        } else if (rewardType == JiFenRewardType.BindMobileReward.getValue()) {
            if (!this.hasUserBindPhone(userIdStr)) {
                resultMap.put("msg", "\u8fd8\u672a\u7ed1\u5b9a\u624b\u673a\uff0c\u8bf7\u5148\u7ed1\u5b9a");
                return JsonObjectUtil.getRtnAndDataJsonObject(3, resultMap);
            }
            REWARDBONUS = 20;
        } else if (rewardType == JiFenRewardType.ChargeReward.getValue()) {
            if (!this.hasUserPayed(userId)) {
                resultMap.put("msg", "\u8fd8\u672a\u5145\u503c");
                return JsonObjectUtil.getRtnAndDataJsonObject(4, resultMap);
            }
            REWARDBONUS = 30;
        } else if (rewardType == JiFenRewardType.JinZuanReward.getValue()) {
            if (!this.isJinzuanUser(userIdStr)) {
                resultMap.put("msg", "\u4e0d\u662f\u91d1\u94bb\u7528\u6237");
                return JsonObjectUtil.getRtnAndDataJsonObject(5, resultMap);
            }
            REWARDBONUS = 50;
        } else if (rewardType == JiFenRewardType.GameReward.getValue()) {
            if (!this.hasUserPlayedGame(mainParam.getSessionid(), userName)) {
                resultMap.put("msg", "\u672a\u73a9\u8fc7\u725bX\u9875\u6e38");
                return JsonObjectUtil.getRtnAndDataJsonObject(6, resultMap);
            }
            REWARDBONUS = 10;
        } else if (rewardType == JiFenRewardType.DailyChargeMoreThan100Reward.getValue()) {
            if (!this.hasUserChargedMoreThan100Today(userIdStr)) {
                resultMap.put("msg", "\u60a8\u4eca\u5929\u672a\u5145\u503c\u8d85\u8fc7100\u5143");
                return JsonObjectUtil.getRtnAndDataJsonObject(7, resultMap);
            }
            REWARDBONUS = 100;
        } else if (rewardType == JiFenRewardType.DailyChargeReward.getValue()) {
            if (!this.hasUserChargedToday(userIdStr)) {
                resultMap.put("msg", "\u60a8\u4eca\u5929\u672a\u5145\u503c");
                return JsonObjectUtil.getRtnAndDataJsonObject(8, resultMap);
            }
            REWARDBONUS = 10;
        } else if (rewardType == JiFenRewardType.DailyGetGiftReward.getValue()) {
            if (!this.hasUserGetNiuxGiftToday(userIdStr)) {
                resultMap.put("msg", "\u60a8\u4eca\u5929\u6ca1\u6709\u5151\u6362\u8fc7\u793c\u5305");
                return JsonObjectUtil.getRtnAndDataJsonObject(9, resultMap);
            }
            REWARDBONUS = 2;
        } else if (rewardType == JiFenRewardType.DailyGetProductReward.getValue()) {
            if (!this.hasUserGetProductToday(userIdStr)) {
                resultMap.put("msg", "\u60a8\u4eca\u5929\u6ca1\u6709\u5151\u6362\u8fc7\u5b9e\u7269");
                return JsonObjectUtil.getRtnAndDataJsonObject(10, resultMap);
            }
            REWARDBONUS = 100;
        } else if (rewardType == JiFenRewardType.DailyLotteryReward.getValue()) {
            if (!this.hasUserLotteryToday(userIdStr)) {
                resultMap.put("msg", "\u60a8\u4eca\u5929\u6ca1\u6709\u62bd\u8fc7\u5956");
                return JsonObjectUtil.getRtnAndDataJsonObject(11, resultMap);
            }
            REWARDBONUS = 2;
        } else {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "rewardType\u53c2\u6570\u9519\u8bef");
        }
        JiFenRewardRecord newRecord = null;
        try {
            newRecord = new JiFenRewardRecord();
            newRecord.setUserId(userId);
            newRecord.setBonusNum(REWARDBONUS);
            newRecord.setRewardType(rewardType);
            newRecord.setRecordTime(DateUtil.formatNowByDefault());
            newRecord.setReleaseStatus(false);
            String now_date = DateUtil.formatNow("yyyy-MM-dd");
            BonusClient.recharge(userIdStr, userName, REWARDBONUS, OrderNoUtil.getOrderNoWithPrefix(Prefix), now_date, ActNo);
            newRecord.setReleaseStatus(true);
        }
        catch (Exception e) {
            logger.error("doJiFenReward \u53d1\u653e\u79ef\u5206\u9519\u8bef\uff1a", e);
        }
        finally {
            if (newRecord != null) {
                FacadeFactory.INSTANCE.getBaseSo().addObject(newRecord);
            }
        }
        resultMap.put("msg", "success");
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private boolean needCheckVerifyCode(int rewardType) {
        return rewardType != JiFenRewardType.DailyChargeMoreThan100Reward.getValue() && rewardType != JiFenRewardType.DailyChargeReward.getValue() && rewardType != JiFenRewardType.DailyGetGiftReward.getValue() && rewardType != JiFenRewardType.DailyGetProductReward.getValue() && rewardType != JiFenRewardType.DailyLotteryReward.getValue();
    }

    private Map<Integer, Boolean> getUserJifenRewardMap(long userId) {
        List<JiFenRewardRecord> rewardRecordList = FacadeFactory.INSTANCE.getJiFenRewardRecordBo().getUserJiFenRewardRecord(userId);
        HashMap<Integer, Boolean> resultMap = new HashMap<Integer, Boolean>();
        for (JiFenRewardRecord record : rewardRecordList) {
            resultMap.put(record.getRewardType(), true);
        }
        List<JiFenRewardRecord> dailyTaskRewardRecordList = FacadeFactory.INSTANCE.getJiFenRewardRecordBo().getUserDailyJiFenRewardRecord(userId);
        for (JiFenRewardRecord record : dailyTaskRewardRecordList) {
            resultMap.put(record.getRewardType(), true);
        }
        return resultMap;
    }

    private CustomerInfo getCustomerInfo(String uid) {
        CustomerInfo queryci = new CustomerInfo();
        queryci.setUid(uid);
        List<CustomerInfo> cilist = FacadeFactory.INSTANCE.getCustomerInfoBo().find(queryci, new Page());
        return cilist == null || cilist.size() == 0 ? null : cilist.get(0);
    }

    private boolean hasUserBindPhone(String userId) {
        CustomerInfo customerInfo = this.getCustomerInfo(userId);
        return customerInfo != null && customerInfo.getPhone() != null && !"".equals(customerInfo.getPhone());
    }

    private boolean hasUserPayed(Long userId) {
        return UserGamePay.isUserPayedGame(userId);
    }

    private boolean hasUserPlayedGame(String sessionId, String userName) {
        return UserGameInfo.isUserPlayedGame(sessionId, userName);
    }

    private boolean isJinzuanUser(String userId) {
        try {
            int isjinzuan = JinZuanClient.isJinZuanUser(userId);
            logger.info("userId:{} isJinZuanUser result:{}", (Object)userId, (Object)isjinzuan);
            return isjinzuan == 0;
        }
        catch (Exception e) {
            logger.error("JinZuanClient isJinZuanUser Exception:", e);
            throw new RuntimeException("\u67e5\u8be2\u91d1\u94bb\u7528\u6237\u4fe1\u606f\u5f02\u5e38");
        }
    }

    private boolean hasUserLotteryToday(String userIdStr) {
        int recordCount = LotteryUtil.getTodayUserDrawedCount("", "", userIdStr);
        if (recordCount == 0) {
            return false;
        }
        if (recordCount < 0) {
            logger.error("doJiFenReward.do\u9519\u8bef, hasUserLotteryToday, recordCount:" + recordCount);
            throw new RuntimeException("\u6570\u636e\u9519\u8bef");
        }
        return true;
    }

    private boolean hasUserGetProductToday(String userIdStr) {
        return this.hasUserGetGiftToday(userIdStr, "product");
    }

    private boolean hasUserGetNiuxGiftToday(String userIdStr) {
        return this.hasUserGetGiftToday(userIdStr, "niuxgift");
    }

    private boolean hasUserGetGiftToday(String userIdStr, String giftType) {
        String now_date = DateUtil.formatNow("yyyy-MM-dd");
        int recordCount = FacadeFactory.INSTANCE.getGiftRecordBo().countGiftRecord(userIdStr, giftType, now_date + " 00:00:00", now_date + " 23:59:59");
        if (recordCount == 0) {
            return false;
        }
        if (recordCount < 0) {
            logger.error("doJiFenReward.do\u9519\u8bef, hasUserGetGiftToday, recordCount:" + recordCount);
            throw new RuntimeException("\u6570\u636e\u9519\u8bef");
        }
        return true;
    }

    private boolean hasUserChargedToday(String userIdStr) {
        return this.getUserTodayChargedMoney(userIdStr) > 0;
    }

    private boolean hasUserChargedMoreThan100Today(String userIdStr) {
        return this.getUserTodayChargedMoney(userIdStr) >= 100;
    }

    private int getUserTodayChargedMoney(String userIdStr) {
        int totalMoney = 0;
        String sql = "select sum(TotalMoney) from paydetailok where ToInnerUserid=? and STR_TO_DATE(SuccessTime, \"%Y-%m-%d\") = STR_TO_DATE(now(), \"%Y-%m-%d\") and OrderIdStatus='S' and giftFlag=0;";
        try {
            Object[] params = new Object[]{userIdStr};
            totalMoney = com.xunlei.niux.data.pay.facade.FacadeFactory.INSTANCE.getBaseSo().count(sql, params);
            logger.info("JiFenRewardCmd getUserTodayChargedMoney totalMoney:" + totalMoney + " ,userId:" + userIdStr);
        }
        catch (Exception e) {
            logger.error("JiFenRewardCmd\u83b7\u53d6\u7528\u6237\u5f53\u5929\u652f\u4ed8\u91d1\u989d\u6570\u636e\u5931\u8d25, " + e);
        }
        return totalMoney;
    }
}

