/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.jifenshop;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cache.GameCache;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.Ret;
import com.xunlei.niux.center.util.ActivityCategoryConstant;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecordQueryTime;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BonusShopMyPrizeCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BonusShopMyPrizeCmd.class.getName());
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static final int timeOut = 10;

    @CmdMapper(value={"/jifenshop/myprize.do"})
    public Object getMyPrize(XLHttpRequest request, XLHttpResponse response) {
        try {
            int pageNo = request.getParameterInteger("pageNo", 1);
            int pageSize = request.getParameterInteger("pageSize", 10);
            pageSize = pageSize <= 0 ? 10 : pageSize;
            MainParam mainParam = this.getMainParamSafe(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            int giftTypeMake = request.getParameterInteger("gifttype", -1);
            HashSet<String> gtSet = new HashSet<String>();
            switch (giftTypeMake) {
                case 1: {
                    gtSet.add("product");
                    break;
                }
                case 2: {
                    gtSet.add("niuxgift");
                    break;
                }
                case 3: {
                    gtSet.add("cash");
                    gtSet.add("niuxcash");
                    break;
                }
                case 4: {
                    gtSet.add("jinzuanvip");
                    break;
                }
                default: {
                    gtSet.add("product");
                }
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int count = FacadeFactory.INSTANCE.getGiftRecordBo().coutJiFenShopGiftRecord(userId, gtSet);
            List<?> gflist = FacadeFactory.INSTANCE.getGiftRecordBo().getJiFenShopGiftRecord(GiftRecordDTO.class, userId, gtSet, (pageNo - 1) * pageSize, pageSize);
            this.updateGiftRecordQueryTime(userId);
            List<Object> mapList = this.ConvertList(gflist);
            if (mapList == null || mapList.isEmpty()) {
                map.put("count", 0);
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            map.put("count", count);
            map.put("pageDatas", mapList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            logger.error("bonusshop getMyPrize exception,cause:", e);
            return new Ret("99", "\u67e5\u8be2\u5931\u8d25");
        }
    }

    private Map<String, Activity> getJiFenShopActivityFromDB() {
        HashMap<String, Activity> acmap = new HashMap<String, Activity>();
        for (Activity a : FacadeFactory.INSTANCE.getActivityBo().getJiFenShopActivity(Activity.class)) {
            if (acmap.containsKey(a.getActno().trim())) continue;
            acmap.put(a.getActno(), a);
        }
        return acmap;
    }

    private Activity getJiFenShopActivity(String actno) {
        String cacheKey;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey = cacheManager.generateCacheKey(this.getClass(), ActivityCategoryConstant.CACHE_KEY));
        if (obj == null) {
            Map<String, Activity> acmap = this.getJiFenShopActivityFromDB();
            cacheManager.put(cacheKey, acmap, 10L);
            return acmap.get(actno);
        }
        Activity activity = (Activity)((Map)obj).get(actno);
        if (activity == null) {
            Map<String, Activity> acmap = this.getJiFenShopActivityFromDB();
            cacheManager.put(cacheKey, acmap, 10L);
            activity = acmap.get(actno);
        }
        return activity;
    }

    private Map<Long, Gift> getGiftMapFromDB() {
        HashMap<Long, Gift> gmap = new HashMap<Long, Gift>();
        for (Gift g : FacadeFactory.INSTANCE.getBaseSo().findObjects(new Gift(), new Page())) {
            if (gmap.containsKey(g.getGiftId())) continue;
            gmap.put(g.getGiftId(), g);
        }
        return gmap;
    }

    private Gift getGift(Long giftId) {
        String cacheKey;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey = cacheManager.generateCacheKey(this.getClass(), "BONUSSHOPMYPRIZECMD_GIFT_CACHE_IJQ1ILZDYDIA6RH5IQJZI8XL2JN9WGCO"));
        if (obj == null) {
            Map<Long, Gift> gmap = this.getGiftMapFromDB();
            cacheManager.put(cacheKey, gmap, 10L);
            return gmap.get(giftId);
        }
        Gift gift = (Gift)((Map)obj).get(giftId);
        if (gift == null) {
            Map<Long, Gift> gmap = this.getGiftMapFromDB();
            cacheManager.put(cacheKey, gmap, 10L);
            gift = gmap.get(giftId);
        }
        return gift;
    }

    private List<Object> ConvertList(List<?> gflist) {
        ArrayList<Object> mapList = new ArrayList<Object>();
        for (int i = 0; i < gflist.size(); ++i) {
            GiftRecordDTO gr = (GiftRecordDTO)gflist.get(i);
            Gift gift = new Gift();
            gift = this.getGift(gr.getGiftId());
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("thirdRecordId", gr.getRecordId());
            Activity activity = this.getJiFenShopActivity(gr.getActNo().trim());
            if (activity == null) continue;
            map1.put("actName", activity == null || activity.getTitle() == null ? "" : activity.getTitle());
            map1.put("productId", gr.getGiftId());
            map1.put("productType", gift.getGiftType());
            map1.put("productNum", gr.getGiftNum());
            map1.put("reportId", gr.getRecordId());
            map1.put("giveOutTime", gr.getRecordTime().substring(0, 10));
            map1.put("productName", gift.getGiftName());
            map1.put("picUrl", gift.getGiftPic());
            map1.put("useExpireDate", gr.getExpireDate());
            map1.put("simpleDesc", gift.getSimpleDesc());
            map1.put("serialNumber", gr.getSerialNumber() == null ? "" : gr.getSerialNumber());
            map1.put("serverName", gr.getServerName() == null ? "" : gr.getServerName());
            this.formatJumpInfo(map1, gift, null);
            if (!gr.getGiftStatus().equals("WAIT")) {
                map1.put("status", "USED");
            } else {
                String nowDate = sdfDate.format(new Date());
                if (nowDate.compareTo(gr.getExpireDate()) > 0) {
                    map1.put("status", "EXPIRED");
                } else {
                    map1.put("status", "CANUSE");
                }
            }
            if (gr.getReleaseStatus() != null && gr.getReleaseStatus().booleanValue()) {
                map1.put("expressStatus", 1);
            }
            mapList.add(map1);
        }
        return mapList;
    }

    private void formatJumpInfo(Map<String, Object> map, Gift gift, GiftRecord gr) {
        String giftType = gift.getGiftType();
        if ("niuxcash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://niu.xunlei.com/order.html");
            return;
        }
        if ("cash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("baijinvip".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("bjtyhy".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/orderlist.html");
            return;
        }
        if ("gstdll".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/freedom/gstdll.html");
            return;
        }
        if ("jshytyk".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://jsq.xunlei.com/");
            return;
        }
        if ("yuanbao".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("bonus".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("xiubi".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("gift".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            String officialUrl = "";
            Games game = null;
            if (gift.getGameId() != null && !"".equals(gift.getGameId())) {
                game = GameCache.getInstance().getGameById(gift.getGameId());
            }
            if (game != null) {
                officialUrl = game.getOfficialWebSite() + "/server.shtml";
            }
            map.put("linkUrl", officialUrl);
            return;
        }
        if ("fortune".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("product".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u7531\u5ba2\u670d\u4eba\u5458\u7ebf\u4e0b\u53d1\u653e");
            map.put("linkUrl", "");
            return;
        }
    }

    private void updateGiftRecordQueryTime(String uid) {
        try {
            GiftRecordQueryTime queryTime = FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecordQueryTime.class, uid);
            String nowTime = sdf_time.format(new Date());
            if (queryTime == null) {
                queryTime = new GiftRecordQueryTime();
                queryTime.setLastQueryTime(nowTime);
                queryTime.setUserId(uid);
                FacadeFactory.INSTANCE.getBaseSo().addObject(queryTime);
            } else {
                queryTime.setLastQueryTime(nowTime);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(queryTime);
            }
        }
        catch (Exception e) {
            logger.error("uid[" + uid + "]update giftrecord lastquerytime");
        }
    }
}

