/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.gift;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cache.GameCache;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.Ret;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.data.vipgame.dto.ActivityNGiftNGiftRecordDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecordQueryTime;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class UserGiftRecordCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(UserGiftRecordCmd.class.getName());
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    protected static Set<String> giftTypeSet = new HashSet<String>();
    protected static Set<String> giftTypeOthersSet = new HashSet<String>();

    @CmdMapper(value={"/gift/userGiftRecord.do"})
    public Object getUserGiftRecord(XLHttpRequest request, XLHttpResponse response) {
        try {
            int pageNo = request.getParameterInteger("pageNo", 1);
            int pageSize = request.getParameterInteger("pageSize", 10);
            pageSize = pageSize <= 0 ? 10 : pageSize;
            MainParam mainParam = this.getMainParamSafe(request, response, true);
            String userId = String.valueOf(mainParam.getUserid());
            String giftTypeMake = request.getParameter("gifttype", "");
            HashSet<String> giftTypeParamSet = new HashSet();
            if ("all".equals(giftTypeMake.trim())) {
                giftTypeParamSet = giftTypeSet;
            } else if ("others".equals(giftTypeMake.trim())) {
                giftTypeParamSet = giftTypeOthersSet;
            } else if (giftTypeSet.contains(giftTypeMake)) {
                giftTypeParamSet.add(giftTypeMake);
            } else {
                return new Ret("99", "\u67e5\u8be2\u5931\u8d25\uff0c\u65e0\u6cd5\u8bc6\u522b\u79cd\u7c7b\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            int count = FacadeFactory.INSTANCE.getGiftRecordBo().countUserGiftRecordByGiftType(userId, giftTypeParamSet);
            List<?> gflist = FacadeFactory.INSTANCE.getGiftRecordBo().getUserGiftRecordByGiftType(ActivityNGiftNGiftRecordDTO.class, userId, giftTypeParamSet, (pageNo - 1) * pageSize, pageSize);
            this.updateGiftRecordQueryTime(userId);
            List<Object> mapList = this.ConvertList(gflist);
            if (mapList == null || mapList.isEmpty()) {
                map.put("count", 0);
                return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
            }
            map.put("count", count);
            map.put("pageDatas", mapList);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            logger.error("UserGiftRecordCmd exception,cause:", e);
            return new Ret("99", "\u67e5\u8be2\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/gift/getUserGiftRecordByActNo.do"})
    public Object getUserGiftRecordByActNo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String userId = request.getParameter("userId", "");
        String actNo = request.getParameter("actNo", "");
        if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(actNo)) {
            logger.error("getUserGiftRecordByActNo params invalid!");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        List<ActivityNGiftNGiftRecordDTO> recordDTOs = FacadeFactory.INSTANCE.getGiftRecordBo().getUserGiftRecordsByActNo(userId, actNo);
        List<Object> mapList = this.ConvertList(recordDTOs);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, mapList);
    }

    @CmdMapper(value={"/gift/isGetGiftEnoughTimesToday.do"})
    public Object isGetGiftEnoughTimesToday(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String userId = request.getParameter("userId", "");
        Integer expectCount = request.getParameterInteger("count");
        if (StringUtils.isEmpty(userId)) {
            logger.error("isGetGiftEnoughTimesOneDay params invalid!");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String nowDate = DateUtil.getNowDay();
        int recordCount = FacadeFactory.INSTANCE.getGiftRecordBo().countGiftRecordInOneDay(userId, nowDate);
        boolean isGetGiftEnought = recordCount >= expectCount;
        map.put("result", isGetGiftEnought);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    @CmdMapper(value={"/gift/getGiftRecordTimes.do"})
    public Object getGiftRecordTimes(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String userId = request.getParameter("userId", "");
        String startTime = request.getParameter("startTime", "");
        String endTime = request.getParameter("endTime", "");
        String giftType = request.getParameter("giftType", "");
        if (StringUtils.isEmpty(userId) || StringUtils.isEmpty(startTime) || StringUtils.isEmpty(endTime)) {
            logger.error("getGiftRecordTimes params invalid!");
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u9519\u8bef");
        }
        int recordCount = FacadeFactory.INSTANCE.getGiftRecordBo().countGiftRecord(userId, startTime, endTime);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, recordCount);
    }

    private List<Object> ConvertList(List<?> gflist) {
        ArrayList<Object> mapList = new ArrayList<Object>();
        for (int i = 0; i < gflist.size(); ++i) {
            ActivityNGiftNGiftRecordDTO gr = (ActivityNGiftNGiftRecordDTO)gflist.get(i);
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("thirdRecordId", gr.getRecordId());
            map1.put("actName", gr.getTitle() == null ? "" : gr.getTitle());
            map1.put("productId", gr.getGiftId());
            map1.put("productType", gr.getGiftType());
            map1.put("productNum", gr.getGiftNum());
            map1.put("reportId", gr.getRecordId());
            map1.put("giveOutTime", gr.getRecordTime().substring(0, 10));
            map1.put("productName", gr.getGiftName());
            map1.put("picUrl", gr.getGiftPic());
            map1.put("useExpireDate", gr.getExpireDate());
            map1.put("simpleDesc", gr.getSimpleDesc());
            map1.put("serialNumber", gr.getSerialNumber() == null ? "" : gr.getSerialNumber());
            map1.put("serverName", gr.getServerName() == null ? "" : gr.getServerName());
            this.formatJumpInfo(map1, gr.getGiftType(), gr.getGameid());
            if (!gr.getGiftStatus().equals("WAIT")) {
                map1.put("status", "USED");
            } else {
                String nowDate = sdfDate.format(new Date());
                if (nowDate.compareTo(gr.getExpireDate()) > 0) {
                    map1.put("status", "EXPIRED");
                } else {
                    map1.put("status", "CANUSE");
                }
            }
            if (gr.getReleaseStatus() != null && gr.getReleaseStatus().booleanValue()) {
                map1.put("expressStatus", 1);
            }
            mapList.add(map1);
        }
        return mapList;
    }

    private void formatJumpInfo(Map<String, Object> map, String giftType, String gameid) {
        if ("niuxcash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://niu.xunlei.com/order.html");
            return;
        }
        if ("cash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("baijinvip".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("bjtyhy".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/orderlist.html");
            return;
        }
        if ("gstdll".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/freedom/gstdll.html");
            return;
        }
        if ("jshytyk".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://jsq.xunlei.com/");
            return;
        }
        if ("yuanbao".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("bonus".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("xiubi".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("gift".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            String officialUrl = "";
            Games game = null;
            if (gameid != null && !"".equals(gameid)) {
                game = GameCache.getInstance().getGameById(gameid);
            }
            if (game != null) {
                officialUrl = game.getOfficialWebSite() + "/server.shtml";
            }
            map.put("linkUrl", officialUrl);
            return;
        }
        if ("fortune".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("product".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u7531\u5ba2\u670d\u4eba\u5458\u7ebf\u4e0b\u53d1\u653e");
            map.put("linkUrl", "");
            return;
        }
    }

    private void updateGiftRecordQueryTime(String uid) {
        try {
            GiftRecordQueryTime queryTime = FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecordQueryTime.class, uid);
            String nowTime = sdf_time.format(new Date());
            if (queryTime == null) {
                queryTime = new GiftRecordQueryTime();
                queryTime.setLastQueryTime(nowTime);
                queryTime.setUserId(uid);
                FacadeFactory.INSTANCE.getBaseSo().addObject(queryTime);
            } else {
                queryTime.setLastQueryTime(nowTime);
                FacadeFactory.INSTANCE.getBaseSo().updateObjectById(queryTime);
            }
        }
        catch (Exception e) {
            logger.error("uid[" + uid + "]update giftrecord lastquerytime");
        }
    }

    static {
        giftTypeSet.add("yuanbao");
        giftTypeSet.add("cash");
        giftTypeSet.add("niuxgift");
        giftTypeSet.add("niuxcash");
        giftTypeSet.add("gstdll");
        giftTypeSet.add("jshytyk");
        giftTypeSet.add("jfscjf");
        giftTypeSet.add("baijinvip");
        giftTypeSet.add("bonus");
        giftTypeSet.add("bjtyhy");
        giftTypeSet.add("gift");
        giftTypeSet.add("product");
        giftTypeSet.add("thanks");
        giftTypeSet.add("lotterychance");
        giftTypeSet.add("jinzuanvip");
        giftTypeSet.add("QCoin");
        giftTypeOthersSet.add("yuanbao");
        giftTypeOthersSet.add("gstdll");
        giftTypeOthersSet.add("jshytyk");
        giftTypeOthersSet.add("jfscjf");
        giftTypeOthersSet.add("bonus");
        giftTypeOthersSet.add("bjtyhy");
        giftTypeOthersSet.add("gift");
        giftTypeOthersSet.add("thanks");
        giftTypeOthersSet.add("lotterychance");
        giftTypeOthersSet.add("QCoin");
    }
}

