/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.gift;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.gift.thread.AddPurchaseLimitRecordThread;
import com.xunlei.niux.client.bonus.BonusClient;
import com.xunlei.niux.client.jinzuan.CommonActivityClient;
import com.xunlei.niux.data.active.dto.commonactivity.ActivityGiftInfoDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.PurchaseLimitationRecord;
import com.xunlei.niux.easyutils.commonutils.MapEasyUtils;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PurchaseLimitationCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PurchaseLimitationCmd.class.getName());
    private static SimpleDateFormat sdf_date = new SimpleDateFormat("yyyy-MM-dd");

    @CmdMapper(value={"/gift/getPurchaseLimitationInfo.do"})
    public Object getPurchaseLimitationInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        Map<String, Object> resultMap = this.getTodayLimitationData();
        logger.info("getTodayLimitationData result:{}", (Object)resultMap.toString());
        int code = Integer.parseInt(resultMap.get("code").toString());
        if (code != 0) {
            String msg = resultMap.get("data").toString();
            return JsonObjectUtil.getRtnAndDataJsonObject(code, msg);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(code, resultMap.get("data"));
    }

    private Map<String, Object> getTodayLimitationData() {
        List<LinkInfo> linkInfoList = FacadeFactory.INSTANCE.getLinkInfoBo().getAllLinkListByLinkLocId("810", false);
        if (CollectionUtils.isEmpty(linkInfoList)) {
            return MapEasyUtils.generateMap(1, "\u6ca1\u6709\u6709\u6548\u9650\u65f6\u62a2\u8d2d\u6570\u636e");
        }
        Date now = new Date();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (LinkInfo li : linkInfoList) {
            Date endDate;
            Date startDate;
            String startTime = li.getExt1();
            String endTime = li.getExt2();
            try {
                startDate = StringUtils.isNotEmpty(startTime) ? sdf_time.parse(startTime) : null;
                endDate = StringUtils.isNotEmpty(endTime) ? sdf_time.parse(endTime) : null;
            }
            catch (ParseException e) {
                logger.error(String.format("linkid:%s,startTime:%s,endTime:%s ParseException", String.valueOf(li.getLinkid()), startTime, endTime));
                continue;
            }
            if (startDate.after(endDate)) {
                logger.warn(String.format("linkid:%s,startTime:%s \u5927\u4e8e endTime:%s ", String.valueOf(li.getLinkid()), startTime, endTime));
                continue;
            }
            if (startDate != null && startDate.after(now)) {
                logger.warn(String.format("linkid:%s,startTime:%s \u5927\u4e8e \u5f53\u524d\u65f6\u95f4\uff0c\u672a\u5f00\u59cb ", String.valueOf(li.getLinkid()), startTime));
                continue;
            }
            if (endDate != null && endDate.before(now)) {
                logger.warn(String.format("linkid:%s,endTime:%s \u5c0f\u4e8e \u5f53\u524d\u65f6\u95f4\uff0c\u5df2\u7ed3\u675f ", String.valueOf(li.getLinkid()), endTime));
                continue;
            }
            int giftId = Integer.parseInt(li.getExt5());
            Gift gift = FacadeFactory.INSTANCE.getGiftBo().getGiftByGiftID(giftId);
            if (gift == null) {
                logger.error(String.format("linkid:%s,giftId:%s \u5956\u54c1\u914d\u7f6e\u4e0d\u5b58\u5728 ", String.valueOf(li.getLinkid()), String.valueOf(giftId)));
                return MapEasyUtils.generateMap(2, "\u6ca1\u6709\u5956\u54c1\u914d\u7f6e\u6570\u636e");
            }
            resultList.add(this.getPurchaseMap(li, gift));
        }
        return MapEasyUtils.generateMap(0, resultList);
    }

    private Map<String, Object> getPurchaseMap(LinkInfo linkinfo, Gift gift) {
        String startTime = linkinfo.getExt1();
        String endTime = linkinfo.getExt2();
        String actNo = linkinfo.getExt3();
        int bonusConsume = 0;
        if (StringUtils.isNotEmpty(linkinfo.getExt6())) {
            bonusConsume = Integer.parseInt(linkinfo.getExt6());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseId", linkinfo.getLinkid());
        map.put("gameId", linkinfo.getGameid());
        map.put("actNo", actNo);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("giftId", gift.getGiftId());
        map.put("giftName", gift.getGiftName());
        map.put("giftContent", gift.getSimpleDesc());
        map.put("comsumeBonusNum", bonusConsume);
        map.put("platPicUrl", linkinfo.getPicurl());
        map.put("boxPicUrl", linkinfo.getSmallpicurl());
        return map;
    }

    private int getLeftCount(String actNo, String moduleId, int giftId) {
        List<ActivityGiftInfoDTO> activityGiftInfoList = com.xunlei.niux.data.active.facade.FacadeFactory.INSTANCE.getActivityGiftBo().getActivityGiftList(actNo, moduleId, giftId);
        if (CollectionUtils.isEmpty(activityGiftInfoList)) {
            throw new RuntimeException("\u6d3b\u52a8\u6a21\u5757\u6ca1\u6709\u914d\u7f6e\u6570\u636e");
        }
        if (activityGiftInfoList.size() > 1) {
            throw new RuntimeException("\u6d3b\u52a8\u6a21\u5757\u6709\u591a\u4e2a\u914d\u7f6e\u6570\u636e");
        }
        ActivityGiftInfoDTO actGiftInfo = activityGiftInfoList.get(0);
        if (actGiftInfo.getGiftId() != giftId) {
            throw new RuntimeException("\u6d3b\u52a8\u6a21\u5757\u5bf9\u5e94\u7684\u5956\u54c1Id\u4e0d\u5339\u914d");
        }
        return actGiftInfo.getLeftCount();
    }

    @CmdMapper(value={"/gift/isUserTodayPartaked.do"})
    public Object isUserTodayPartaked(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        int isPartaked = 0;
        this.setInnerContentType(request, response);
        int userId = request.getParameterInteger("userId", 0);
        int linkId = request.getParameterInteger("purchaseId", 0);
        if (linkId <= 0 || userId <= 0) {
            JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        if (this.isUserPartaked(userId, linkId)) {
            isPartaked = 1;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("isPartaked", isPartaked);
        resultMap.put("jumpUrl", "http://niu.xunlei.com/u/myprize.html");
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private boolean isUserPartaked(int userId, int linkId) {
        PurchaseLimitationRecord query = new PurchaseLimitationRecord();
        query.setUserId(userId);
        query.setLinkId(linkId);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        return count > 0;
    }

    @CmdMapper(value={"/gift/purchaseLimitationGift.do"})
    public Object purchaseLimitationGift(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String userIdStr = String.valueOf(userId);
        String userName = UserUtility.getUserNameByUserId(userIdStr);
        logger.info("\u8bf7\u6c42URL\u4e3a\uff1a" + request.getUrl());
        int linkId = request.getParameterInteger("purchaseId", 0);
        String remoteIp = request.getRemoteIP();
        if (this.isUserPartaked((int)userId, linkId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(102, "\u5df2\u7ecf\u9886\u53d6\u8fc7\u8be5\u793c\u5305");
        }
        LinkInfo linkinfo = FacadeFactory.INSTANCE.getLinkInfoBo().find(linkId);
        if (linkinfo == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(110, "purchaseId\u5bf9\u5e94\u914d\u7f6e\u4e0d\u5b58\u5728");
        }
        String actNo = linkinfo.getExt3();
        String moduleId = linkinfo.getExt4();
        String giftIdStr = linkinfo.getExt5();
        String startTime = linkinfo.getExt1();
        String endTime = linkinfo.getExt2();
        int bonusConsume = 0;
        String bonusConsumeStr = linkinfo.getExt6();
        if (StringUtils.isNotEmpty(bonusConsumeStr)) {
            try {
                bonusConsume = Integer.parseInt(bonusConsumeStr);
            }
            catch (NumberFormatException e) {
                logger.error(String.format("linkId:%s bonusConsume:%s can't convert to int", linkinfo.getLinkid(), bonusConsumeStr));
                JsonObjectUtil.getRtnAndDataJsonObject(111, "purchaseId\u5bf9\u5e94\u914d\u7f6e\u79ef\u5206\u6d88\u8017\u6709\u8bef");
            }
        }
        try {
            String curDate = sdf_date.format(new Date());
            Calendar nowCalendar = Calendar.getInstance();
            Calendar startCalendar = Calendar.getInstance();
            Calendar endCalendar = Calendar.getInstance();
            try {
                startCalendar.setTime(sdf_time.parse(startTime));
                endCalendar.setTime(sdf_time.parse(endTime));
            }
            catch (ParseException e) {
                logger.error("Date parse Exception:{}", e);
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u914d\u7f6e\u9519\u8bef");
            }
            if (nowCalendar.before(startCalendar)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(8, "\u4eca\u5929\u9650\u65f6\u62a2\u8d2d\u8fd8\u672a\u5f00\u59cb");
            }
            if (nowCalendar.after(endCalendar)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(9, "\u4eca\u5929\u9650\u65f6\u62a2\u8d2d\u5df2\u7ed3\u675f");
            }
            Date now = new Date();
            long time = now.getTime();
            if (bonusConsume > 0) {
                try {
                    Random random = new Random(System.currentTimeMillis());
                    String orderId = "PurchL" + time + random.nextInt(10000);
                    String resultCode = BonusClient.consume(userIdStr, userName, bonusConsume, orderId, sdf_date.format(now), actNo, "");
                    if (!resultCode.equals("00")) {
                        String msg = "\u6d88\u8017\u79ef\u5206\u5931\u8d25\uff0cResult Code:" + resultCode;
                        logger.error(msg);
                        return JsonObjectUtil.getRtnAndDataJsonObject(303, msg);
                    }
                }
                catch (Exception e) {
                    logger.error("Exception when doBonusExchange consume bonus\uff1a", e);
                    return JsonObjectUtil.getRtnAndDataJsonObject(303, "\u6d88\u8017\u79ef\u5206\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                }
            }
            String result = CommonActivityClient.getGift(actNo, moduleId, userIdStr, giftIdStr, remoteIp, false);
            logger.info("CommonActivityClient.getGift \u7684\u7ed3\u679c\u4e3a\uff1a" + result);
            JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
            int resultcode = jsonObject.get("rtn").getAsInt();
            if (resultcode != 0) {
                Random random = new Random(System.currentTimeMillis());
                String orderId = "PurchLRoll" + time + random.nextInt(10000);
                try {
                    BonusClient.recharge(userIdStr, userName, bonusConsume, orderId, sdf_date.format(now), actNo);
                }
                catch (Exception e) {
                    logger.error("rollBackBonus recharge Exception:", e);
                }
                return result;
            }
            new Thread(new AddPurchaseLimitRecordThread((int)userId, curDate)).start();
            return result;
        }
        catch (Exception e) {
            logger.error("purchaseLimitationGift Exception:{}", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }
}

