/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.gift;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.league.facade.FacadeFactory;
import com.xunlei.niux.data.league.vo.NiuxCash;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.dto.GiftRecordDTO;
import com.xunlei.niux.data.vipgame.vo.Activity;
import com.xunlei.niux.data.vipgame.vo.CustomerGrade;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackageGame;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecordQueryTime;
import com.xunlei.util.Log;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ProductReceiveReportCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(ProductReceiveReportCmd.class.getName());
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");

    @CmdMapper(value={"/product/queryUsedStatus.do"})
    public Object queryUsedStatus(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        NiuxCash cash = new NiuxCash();
        cash.setReceiveUserId(userId);
        cash.setCashStatus("0");
        int count = FacadeFactory.INSTANCE.getNiuxCashBo().count(cash);
        cash.setCashStatus("1");
        int count1 = FacadeFactory.INSTANCE.getNiuxCashBo().count(cash);
        if (count + count1 >= 1) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6709\u672a\u4f7f\u7528\u7684\u4ee3\u91d1\u5238");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u6ca1\u6709\u672a\u4f7f\u7528\u7684\u4ee3\u91d1\u5238");
    }

    @CmdMapper(value={"/product/getReportRecords.do"})
    public Object getGiftRecords(XLHttpRequest request, XLHttpResponse response) {
        int pageNo = request.getParameterInteger("pageNo", 1);
        int pageSize = request.getParameterInteger("pageSize", 10);
        pageSize = pageSize <= 0 ? 10 : pageSize;
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        String showLocNo = request.getParameter("showLocNo", "myproduct");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        String countSql = "select count(*) from giftrecord left join gift on giftrecord.giftId = gift.giftId left join giftshopreleaserecord on giftrecord.recordId = giftshopreleaserecord.giftRecordId where gift.gifttype <> 'niuxcash' and giftrecord.userid=? AND giftrecord.isshow='1' AND giftrecord.showLocNo=? ";
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().count(countSql, new Object[]{userId, showLocNo});
        map.put("count", Integer.valueOf(count));
        if (count == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        String sql = "select giftrecord.*,giftshopreleaserecord.*,0 as goodId from giftrecord left join gift on giftrecord.giftId = gift.giftId left join giftshopreleaserecord on giftrecord.recordId = giftshopreleaserecord.giftRecordId where gift.gifttype <> 'niuxcash' and giftrecord.userid=? AND giftrecord.isshow='1' AND giftrecord.showLocNo=? ORDER BY recordTime DESC limit ?,?";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(userId);
        list.add(showLocNo);
        list.add((pageNo - 1) * pageSize);
        list.add(pageSize);
        List gflist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(GiftRecordDTO.class, sql, list);
        ArrayList<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < gflist.size(); ++i) {
            GiftRecordDTO gr = (GiftRecordDTO)gflist.get(i);
            Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, gr.getGiftId());
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("thirdRecordId", gr.getRecordId());
            Activity activity = ProductReceiveReportCmd.getActivtiy(gr.getActNo());
            map1.put("actName", activity == null || activity.getTitle() == null ? "" : activity.getTitle());
            map1.put("productId", gr.getGiftId());
            map1.put("productType", gift.getGiftType());
            map1.put("productNum", gr.getGiftNum());
            map1.put("reportId", gr.getRecordId());
            map1.put("giveOutTime", gr.getRecordTime().substring(0, 10));
            map1.put("productName", gift.getGiftName());
            map1.put("picUrl", gift.getGiftPic());
            map1.put("useExpireDate", gr.getExpireDate());
            map1.put("simpleDesc", gift.getSimpleDesc());
            map1.put("serialNumber", gr.getSerialNumber() == null ? "" : gr.getSerialNumber());
            map1.put("serverName", gr.getServerName() == null ? "" : gr.getServerName());
            ProductReceiveReportCmd.formatJumpInfo(map1, gift, null);
            if (!gr.getGiftStatus().equals("WAIT")) {
                map1.put("status", "USED");
            } else {
                String nowDate = sdfDate.format(new Date());
                if (nowDate.compareTo(gr.getExpireDate()) > 0) {
                    map1.put("status", "EXPIRED");
                } else {
                    map1.put("status", "CANUSE");
                }
            }
            if (gr.getReleaseStatus().booleanValue()) {
                map1.put("expressStatus", 1);
            }
            mapList.add(map1);
        }
        map.put("pageDatas", mapList);
        this.updateGiftRecordQueryTime(userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    @CmdMapper(value={"/product/getCashRecords.do"})
    public Object getCashRecords(XLHttpRequest request, XLHttpResponse response) {
        int pageNo = request.getParameterInteger("pageNo", 1);
        int pageSize = request.getParameterInteger("pageSize", 10);
        pageSize = pageSize <= 0 ? 10 : pageSize;
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        NiuxCash cash = new NiuxCash();
        cash.setReceiveUserId(userId);
        List<NiuxCash> niuxcashlist = FacadeFactory.INSTANCE.getNiuxCashBo().finds(cash, new Page());
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        StringBuffer countsql = new StringBuffer();
        countsql.append("SELECT COUNT(*) FROM giftrecord s1 INNER JOIN   ").append("  (SELECT giftid FROM gift WHERE gifttype = 'niuxcash') s2  ").append("  ON s1.giftid = s2.giftid  ").append("  WHERE s1.userid=? AND s1.isshow='1'; ");
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().count(countsql.toString(), new Object[]{userId});
        map.put("count", Integer.valueOf(count));
        if (count == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT s1.* FROM giftrecord s1 INNER JOIN   ").append("  (SELECT giftid FROM gift WHERE gifttype = 'niuxcash') s2  ").append("  ON s1.giftid = s2.giftid  ").append("  WHERE s1.userid=? AND s1.isshow='1'").append(" ORDER BY recordTime DESC ").append(" limit ?,?");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(userId);
        list.add((pageNo - 1) * pageSize);
        list.add(pageSize);
        List gflist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().executeQuery(GiftRecord.class, sql.toString(), list);
        ArrayList<HashMap<String, Object>> mapList = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < gflist.size(); ++i) {
            GiftRecord gr = (GiftRecord)gflist.get(i);
            Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, gr.getGiftId());
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            map1.put("thirdRecordId", gr.getRecordId());
            Activity activity = ProductReceiveReportCmd.getActivtiy(gr.getActNo());
            map1.put("actName", activity == null || activity.getTitle() == null ? "" : activity.getTitle());
            map1.put("productId", gr.getGiftId());
            map1.put("productType", gift.getGiftType());
            map1.put("productNum", gr.getGiftNum());
            map1.put("reportId", gr.getRecordId());
            map1.put("giveOutTime", gr.getRecordTime().substring(0, 10));
            map1.put("productName", gift.getGiftName());
            map1.put("picUrl", gift.getGiftPic());
            map1.put("useExpireDate", gr.getExpireDate());
            map1.put("simpleDesc", gift.getSimpleDesc());
            map1.put("serialNumber", gr.getSerialNumber() == null ? "" : gr.getSerialNumber());
            ProductReceiveReportCmd.formatJumpInfo(map1, gift, gr);
            String status = this.getStatus(niuxcashlist, gr.getSerialNumber());
            if (status == null) continue;
            if ("2".equals(status)) {
                map1.put("status", "USED");
            } else {
                map1.put("status", "CANUSE");
            }
            mapList.add(map1);
        }
        map.put("pageDatas", mapList);
        this.updateGiftRecordQueryTime(userId);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    private String getStatus(List<NiuxCash> niuxcashlist, String serialNumber) {
        if (niuxcashlist == null || niuxcashlist.size() == 0) {
            return null;
        }
        if (serialNumber == null || "".equals(serialNumber)) {
            return null;
        }
        for (NiuxCash niuxcash : niuxcashlist) {
            String cashno = niuxcash.getCashNo();
            if (!cashno.trim().equals(serialNumber)) continue;
            return niuxcash.getCashStatus();
        }
        return null;
    }

    @CmdMapper(value={"/product/getReportNiuxGiftUseCondition.do"})
    public Object getReportNiuxGiftUseCondition(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        Long recordId = request.getParameterLong("reportId");
        GiftRecord giftRecord = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecord.class, recordId);
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, giftRecord.getGiftId());
        if (!gift.getGiftType().equals("niuxgift")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(13, "\u4e0d\u662f\u793c\u5305");
        }
        GiftPackage giftPackage = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftPackage.class, gift.getGiftLot());
        HashMap<String, Object> resultmap = new HashMap<String, Object>();
        double needJinKaMoney = ProductReceiveReportCmd.getEnoughJinKaMoney(userId, giftPackage.getMinJinKaLevelNum());
        resultmap.put("jinKaLeveLEnough", needJinKaMoney <= 0.0);
        resultmap.put("needEnoughJinKaLevelMoney", needJinKaMoney);
        resultmap.put("isNeedSelectGame", false);
        if (!giftPackage.getIsGamePackage().booleanValue()) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultmap);
        }
        String limitType = giftPackage.getInheritParentGameServerType();
        if (limitType.equals("SERVER")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultmap);
        }
        resultmap.put("isNeedSelectGame", true);
        boolean isNeedBindMobile = false;
        String gameId = limitType.equals("GAME") ? giftRecord.getGameId() : "";
        GiftPackageGame ggquery = new GiftPackageGame();
        ggquery.setGameId(gameId);
        ggquery.setPackageId(giftPackage.getPackageId());
        List<GiftPackageGame> gglist = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObjects(ggquery, new Page());
        ArrayList mapList = new ArrayList();
        for (GiftPackageGame gg : gglist) {
            HashMap<String, Object> tmap = new HashMap<String, Object>();
            Games game = ProductReceiveReportCmd.getGames(gg.getGameId());
            tmap.put("gameId", gg.getGameId());
            tmap.put("gameNo", game.getGameNo());
            tmap.put("gameName", game.getGameName());
            tmap.put("isNeedBindMobile", gg.getIsNeedBindMobile());
            tmap.put("minRoleLevelNum", gg.getMinRoleLevelNum());
            GamePayInfo getGamePayInfo = this.getGamePayInfo(gg.getGameId());
            tmap.put("isNeedSelectServer", getGamePayInfo == null || getGamePayInfo.getFormType().contains("s"));
            tmap.put("isNeedSelectRole", getGamePayInfo == null || getGamePayInfo.getFormType().contains("r"));
            mapList.add(tmap);
            isNeedBindMobile = gg.getIsNeedBindMobile() != false ? gg.getIsNeedBindMobile() : isNeedBindMobile;
        }
        if (isNeedBindMobile) {
            String mobile = ProductReceiveReportCmd.getMobileNum(userId);
            if (mobile.equals("")) {
                resultmap.put("mobileStatus", "NOTBIND");
            } else {
                GiftRecord tgpurquery = new GiftRecord();
                tgpurquery.setGiftId(gift.getGiftId());
                tgpurquery.setMobile(mobile);
                int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(tgpurquery);
                if (count > 0) {
                    resultmap.put("mobileStatus", "USED");
                } else {
                    resultmap.put("mobileStatus", "BINDED");
                }
            }
        }
        resultmap.put("giftGames", mapList);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultmap);
    }

    private static String getMobileNum(String userId) {
        CustomerInfo query = new CustomerInfo();
        query.setUid(userId);
        CustomerInfo customer = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return customer == null || customer.getPhone() == null ? "" : customer.getPhone();
    }

    private static Games getGames(String gameId) {
        Games query = new Games();
        query.setGameId(gameId);
        return com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private static Activity getActivtiy(String actNo) {
        if (actNo.equals("")) {
            return null;
        }
        Activity query = new Activity();
        query.setActno(actNo);
        return com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private static double getEnoughJinKaMoney(String userId, int minLevelNum) {
        if (minLevelNum <= 0) {
            return 0.0;
        }
        int curLevel = 0;
        double curTotalMoney = 0.0;
        UserVipBo userVipBo = com.xunlei.niux.data.vip.facade.FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(Long.parseLong(userId));
        if (userVip != null) {
            curLevel = userVip.getVipLervelNum();
            curTotalMoney = userVip.getPayMoney();
        }
        if (curLevel >= minLevelNum) {
            return 0.0;
        }
        CustomerGrade queryGrade = new CustomerGrade();
        queryGrade.setVipGrade(minLevelNum);
        CustomerGrade grade = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(queryGrade);
        return (double)grade.getAmountFrom().longValue() - curTotalMoney;
    }

    public GamePayInfo getGamePayInfo(String gameId) {
        GamePayInfo query = new GamePayInfo();
        query.setGameid(gameId);
        return com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    public static void formatJumpInfo(Map<String, Object> map, Gift gift, GiftRecord gr) {
        String giftType = gift.getGiftType();
        if ("niuxcash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://niu.xunlei.com/order.html");
            return;
        }
        if ("cash".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("baijinvip".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/jinku.html");
            return;
        }
        if ("bjtyhy".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/orderlist.html");
            return;
        }
        if ("gstdll".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://vip.xunlei.com/vip_service/freedom/gstdll.html");
            return;
        }
        if ("jshytyk".equals(giftType)) {
            map.put("linkName", "\u67e5\u770b\u8bb0\u5f55");
            map.put("linkUrl", "http://jsq.xunlei.com/");
            return;
        }
        if ("yuanbao".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("bonus".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("xiubi".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("gift".equals(giftType)) {
            map.put("linkName", "\u7acb\u5373\u4f7f\u7528");
            String officialUrl = "";
            Games game = null;
            if (gift.getGameId() != null && !"".equals(gift.getGameId())) {
                game = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(gift.getGameId());
            }
            if (game != null) {
                officialUrl = game.getOfficialWebSite() + "/server.shtml";
            }
            map.put("linkUrl", officialUrl);
            return;
        }
        if ("fortune".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u5df2\u53d1\u653e\u81f3\u5e10\u53f7");
            map.put("linkUrl", "");
            return;
        }
        if ("product".equals(giftType)) {
            map.put("linkName", "\u72b6\u6001\uff1a\u7531\u5ba2\u670d\u4eba\u5458\u7ebf\u4e0b\u53d1\u653e");
            map.put("linkUrl", "");
            return;
        }
    }

    private void updateGiftRecordQueryTime(String uid) {
        try {
            GiftRecordQueryTime queryTime = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftRecordQueryTime.class, uid);
            String nowTime = sdf_time.format(new Date());
            if (queryTime == null) {
                queryTime = new GiftRecordQueryTime();
                queryTime.setLastQueryTime(nowTime);
                queryTime.setUserId(uid);
                com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().addObject(queryTime);
            } else {
                queryTime.setLastQueryTime(nowTime);
                com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().updateObjectById(queryTime);
            }
        }
        catch (Exception e) {
            logger.error("uid[" + uid + "]update giftrecord lastquerytime");
        }
    }
}

