/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.gift;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.CardClient;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.client.daijinquan.NewDaiJinQuanClient;
import com.xunlei.niux.client.vip.VipClient;
import com.xunlei.niux.client.yuanbao.YuanBaoClient;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GamePayInfo;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftFlow;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class GiveOutGift
extends DefaultCmd {
    private static SimpleDateFormat sdftime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdfdate = new SimpleDateFormat("yyyy-MM-dd");
    private static String daijinquanbizno = EnvPropertyUtil.loadProperty("niux", "daijinquanbizno_niuxgift");
    private static String daijinquanbizpwd = EnvPropertyUtil.loadProperty("niux", "daijinquanbizpwd_niuxgift");
    private static String bizKey = "dafsdfsdfsdfas";

    @CmdMapper(value={"/gift/giveoutgift.do"})
    public Object giveOutGift(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        Long giftId = request.getParameterLong("giftId");
        String userId = request.getParameter("userId", "");
        String gameId = request.getParameter("gameId", "");
        String serverId = request.getParameter("serverId", "");
        String roleId = request.getParameter("roleId", "");
        String actNo = request.getParameter("actNo", "");
        String thirdOrderNo = request.getParameter("thirdOrderNo", "");
        String bizNo = request.getParameter("bizNo", "");
        String oldSign = request.getParameter("sign", "");
        Integer giftNum = request.getParameterInteger("giftNum");
        if ("".equals(userId) || "".equals(actNo) || "".equals(thirdOrderNo)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(13, "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("giftId", String.valueOf(giftId));
        param.put("serverId", serverId);
        param.put("roleId", roleId);
        param.put("actNo", actNo);
        param.put("thirdOrderNo", thirdOrderNo);
        param.put("bizNo", bizNo);
        param.put("gameId", gameId);
        param.put("giftNum", String.valueOf(giftNum));
        String sign = SignUtil.sign(param, bizKey);
        if (!sign.equals(oldSign)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(11, "\u7b7e\u540d\u4e0d\u6b63\u786e");
        }
        Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, giftId);
        if (gift == null || !gift.getIsValid().booleanValue()) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2000, "\u4ea7\u54c1[" + giftId + "]\u4e0d\u5b58\u5728\u6216\u8005\u65e0\u6548");
        }
        try {
            this.checkGiftGameInfoValid(gift, gameId, serverId, roleId);
        }
        catch (NiuExceptionAndCode e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage());
        }
        try {
            this.checkGiftNumValid(gift, giftNum);
        }
        catch (NiuExceptionAndCode e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage());
        }
        GiftFlow giftFlow = this.findGiftFlow(actNo, thirdOrderNo);
        if (giftFlow == null) {
            giftFlow = new GiftFlow();
            giftFlow.setActNo(actNo);
            giftFlow.setDealTime("");
            giftFlow.setFailCause("");
            giftFlow.setFlowStatus("W");
            giftFlow.setFlowTime(sdftime.format(new Date()));
            giftFlow.setGameId(gameId);
            giftFlow.setGiftId(giftId);
            giftFlow.setUserId(userId);
            giftFlow.setThirdOrderNo(thirdOrderNo);
            giftFlow.setServerId(serverId);
            giftFlow.setSerialNum("");
            giftFlow.setRoleId(roleId);
            giftFlow.setGiftNum(giftNum);
            FacadeFactory.INSTANCE.getBaseSo().addObject(giftFlow);
            giftFlow = this.findGiftFlow(actNo, thirdOrderNo);
        }
        if ("W".equals(giftFlow.getFlowStatus())) {
            this.dealGift(giftFlow, gift);
        }
        if ("F".equals(giftFlow.getFlowStatus())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(99, giftFlow.getFailCause());
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("giftType", gift.getGiftType());
        resultMap.put("serialNum", giftFlow.getSerialNum());
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private void dealGift(GiftFlow giftFlow, Gift gift) {
        try {
            if (gift.getGiftType().equals("yuanbao")) {
                String userName = UserUtility.getUserNameByUserId(giftFlow.getUserId());
                YuanBaoClient.giveOutYuanBao(userName, giftFlow.getGameId(), giftFlow.getServerId(), giftFlow.getThirdOrderNo(), giftFlow.getActNo(), (int)((double)giftFlow.getGiftNum().intValue() * gift.getProductUnitPrice()), giftFlow.getRoleId());
            } else if ("cash".equals(gift.getGiftType())) {
                NewDaiJinQuanClient.giveOut(giftFlow.getActNo(), giftFlow.getUserId(), giftFlow.getFlowId() + "_giftflow" + SignUtil.sign(giftFlow.getThirdOrderNo(), giftFlow.getUserId()).substring(0, 5), gift.getGiftType(), (long)(gift.getProductUnitPrice() * 100.0));
            } else if ("bonus".equals(gift.getGiftType())) {
                String userName = UserUtility.getUserNameByUserId(giftFlow.getUserId());
                BonusClient.recharge(giftFlow.getUserId(), userName, (int)(gift.getProductUnitPrice() * (double)giftFlow.getGiftNum().intValue()), giftFlow.getFlowId() + "_giftflow" + SignUtil.sign(giftFlow.getThirdOrderNo(), giftFlow.getUserId()).substring(0, 5), sdfdate.format(new Date()), giftFlow.getActNo());
            } else if ("gift".equals(gift.getGiftType())) {
                String gameId = giftFlow.getGameId();
                gameId = gameId.length() > 5 ? gameId.substring(gameId.length() - 5) : gameId;
                String userName = UserUtility.getUserNameByUserId(giftFlow.getUserId());
                String tempserialNum = CardClient.getCardCode22(gameId, giftFlow.getServerId(), gift.getGiftType(), gift.getGiftLot(), Long.valueOf(giftFlow.getUserId()), userName, true);
                if (StringUtil.isEmpty(tempserialNum)) {
                    throw new Exception("\u793c\u5305\u83b7\u53d6\u5931\u8d25");
                }
                giftFlow.setSerialNum(tempserialNum);
            } else if ("bjtyhy".equals(gift.getGiftType())) {
                VipClient.rechargeBaiJinVipByDay(giftFlow.getUserId(), gift.getProductUnitPrice().intValue(), giftFlow.getFlowId() + "_gf", giftFlow.getActNo());
            } else {
                throw new RuntimeException("\u975e\u6cd5gift\u7c7b\u578b");
            }
            giftFlow.setFlowStatus("S");
        }
        catch (Exception e) {
            giftFlow.setFailCause(e.getMessage());
            giftFlow.setFlowStatus("F");
        }
        giftFlow.setDealTime(sdftime.format(new Date()));
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(giftFlow);
    }

    private GiftFlow findGiftFlow(String actNo, String thirdOrderNo) {
        GiftFlow query = new GiftFlow();
        query.setActNo(actNo);
        query.setThirdOrderNo(thirdOrderNo);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }

    private void checkGiftNumValid(Gift gift, Integer giftNum) throws NiuExceptionAndCode {
        if ("yuanbao".equals(gift.getGiftType()) || "bonus".equals(gift.getGiftType())) {
            return;
        }
        if (giftNum != 1) {
            throw new NiuExceptionAndCode("13", "\u6570\u91cf\u9519\u8bef");
        }
    }

    private void checkGiftGameInfoValid(Gift gift, String gameId, String serverId, String roleId) throws NiuExceptionAndCode {
        boolean isNeedSelectRole;
        if (!gift.getIsGameGift().booleanValue()) {
            return;
        }
        if ("".equals(gameId)) {
            throw new NiuExceptionAndCode("2004", "\u6e38\u620f\u4e3a\u7a7a");
        }
        if (!"".equals(gift.getGameId()) && gameId.equals(gift.getGameId())) {
            throw new NiuExceptionAndCode("2004", "\u6e38\u620f\u4e0d\u4e00\u81f4");
        }
        GamePayInfo getGamePayInfo = GiveOutGift.getGamePayInfo(gift.getGameId());
        boolean isNeedSelectServer = getGamePayInfo == null || getGamePayInfo.getFormType().contains("s");
        boolean bl = isNeedSelectRole = getGamePayInfo == null || getGamePayInfo.getFormType().contains("r");
        if (isNeedSelectServer && "".equals(serverId)) {
            throw new NiuExceptionAndCode("2005", "\u533a\u670d\u4e3a\u7a7a");
        }
        if (isNeedSelectRole && "".equals(roleId)) {
            throw new NiuExceptionAndCode("2006", "\u89d2\u8272\u4e3a\u7a7a");
        }
    }

    private static GamePayInfo getGamePayInfo(String gameId) {
        GamePayInfo query = new GamePayInfo();
        query.setGameid(gameId);
        return FacadeFactory.INSTANCE.getBaseSo().findObject(query);
    }
}

