/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.gift;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.so.gift.UseGiftPackageSo;
import com.xunlei.niux.center.thirdclient.vip.VipClient;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GiftPackageCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GiftPackageCmd.class.getName());

    @CmdMapper(value={"/gift/useGift.do"})
    public Object useGift(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        Long recordId = request.getParameterLong("recordId");
        String gameId = request.getParameter("gameId", "");
        String serverId = request.getParameter("serverId", "");
        String roleId = request.getParameter("roleId", "");
        String sessionid = request.getCookieValue("sessionid");
        String serverName = request.getParameter("serverName", "");
        try {
            String xunleiVipType = this.checkIsVip(userId, sessionid) ? "VIP" : "NOTVIP";
            UseGiftPackageSo.useGift(recordId, userId, gameId, serverId, roleId, xunleiVipType, serverName);
            UseGiftPackageSo.userPackageDetail(recordId);
            List<Map<String, Object>> resultlist = this.getResult(recordId);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultlist);
        }
        catch (NiuExceptionAndCode e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.code + "-" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage());
        }
        catch (NiuRuntimeException e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.code + "-" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.valueOf(e.code), e.getMessage());
        }
        catch (Exception e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.getMessage());
        }
    }

    @CmdMapper(value={"/gift/queryGiftResult.do"})
    public Object queryGiftResult(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        Long recordId = request.getParameterLong("recordId");
        try {
            List<Map<String, Object>> resultlist = this.getResult(recordId);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultlist);
        }
        catch (Exception e) {
            logger.error("\u7528\u6237[" + userId + "]\u4f7f\u7528\u793c\u5305[" + recordId + "]\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(99, e.getMessage());
        }
    }

    public List<Map<String, Object>> getResult(long parentRecordId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        GiftRecord query = new GiftRecord();
        query.setParentRecordId(parentRecordId);
        List<GiftRecord> grList = FacadeFactory.INSTANCE.getBaseSo().findObjects(query, new Page());
        for (int i = 0; i < grList.size(); ++i) {
            GiftRecord gr = grList.get(i);
            Gift gift = FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, gr.getGiftId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("giftType", gift.getGiftType());
            map.put("giftNum", gr.getGiftNum());
            map.put("giftName", gift.getGiftName());
            map.put("serialNumber", gr.getSerialNumber());
            list.add(map);
        }
        return list;
    }

    private boolean checkIsVip(String uid, String sessionid) {
        try {
            Map<String, String> resultMap = VipClient.getVipInfo(uid, sessionid);
            String vipType = resultMap.get("vas_type");
            vipType = vipType == null ? "" : vipType;
            String isVip = resultMap.get("isvip");
            String string = isVip = isVip == null ? "" : isVip;
            return "1".equals(isVip);
        }
        catch (NiuRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NiuRuntimeException("1047", "\u67e5\u8be2userId[" + uid + "]\u662f\u5426\u767d\u91d1\u4f1a\u5458\u51fa\u5e2d\u5f02\u5e38");
        }
    }
}

