/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.gift;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.vip.bo.UserVipBo;
import com.xunlei.niux.data.vip.facade.FacadeFactory;
import com.xunlei.niux.data.vip.vo.UserVip;
import com.xunlei.niux.data.vipgame.vo.gift.Gift;
import com.xunlei.niux.data.vipgame.vo.gift.GiftPackage;
import com.xunlei.niux.data.vipgame.vo.gift.GiftRecord;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GiftPackageActCmd
extends DefaultCmd {
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static Logger logger = Log.getLogger(GiftPackageActCmd.class.getName());
    private static long cashGiftId1 = 1026L;
    private static String cashGiftActNo = "niuxcashgift";

    @CmdMapper(value={"/gift/hasCashGift.do"})
    public Object hasCashGift(XLHttpRequest request, XLHttpResponse response) {
        int jinKaLevel;
        boolean hasCashGift;
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        GiftRecord query = new GiftRecord();
        query.setActNo(cashGiftActNo);
        query.setUserId(userId);
        query.setGiftId(cashGiftId1);
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, cashGiftId1);
        if (gift == null || !gift.getIsValid().booleanValue()) {
            resultMap.put("hasCashGift", true);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        boolean bl = hasCashGift = count > 0;
        if (!hasCashGift && (jinKaLevel = GiftPackageActCmd.getJinKaLevelNum(Long.valueOf(userId))) > 0) {
            hasCashGift = true;
        }
        resultMap.put("hasCashGift", hasCashGift);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private static int getJinKaLevelNum(long userId) {
        UserVipBo userVipBo = FacadeFactory.INSTANCE.getUserVipBo();
        UserVip userVip = userVipBo.find(userId);
        return userVip == null ? 0 : userVip.getVipLervelNum();
    }

    @CmdMapper(value={"/gift/getCashGift.do"})
    public Object getCashGift(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        String userId = String.valueOf(mainParam.getUserid());
        try {
            int jinKaLevel;
            GiftRecord query = new GiftRecord();
            query.setActNo(cashGiftActNo);
            query.setUserId(userId);
            query.setGiftId(cashGiftId1);
            int count = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().countObject(query);
            if (count == 0 && (jinKaLevel = GiftPackageActCmd.getJinKaLevelNum(Long.valueOf(userId))) == 0) {
                Gift gift = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(Gift.class, cashGiftId1);
                if (!gift.getGiftType().equals("niuxgift")) {
                    throw new RuntimeException("\u975e\u793c\u5305");
                }
                if (gift.getGiftLot().equals("")) {
                    throw new RuntimeException("\u975e\u793c\u5305");
                }
                GiftPackage giftPackage = com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getBaseSo().findById(GiftPackage.class, gift.getGiftLot());
                GiftRecord detailGiftRecord = new GiftRecord();
                detailGiftRecord.setActNo(cashGiftActNo);
                detailGiftRecord.setGameId("");
                detailGiftRecord.setGiftId(cashGiftId1);
                detailGiftRecord.setGiftNum(1.0);
                detailGiftRecord.setRoleId("");
                detailGiftRecord.setServerId("");
                detailGiftRecord.setThirdRecordId(cashGiftId1 + "_" + userId + "_" + cashGiftActNo);
                detailGiftRecord.setUserId(userId);
                detailGiftRecord.setIsShow(true);
                detailGiftRecord.setExpireDate(GiftPackageActCmd.calExpireDate(giftPackage.getExpireDays()));
                com.xunlei.niux.data.vipgame.facade.FacadeFactory.INSTANCE.getUseGiftPackageBo().addGiftPackageDetail(detailGiftRecord);
            }
        }
        catch (Exception e) {
            logger.info("\u7528\u6237[" + userId + "]\u9886\u53d6\u73b0\u91d1\u793c\u5305\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        response.redirect("http://niu.xunlei.com/myprize.html?type=niux");
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f\u9886\u53d6");
    }

    private static String calExpireDate(int days) {
        long now = System.currentTimeMillis();
        long expiretime = now + 86400000L * (long)days;
        return sdfDate.format(new Date(expiretime));
    }
}

