/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.game;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.client.util.URLUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.Advice;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class GetGameHelpCmd
extends DefaultCmd {
    @CmdMapper(value={"/game/gethelp.do"})
    public Object getGameHelp(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String key = "Bk17dES88ApSJwsO";
        String gameId = request.getParameter("gameId", "");
        if ("".equals(gameId)) {
            resultMap.put("count", 0);
            resultMap.put("levelNum", "");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            resultMap.put("msg", "session\u8fc7\u671f");
            resultMap.put("count", 0);
            resultMap.put("levelNum", "");
            return JsonObjectUtil.getRtnAndDataJsonObject(11, resultMap);
        }
        String userId = mainParam.getUserid() + "";
        Integer fenQuNum = request.getParameterInteger("fenQuNum");
        Integer pageSize = request.getParameterInteger("pageSize", 8);
        Integer pageNo = request.getParameterInteger("pageNo", 1);
        String serverId = this.getServerId(gameId, fenQuNum);
        List<Advice> adList = this.getAdvice(gameId);
        Integer levelNum = GetGameHelpCmd.getGameLevel(gameId, serverId, userId, key);
        resultMap.put("levelNum", levelNum == null ? "" : levelNum);
        List<Map<String, Object>> list = this.formatAdvice(adList, levelNum);
        resultMap.put("count", list.size());
        resultMap.put("advices", this.pageAdvices(list, pageNo, pageSize));
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private List<Map<String, Object>> pageAdvices(List<Map<String, Object>> list, int pageNo, int pageSize) {
        ArrayList<Map<String, Object>> pageList = new ArrayList<Map<String, Object>>();
        if (list == null || list.size() == 0) {
            return pageList;
        }
        int firstIndex = pageSize * (pageNo - 1);
        int lastIndex = pageSize * pageNo - 1;
        for (int i = firstIndex; i < list.size() && i <= lastIndex; ++i) {
            pageList.add(list.get(i));
        }
        return pageList;
    }

    private List<Map<String, Object>> formatAdvice(List<Advice> adList, Integer levelNum) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (adList == null || adList.size() == 0) {
            return list;
        }
        ArrayList commonList = new ArrayList();
        ArrayList topList = new ArrayList();
        for (Advice advice : adList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("title", advice.getTitle() == null ? "" : advice.getTitle());
            map.put("url", advice.getJumpUrl() == null ? "" : advice.getJumpUrl());
            boolean isTop = this.isTop(advice, levelNum);
            map.put("isTop", isTop);
            if (isTop) {
                topList.add(map);
                continue;
            }
            commonList.add(map);
        }
        list.addAll(topList);
        list.addAll(commonList);
        return list;
    }

    private boolean isTop(Advice advice, Integer levelNum) {
        if (advice == null || levelNum == null) {
            return false;
        }
        if (advice.getLevelNum() == null) {
            return false;
        }
        int minLevel = levelNum / 10 * 10;
        int maxLevel = minLevel + 9;
        return advice.getLevelNum() >= minLevel && advice.getLevelNum() <= maxLevel;
    }

    public List<Advice> getAdvice(String gameId) {
        ArrayList<Advice> adList = new ArrayList();
        Advice query = new Advice();
        query.setAdviceType("3");
        query.setGameId(gameId);
        query.setPlatformno("gonglue");
        Page page = new Page();
        page.addOrder("levelNum", OrderType.ESC);
        page.addOrder("displayOrder", OrderType.ESC);
        adList = FacadeFactory.INSTANCE.getAdviceBo().findAdvice(query, page);
        return adList;
    }

    public String getServerId(String gameId, int fenQuNum) {
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setFenQuNum(fenQuNum);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(query, new Page());
        GameServers gs = gsList == null || gsList.size() == 0 ? null : gsList.get(0);
        return gs == null ? "" : gs.getServerId();
    }

    public static Integer getGameLevel(String gameId, String serverId, String userId, String key) {
        String sign = SignUtil.sign(userId + gameId + serverId, key);
        StringBuilder sb = new StringBuilder();
        sb.append("http://websvr.niu.xunlei.com/boxQueryGameUserLevel.gameUserInfo?").append("gameid=").append(gameId).append("&serverid=").append(serverId).append("&userid=").append(userId).append("&sign=").append(sign);
        try {
            String resp = URLUtil.get(sb.toString());
            resp = resp.replaceAll("\\{", "");
            resp = resp.replaceAll("\\}", "");
            resp = resp.replaceAll("\"", "");
            HashMap<String, String> map = new HashMap<String, String>();
            String[] respArr = resp.split(",");
            if (respArr != null && respArr.length > 0) {
                for (String respStr : respArr) {
                    String[] tempArr;
                    if (respStr == null || "".equals(respStr) || (tempArr = respStr.split(":")) == null || tempArr.length != 2) continue;
                    System.out.println(tempArr[0] + ":" + tempArr[1]);
                    map.put(tempArr[0], tempArr[1]);
                }
            }
            if (!"0".equals(map.get("statues"))) {
                return null;
            }
            return map.get("level") == null ? null : Integer.valueOf(map.get("level") + "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

