/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.game;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GameServerCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GameServerCmd.class);

    @CmdMapper(value={"/game/getgameserverinfo.do"})
    public Object getGameServerInfo(XLHttpRequest request, XLHttpResponse response) {
        String gameId = request.getParameter("gameId", "000000");
        int fenQuNum = request.getParameterInteger("fenQuNum", -1);
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setFenQuNum(fenQuNum);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(query, new Page());
        GameServers gs = gsList == null || gsList.size() == 0 ? null : gsList.get(0);
        HashMap<Integer, GameServers> gsMap = new HashMap<Integer, GameServers>();
        if (gs != null) {
            gsMap.put(gs.getFenQuNum(), gs);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, gsMap);
    }

    @CmdMapper(value={"/game/getserverinfo.do"})
    public Object getServerInfo(XLHttpRequest request, XLHttpResponse response) {
        String fromOpenDate = request.getParameter("fromOpenDate", "");
        String toOpenDate = request.getParameter("toOpenDate", "");
        String openStatus = request.getParameter("openStatus", "");
        String gameId = request.getParameter("gameId", "");
        GameServers query = new GameServers();
        if (!"".equals(toOpenDate)) {
            query.setToopentime(toOpenDate + " 23:59:59");
        }
        if (!"".equals(fromOpenDate)) {
            query.setFromopentime(fromOpenDate + " 00:00:00");
        }
        query.setGameId(gameId);
        query.setOpenStatus(openStatus);
        Page page = new Page();
        page.addOrder("openTime", OrderType.ESC);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(query, page);
        List<Map<String, Object>> list = GameServerCmd.fliterGameServerInfo(gsList);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
    }

    @CmdMapper(value={"/game/getserverinfos.do"})
    public Object getServerInfos(XLHttpRequest request, XLHttpResponse response) {
        String gameId = request.getParameter("gameId", "");
        GameServers query = new GameServers();
        query.setGameId(gameId);
        Page page = new Page();
        page.addOrder("openTime", OrderType.ESC);
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(query, page);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, gsList);
    }

    private static List<Map<String, Object>> fliterGameServerInfo(List<GameServers> gsList) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (gsList == null || gsList.size() == 0) {
            return list;
        }
        for (int i = 0; i < gsList.size(); ++i) {
            GameServers tgs = gsList.get(i);
            Games games = GameServerCmd.findGame(tgs.getGameId());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("seqId", tgs.getSeqId());
            map.put("gameId", tgs.getGameId());
            map.put("fenQuNum", tgs.getFenQuNum());
            map.put("fenQuName", tgs.getFenQuName());
            map.put("serverId", tgs.getServerId());
            map.put("openStatus", tgs.getOpenStatus());
            map.put("openTime", tgs.getOpenTime());
            map.put("isnew", tgs.getIsnew());
            map.put("fenQuNickName", tgs.getFenQuNickName());
            map.put("bigFenQuName", tgs.getBigFenQuName());
            map.put("gameNo", games.getGameNo());
            map.put("gameName", games.getGameName());
            list.add(map);
        }
        return list;
    }

    private static Games findGame(String gameId) {
        Games query = new Games();
        query.setGameId(gameId);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        List<Games> list = FacadeFactory.INSTANCE.getGamesBo().findGames(query, page);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    @CmdMapper(value={"/game/getGameNewestServer.do"})
    public Object getGameNewestServer(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String gameIds = request.getParameter("gameids");
        if (StringUtils.isEmpty(gameIds)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            List<String> gameIdList = StringUtil.getListFromString(gameIds, ",");
            List<GameServers> gameServersList = FacadeFactory.INSTANCE.getGameServersBo().getNewestOpenedGameServersByGameIdList(gameIdList);
            HashMap result = new HashMap();
            for (GameServers gameServer : gameServersList) {
                HashMap<String, Object> serverMap = new HashMap<String, Object>();
                serverMap.put("serverId", gameServer.getServerId());
                serverMap.put("fenQuNum", gameServer.getFenQuNum());
                if (StringUtils.isEmpty(gameServer.getFenQuNickName())) {
                    serverMap.put("fenQuNickName", gameServer.getFenQuName());
                } else {
                    serverMap.put("fenQuNickName", gameServer.getFenQuNickName());
                }
                result.put(gameServer.getGameId(), serverMap);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getGameNewestServer unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/game/getLatestGameNewestServer.do"})
    public Object getLatestGameNewestServer(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String gameIds = request.getParameter("gameids");
        if (StringUtils.isEmpty(gameIds)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            List<String> gameIdList = StringUtil.getListFromString(gameIds, ",");
            List<GameServers> gameServersList = FacadeFactory.INSTANCE.getGameServersBo().getLatestNewestOpenedGameServersByGameIdList(gameIdList);
            HashMap result = new HashMap();
            for (GameServers gameServer : gameServersList) {
                List<GameServers> gameServers;
                String gameId;
                if (StringUtils.isEmpty(gameServer.getFenQuNickName())) {
                    gameServer.setFenQuNickName(gameServer.getFenQuName());
                }
                if (!result.containsKey(gameId = gameServer.getGameId())) {
                    gameServers = new ArrayList<GameServers>();
                    gameServers.add(gameServer);
                    result.put(gameId, gameServers);
                    continue;
                }
                gameServers = (List)result.get(gameId);
                gameServers.add(gameServer);
                result.put(gameId, gameServers);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getGameNewestServer unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/game/getTodayAndTomorrowOpenServers.do"})
    public Object getTodayAndTomorrowOpenServers(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.setInnerContentType(request, response);
            Map resultMap = null;
            String cacheKey = this.getClass() + "_TodayAndTomorrowOpenServersData";
            CacheManager cacheManager = CacheManager.GetInstance();
            Object object = cacheManager.get(cacheKey);
            if (object == null) {
                resultMap = this.getTodayAndTomorrowServersData();
                if (MapUtils.isNotEmpty(resultMap)) {
                    cacheManager.put(cacheKey, resultMap, 10L);
                }
            } else {
                resultMap = (Map)object;
            }
            resultMap.put("current", new Date().getTime());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        catch (Exception e) {
            logger.error("getTodayAndTomorrowOpenServers unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    public Map<String, Object> getTodayAndTomorrowServersData() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String pattern = "yyyy-MM-dd";
        Calendar calendar = Calendar.getInstance();
        Date today = calendar.getTime();
        String todayStr = DateUtil.format(today, pattern);
        calendar.add(6, 1);
        Date tomorrow = calendar.getTime();
        String tomorrowStr = DateUtil.format(tomorrow, pattern);
        List<GameServers> todayServersList = FacadeFactory.INSTANCE.getGameServersBo().getOpenServersByFromDateAndToDate(todayStr, todayStr);
        List<GameServers> tomorrowServersList = FacadeFactory.INSTANCE.getGameServersBo().getOpenServersByFromDateAndToDate(tomorrowStr, tomorrowStr);
        if (CollectionUtils.isEmpty(todayServersList) && CollectionUtils.isEmpty(tomorrowServersList)) {
            return new HashMap<String, Object>();
        }
        resultMap.put("today", this.getTimeMapByServerList(todayServersList));
        resultMap.put("tomorrow", this.getTimeMapByServerList(tomorrowServersList));
        return resultMap;
    }

    private Map<String, Object> getTimeMapByServerList(List<GameServers> serversList) {
        LinkedHashMap<String, Object> resultTimeMap = new LinkedHashMap<String, Object>();
        if (CollectionUtils.isEmpty(serversList)) {
            return resultTimeMap;
        }
        for (GameServers server : serversList) {
            String openServerTime = server.getOpenTime();
            String time = openServerTime.substring(11, 16);
            List timeServerList = null;
            timeServerList = resultTimeMap.containsKey(time) ? (List)resultTimeMap.get(time) : new ArrayList();
            timeServerList.add(this.getGameServerShowMap(server));
            resultTimeMap.put(time, timeServerList);
        }
        return resultTimeMap;
    }

    private Map<String, Object> getGameServerShowMap(GameServers server) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (server == null) {
            throw new RuntimeException("method[getGameServerShowMap] param server can not be null!");
        }
        Games game = FacadeFactory.INSTANCE.getGamesBo().getGameByGameId(server.getGameId());
        if (game == null) {
            throw new RuntimeException("method[getGameServerShowMap] game is not exist by gameId:" + server.getGameId());
        }
        map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
        map.put("gameId", server.getGameId());
        map.put("gameNo", game.getGameNo() == null ? "" : game.getGameNo());
        map.put("fenQuNickName", StringUtils.isEmpty(server.getFenQuNickName()) ? server.getFenQuName() : server.getFenQuNickName());
        map.put("fenQuNum", server.getFenQuNum());
        map.put("isHot", game.getIsHot() != false ? 1 : 0);
        map.put("isNew", game.getIsNew() != false ? 1 : 0);
        return map;
    }
}

