/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.game;

import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.proxy.JRedisProxy;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.gamepoint.GamePoint;
import com.xunlei.niux.data.vipgame.vo.gamepoint.UserGradePoint;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GamePointCmd
extends DefaultCmd {
    @CmdMapper(value={"/point/getPointInfo.do"})
    public Object getPointInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String gameId = request.getParameter("gameId");
        if (StringUtils.isEmpty(gameId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        GamePoint gamePoint = null;
        String memCacheKey = "GamePointInitiation_" + gameId;
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(memCacheKey);
        if (obj == null) {
            gamePoint = FacadeFactory.INSTANCE.getGamePointBo().getGamePointByGameId(gameId);
            if (gamePoint != null) {
                cacheManager.put(memCacheKey, gamePoint, 30L);
            }
        } else {
            gamePoint = (GamePoint)obj;
        }
        if (gamePoint == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u6ca1\u6709\u6e38\u620f\u8bc4\u5206\u6570\u636e");
        }
        HashMap<String, Number> resultMap = new HashMap<String, Number>();
        resultMap.put("totalPoint", this.getCacheTotalPoint(gamePoint));
        resultMap.put("picPoint", gamePoint.getInitPicPoint());
        resultMap.put("soundPoint", gamePoint.getInitSoundPoint());
        resultMap.put("dutyPoint", gamePoint.getInitDutyPoint());
        resultMap.put("operatePoint", gamePoint.getInitOperatePoint());
        resultMap.put("featurePoint", gamePoint.getInitFeaturePoint());
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private double getCacheTotalPoint(GamePoint gamePoint) {
        double gameTotalPoint;
        String cacheKey = "GameTotalPoint_" + gamePoint.getGameId();
        String gameTotalPointStr = JRedisProxy.getInstance().get(cacheKey);
        if (StringUtils.isEmpty(gameTotalPointStr)) {
            gameTotalPoint = this.getTotalPoint(gamePoint);
            if (gameTotalPoint > 0.0) {
                JRedisProxy.getInstance().set(cacheKey, String.valueOf(gameTotalPoint), 1800);
            }
        } else {
            gameTotalPoint = Double.parseDouble(gameTotalPointStr);
        }
        return gameTotalPoint;
    }

    private double getTotalPoint(GamePoint gamePoint) {
        List<UserGradePoint> userGradePointList = FacadeFactory.INSTANCE.getUserGradePointBo().getUserGradePointListByGameId(gamePoint.getGameId());
        if (CollectionUtils.isEmpty(userGradePointList)) {
            return gamePoint.getInitTotalPoint();
        }
        int initCount = 10000;
        int count = userGradePointList.size();
        int sum = 0;
        for (UserGradePoint userPoint : userGradePointList) {
            sum += userPoint.getPicPoint().intValue();
            sum += userPoint.getSoundPoint().intValue();
            sum += userPoint.getDutyPoint().intValue();
            sum += userPoint.getOperatePoint().intValue();
            sum += userPoint.getFeaturePoint().intValue();
        }
        double resultPoint = ((double)initCount * gamePoint.getInitTotalPoint() + (double)sum) / (double)(initCount + count * 5);
        resultPoint = (double)Math.round(resultPoint * 100.0) / 100.0;
        return resultPoint;
    }

    @CmdMapper(value={"/point/submitUserPoint.do"})
    public Object submitUserPoint(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        MainParam mainParam = this.getMainParamSafe(request, response, true);
        long userId = mainParam.getUserid();
        String gameId = request.getParameter("gameId", "");
        int picPoint = request.getParameterInteger("picPoint", -1);
        int soundPoint = request.getParameterInteger("soundPoint", -1);
        int dutyPoint = request.getParameterInteger("dutyPoint", -1);
        int operatePoint = request.getParameterInteger("operatePoint", -1);
        int featurePoint = request.getParameterInteger("featurePoint", -1);
        if (StringUtils.isEmpty(gameId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        if (!(this.checkPoint(picPoint) && this.checkPoint(soundPoint) && this.checkPoint(dutyPoint) && this.checkPoint(operatePoint) && this.checkPoint(featurePoint))) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            if (this.isUserHasGradeGame((int)userId, gameId)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7528\u6237\u5df2\u53c2\u4e0e\u8fc7\u8be5\u6e38\u620f\u8bc4\u5206");
            }
            UserGradePoint userGradePoint = new UserGradePoint();
            userGradePoint.setUserId((int)userId);
            userGradePoint.setGameId(gameId);
            userGradePoint.setPicPoint(picPoint);
            userGradePoint.setSoundPoint(soundPoint);
            userGradePoint.setDutyPoint(dutyPoint);
            userGradePoint.setOperatePoint(operatePoint);
            userGradePoint.setFeaturePoint(featurePoint);
            userGradePoint.setCreateTime(sdf_time.format(new Date()));
            FacadeFactory.INSTANCE.getBaseSo().addObject(userGradePoint);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(100, "\u7f51\u7edc\u9519\u8bef");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u63d0\u4ea4\u6210\u529f");
    }

    private boolean isUserHasGradeGame(int userId, String gameId) {
        UserGradePoint userGradePoint = FacadeFactory.INSTANCE.getUserGradePointBo().getUserGradePointByGameIdAndUserId(gameId, userId);
        return userGradePoint != null;
    }

    private boolean checkPoint(int point) {
        return point >= 0 && point <= 10;
    }
}

