/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.game;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.data.vipgame.bo.LinkInfoBo;
import com.xunlei.niux.data.vipgame.dto.game.GameDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.GameServers;
import com.xunlei.niux.data.vipgame.vo.Games;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.easyutils.commonutils.NumParseUtil;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class GameInfoCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(GameInfoCmd.class);
    private static Map<String, Object> gameTypeMap;

    private Map<String, LinkInfo> getCacheMobileGameDownloadInfoMap() {
        Map mobileGameDownloadInfoMap;
        String cacheKey = GameInfoCmd.class.getSimpleName() + "getMobileGameDownloadInfoMap";
        CacheManager cacheManager = CacheManager.GetInstance();
        Object obj = cacheManager.get(cacheKey);
        if (obj == null) {
            mobileGameDownloadInfoMap = this.getMobileGameDownloadInfoMap();
            if (MapUtils.isNotEmpty(mobileGameDownloadInfoMap)) {
                cacheManager.put(cacheKey, mobileGameDownloadInfoMap, 30L);
            }
        } else {
            mobileGameDownloadInfoMap = (Map)obj;
        }
        return mobileGameDownloadInfoMap;
    }

    private Map<String, LinkInfo> getMobileGameDownloadInfoMap() {
        LinkInfoBo linkInfoBo = FacadeFactory.INSTANCE.getLinkInfoBo();
        HashMap<String, LinkInfo> mobileGameDownloadInfoMap = new HashMap<String, LinkInfo>();
        List<LinkInfo> gameDownloadInfoList = linkInfoBo.getAllLinkListByLinkLocId("1601", false);
        if (CollectionUtils.isEmpty(gameDownloadInfoList)) {
            return mobileGameDownloadInfoMap;
        }
        for (LinkInfo linkInfo : gameDownloadInfoList) {
            mobileGameDownloadInfoMap.put(linkInfo.getGameidbytuijian(), linkInfo);
        }
        return mobileGameDownloadInfoMap;
    }

    @CmdMapper(value={"/game/getgameinfo.do"})
    public Object getGameServerInfo(XLHttpRequest request, XLHttpResponse response) {
        String gameId = request.getParameter("gameid", "000000");
        if (StringTools.isEmpty(gameId)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        int serverCount = 0;
        long onlineCount = 0L;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Page page = new Page();
        Games querygames = new Games();
        querygames.setGameId(gameId);
        List<Games> gamesList = FacadeFactory.INSTANCE.getGamesBo().findGames(querygames, page);
        if (gamesList == null || gamesList.size() == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u6ca1\u6709\u67e5\u5230\u8be5\u6e38\u620f\u4fe1\u606f");
        }
        Games games = gamesList.get(0);
        GameServers query = new GameServers();
        query.setGameId(gameId);
        query.setOpenStatus("1");
        List<GameServers> gsList = FacadeFactory.INSTANCE.getGameServersBo().find(query, page);
        if (gsList != null && gsList.size() > 0) {
            serverCount = gsList.size();
        }
        LinkInfo info = new LinkInfo();
        info.setLinklocid("664");
        info.setGameidbytuijian(gameId);
        List<LinkInfo> llist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info, page);
        if (llist != null && llist.size() > 0) {
            LinkInfo link = llist.get(0);
            onlineCount = Long.parseLong(link.getExt1() == null ? "0" : link.getExt1());
        }
        result.put("gameid", games.getGameId());
        result.put("gameNo", games.getGameNo());
        result.put("gameName", games.getGameName());
        result.put("officialWebSite", games.getOfficialWebSite());
        result.put("forumUrl", games.getForumUrl());
        String gameDesc = games.getGameDesc();
        result.put("gameDesc", gameDesc == null ? "" : (gameDesc.length() > 100 ? gameDesc.substring(0, 100) : gameDesc));
        result.put("gameName", games.getGameName());
        result.put("serverCount", serverCount);
        result.put("onlineCount", onlineCount);
        result.put("gameType", gameTypeMap.get(games.getGameType()));
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    @CmdMapper(value={"/game/getonlygameinfo.do"})
    public Object getGameInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String gameId = request.getParameter("gameId", "");
        String gameNo = request.getParameter("gameNo", "");
        if (gameId.length() == 0 && gameNo.length() == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(13, "\u53c2\u6570\u9519\u8bef", null);
        }
        Games query = new Games();
        query.setGameId(gameId);
        query.setGameNo(gameNo);
        Games game = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, "\u6210\u529f", game);
    }

    @CmdMapper(value={"/game/queryGamesByKeyWords.do"})
    public Object queryGamesByKeyWords(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.setInnerContentType(request, response);
            String keyWord = request.getParameter("keyword");
            String gameTypeStr = request.getParameter("gameType");
            if (StringUtils.isEmpty(keyWord)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            int gameType = 0;
            if (StringUtils.isNotEmpty(gameTypeStr)) {
                try {
                    gameType = Integer.parseInt(gameTypeStr);
                }
                catch (NumberFormatException e) {
                    logger.error("-2", (Object)"gameType\u7c7b\u578b\u9519\u8bef\uff01");
                }
            }
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
            List<GameDTO> gameList = FacadeFactory.INSTANCE.getGamesBo().queryGamesByKeyWord(keyWord, gameType);
            for (GameDTO game : gameList) {
                resultList.add(this.getShowGameMap(game, gameType));
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        catch (Exception e) {
            logger.error("queryGamesByKeyWords unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/game/queryGamesTipsByKeyWords.do"})
    public Object queryGamesTipsByKeyWords(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.setInnerContentType(request, response);
            String keyWord = request.getParameter("keyword");
            String gameTypeStr = request.getParameter("gameType");
            if (StringUtils.isEmpty(keyWord)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            int gameType = 0;
            if (StringUtils.isNotEmpty(gameTypeStr)) {
                try {
                    gameType = Integer.parseInt(gameTypeStr);
                }
                catch (NumberFormatException e) {
                    logger.error("-2", (Object)"gameType\u7c7b\u578b\u9519\u8bef\uff01");
                }
            }
            ArrayList resultList = new ArrayList();
            List<GameDTO> gameList = FacadeFactory.INSTANCE.getGamesBo().queryGamesByKeyWord(keyWord, gameType);
            for (GameDTO game : gameList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("gameName", game.getGameName());
                resultList.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        catch (Exception e) {
            logger.error("queryGamesTipsByKeyWords unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    private Map<String, Object> getShowGameMap(GameDTO game, int gameType) {
        String gameId = game.getGameId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("gameName", game.getGameName() == null ? "" : game.getGameName());
        map.put("pic", game.getPicUrl() == null ? "" : game.getPicUrl());
        map.put("smallpic", game.getSmallPicUrl() == null ? "" : game.getSmallPicUrl());
        map.put("gameOfficalUrl", game.getOfficialWebSite());
        map.put("gameId", gameId);
        map.put("gameNo", game.getGameNo());
        map.put("content", game.getGameDesc());
        if (gameType == 1) {
            map.put("mulPhotoUrl", game.getMulPhotoUrl());
            map.put("downLoadLink", game.getDownLoadUrl());
            if (!gameId.startsWith("c")) {
                LinkInfo linkInfo = this.getCacheMobileGameDownloadInfoMap().get(game.getGameId());
                if (linkInfo != null) {
                    map.put("downloadNum", NumParseUtil.getDownloadNumStr(linkInfo.getExt1()));
                } else {
                    map.put("downloadNum", "");
                }
            } else {
                map.put("downloadNum", NumParseUtil.getDownloadNumStr(String.valueOf(game.getDownloadNum())));
            }
        }
        return map;
    }

    @CmdMapper(value={"/game/queryGames.do"})
    public Object queryGames(XLHttpRequest request, XLHttpResponse response) {
        try {
            ArrayList resultList = new ArrayList();
            this.setInnerContentType(request, response);
            String keyWord = request.getParameter("keyword");
            if (StringTools.isEmpty(keyWord)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List<Games> gameList = FacadeFactory.INSTANCE.getGamesBo().queryGames(keyWord, 4);
            for (Games game : gameList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", game.getGameName() == null ? "" : game.getGameName());
                map.put("number", game.getGameNo());
                resultList.add(map);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        catch (Exception e) {
            logger.error("queryGames unknown Exception:", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(-100, "\u7f51\u7edc\u9519\u8bef");
        }
    }

    static {
        if (gameTypeMap == null) {
            gameTypeMap = new HashMap<String, Object>();
            gameTypeMap.put("1", "\u89d2\u8272\u626e\u6f14");
            gameTypeMap.put("2", "\u5199\u5b9e");
            gameTypeMap.put("3", "Q\u7248\u840c\u7cfb");
            gameTypeMap.put("4", "\u6218\u4e89\u7b56\u7565");
        }
    }
}

