/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.customer;

import com.ferret.common.dao.vo.Page;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.Ret;
import com.xunlei.niux.center.exception.NiuxException;
import com.xunlei.niux.center.thirdclient.SmsClient;
import com.xunlei.niux.center.thirdclient.ipinfoclient.IPInfoLookUpClient;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.center.util.Validator;
import com.xunlei.niux.center.util.VerifyCodeUtil;
import com.xunlei.niux.common.exception.NiuExceptionAndCode;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.util.StringTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
public class CustomerMobileCmd
extends DefaultCmd {
    private static String privateKey = "iwesdiosdflsdkl";

    @CmdMapper(value={"/customer/getphone.do"})
    public Object getPhone(XLHttpRequest request, XLHttpResponse response) {
        String remoteIp = request.getRemoteIP();
        this.setInnerContentType(request, response);
        try {
            MainParam param = this.checkMainParam(request, response, true);
            String userid = param.getUserid() + "";
            CustomerInfo info = new CustomerInfo();
            info.setUid(userid);
            IPInfoLookUpClient ininfolookupclient = new IPInfoLookUpClient();
            boolean isMainLandIp = ininfolookupclient.isIPChinaMainland(remoteIp);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("isrequired", isMainLandIp ? "1" : "0");
            List<CustomerInfo> infolist = FacadeFactory.INSTANCE.getCustomerInfoBo().find(info, new Page());
            if (infolist == null || infolist.size() == 0) {
                result.put("msg", "\u8be5\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            CustomerInfo customer = infolist.get(0);
            if (customer == null) {
                result.put("msg", "\u8be5\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            if (StringTools.isEmpty(customer.getPhone())) {
                result.put("msg", "\u8be5\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u624b\u673a\u53f7");
                return JsonObjectUtil.getRtnAndDataJsonObject(1, result);
            }
            result.put("tel", customer.getPhone());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/customer/phone.do"})
    public Object phone(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String phone = request.getParameter("phone");
        String code = request.getParameter("code");
        String typestr = request.getParameter("type");
        try {
            MainParam param = this.checkMainParam(request, response, true);
            String userid = param.getUserid() + "";
            if (StringTools.isEmpty(typestr) || StringTools.isEmpty(phone) || StringTools.isEmpty(code)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            if ("1".equals(typestr)) {
                SmsClient.checkIdentifyingCode(phone, code);
                Long timestamp = System.currentTimeMillis() / 1000L;
                String sign = SignUtil.sign(userid + timestamp, privateKey);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("key", sign);
                result.put("timestamp", timestamp);
                CustomerInfo info = new CustomerInfo();
                info.setUid(userid);
                List<CustomerInfo> infolist = FacadeFactory.INSTANCE.getCustomerInfoBo().find(info, new Page());
                if (infolist == null || infolist.size() == 0) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u8be5\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u8fc7\u624b\u673a\u53f7");
                }
                CustomerInfo customer = infolist.get(0);
                FacadeFactory.INSTANCE.getCustomerInfoBo().update(customer);
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            if ("2".equals(typestr)) {
                SmsClient.checkIdentifyingCode(phone, code);
                CustomerInfo info = new CustomerInfo();
                info.setUid(userid);
                List<CustomerInfo> infolist = FacadeFactory.INSTANCE.getCustomerInfoBo().find(info, new Page());
                if (infolist == null || infolist.size() == 0) {
                    info.setPhone(phone);
                    FacadeFactory.INSTANCE.getCustomerInfoBo().insert(info);
                    return JsonObjectUtil.getOnlyOkJson();
                }
                CustomerInfo customer = infolist.get(0);
                if (StringTools.isEmpty(customer.getPhone())) {
                    customer.setPhone(phone);
                    FacadeFactory.INSTANCE.getCustomerInfoBo().update(customer);
                    return JsonObjectUtil.getOnlyOkJson();
                }
                customer.setOldphone(customer.getPhone());
                String key = request.getParameter("key");
                String time = request.getParameter("timestamp");
                if (StringTools.isEmpty(key) || StringTools.isEmpty(time)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
                }
                Long timestmp = Long.parseLong(time);
                Long nowtime = System.currentTimeMillis() / 1000L;
                if (nowtime - timestmp > 1800L) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u8be5\u8bf7\u6c42\u5df2\u8fc7\u671f");
                }
                String sign = SignUtil.sign(userid + time, privateKey);
                if (!key.trim().equals(sign)) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u6570\u5b57\u7b7e\u540d\u9519\u8bef");
                }
                customer.setPhone(phone);
                FacadeFactory.INSTANCE.getCustomerInfoBo().update(customer);
                return JsonObjectUtil.getOnlyOkJson();
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        catch (NumberFormatException e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        catch (NiuxException e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/sendCode.do"})
    public Object sendPhoneCode(XLHttpRequest request, XLHttpResponse response) {
        try {
            this.checkMainParam(request, response, true);
            String phone = request.getParameter("phone", "");
            if (StringTools.isEmpty(phone)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u624b\u673a\u53f7\u4e0d\u6b63\u786e");
            }
            if (phone.length() != 11) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u624b\u673a\u53f7\u4e0d\u6b63\u786e");
            }
            SmsClient.sendIdentifyingCode(phone, "\u8fc5\u96f7\u725bX\u9875\u6e38\u5e73\u53f0\u9a8c\u8bc1\u7801\uff1a{}");
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25");
        }
    }

    private boolean checkPhone(String phone) {
        Pattern p = Pattern.compile("^((13[0-9])|(17[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$");
        Matcher m = p.matcher(phone);
        return m.matches();
    }

    @CmdMapper(value={"/customer/getMobile.do"})
    public Object getMobile(XLHttpRequest request, XLHttpResponse response) {
        String uid;
        this.setInnerContentType(request, response);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            uid = this.getUserId(request, response);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        CustomerInfo customerInfo = this.getCustomerInfo(uid);
        if (customerInfo == null || customerInfo.getPhone() == null || "".equals(customerInfo.getPhone())) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getResultMap("01", "\u672a\u7ed1\u5b9a"));
        }
        map.put("code", "00");
        map.put("mobile", customerInfo.getPhone());
        map.put("mobileChecked", customerInfo.getCheckPhone());
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    private boolean isServerCall(XLHttpRequest request) {
        String sign = request.getParameter("sign", "");
        return !"".equals(sign);
    }

    private String getUserId(XLHttpRequest request, XLHttpResponse response) throws NiuExceptionAndCode {
        boolean isServer = this.isServerCall(request);
        if (isServer) {
            String userId;
            String newSign;
            String sign = request.getParameter("sign", "");
            if (sign.equals(newSign = SignUtil.sign(userId = request.getParameter("userId"), privateKey))) {
                return userId;
            }
            throw new NiuExceptionAndCode("13", "\u7b7e\u540d\u4e0d\u4e00\u81f4");
        }
        MainParam mainParam = this.checkMainParam(request, response, true);
        return String.valueOf(mainParam.getUserid());
    }

    private void setInnerContentType1(XLHttpRequest request, XLHttpResponse response) {
        boolean isServer = this.isServerCall(request);
        if (isServer) {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
        }
    }

    public CustomerInfo getCustomerInfo(String uid) {
        CustomerInfo queryci = new CustomerInfo();
        queryci.setUid(uid);
        List<CustomerInfo> cilist = FacadeFactory.INSTANCE.getCustomerInfoBo().find(queryci, new Page());
        return cilist == null || cilist.size() == 0 ? null : cilist.get(0);
    }

    @CmdMapper(value={"/customer/sendIdentityCode.do"})
    public Object sendMobileIdentifyCode(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType1(request, response);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            this.getUserId(request, response);
            boolean isServer = this.isServerCall(request);
            String mobile = request.getParameter("mobile", "");
            this.checkNotEmpty(mobile, "13", "\u624b\u673a\u53f7\u4e3a\u7a7a");
            if (Validator.isNotMobileNO(mobile)) {
                throw new NiuExceptionAndCode("13", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (!isServer) {
                String verify = request.getParameter("verify");
                this.checkNotEmpty(verify, "13", "\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
                String verifyKey = request.getCookieValue("VERIFY_KEY");
                this.checkNotEmpty(verifyKey, "13", "\u9a8c\u8bc1\u7801\u5bc6\u94a5\u4e3a\u7a7a");
                if (!VerifyCodeUtil.isVerify(verifyKey, "MMA", verify)) {
                    throw new NiuExceptionAndCode("13", "\u60a8\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165~");
                }
            }
            SmsClient.sendIdentifyingCode(mobile, "\u8fc5\u96f7\u725bX\u9875\u6e38\u5e73\u53f0\u9a8c\u8bc1\u7801\uff1a{}");
            map.put("code", "00");
            map.put("msg", "\u6210\u529f");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    @CmdMapper(value={"/customer/checkOldMobileIdentifyCode.do"})
    public Object checkOldMobileIdentifyCode(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        try {
            String userId = this.getUserId(request, response);
            CustomerInfo customerInfo = this.getCustomerInfo(userId);
            if (customerInfo == null || customerInfo.getPhone() == null || "".equals(customerInfo.getPhone())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("01", "\u7528\u6237\u6ca1\u6709\u7ed1\u5b9a\u8fc7\u624b\u673a\u53f7"));
            }
            String mobile = request.getParameter("mobile", "");
            if (mobile.equals(customerInfo.getPhone())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("01", "\u624b\u673a\u53f7\u7801\u4e0d\u4e00\u81f4"));
            }
            String identityCode = request.getParameter("identityCode", "");
            this.checkNotEmpty(identityCode, "13", "\u624b\u673a\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
            SmsClient.checkIdentifyingCode(mobile, identityCode);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "00");
            map.put("mobilepasskey", SignUtil.sign(userId + mobile, privateKey));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", "99");
            map.put("msg", "\u9a8c\u8bc1\u5931\u8d25");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
    }

    @CmdMapper(value={"/customer/checkMobileIdentifyCodeAndBind.do"})
    public Object checkMobileIdentifyCodeAndBind(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String userId = this.getUserId(request, response);
            String mobile = request.getParameter("mobile", "");
            this.checkNotEmpty(mobile, "13", "\u624b\u673a\u53f7\u4e3a\u7a7a");
            if (Validator.isNotMobileNO(mobile)) {
                throw new NiuExceptionAndCode("13", "\u60a8\u8f93\u5165\u7684\u624b\u673a\u53f7\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            String identityCode = request.getParameter("identityCode", "");
            this.checkNotEmpty(identityCode, "13", "\u624b\u673a\u9a8c\u8bc1\u7801\u4e3a\u7a7a");
            SmsClient.checkIdentifyingCode(mobile, identityCode);
            CustomerInfo customerInfo = this.getCustomerInfo(userId);
            if (customerInfo == null) {
                customerInfo = new CustomerInfo();
                customerInfo.setUid(userId);
                customerInfo.setPhone(mobile);
                customerInfo.setCheckPhone(true);
                customerInfo.setCheckFlag(false);
                FacadeFactory.INSTANCE.getCustomerInfoBo().insert(customerInfo);
            } else if (customerInfo.getPhone() == null || "".equals(customerInfo.getPhone())) {
                customerInfo.setPhone(mobile);
                customerInfo.setCheckPhone(true);
                FacadeFactory.INSTANCE.getCustomerInfoBo().update(customerInfo);
            } else {
                String mobilepasskeysign;
                String mobilepasskey = request.getParameter("mobilepasskey", "");
                if (!mobilepasskey.equals(mobilepasskeysign = SignUtil.sign(userId + customerInfo.getPhone(), privateKey))) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(0, new Ret("01", "\u65e7\u624b\u673a\u53f7\u7801\u6ca1\u6709\u901a\u8fc7\u9a8c\u8bc1"));
                }
                customerInfo.setPhone(mobile);
                customerInfo.setCheckPhone(true);
                FacadeFactory.INSTANCE.getCustomerInfoBo().update(customerInfo);
            }
            map.put("code", "00");
            map.put("msg", "\u6210\u529f");
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuExceptionAndCode e) {
            map.put("code", e.code);
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (NiuRuntimeException e) {
            map.put("code", e.code);
            String msg = e.getMessage();
            map.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
        }
        catch (Exception e) {
            map.put("code", "99");
            map.put("msg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(1, map);
        }
    }

    public Map<String, String> getResultMap(String code, String msg) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("msg", msg);
        return map;
    }

    private MainParam checkMainParam(XLHttpRequest request, XLHttpResponse response, boolean isSeccode) throws NiuExceptionAndCode {
        MainParam mainParam = null;
        try {
            mainParam = this.getMainParam(request, response, isSeccode);
        }
        catch (Exception e) {
            throw new NiuExceptionAndCode("99", "\u767b\u5f55\u5931\u6548");
        }
        if (mainParam == null) {
            throw new NiuExceptionAndCode("99", "\u767b\u5f55\u5931\u6548");
        }
        return mainParam;
    }

    private void checkNotEmpty(String value, String errrorCode, String errorMsg) throws NiuExceptionAndCode {
        if (value == null || "".equals(value)) {
            throw new NiuExceptionAndCode(errrorCode, errorMsg);
        }
    }
}

