/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.customer;

import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.RetData;
import com.xunlei.niux.data.vipgame.bo.BaseSo;
import com.xunlei.niux.data.vipgame.bo.CustomerInfoBo;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BlackIp;
import com.xunlei.niux.data.vipgame.vo.CustomerDetailQuery;
import com.xunlei.niux.data.vipgame.vo.CustomerInfo;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerInfoCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(CustomerInfoCmd.class);
    private static Integer attrackCount = EnvPropertyUtil.loadIntProperty("niux", "attrackCount");
    private static String validIps = EnvPropertyUtil.loadProperty("niux", "validips");
    private static String PAYURL = "http://paysvr.niu.xunlei.com:8090/gamepaycenter/recharge?action=querygiftordernum&giftflag=1";
    private static String VIPGRADEULR = "http://paysvr.niu.xunlei.com:8090/gamepaycenter/recharge?action=newqueryvipuser&username=";

    private boolean checkVip(XLHttpRequest request) {
        if (StringTools.isEmpty(validIps)) {
            return true;
        }
        String[] vips = validIps.split(",");
        String ip = request.getRemoteIP();
        boolean flag = false;
        for (String vip : vips) {
            if (!ip.equals(vip.trim())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @CmdMapper(value={"/customer/getCustomerContant.do"})
    public Object getCustomerContant(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String uid = request.getParameter("uid");
        String type = request.getParameter("type");
        if (!this.checkVip(request)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "ip\u9650\u5236");
        }
        if (StringTools.isEmpty(uid)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        try {
            long userid = Long.parseLong(uid);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        CustomerDetailQuery query = new CustomerDetailQuery();
        query.setUid(uid);
        CustomerDetailQuery cdq = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
        if (cdq != null) {
            if (StringTools.isEmpty(type)) {
                result.put("phone", StringTools.isEmpty(cdq.getPhone()) ? cdq.getContactNumber() : cdq.getPhone());
                result.put("qq", cdq.getQq());
                result.put("email", cdq.getEmail());
            } else {
                result.put("vipGrade", cdq.getLiveVipGrade());
                result.put("lastCaller", cdq.getLastCaller());
                result.put("lastCallTime", cdq.getLastCallTime());
                result.put("customerService", cdq.getCustomerService());
            }
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    @CmdMapper(value={"/customer/getcustomerphone.do"})
    public Object getcustomerphone(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String uid = request.getParameter("uid");
        if (StringTools.isEmpty(uid)) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
        }
        BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
        CustomerDetailQuery cdquery = new CustomerDetailQuery();
        cdquery.setUid(uid);
        CustomerDetailQuery cdq = baseSo.findObject(cdquery);
        HashMap<String, String> result = new HashMap<String, String>();
        if (cdq == null) {
            CustomerInfo infoquery = new CustomerInfo();
            infoquery.setUid(uid);
            CustomerInfo info = baseSo.findObject(infoquery);
            if (info == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u9700\u8981\u7ed1\u5b9a");
            }
            if (StringTools.isEmpty(info.getPhone())) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u9700\u8981\u7ed1\u5b9a");
            }
            result.put("phone", info.getPhone());
            result.put("email", info.getEmail());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        result.put("email", cdq.getEmail());
        if (StringTools.isEmpty(cdq.getPhone())) {
            CustomerInfo infoquery = new CustomerInfo();
            infoquery.setUid(uid);
            CustomerInfo info = baseSo.findObject(infoquery);
            if (info == null) {
                result.put("phone", "");
            } else {
                result.put("phone", info.getPhone());
            }
        } else {
            result.put("phone", cdq.getPhone());
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    @CmdMapper(value={"/customer/updatecustomer.do"})
    public Object updatecustomer(XLHttpRequest request, XLHttpResponse response) {
        try {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String uid = request.getParameter("uid");
            String username = request.getParameter("username");
            String phone = request.getParameter("phone");
            String qq = request.getParameter("qq");
            String birthday = request.getParameter("birthday");
            String address = request.getParameter("address");
            boolean flag = this.checkVip(request);
            if (!flag) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "ip\u9650\u5236");
            }
            if (StringTools.isEmpty(uid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            if (StringTools.isEmpty(username) && StringTools.isEmpty(phone) && StringTools.isEmpty(qq) && StringTools.isEmpty(birthday) && StringTools.isEmpty(address)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            if (!StringTools.isEmpty(address)) {
                try {
                    username = URLDecoder.decode(username.replaceAll("%", "%25"), "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.info("updatecustomer.do  uid=" + uid + ",username=" + username + ",reason=" + e.getMessage());
                    return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
                }
            }
            if (!StringTools.isEmpty(address)) {
                try {
                    address = URLDecoder.decode(address.replaceAll("%", "%25"), "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    logger.info("updatecustomer.do  uid=" + uid + ",address=" + address + ",reason=" + e.getMessage());
                    return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
                }
            }
            CustomerInfo info = new CustomerInfo();
            info.setUid(uid);
            CustomerInfoBo customerInfoBo = FacadeFactory.INSTANCE.getCustomerInfoBo();
            List<CustomerInfo> infolist = customerInfoBo.find(info, new Page());
            if (CollectionUtils.isEmpty(infolist)) {
                info = new CustomerInfo();
                info.setUid(uid);
                info.setAddress(address);
                info.setPhone(phone);
                info.setBirthday(birthday);
                info.setQq(qq);
                info.setUsername(username);
                customerInfoBo.insert(info);
            } else {
                info = infolist.get(0);
                info.setAddress(address);
                info.setPhone(phone);
                info.setBirthday(birthday);
                info.setQq(qq);
                info.setUsername(username);
                customerInfoBo.update(info);
            }
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u7f51\u7edc\u5f02\u5e38");
        }
        return JsonObjectUtil.getOnlyOkJson();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CmdMapper(value={"/customer/updatecustomerinfo.do"})
    public Object updatecustomerinfo(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowtime = sdf.format(new Date());
        String account = request.getParameter("username");
        String qq = request.getParameter("qq");
        String phone = request.getParameter("phone");
        String checkFlag = request.getParameter("checkFlag");
        try {
            BlackIp blackip;
            int cf;
            boolean flag = false;
            if (checkFlag != null && !"".equals(checkFlag) && (cf = Integer.parseInt(checkFlag)) == 1) {
                flag = true;
            }
            if (account == null || "".equals(account)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(7, "\u53c2\u6570\u9519\u8bef\uff01");
            }
            String ip = request.getRemoteIP();
            logger.info("remoteip===============>" + ip);
            BlackIp bi = new BlackIp();
            bi.setIp(ip);
            List<BlackIp> bilist = FacadeFactory.INSTANCE.getBlackIpBo().findBlackIp(bi, new Page());
            if (bilist != null && bilist.size() > 0 && (blackip = bilist.get(0)).getFlag().booleanValue()) {
                logger.info("update customer info failure. the ip is bad.account=" + account + ",ip=" + ip);
                return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u7531\u4e8e\u60a8\u7684\u5f02\u5e38\u64cd\u4f5c\uff0c\u60a8\u7684IP\u5df2\u7ecf\u88ab\u7981\u6b62\u8c03\u7528\u672c\u63a5\u53e3\uff0c\u8c22\u8c22\u5408\u4f5c\uff01");
            }
            if (!this.checkVipGrade(account)) {
                if (bilist == null || bilist.size() == 0) {
                    bi.setCount(1);
                    bi.setFirstTime(nowtime);
                    bi.setLastTime(nowtime);
                    bi.setFlag(false);
                    bi.setType(1);
                    FacadeFactory.INSTANCE.getBlackIpBo().insert(bi);
                    return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8bf7\u505c\u6b62\u975e\u6cd5\u8c03\u7528\uff0c\u8c22\u8c22\u5408\u4f5c\uff01");
                } else {
                    bi = bilist.get(0);
                    bi.setLastTime(nowtime);
                    bi.setFlag(false);
                    if (bi.getCount() == attrackCount - 1) {
                        bi.setFlag(true);
                    }
                    bi.setCount(bi.getCount() + 1);
                    FacadeFactory.INSTANCE.getBlackIpBo().update(bi);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u8bf7\u505c\u6b62\u975e\u6cd5\u8c03\u7528\uff0c\u8c22\u8c22\u5408\u4f5c\uff01");
            }
            CustomerInfoBo customerInfoBo = FacadeFactory.INSTANCE.getCustomerInfoBo();
            CustomerInfo info = new CustomerInfo();
            info.setAccount(account);
            List<CustomerInfo> cinfolist = customerInfoBo.find(info, new Page());
            if (cinfolist == null || cinfolist.size() == 0) {
                if (qq == null || "".equals(qq)) return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u60a8\u9700\u8981\u7ed1\u5b9aQQ\u53f7\uff01");
                info.setQq(qq);
                info.setPhone(phone);
                info.setCheckFlag(flag);
                info.setInputtime(nowtime);
                customerInfoBo.insert(info);
            } else {
                CustomerInfo cinfo = cinfolist.get(0);
                if (qq != null && !"".equals(qq)) {
                    if (cinfo.getQq() != null && !"".equals(cinfo.getQq())) {
                        return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u60a8\u7684QQ\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u4e86\uff01");
                    }
                } else {
                    if (cinfo.getQq() == null || "".equals(cinfo.getQq())) return JsonObjectUtil.getRtnAndDataJsonObject(6, "\u60a8\u9700\u8981\u7ed1\u5b9aQQ\u53f7\uff01");
                    return JsonObjectUtil.getRtnAndDataJsonObject(5, "\u60a8\u7684QQ\u5df2\u7ecf\u7ed1\u5b9a\u8fc7\u4e86\uff01");
                }
                cinfo.setQq(qq);
                if (phone != null && !"".equals(phone)) {
                    cinfo.setPhone(phone);
                }
                customerInfoBo.update(cinfo);
            }
            logger.info("update customer info success,account=" + account + ",qq=" + qq + ",phone=" + phone + ",flag=" + flag + ",time=" + nowtime);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            logger.info("\u66f4\u65b0\u5ba2\u6237\u4fe1\u606f\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            logger.info("update customer info failure,account=" + account + ",qq=" + qq + ",phone=" + phone + ",checkFlag=" + checkFlag + ",time=" + nowtime);
            RetData data = new RetData();
            data.setErrmsg("\u5185\u90e8\u9519\u8bef");
            JsonObjectUtil.getRtnAndDataJsonObject(2, data);
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    private boolean checkVipGrade(String account) {
        String[] strs;
        StringBuffer sb = new StringBuffer();
        sb.append(VIPGRADEULR).append(account.trim());
        String jsonStr = CustomerInfoCmd.getInfoForHttpGetMothed(sb.toString());
        jsonStr = jsonStr.replace("{", "").replace("}", "");
        for (String str : strs = jsonStr.split(",")) {
            String vip;
            int vipGrade;
            String[] substrs;
            if (str.indexOf("code") > -1 && !"0".equals((substrs = str.split(":"))[1])) {
                return false;
            }
            if (str.indexOf("vip") <= -1 || str.indexOf("vipfate") != -1 || (vipGrade = Integer.parseInt(vip = (substrs = str.split(":"))[1].replaceAll("\"", ""))) < 3) continue;
            return true;
        }
        return false;
    }

    private boolean checkPay(String account, String nowtime) {
        String time1 = nowtime.split(" ")[1];
        String time2 = "01:00:00";
        String begintime = null;
        String endtime = nowtime.split(" ")[0];
        begintime = CustomerInfoCmd.compareTime(endtime + " " + time1, endtime + " " + time2, "yyyy-MM-dd HH:mm:ss") >= 0L ? CustomerInfoCmd.yesterday() : CustomerInfoCmd.before();
        StringBuffer sb = new StringBuffer();
        sb.append(PAYURL).append("&username=").append(account).append("&begintime=").append(begintime).append("&endtime=").append(endtime);
        logger.info("check pay url==============>" + sb);
        String jsonStr = CustomerInfoCmd.getInfoForHttpGetMothed(sb.toString());
        logger.info("jsonStr====================>" + jsonStr);
        jsonStr = jsonStr.replace("var defaultRtnName = ", "").replace("{", "").replace("}", "").replaceAll("'", "");
        String[] str = jsonStr.split(",");
        String[] substr = str[0].split(":");
        if (Integer.parseInt(substr[1]) != 0) {
            return false;
        }
        String[] amountstr = str[1].split(":");
        long amount = Long.parseLong(amountstr[1]);
        return amount >= 1L;
    }

    public static long compareTime(String fromtime, String totime, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        Date one = null;
        Date two = null;
        long days = 0L;
        try {
            one = df.parse(fromtime);
            two = df.parse(totime);
            long time1 = one.getTime();
            long time2 = two.getTime();
            long diff = time1 - time2;
            days = diff / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static String yesterday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(cal.getTime());
        return time;
    }

    public static String before() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -2);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = sdf.format(cal.getTime());
        return time;
    }

    public static String getInfoForHttpGetMothed(String url) {
        try {
            HttpGet httpget = new HttpGet(url);
            DefaultHttpClient client = new DefaultHttpClient();
            String backStr = "";
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            backStr = client.execute((HttpUriRequest)httpget, responseHandler);
            return backStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

