/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.code;

import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.util.QRCodeUtil;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.net.URLEncoder;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class CodeCmd
extends DefaultCmd {
    private static final String boxPayUrl = EnvPropertyUtil.loadProperty("niux", "boxPayUrl");
    private static Logger logger = Log.getLogger(CodeCmd.class);

    @CmdMapper(value={"/code/make.do"})
    public Object make(XLHttpRequest request, XLHttpResponse response) {
        try {
            String gameId = request.getParameter("gameId");
            String serverId = request.getParameter("serverId");
            String userName = request.getParameter("userName");
            String serverName = request.getParameter("serverName");
            String advNo = request.getParameter("advNo");
            String fenQuNum = request.getParameter("fenQuNum", "");
            if (StringTools.isEmpty(gameId) || StringTools.isEmpty(serverId) || StringTools.isEmpty(userName) || StringTools.isEmpty(serverName) || StringTools.isEmpty(advNo)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u4e3a\u7a7a");
            }
            StringBuffer buffer = new StringBuffer(boxPayUrl).append("gameId=").append(gameId).append("&serverId=").append(serverId).append("&userName=").append(URLEncoder.encode(userName, "utf8")).append("&serverName=").append(URLEncoder.encode(serverName, "utf8")).append("&advNo=").append(advNo).append("&fenQuNum=").append(fenQuNum);
            logger.info("code/make.do url:" + buffer);
            ChannelBuffer cb = QRCodeUtil.getImageBytes(buffer.toString(), "png");
            response.setContent(cb);
            response.addHeader("Content-Type", "image/png");
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38");
        }
    }
}

