/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.boxThree;

import com.ferret.common.dao.vo.Page;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.json.JSONUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.exception.NiuxException;
import com.xunlei.niux.center.proxy.JRedisProxy;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.Utility;
import com.xunlei.niux.client.jinzuan.CommonActivityClient;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.dto.ProductDTO;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.AutoCount;
import com.xunlei.niux.data.vipgame.vo.AutoProduct;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusExchange;
import com.xunlei.niux.data.vipgame.vo.boxThree.BoxBonusProductCharge;
import com.xunlei.niux.data.vipgame.vo.boxThree.BoxBonusProductChargeRecord;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class BoxBonusProductCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(BoxBonusProductCmd.class);
    private static final String ACTNO = "jifenmarket";
    private static final String EXCEPTION_CODE = "java.lang.RuntimeException:";
    private static final String EXCEPTION_CODE2 = "com.xunlei.niux.common.exception.NiuExceptionAndCode:";

    @CmdMapper(value={"/boxproduct/exchange.do"})
    public Object exchange(XLHttpRequest request, XLHttpResponse response) {
        String giftId = request.getParameter("giftId", "");
        String ip = request.getRemoteIP();
        long userId = 0L;
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            userId = mainParam.getUserid();
            if (StringTools.isEmpty(giftId)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef");
            }
            BoxBonusProductCharge query = new BoxBonusProductCharge();
            query.setProductId(giftId);
            BoxBonusProductCharge bpc = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (bpc == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u8be5\u5546\u54c1\u4e0d\u5b58\u5728");
            }
            long bonus = bpc.getBonus();
            bpc.setBonus(bonus);
            long leftBonus = this.getLeftBonus(userId + "");
            if (leftBonus < bonus) {
                return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u53ef\u7528\u76d2\u5b50\u79ef\u5206\u4e0d\u8db3");
            }
            this.exchange(bpc, userId, ip);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (NiuRuntimeException e) {
            logger.info("boxproduct.exchange.do NiuRuntimeException giftId=" + giftId + ",userId=" + userId + ",ip=" + ip + ",code=" + e.code + ",reason=" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(Integer.parseInt(e.code), this.getMessage(e.getMessage()));
        }
        catch (RuntimeException e) {
            logger.info("boxproduct.exchange.do NiuRuntimeException giftId=" + giftId + ",userId=" + userId + ",ip=" + ip + ",reason=" + e.getMessage(), e);
            return this.getMessage(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("boxproduct.exchange.do Exception giftId=" + giftId + ",userId=" + userId + ",ip=" + ip + ",reason=" + e.getMessage(), e);
            return JsonObjectUtil.getRtnAndDataJsonObject(4, "\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    private String getMessage(String msg) {
        if (StringTools.isNotEmpty(msg)) {
            return msg.replace(EXCEPTION_CODE, "").replace(EXCEPTION_CODE2, "");
        }
        return msg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean exchange(BoxBonusProductCharge bpc, long userId, String ip) {
        boolean flag;
        BonusClient.checkBonusEnough(userId + "", bpc.getBonus().intValue());
        String dayTime = DateUtil.getCurDateStr();
        String orderId = Utility.createApplyId();
        String code = BonusClient.consume(userId + "", "", bpc.getBonus().intValue(), orderId, dayTime, ACTNO, "");
        boolean bl = flag = "00".equals(code);
        if (!flag) throw new NiuRuntimeException("1005", "\u76d2\u5b50\u79ef\u5206\u6263\u9664\u5931\u8d25");
        BoxBonusProductChargeRecord record = null;
        try {
            record = FacadeFactory.INSTANCE.getBonusExchangeBo().insert(bpc, userId, ip);
        }
        catch (Exception e) {
            logger.error("BonusExchangeBo.insert Exception", e);
            BonusClient.returnconsume(userId + "", bpc.getBonus().intValue(), orderId, dayTime, ACTNO, "");
            this.saveRecord(record, 4);
            throw new NiuRuntimeException("1007", e.getMessage());
        }
        String msg = this.releaseGift(ACTNO, userId, bpc.getProductId(), ip);
        if (msg == null) {
            record = this.saveRecord(record, 3);
            return flag;
        } else {
            msg = this.releaseGift(ACTNO, userId, bpc.getProductId(), ip);
            if (msg == null) {
                this.saveRecord(record, 3);
                return flag;
            } else {
                BonusClient.returnconsume(userId + "", bpc.getBonus().intValue(), orderId, dayTime, ACTNO, "");
                this.saveRecord(record, 4);
                FacadeFactory.INSTANCE.getBonusExchangeBo().update(bpc, false);
                throw new NiuRuntimeException("1006", msg);
            }
        }
    }

    private BoxBonusProductChargeRecord saveRecord(BoxBonusProductChargeRecord record, int chargeType) {
        if (record == null) {
            return record;
        }
        BoxBonusProductChargeRecord bpcr = FacadeFactory.INSTANCE.getBaseSo().findObject(record);
        bpcr.setChargeFlag(chargeType);
        FacadeFactory.INSTANCE.getBaseSo().updateObjectById(bpcr);
        return bpcr;
    }

    public String releaseGift(String actNo, long userId, String giftId, String remoteIp) {
        try {
            String result = CommonActivityClient.getGift(actNo, null, String.valueOf(userId), giftId, remoteIp, false);
            logger.info("CommonActivityClient.getGift \u7684\u7ed3\u679c\u4e3a\uff1a" + result);
            JsonObject jsonObject = new JsonParser().parse(result).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            if (code == 0) {
                return null;
            }
            return jsonObject.get("data").getAsString();
        }
        catch (Exception e) {
            return "\u6570\u636e\u5f02\u5e38";
        }
    }

    private long getLeftBonus(String userId) {
        BonusClient.UserBonus userBonus = BonusClient.queryBonus(userId);
        if (userBonus == null) {
            return 0L;
        }
        return userBonus.getBonusNum().intValue();
    }

    @CmdMapper(value={"/boxproduct/giftRank.do"})
    public Object giftRank(XLHttpRequest request, XLHttpResponse response) {
        try {
            String json = JRedisProxy.getInstance().get("productGiftRank");
            if (StringTools.isEmpty(json)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getRankList());
            }
            System.out.println(json);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getList(json, 1));
        }
        catch (Exception e) {
            logger.error("giftRank.do error", e);
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u6392\u884c\u699c\u67e5\u8be2\u5931\u8d25");
        }
    }

    private List<Map<String, Object>> getGiftJson() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftid", "1472");
        map.put("giftName", "\u5927\u5929\u4f7f-\u795e\u5947\u5927\u793c\u5305");
        map.put("giftImgUrl", "http://i2.webgame.kanimg.com/20150205/1423141240465.jpg");
        map.put("bonus", 200);
        map.put("isJinZuan", 1);
        map.put("userId", 243385350);
        map.put("userName", "12ww");
        data.add(map);
        return data;
    }

    @CmdMapper(value={"/boxproduct/getChargeList.do"})
    public Object getChargeList(XLHttpRequest request, XLHttpResponse response) {
        try {
            String json = JRedisProxy.getInstance().get("productChargeList");
            if (StringTools.isEmpty(json)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getGiftJson());
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, this.getList(json, 2));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("giftRank.do error", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5151\u6362\u52a8\u6001\u67e5\u8be2\u5931\u8d25");
        }
    }

    private List<Map<String, Object>> getList(String json, int type) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        JsonArray array = new JsonParser().parse(json).getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement e = array.get(i);
            JsonObject obj = e.getAsJsonObject();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("giftid", obj.get("giftid").getAsString());
            map.put("giftName", obj.get("giftName").getAsString());
            map.put("giftImgUrl", obj.get("giftImgUrl").getAsString());
            map.put("bonus", obj.get("bonus").getAsLong());
            if (type != 1) {
                map.put("isJinZuan", obj.get("isJinZuan").getAsInt());
                map.put("userId", obj.get("userId").getAsString());
                map.put("userName", obj.get("userName").getAsString());
            }
            list.add(map);
        }
        return list;
    }

    private List<Map<String, Object>> getRankList() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftid", "1472");
        map.put("giftName", "\u5927\u5929\u4f7f-\u795e\u5947\u5927\u793c\u5305");
        map.put("giftImgUrl", "http://i2.webgame.kanimg.com/20150205/1423141240465.jpg");
        map.put("bonus", 200);
        data.add(map);
        return data;
    }

    @CmdMapper(value={"/boxproduct/giftList.do"})
    public Object giftList(XLHttpRequest request, XLHttpResponse response) {
        return "";
    }

    @CmdMapper(value={"/boxproduct/getproductforintegral.do"})
    public Object getProductForIntegral(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u83b7\u5f97\u5f53\u524d\u7528\u6237\u76d2\u5b50\u79ef\u5206\u53ef\u5151\u6362\u7684\u5546\u54c1");
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String integralstr = request.getParameter("integral");
            int isvip = request.getParameterInteger("isvip");
            long integral = 0L;
            if (integralstr == null || "".equals(integralstr)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef", null);
            }
            integral = Long.parseLong(integralstr);
            Object sql = null;
            if (isvip != 0 && isvip != 1) {
                return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u53c2\u6570\u9519\u8bef", null);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(1, null);
        }
        catch (Exception e) {
            logger.info("\u83b7\u5f97\u5f53\u524d\u7528\u6237\u76d2\u5b50\u79ef\u5206\u53ef\u5151\u6362\u7684\u5546\u54c1\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38", null);
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u7f51\u7edc\u5f02\u5e38", null);
        }
    }

    @CmdMapper(value={"/boxproduct/gettimerproduct.do"})
    public Object getTimerProduct(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u83b7\u5f97\u5956\u54c1\u5269\u4f59\u6570\u91cf\u548c\u5b9a\u65f6\u53d1\u653e\u60c5\u51b5");
        try {
            String pids = request.getParameter("pids");
            HashMap<String, Object> result = new HashMap<String, Object>();
            HashMap boxproduct = new HashMap();
            String nowtime = BoxBonusProductCmd.now();
            if (pids != null && !"".equals(pids)) {
                String myids = "";
                if (pids.indexOf("_") > -1) {
                    String[] ids;
                    for (String id : ids = pids.split("_")) {
                        myids = myids + id + ",";
                    }
                    myids = myids.substring(0, myids.lastIndexOf(","));
                } else {
                    myids = pids;
                }
                String sql = "select * from bonusproduct where seqId in ( ? )";
                ArrayList<String> param = new ArrayList<String>();
                param.add(myids);
                List productList = FacadeFactory.INSTANCE.getBonusProductBo().executeQuery(BonusProduct.class, sql, param);
                StringBuffer sb = new StringBuffer("SELECT s2.* FROM  ((SELECT productid pid,MIN(TIME) ptime FROM `autoproduct`").append(" WHERE CONCAT(CURDATE(),' ',DATE_FORMAT(TIME,'%T')) >= NOW() ").append(" GROUP BY productid) ").append(" UNION  ").append(" ( SELECT productid pid,MIN(TIME) ptime FROM `autoproduct`  ").append(" WHERE CONCAT(DATE_FORMAT(DATE_SUB(CURDATE(),INTERVAL -1 DAY), '%Y-%m-%d') ,' ',DATE_FORMAT(TIME,'%T')) >= NOW()  ").append(" GROUP BY productid))s1 ").append(" LEFT JOIN autoproduct s2 ON s1.pid = s2.productid AND s1.ptime = s2.time ").append(" ORDER BY s2.productid ASC,s2.time DESC ");
                List autoProductList = FacadeFactory.INSTANCE.getAutoProductBo().executeQuery(AutoProduct.class, sb.toString(), new ArrayList());
                AutoCount autoCount = new AutoCount();
                List<AutoCount> aclist = FacadeFactory.INSTANCE.getAutoCountBo().findAutoCount(autoCount, new Page());
                if (autoProductList != null && autoProductList.size() > 0) {
                    for (Object obj : productList) {
                        BonusProduct bp = (BonusProduct)obj;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        boolean flag = false;
                        String resultTime = null;
                        String lastProductid = null;
                        for (Object o : autoProductList) {
                            AutoProduct ap = (AutoProduct)o;
                            if (bp.getProductNo().trim().equals(ap.getProductid().trim())) {
                                if (lastProductid != null && lastProductid.equals(ap.getProductid())) continue;
                                flag = true;
                                map.put("productNum", bp.getProductNum());
                                String time = ap.getTime().split(" ")[1];
                                resultTime = DateUtil.formatNow("yyyy-MM-dd") + " " + time;
                                long secord = DateUtil.compareTime(resultTime, nowtime, "yyyy-MM-dd HH:mm:ss");
                                if (secord <= 0L) {
                                    String tomorrow = DateUtil.format(DateUtil.tomorrow(), "yyyy-MM-dd");
                                    resultTime = tomorrow + " " + time;
                                    secord = DateUtil.compareTime(resultTime, nowtime, "yyyy-MM-dd HH:mm:ss");
                                }
                                if (secord <= 3600L) {
                                    map.put("secord", secord);
                                } else {
                                    map.put("secord", 0);
                                    map.put("time", resultTime);
                                }
                                for (AutoCount ac : aclist) {
                                    if (!ap.getProductid().trim().equals(ac.getProductNo().trim())) continue;
                                    if (ac.getCount() == 0L) {
                                        if (bp.getProductNum() != 0L) continue;
                                        map.put("flag", 0);
                                        continue;
                                    }
                                    map.put("flag", 1);
                                }
                                map.put("type", 1);
                                map.put("amount", ap.getAmount());
                                boxproduct.put("pid_" + bp.getSeqId(), map);
                            }
                            lastProductid = ap.getProductid();
                        }
                        if (flag) continue;
                        map.put("type", 0);
                        map.put("productNum", bp.getProductNum());
                        boxproduct.put("pid_" + bp.getSeqId(), map);
                    }
                }
            }
            result.put("nowtime", nowtime);
            result.put("boxproduct", boxproduct);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.info("\u83b7\u5f97\u5956\u54c1\u5269\u4f59\u6570\u91cf\u548c\u5b9a\u65f6\u53d1\u653e\u60c5\u51b5\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38", null);
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38", null);
        }
    }

    private List<BoxBonusProductCharge> getProductChargeList(XLHttpRequest request) throws Exception {
        List productList = null;
        String pids = request.getParameter("pids");
        if (StringTools.isNotEmpty(pids)) {
            ArrayList<String> param = new ArrayList<String>();
            if (pids.indexOf("_") > -1) {
                String[] ids;
                for (String id : ids = pids.split("_")) {
                    if (StringTools.isEmpty(id)) continue;
                    param.add(id.trim());
                }
            } else {
                param.add(pids.trim());
            }
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < param.size(); ++i) {
                buffer.append("?, ");
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.deleteCharAt(buffer.length() - 1);
            String sql = "select * from BoxBonusProductCharge where productId in (" + buffer + ")";
            productList = FacadeFactory.INSTANCE.getBaseSo().executeQuery(BoxBonusProductCharge.class, sql, param);
        }
        return productList;
    }

    @CmdMapper(value={"/boxproduct/getProduct.do"})
    public Object getProduct(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        try {
            HashMap result = new HashMap();
            HashMap boxproduct = new HashMap();
            int giftId = request.getParameterInteger("giftId", 0);
            List<ProductDTO> productList = FacadeFactory.INSTANCE.getGiftRecordBo().getDayBoxProduct(false, false, 0, giftId);
            if (productList == null || productList.size() > 1) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u6ca1\u6709\u627e\u5230\u8be5\u793c\u54c1\uff01");
            }
            String now = DateUtil.formatNow("yyyy/MM/dd");
            ProductDTO dto = productList.get(0);
            if (dto.getIsTimeLimit() == 0) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u8be5\u793c\u54c1\u4fe1\u606f\u914d\u7f6e\u51fa\u9519\uff01");
            }
            String[] dayTime = dto.getStartTime().split(" ");
            String day = dayTime[0];
            String startTime = dayTime[1];
            HashMap<String, Object> dtoMap = new HashMap<String, Object>();
            dtoMap.put("day", day);
            dtoMap.put("startTime", startTime);
            dtoMap.put("endTime", dto.getValdateTime().split(" ")[1]);
            dtoMap.put("giftName", dto.getGiftName());
            dtoMap.put("giftType", dto.getGiftType());
            dtoMap.put("isTimeLimit", dto.getIsTimeLimit());
            dtoMap.put("totalNum", dto.getTotalNum());
            dtoMap.put("remainNum", dto.getRemainNum());
            dtoMap.put("giftImgUrl", dto.getGiftImgUrl());
            dtoMap.put("giftid", dto.getGiftid());
            dtoMap.put("smallImgUrl", dto.getSmallImgUrl());
            dtoMap.put("giftBonusNum", dto.getGiftBonusNum());
            dtoMap.put("giftMoneyNum", dto.getGiftMoneyNum());
            dtoMap.put("serverTime", DateUtil.format(new Date(), "yyyy/MM/dd hh:mm:ss"));
            return JsonObjectUtil.getDataJsonObject(dtoMap);
        }
        catch (Exception e) {
            logger.error("getProduct.do error", e);
            JsonObjectUtil.getRtnAndDataJsonObject(2, "\u670d\u52a1\u5668\u5f02\u5e38");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/boxproduct/getProductExchangeCount.do"})
    public Object getProductExchangeCount(XLHttpRequest request, XLHttpResponse response) {
        try {
            HashMap<String, Long> result = new HashMap<String, Long>();
            List<BoxBonusProductCharge> productList = this.getProductChargeList(request);
            for (BoxBonusProductCharge bpc : productList) {
                result.put("pid_" + bpc.getProductId(), bpc.getExchangeCount());
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getProduct.do error", e);
            JsonObjectUtil.getRtnAndDataJsonObject(2, "\u670d\u52a1\u5668\u5f02\u5e38");
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/boxproduct/getproduct.do"})
    public Object getproduct(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u83b7\u5f97\u5956\u54c1\u8be6\u60c5");
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String pid = request.getParameter("pid");
            if (pid == null || "".equals(pid.trim())) {
                JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4e0d\u5141\u8bb8\u975e\u6cd5\u8bbf\u95ee", null);
            }
            pid = pid.trim();
            BonusProduct boxproduct = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(Long.parseLong(pid));
            if (boxproduct == null) {
                JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4f60\u8bbf\u95ee\u7684\u5956\u54c1\u4e0d\u5b58\u5728", null);
            }
            LinkInfo info = new LinkInfo();
            info.setLinklocid("229");
            info.setLinktitle(pid);
            List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
            if (lilist == null || lilist.size() != 0) {
                JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5bf9\u4e0d\u8d77\uff0c\u6ca1\u6709\u627e\u51fa\u5408\u9002\u7684\u5956\u54c1", null);
            }
            LinkInfo lif = lilist.get(0);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("pid", pid);
            result.put("price", boxproduct.getPrice());
            result.put("vipprice", boxproduct.getVipPrice());
            result.put("productNo", boxproduct.getProductNo());
            result.put("productName", boxproduct.getProductName());
            result.put("usedSum", boxproduct.getUsedSum());
            result.put("productSum", boxproduct.getProductSum());
            result.put("productNum", boxproduct.getProductNum());
            result.put("validPeriod", boxproduct.getValidPeriod());
            result.put("content", lif.getLinkcontents() == null ? "" : lif.getLinkcontents());
            result.put("photo", lif.getPicurl());
            result.put("minGameLevel", boxproduct.getMinGameLevel() == null ? 0 : boxproduct.getMinGameLevel());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.info("\u83b7\u5f97\u5956\u54c1\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38", null);
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38", null);
        }
    }

    @CmdMapper(value={"/boxproduct/getvipproduct.do"})
    public Object getVipProduct(XLHttpRequest request, XLHttpResponse response) {
        logger.info("\u5f00\u59cb\u83b7\u5f97\u5956\u54c1\u8be6\u60c5");
        try {
            String pid = request.getParameter("pid");
            if (pid == null || "".equals(pid.trim())) {
                JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4e0d\u5141\u8bb8\u975e\u6cd5\u8bbf\u95ee", null);
            }
            pid = pid.trim();
            BonusProduct boxproduct = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(Long.parseLong(pid));
            if (boxproduct == null) {
                JsonObjectUtil.getRtnAndDataJsonObject(1, "\u4f60\u8bbf\u95ee\u7684\u5956\u54c1\u4e0d\u5b58\u5728", null);
            }
            LinkInfo info = new LinkInfo();
            info.setLinklocid("229");
            info.setLinktitle(pid);
            List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
            if (lilist == null || lilist.size() == 0) {
                JsonObjectUtil.getRtnAndDataJsonObject(1, "\u5bf9\u4e0d\u8d77\uff0c\u6ca1\u6709\u627e\u51fa\u5408\u9002\u7684\u5956\u54c1", null);
            }
            LinkInfo lif = lilist.get(0);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("pid", pid);
            result.put("productNo", boxproduct.getProductNo());
            result.put("productName", boxproduct.getProductName());
            result.put("usedSum", boxproduct.getUsedSum());
            result.put("productSum", boxproduct.getProductSum());
            result.put("productNum", boxproduct.getProductNum());
            result.put("validPeriod", boxproduct.getValidPeriod());
            result.put("content", lif.getLinkcontents() == null ? "" : lif.getLinkcontents());
            result.put("photo", lif.getPicurl());
            info = new LinkInfo();
            info.setLinklocid("1262");
            info.setLinktitle(pid);
            lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(info);
            if (lilist != null && lilist.size() > 0) {
                lif = lilist.get(0);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.info("\u83b7\u5f97\u5956\u54c1\u8be6\u60c5\u5931\u8d25,\u539f\u56e0\uff1a" + e.getMessage());
            JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38", null);
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u7f51\u7edc\u5f02\u5e38", null);
        }
    }

    @CmdMapper(value={"/boxproduct/getheziproduct.do"})
    public Object getheziproducts(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        HashMap result = new HashMap();
        Map<String, AutoProduct> autoProductMap = this.getAllAutoProductMap();
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().getValidteLinkInfoListByLinkLocId("272", 4, false);
        for (LinkInfo li : lilist) {
            BonusProduct boxproduct = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(Long.parseLong(li.getLinktitle()));
            if (boxproduct == null) continue;
            HashMap<String, Object> liMap = new HashMap<String, Object>();
            liMap.put("type", boxproduct.getExchangeDirect() == null ? "" : boxproduct.getExchangeDirect());
            liMap.put("gameid", boxproduct.getGameId() == null ? "" : boxproduct.getGameId());
            liMap.put("title", boxproduct.getProductName() == null ? "" : boxproduct.getProductName());
            liMap.put("imgurl", li.getPicurl() == null ? "" : li.getPicurl());
            liMap.put("samllimgurl", li.getSmallpicurl() == null ? "" : li.getSmallpicurl());
            liMap.put("total", boxproduct.getProductSum() == null ? "" : boxproduct.getProductSum());
            liMap.put("surplus", boxproduct.getProductNum() == null ? "" : boxproduct.getProductNum());
            if ("11".equals(boxproduct.getExchangeDirect())) {
                liMap.put("cost", boxproduct.getBaseUnitNum());
            } else {
                liMap.put("cost", boxproduct.getPrice() == null ? "" : boxproduct.getPrice());
            }
            AutoProduct ap = autoProductMap.get(boxproduct.getProductNo());
            liMap.put("nexttime", ap == null || ap.getTime() == null ? "" : ap.getTime());
            liMap.put("nextnum", ap == null || ap.getAmount() == null ? "" : ap.getAmount());
            liMap.put("oktips", boxproduct.getSuccessTips() == null ? "" : boxproduct.getSuccessTips());
            result.put(boxproduct.getProductNo(), liMap);
        }
        String json = JSONUtil.fromObject(result);
        return "g_products_data = " + json + ";";
    }

    private List<AutoProduct> getAllAutoProduct() {
        StringBuffer sb = new StringBuffer("SELECT s2.* FROM  ((SELECT productid pid,MIN(TIME) ptime FROM `autoproduct`").append(" WHERE CONCAT(CURDATE(),' ',DATE_FORMAT(TIME,'%T')) >= NOW() ").append(" GROUP BY productid) ").append(" UNION  ").append(" ( SELECT productid pid,MIN(TIME) ptime FROM `autoproduct`  ").append(" WHERE CONCAT(DATE_FORMAT(DATE_SUB(CURDATE(),INTERVAL -1 DAY), '%Y-%m-%d') ,' ',DATE_FORMAT(TIME,'%T')) >= NOW()  ").append(" GROUP BY productid))s1 ").append(" LEFT JOIN autoproduct s2 ON s1.pid = s2.productid AND s1.ptime = s2.time ").append(" ORDER BY s2.productid ASC,s2.time DESC ");
        List autoProductList = FacadeFactory.INSTANCE.getAutoProductBo().executeQuery(AutoProduct.class, sb.toString(), new ArrayList());
        return autoProductList;
    }

    private Map<String, AutoProduct> getAllAutoProductMap() {
        HashMap<String, AutoProduct> map = new HashMap<String, AutoProduct>();
        List<AutoProduct> list = this.getAllAutoProduct();
        if (list == null || list.size() == 0) {
            return map;
        }
        for (AutoProduct ap : list) {
            AutoProduct autoProduct = (AutoProduct)map.get(ap.getProductid());
            if (autoProduct != null && autoProduct.getTime().substring(11).compareTo(ap.getTime().substring(11)) > 0) continue;
            map.put(ap.getProductid(), ap);
        }
        return map;
    }

    @CmdMapper(value={"/boxbonus/queryProductUserNum.do"})
    public Object queryProductUserNum(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String productNosString = request.getParameter("productNo", "");
        String[] productNos = productNosString.split("\\_");
        ArrayList resultList = new ArrayList();
        if (productNos == null || productNos.length == 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
        }
        for (String productNo : productNos) {
            if (productNo == null || "".equals(productNo)) continue;
            BonusProduct query = new BonusProduct();
            query.setProductNo(productNo);
            BonusProduct boxproduct = FacadeFactory.INSTANCE.getBaseSo().findObject(query);
            if (boxproduct == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("productNo", productNo);
            map.put("productCanUseNum", boxproduct.getProductNum());
            map.put("productSum", boxproduct.getProductSum());
            resultList.add(map);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
    }

    @CmdMapper(value={"/boxbonus/countUserGiftNum.do"})
    public Object countUserGiftNum(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        long userId = request.getParameterLong("userId");
        String productNo = request.getParameter("productNo", "");
        String actNo = request.getParameter("actNo", "");
        BonusExchange exchange = new BonusExchange();
        exchange.setUserId(String.valueOf(userId));
        exchange.setProductNo(productNo);
        exchange.setExchangePlatform(actNo);
        exchange.setExchangeStatus("2");
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(exchange);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("count", count);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, map);
    }

    @CmdMapper(value={"/boxbonus/getProdcutChargeList.do"})
    public Object getProdcutChargeList(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        Integer listNum = 0;
        boolean isTimeLimit = false;
        boolean isEntityGift = false;
        try {
            listNum = request.getParameterInteger("listNum", 0);
            isTimeLimit = request.getParameterBoolean("isTimeLimit", false);
            isEntityGift = request.getParameterBoolean("isEntityGift", false);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List<ProductDTO> list = null;
        try {
            list = FacadeFactory.INSTANCE.getGiftRecordBo().getBoxBonusProductChargeList(listNum, isTimeLimit, isEntityGift);
            if (CollectionUtils.isEmpty(list)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u6570\u636e");
            }
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u7f51\u7edc\u9519\u8bef");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
    }

    private long calcBonus(long userId, BoxBonusProductCharge bpc) throws Exception {
        long resultBonus;
        Integer isTimeLimit = bpc.getIsTimeLimit();
        if (isTimeLimit == 1) {
            int isJinZuanCode = JinZuanClient.isJinZuanUser(String.valueOf(userId));
            resultBonus = isJinZuanCode == 0 || isJinZuanCode == 3 ? (long)((double)bpc.getBonus().longValue() * 0.8) : (long)((double)bpc.getBonus().longValue() * 0.9);
        } else if (isTimeLimit == 0) {
            resultBonus = bpc.getBonus();
        } else {
            throw new NiuxException("", "isTimeLimit\u5f02\u5e38:" + isTimeLimit);
        }
        return resultBonus;
    }

    @CmdMapper(value={"/boxbonus/getProdcutBoxChargeList.do"})
    public Object getProdcutChargeBoxList(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        Integer listNum = 0;
        boolean isTimeLimit = false;
        boolean isEntityGift = false;
        try {
            listNum = request.getParameterInteger("listNum", 0);
            isTimeLimit = request.getParameterBoolean("isTimeLimit", false);
            isEntityGift = request.getParameterBoolean("isEntityGift", false);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List<ProductDTO> list = null;
        try {
            list = FacadeFactory.INSTANCE.getGiftRecordBo().getBoxBonusProductChargeList(listNum, isTimeLimit, isEntityGift);
            if (CollectionUtils.isEmpty(list)) {
                return JsonObjectUtil.getRtnAndDataJsonObject(-2, "\u6ca1\u6709\u6570\u636e");
            }
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u7f51\u7edc\u9519\u8bef");
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, list);
    }

    @CmdMapper(value={"/boxbonus/getboxProdcutChargeList.do"})
    public Object getboxProdcutChargeList(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        Integer listNum = 0;
        boolean isTimeLimit = false;
        boolean isEntityGift = false;
        Integer giftId = 0;
        try {
            listNum = request.getParameterInteger("listNum", 0);
            isTimeLimit = request.getParameterBoolean("isTimeLimit", false);
            isEntityGift = request.getParameterBoolean("isEntityGift", false);
            giftId = request.getParameterInteger("giftId", 0);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List<ProductDTO> list = null;
        try {
            list = FacadeFactory.INSTANCE.getGiftRecordBo().getDayBoxProduct(isTimeLimit, isEntityGift, listNum, 0);
            HashMap map = new HashMap();
            ArrayList today = new ArrayList();
            ArrayList tomorrow = new ArrayList();
            map.put("today", today);
            map.put("tomorrow", tomorrow);
            if (list == null || list.size() == 0) {
                return JsonObjectUtil.getDataJsonObject(map);
            }
            String now = DateUtil.formatNow("yyyy/MM/dd");
            for (ProductDTO dto : list) {
                if (dto.getIsTimeLimit() == 0) continue;
                String[] dayTime = dto.getStartTime().split(" ");
                String day = dayTime[0];
                String startTime = dayTime[1];
                HashMap<String, Object> dtoMap = new HashMap<String, Object>();
                dtoMap.put("day", day);
                dtoMap.put("startTime", startTime);
                dtoMap.put("endTime", dto.getValdateTime().split(" ")[1]);
                dtoMap.put("giftName", dto.getGiftName());
                dtoMap.put("giftType", dto.getGiftType());
                dtoMap.put("isTimeLimit", dto.getIsTimeLimit());
                dtoMap.put("totalNum", dto.getTotalNum());
                dtoMap.put("remainNum", dto.getRemainNum());
                dtoMap.put("giftImgUrl", dto.getGiftImgUrl());
                dtoMap.put("giftid", dto.getGiftid());
                dtoMap.put("smallImgUrl", dto.getSmallImgUrl());
                dtoMap.put("giftBonusNum", dto.getGiftBonusNum());
                dtoMap.put("giftMoneyNum", dto.getGiftMoneyNum());
                dtoMap.put("serverTime", DateUtil.format(new Date(), "yyyy/MM/dd hh:mm:ss"));
                if (day.equals(now)) {
                    today.add(dtoMap);
                    continue;
                }
                tomorrow.add(dtoMap);
            }
            return JsonObjectUtil.getDataJsonObject(map);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(-3, "\u7f51\u7edc\u9519\u8bef");
        }
    }
}

