/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bonus.thread;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.niux.center.thirdclient.BonusClient;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LiveCount;
import com.xunlei.niux.data.vipgame.vo.bonus.SignRecord;
import com.xunlei.util.Log;
import org.slf4j.Logger;

public class AfterSignUpdateThread
implements Runnable {
    private static Logger logger = Log.getLogger(AfterSignUpdateThread.class.getName());
    private static final String BUQIAN_DATA_URL = "http://jinzuan.niu.xunlei.com:9090/sign/addBuQianRecord.do?";
    private static final String PRIVILEGE_USE_URL = "http://jinzuan.niu.xunlei.com:9090/privilege/use.do?";
    private static final String PRIVILEGE_USE_KEY = "3b53aaf7-ac55-46af-9b2f-115e12f306da";
    private static final String BUQIAN_DATA_KEY = "11a05e44-27a8-4553-b0a2-553b43bddc6d";
    private String date;
    private long signSeqId;
    private SignRecord signRecord;
    private boolean isReSign;

    public AfterSignUpdateThread(SignRecord signRecord, String date, long signSeqId, boolean isReSign) {
        this.date = date;
        this.signSeqId = signSeqId;
        this.signRecord = signRecord;
        this.isReSign = isReSign;
    }

    @Override
    public void run() {
        if (!this.isReSign) {
            SignRecord allQuery = new SignRecord();
            allQuery.setSignDate(this.date);
            long allcount = FacadeFactory.INSTANCE.getSignRecordBo().count(allQuery);
            LiveCount liveCount = FacadeFactory.INSTANCE.getLiveCountBo().find(this.signSeqId);
            liveCount.setLiveCount(allcount);
            FacadeFactory.INSTANCE.getLiveCountBo().update(liveCount);
        } else {
            this.privilegeUseCount();
            this.buQianLog();
        }
        boolean flag = this.giveOutBonus(this.signRecord.getUserId(), this.signRecord.getUserName(), this.signRecord.getBonusNum(), this.signRecord.getSignNo(), this.signRecord.getSignDate());
        if (flag) {
            this.updateSignStatus(this.signRecord);
        }
    }

    private void privilegeUseCount() {
        long timeStamp = System.currentTimeMillis() / 1000L;
        String content = this.signRecord.getUserId() + "6" + "1" + timeStamp;
        String sign = SignUtil.sign(content, PRIVILEGE_USE_KEY);
        StringBuffer buffer = new StringBuffer(PRIVILEGE_USE_URL);
        buffer.append("uid=").append(this.signRecord.getUserId()).append("&usedValue=1").append("&ptype=6").append("&timestamp=").append(timeStamp).append("&sign=").append(sign);
        logger.info("privilegeUseCount uid=" + this.signRecord.getUserId());
        try {
            String responseText = HttpClientUtil.get(buffer.toString());
            JsonObject jsonObject = new JsonParser().parse(responseText).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            logger.info("privilegeUseCount uid=" + this.signRecord.getUserId() + ",rtn=" + code);
            if (code == 0) {
                logger.info("privilegeUseCount success uid=" + this.signRecord.getUserId());
            } else {
                logger.info("privilegeUseCount failure uid=" + this.signRecord.getUserId() + ",rtn=" + code);
            }
        }
        catch (Exception e) {
            logger.error("privilegeUseCount error uid=" + this.signRecord.getUserId(), e);
        }
    }

    private void buQianLog() {
        long timeStamp = System.currentTimeMillis() / 1000L;
        String content = this.signRecord.getUserId() + "1" + this.date + "10" + timeStamp;
        String sign = SignUtil.sign(content, BUQIAN_DATA_KEY);
        StringBuffer buffer = new StringBuffer(BUQIAN_DATA_URL);
        buffer.append("uid=").append(this.signRecord.getUserId()).append("&signWay=1").append("&dayTime=").append(this.date).append("&bonus=1").append("&growValue=0").append("&timeStamp=").append(timeStamp).append("&sign=").append(sign);
        logger.info("buQianLog uid=" + this.signRecord.getUserId());
        try {
            String responseText = HttpClientUtil.get(buffer.toString());
            JsonObject jsonObject = new JsonParser().parse(responseText).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            logger.info("buQianLog uid=" + this.signRecord.getUserId() + ",rtn=" + code);
            if (code == 0) {
                logger.info("buQianLog success uid=" + this.signRecord.getUserId());
            }
        }
        catch (Exception e) {
            logger.error("buQianLog error uid=" + this.signRecord.getUserId(), e);
        }
    }

    private boolean giveOutBonus(String userId, String userName, Integer transNum, String transNo, String balanceDate) {
        try {
            BonusClient.recharge(userId, userName, transNum, transNo, balanceDate, "nxqiandao");
            return true;
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]transNo[" + transNo + "]transNum[" + transNum + "]\u53d1\u653e\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
            return false;
        }
    }

    private void updateSignStatus(SignRecord signRecord) {
        try {
            SignRecord sr = FacadeFactory.INSTANCE.getSignRecordBo().find(signRecord.getUserId(), signRecord.getSignDate());
            sr.setGiveOutBonusStatus("1");
            FacadeFactory.INSTANCE.getSignRecordBo().update(sr);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u7528\u6237[" + signRecord.getUserId() + "]\u7b7e\u5230\u53d1\u653e\u79ef\u5206\u72b6\u6001\u5931\u8d25", e);
        }
    }
}

