/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bonus;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.cmd.bonus.thread.AfterSignUpdateThread;
import com.xunlei.niux.center.thirdclient.JinZuanClient;
import com.xunlei.niux.center.util.DateUtil;
import com.xunlei.niux.center.util.LogReportUtil;
import com.xunlei.niux.center.util.SignUtil;
import com.xunlei.niux.center.util.VerifyCodeUtil;
import com.xunlei.niux.client.jinzuan.MemberInfoClient;
import com.xunlei.niux.client.jinzuan.dto.MemberShipDTO;
import com.xunlei.niux.client.util.HttpClientUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.LiveCount;
import com.xunlei.niux.data.vipgame.vo.bonus.SignRecord;
import com.xunlei.niux.easyutils.propertyutils.EnvPropertyUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SignCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(SignCmd.class.getName());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static int IP_DAY_SIGN_MAX_TIMES = 10;
    private static final long signSeqId = 4L;
    private static String WEIXIN_SIGNKEY = "6f5aadf0-8aa7-41bf-bcd1-74eab17dd9b5";
    private static String BUQIAN_COUNT_URL = "http://jinzuan.niu.xunlei.com:9090/sign/queryBuQianCount.do?";
    private static String BUQIAN_KEY = "11a05e44-27a8-4553-b0a2-553b43bddc6d";

    private Map<String, Object> getSignMap(long uid) {
        SignRecord signRecord = new SignRecord();
        signRecord.setUserId(uid + "");
        String nowShort = sdf.format(new Date());
        SignRecord todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().find(signRecord.getUserId(), nowShort);
        String daytime = DateUtil.getCurDateStr();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("daytime", daytime);
        if (todaySignRecord == null) {
            result.put("isSign", 0);
        } else {
            result.put("isSign", 1);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        String beforetime = sdf.format(cal.getTime());
        String beforeMonth = beforetime.substring(0, 7);
        String month = daytime.substring(0, 7);
        beforetime = beforeMonth + "-01";
        String sql = "select * from signrecord where userId=? and  signDate>=? and signDate<=?  order by signTime asc";
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(uid);
        list.add(beforetime);
        list.add(daytime);
        List shlist = FacadeFactory.INSTANCE.getBaseSo().executeQuery(SignRecord.class, sql, list);
        ArrayList<Integer> beforeList = new ArrayList<Integer>();
        ArrayList<Integer> nowList = new ArrayList<Integer>();
        for (SignRecord sh : shlist) {
            String mydaytime = sh.getSignDate();
            if (mydaytime.indexOf(beforeMonth) != -1) {
                beforeList.add(this.getDays(mydaytime));
                continue;
            }
            nowList.add(this.getDays(mydaytime));
        }
        TreeMap<String, ArrayList<Integer>> monthMap = new TreeMap<String, ArrayList<Integer>>();
        monthMap.put(this.formatMonth(beforeMonth), beforeList);
        monthMap.put(this.formatMonth(month), nowList);
        result.put("signHistory", monthMap);
        return result;
    }

    @CmdMapper(value={"/sign/getSignInfo.do"})
    public Object getSignInfo(XLHttpRequest request, XLHttpResponse response) {
        try {
            MainParam param = this.getMainParam(request, response, true);
            long uid = param.getUserid();
            MemberShipDTO shipDto = MemberInfoClient.getMemberInfo(uid + "");
            if (shipDto == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            Map<String, Object> result = this.getSignMap(uid);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("getSignInfo.do error", e);
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    private int getDays(String daytime) {
        if ((daytime = daytime.substring(8)).charAt(0) == '\u0000') {
            daytime = daytime.substring(1);
        }
        return Integer.parseInt(daytime);
    }

    private String formatMonth(String month) {
        if (StringTools.isEmpty(month)) {
            return "";
        }
        String[] strs = month.split("-");
        return "y" + strs[0] + strs[1];
    }

    @CmdMapper(value={"/sign/getSignCount.do"})
    public Object getSignCount(XLHttpRequest request, XLHttpResponse response) {
        try {
            LiveCount liveCount = FacadeFactory.INSTANCE.getLiveCountBo().find(4L);
            long count = liveCount.getLiveCount();
            return JsonObjectUtil.getRtnAndDataJsonObject(0, count);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject(1, "\u67e5\u8be2\u5931\u8d25");
        }
    }

    private boolean validateReSign(long userId) {
        boolean flag = false;
        try {
            JsonObject result;
            int availableValue;
            long timeStamp = System.currentTimeMillis() / 1000L;
            String sign = SignUtil.sign(userId + "" + timeStamp, BUQIAN_KEY);
            StringBuffer buffer = new StringBuffer(BUQIAN_COUNT_URL);
            buffer.append("uid=").append(userId).append("&timeStamp=").append(timeStamp).append("&sign=").append(sign);
            String responseText = HttpClientUtil.get(buffer.toString());
            JsonObject jsonObject = new JsonParser().parse(responseText).getAsJsonObject();
            int code = jsonObject.get("rtn").getAsInt();
            if (code == 0 && (availableValue = (result = jsonObject.get("data").getAsJsonObject()).get("availableValue").getAsInt()) > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error("validateReSign error", e);
        }
        return flag;
    }

    @CmdMapper(value={"/bonus/sign.do"})
    public Object sign(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            MemberShipDTO shipDto;
            SignRecord todaySignRecord;
            MainParam mainParam = this.getMainParam(request, response, true);
            SignRecord signRecord = new SignRecord();
            signRecord.setSignIp(request.getRemoteIP());
            signRecord.setUserId(mainParam.getUserid() + "");
            signRecord.setUserName(this.getUserName(request));
            String verifycode = request.getParameter("verifycode", "");
            String verifykey = request.getCookieValue("VERIFY_KEY");
            String verifytype = "MVA";
            String dayStr = request.getParameter("day", "");
            int day = 0;
            if (StringUtils.isNotEmpty(dayStr)) {
                day = Integer.parseInt(dayStr);
            }
            boolean isReSign = false;
            Calendar calendar = Calendar.getInstance();
            int curDay = calendar.get(5);
            if (day < 0 || day > curDay) {
                return JsonObjectUtil.getRtnAndDataJsonObject(201, "day\u53c2\u6570\u9519\u8bef");
            }
            if (day > 0 && day < curDay) {
                isReSign = true;
            }
            String nowShort = sdf.format(new Date());
            String daytime = null;
            if (isReSign) {
                String month = nowShort.substring(0, 7);
                daytime = month + "-" + this.changeDay(day);
                int rtn = JinZuanClient.isJinZuanUser(mainParam.getUserid() + "");
                if (rtn != 0 && rtn != 3) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
                }
                if (!this.validateReSign(mainParam.getUserid())) {
                    return JsonObjectUtil.getRtnAndDataJsonObject(3, "\u4eb2\u7231\u7684\u7528\u6237\uff0c\u60a8\u672c\u6708\u7684\u8865\u7b7e\u7279\u6743\u5df2\u7528\u5b8c~");
                }
            } else {
                if (!VerifyCodeUtil.isVerify(verifykey, verifytype, verifycode)) {
                    throw new NiuRuntimeException("99", "\u60a8\u8f93\u5165\u7684\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
                }
                daytime = nowShort;
            }
            if ((todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().find(signRecord.getUserId(), daytime)) != null) {
                throw new NiuRuntimeException("99", "\u8be5\u65e5\u671f\u60a8\u5df2\u7ecf\u7b7e\u5230\u8fc7\u4e86\uff01");
            }
            if (!this.checkIpCanSign(signRecord.getSignIp(), nowShort, IP_DAY_SIGN_MAX_TIMES)) {
                throw new RuntimeException("\u4eb2\u7231\u7684\u7528\u6237\uff0c\u4f60\u6240\u5728\u7684IP\u4eca\u5929\u7b7e\u5230\u5df2\u8fbe\u4eba\u6570\u4e0a\u9650\uff0c\u8bf7\u660e\u5929\u518d\u6765~");
            }
            signRecord.setSignDate(daytime);
            todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().insert(signRecord, isReSign);
            new Thread(new AfterSignUpdateThread(todaySignRecord, daytime, 4L, isReSign)).start();
            this.report(todaySignRecord, request.getParameter("channelNo", ""));
            result.put("code", "00");
            result.put("seriesSignDays", todaySignRecord.getSeriesSignDays());
            result.put("sumSignDays", todaySignRecord.getSignSumDays());
            result.put("todaySignIndex", todaySignRecord.getTodaySignIndex());
            result.put("totalSignBonusNum", todaySignRecord.getSignTotalBonusNum());
            result.put("msg", "\u7b7e\u5230\u6210\u529f");
            if (isReSign && (shipDto = MemberInfoClient.getMemberInfo(mainParam.getUserid() + "")) == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject(2, "\u8be5\u7528\u6237\u975e\u91d1\u94bb\u4f1a\u5458");
            }
            Map<String, Object> historyRecord = this.getSignMap(mainParam.getUserid());
            result.put("historyRecord", historyRecord);
        }
        catch (NiuRuntimeException e) {
            result.put("code", "99");
            result.put("msg", e.getMessage());
        }
        catch (Exception e) {
            result.put("code", "99");
            result.put("msg", "\u7b7e\u5230\u5931\u8d25");
            e.printStackTrace();
            logger.error("sign error", e);
            logger.error("\u67e5\u8be2\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
    }

    private String changeDay(int day) {
        if (day <= 9) {
            return "0" + day;
        }
        return day + "";
    }

    @CmdMapper(value={"/bonus/signOfWeixin.do"})
    public Object signOfWeixin(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String userid = request.getParameter("uid", "");
            String time = request.getParameter("time", "");
            String sign = request.getParameter("sign", "");
            String ip = request.getHeader("X-Real-IP");
            if (StringUtils.isEmpty(ip)) {
                ip = request.getRemoteIP();
            }
            SignRecord signRecord = new SignRecord();
            signRecord.setUserId(userid);
            signRecord.setSignIp(ip);
            if (StringUtils.isEmpty(userid) || StringUtils.isEmpty(time)) {
                logger.info("[signOfWeixin]param not valid");
                return JsonObjectUtil.getOnlyRtnJson(1);
            }
            String signStr = userid + time + WEIXIN_SIGNKEY;
            logger.info("[signOfWeixin]userid:" + userid);
            String newSign = Md5Encrypt.md5(signStr);
            if (!newSign.equals(sign)) {
                logger.info("[signOfWeixin]token not valid");
                return JsonObjectUtil.getOnlyRtnJson(2);
            }
            String userName = UserUtility.getUserNameByUserId(userid);
            signRecord.setUserName(userName);
            if (StringUtils.isEmpty(userName)) {
                logger.info("[signOfWeixin]userid not valid");
                return JsonObjectUtil.getOnlyRtnJson(3);
            }
            String nowShort = sdf.format(new Date());
            SignRecord todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().find(signRecord.getUserId(), nowShort);
            if (todaySignRecord != null) {
                logger.error("[signOfWeixin]already sign.getUserId()" + signRecord.getUserId() + ",nowShort" + nowShort);
                result.put("code", "4");
                result.put("seriesSignDays", todaySignRecord.getSeriesSignDays());
                result.put("sumSignDays", todaySignRecord.getSignSumDays());
                result.put("todaySignIndex", todaySignRecord.getTodaySignIndex());
                result.put("totalSignBonusNum", todaySignRecord.getSignTotalBonusNum());
                result.put("bonusNum", todaySignRecord.getBonusNum());
                return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
            }
            todaySignRecord = FacadeFactory.INSTANCE.getSignRecordBo().insert(signRecord, false);
            new Thread(new AfterSignUpdateThread(todaySignRecord, nowShort, 4L, false)).start();
            this.report(todaySignRecord, request.getParameter("channelNo", ""));
            result.put("code", "0");
            result.put("seriesSignDays", todaySignRecord.getSeriesSignDays());
            result.put("sumSignDays", todaySignRecord.getSignSumDays());
            result.put("todaySignIndex", todaySignRecord.getTodaySignIndex());
            result.put("totalSignBonusNum", todaySignRecord.getSignTotalBonusNum());
            result.put("bonusNum", todaySignRecord.getBonusNum());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (NiuRuntimeException e) {
            logger.error("[signOfWeixin]\u67e5\u8be2\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getOnlyRtnJson(99);
        }
        catch (Exception e) {
            logger.error("[signOfWeixin]\u67e5\u8be2\u79ef\u5206\u51fa\u73b0\u5f02\u5e38", e);
            return JsonObjectUtil.getOnlyRtnJson(99);
        }
    }

    @CmdMapper(value={"/bonus/istodaysign.do"})
    public Object isTodaySign(XLHttpRequest request, XLHttpResponse response) {
        String userId = request.getParameter("userId", "");
        if (userId.equals("")) {
            return JsonObjectUtil.getRtnAndDataJsonObject(13, "\u975e\u6cd5\u53c2\u6570");
        }
        HashMap<String, Boolean> resultMap = new HashMap<String, Boolean>();
        String todayDate = sdf.format(new Date());
        SignRecord query = new SignRecord();
        query.setUserId(userId);
        query.setSignDate(todayDate);
        int count = FacadeFactory.INSTANCE.getBaseSo().countObject(query);
        resultMap.put("isSign", count > 0);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private boolean checkIpCanSign(String signIp, String signDate, int maxTimes) {
        if (signIp == null || "".equals(signIp)) {
            return true;
        }
        if (signDate == null || "".equals(signDate)) {
            return true;
        }
        if (maxTimes < 1) {
            return true;
        }
        String validIps = EnvPropertyUtil.loadProperty("niux", "company_white_ip");
        if (validIps != null && validIps.contains(signIp)) {
            return true;
        }
        SignRecord signRecord = new SignRecord();
        signRecord.setSignIp(signIp);
        signRecord.setSignDate(signDate);
        int countTimes = FacadeFactory.INSTANCE.getSignRecordBo().count(signRecord);
        return countTimes < maxTimes;
    }

    private void report(SignRecord signRecord, String channelNo) {
        if (signRecord == null) {
            return;
        }
        LogReportUtil.LogReport logReport = new LogReportUtil.LogReport();
        logReport.logTime = new Date();
        logReport.actId = "nxqiandao";
        logReport.userId = signRecord.getUserId();
        logReport.operatorId = "4";
        logReport.productId = "bonus";
        logReport.bonusNum = signRecord.getBonusNum();
        logReport.str1 = signRecord.getSignTotalBonusNum() + "";
        logReport.str2 = channelNo == null ? "" : channelNo;
        LogReportUtil.report(logReport);
    }
}

