/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.center.cmd.bonus;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.UserUtility;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.cache.CacheManager;
import com.xunlei.niux.center.cmd.DefaultCmd;
import com.xunlei.niux.center.enums.MemberShipType;
import com.xunlei.niux.center.so.bonus.ExchangeProductSo;
import com.xunlei.niux.center.util.StringUtil;
import com.xunlei.niux.common.exception.NiuRuntimeException;
import com.xunlei.niux.data.vipgame.bt.bonus.BonusProductBT;
import com.xunlei.niux.data.vipgame.facade.FacadeFactory;
import com.xunlei.niux.data.vipgame.vo.BonusProduct;
import com.xunlei.niux.data.vipgame.vo.LinkInfo;
import com.xunlei.niux.data.vipgame.vo.bonus.BonusExchange;
import com.xunlei.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ExchangeProductCmd
extends DefaultCmd {
    private static final int timeOut = 10;
    private static Logger logger = Log.getLogger(ExchangeProductCmd.class.getName());

    @CmdMapper(value={"/bonus/productexchange.do"})
    public Object productexchange(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isbackserialnum", false);
        String code = "00";
        String userId = "";
        String productNo = "";
        String productType = "";
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            BonusExchange exchange = new BonusExchange();
            userId = mainParam.getUserid() + "";
            exchange.setUserId(userId);
            exchange.setUserName(this.getUserName(request));
            productNo = request.getParameter("productNo", "");
            exchange.setProductNo(productNo);
            exchange.setServerId(request.getParameter("exchangeServer", "1"));
            exchange.setGameId(request.getParameter("gameId", ""));
            exchange.setExchangePlatform(request.getParameter("actNo", "nxjifenduihuan"));
            exchange.setExchangeIp("");
            exchange.setRoleId(request.getParameter("roleId", ""));
            String sessionId = request.getCookieValue("sessionid");
            String gameLevelServerId = request.getParameter("serverId", "");
            BonusProduct product = this.findBonusProduct(exchange.getProductNo());
            result.put("successTips", product.getSuccessTips());
            result.put("successTipLink", product.getSuccessTipLink());
            result.put("giveOutType", product.getGiveOutType());
            productType = product.getProductType();
            exchange = new ExchangeProductSo().deal(exchange, gameLevelServerId, sessionId, MemberShipType.JinKa);
            result.put("serialnumber", exchange.getSerialNumber());
            code = "2".equals(exchange.getExchangeStatus()) ? "00" : exchange.getFailCause();
            String msg = "2".equals(exchange.getExchangeStatus()) ? "\u5151\u6362\u6210\u529f" : exchange.getRemark();
            result.put("code", code);
            result.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (NiuRuntimeException e) {
            logger.error("userId[" + userId + "]\u5151\u6362\u5931\u8d25\u4ea7\u54c1[" + productNo + "],\u5931\u8d25\u4ee3\u7801[" + e.code + "]\u539f\u56e0\uff1a" + e.getMessage());
            result.put("code", e.code);
            result.put("msg", "\u5151\u6362\u5931\u8d25");
            result.put("errormsg", e.getMessage());
            result.put("serialnumber", this.lastserialnumber(productNo, productType, userId, e));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]\u5151\u6362\u5931\u8d25\u4ea7\u54c1[" + productNo + "]\u539f\u56e0\uff1a" + e.getMessage());
            result.put("code", "99");
            result.put("msg", "\u5151\u6362\u5931\u8d25");
            result.put("errormsg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
    }

    @CmdMapper(value={"/bonus/heziproductexchange.do"})
    public Object heziproductexchange(XLHttpRequest request, XLHttpResponse response) {
        String resptype = request.getParameter("resptype", "json");
        if ("plain".equals(resptype)) {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String code = "00";
        String userId = "";
        String productNo = "";
        try {
            BonusExchange exchange = new BonusExchange();
            userId = request.getParameter("userid", "");
            exchange.setUserId(request.getParameter("userid", ""));
            exchange.setUserName(this.getUserNameById(exchange.getUserId()));
            if (exchange.getUserId() == null || "".equals(exchange.getUserId()) || exchange.getUserName() == null || "".equals(exchange.getUserName())) {
                throw new NiuRuntimeException("13", "\u8d26\u53f7\u4e0d\u6b63\u786e");
            }
            productNo = request.getParameter("productNo", "");
            exchange.setProductNo(request.getParameter("productNo", ""));
            exchange.setServerId(request.getParameter("exchangeServer", "1"));
            exchange.setGameId(request.getParameter("gameId", ""));
            exchange.setExchangePlatform(request.getParameter("actNo", "hezijifenduihuan"));
            exchange.setExchangeIp("");
            String sessionId = request.getCookieValue("sessionid");
            String gameLevelServerId = request.getParameter("serverId", "");
            BonusProduct product = this.findBonusProduct(exchange.getProductNo());
            result.put("successTips", product.getSuccessTips());
            result.put("successTipLink", product.getSuccessTipLink());
            result.put("giveOutType", product.getGiveOutType());
            exchange = new ExchangeProductSo().deal(exchange, gameLevelServerId, sessionId, MemberShipType.JinKa);
            result.put("serialnumber", exchange.getSerialNumber());
            code = "2".equals(exchange.getExchangeStatus()) ? "00" : exchange.getFailCause();
            String msg = "2".equals(exchange.getExchangeStatus()) ? "\u5151\u6362\u6210\u529f" : exchange.getRemark();
            result.put("code", code);
            result.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (NiuRuntimeException e) {
            logger.error("userId[" + userId + "]\u5151\u6362\u5931\u8d25\u4ea7\u54c1[" + productNo + "],\u5931\u8d25\u4ee3\u7801[" + e.code + "]\u539f\u56e0\uff1a" + e.getMessage());
            result.put("code", e.code);
            result.put("msg", "\u5151\u6362\u5931\u8d25");
            result.put("errormsg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]\u5151\u6362\u5931\u8d25\u4ea7\u54c1[" + productNo + "]\u539f\u56e0\uff1a" + e.getMessage());
            result.put("code", "99");
            result.put("msg", "\u5151\u6362\u5931\u8d25");
            result.put("errormsg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
    }

    public BonusProduct findBonusProduct(String productNo) {
        BonusProduct query = new BonusProduct();
        query.setProductNo(productNo);
        List<BonusProduct> list = FacadeFactory.INSTANCE.getBonusProductBo().find(query, 1, 1);
        return list == null || list.size() == 0 ? null : list.get(0);
    }

    public String getUserNameById(String userId) {
        return UserUtility.getUserNameByUserId(userId);
    }

    public LinkInfo getLinkInfo(String linklocid, String productId) {
        LinkInfo liquery = new LinkInfo();
        liquery.setLinklocid(linklocid);
        liquery.setLinktitle(productId);
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(1);
        List<LinkInfo> lilist = FacadeFactory.INSTANCE.getLinkInfoBo().find(liquery, page);
        return lilist == null || lilist.size() == 0 ? null : lilist.get(0);
    }

    @CmdMapper(value={"/bonus/getexchangeproduct.do"})
    public Object getExchangeProduct(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        ArrayList resultList = new ArrayList();
        int count = 0;
        String userId = "";
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            userId = mainParam.getUserid() + "";
            String actNo = request.getParameter("actNo");
            Integer pageNo = request.getParameterInteger("pageNo", 1);
            Integer pageSize = request.getParameterInteger("pageSize", 20);
            BonusExchange querybe = new BonusExchange();
            querybe.setUserId(userId);
            querybe.setExchangePlatform(actNo);
            querybe.setProductType("gift");
            querybe.setExchangeStatus("2");
            Page page = new Page();
            page.setPageNo(pageNo);
            page.setPageSize(pageSize);
            page.addOrder("exchangeTime", OrderType.DESC);
            count = FacadeFactory.INSTANCE.getBonusExchangeBo().count(querybe);
            List<BonusExchange> list = FacadeFactory.INSTANCE.getBonusExchangeBo().finds(querybe, page);
            for (BonusExchange be : list) {
                BonusProduct bonusProduct = this.findBonusProduct(be.getProductNo());
                if (bonusProduct == null) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("serialNumber", be.getSerialNumber());
                map.put("productName", bonusProduct.getProductName());
                map.put("validPeriod", bonusProduct.getValidPeriod().substring(0, 10));
                map.put("vipLevel", bonusProduct.getMinJinKaLevel() == null ? 0 : bonusProduct.getMinJinKaLevel());
                LinkInfo li = this.getLinkInfo("1263", bonusProduct.getSeqId() + "");
                map.put("desc", li == null || li.getLinkdesc() == null ? "" : li.getLinkdesc());
                map.put("photo", li == null || li.getPicurl() == null ? "" : li.getPicurl());
                map.put("watermark", li == null || li.getSmallpicurl() == null ? "" : li.getSmallpicurl());
                map.put("exchangeTime", be.getExchangeTime());
                map.put("pid", bonusProduct.getSeqId());
                resultList.add(map);
            }
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]\u67e5\u8be2\u6211\u7684\u91d1\u5361\u6fc0\u6d3b\u7801\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        resultMap.put("totalcount", Integer.valueOf(count));
        resultMap.put("items", resultList);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/iscanexchange.do"})
    public Object isCanExchange(XLHttpRequest request, XLHttpResponse response) {
        HashMap resultMap = new HashMap();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        String productIdsString = request.getParameter("pids", "");
        String[] productIds = productIdsString.split("_");
        if (productIds == null || productIds.length == 0) {
            resultMap.put("items", map);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            String userId = mainParam.getUserid() + "";
            for (String productId : productIds) {
                Boolean flag = this.isCanExchange(userId, new Date(), productId);
                map.put(productId, flag);
            }
        }
        catch (Exception e) {
            logger.debug("\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38", e);
        }
        resultMap.put("items", map);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    private boolean isCanExchange(String userId, Date date, String productId) {
        try {
            BonusProduct bp = FacadeFactory.INSTANCE.getBonusProductBo().findBonusProductById(Long.valueOf(productId));
            if (bp == null) {
                return true;
            }
            FacadeFactory.INSTANCE.getBonusExchangeBo().checkUserCanExchange(userId, date, bp);
        }
        catch (NiuRuntimeException e) {
            if ("1041".equals(e.code) || "1040".equals(e.code)) {
                return false;
            }
            logger.error("userId[" + userId + "]productId[" + productId + "] qurey is can exchange exception,caluse:" + e.getMessage());
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]productId[" + productId + "] qurey is can exchange exception,caluse:" + e.getMessage());
        }
        return true;
    }

    private String lastserialnumber(String productNo, String proudctType, String userId, NiuRuntimeException e) {
        if (proudctType == null || !"gift".equals(proudctType)) {
            return "";
        }
        if (userId == null || "".equals(userId) || productNo == null || "".equals(userId)) {
            return "";
        }
        if (e.code == null) {
            return "";
        }
        if (!"1040".equals(e.code) && !"1041".equals(e.code)) {
            return "";
        }
        BonusExchange query = new BonusExchange();
        query.setUserId(userId);
        query.setProductNo(productNo);
        query.setExchangeStatus("2");
        Page page = new Page();
        page.addOrder("exchangeTime", OrderType.DESC);
        page.setPageNo(1);
        page.setPageSize(1);
        List<BonusExchange> belist = FacadeFactory.INSTANCE.getBonusExchangeBo().finds(query, page);
        BonusExchange be = belist == null || belist.size() == 0 ? null : belist.get(0);
        return be == null || be.getSerialNumber() == null ? "" : be.getSerialNumber();
    }

    @CmdMapper(value={"/bonus/getmyexchangeproduct.do"})
    public Object getMyExchangeProduct(XLHttpRequest request, XLHttpResponse response) {
        String actNo = request.getParameter("actNo", "");
        Integer pageNo = request.getParameterInteger("pageNo", 1);
        Integer pageSize = request.getParameterInteger("pageSize", 20);
        MainParam mainParam = null;
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        try {
            mainParam = this.getMainParam(request, response, true);
        }
        catch (Exception e) {
            resultMap.put("count", Integer.valueOf(0));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        String userId = mainParam.getUserid() + "";
        BonusExchange query = new BonusExchange();
        query.setUserId(userId);
        query.setExchangePlatform(actNo);
        query.setExchangeStatus("2");
        query.setExchangeDirect("10");
        Page page = new Page();
        page.setPageNo(pageNo);
        page.setPageSize(pageSize);
        page.addOrder("exchangeTime", OrderType.DESC);
        int count = FacadeFactory.INSTANCE.getBonusExchangeBo().count(query);
        resultMap.put("count", Integer.valueOf(count));
        if (count <= 0) {
            return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
        }
        ArrayList beList = FacadeFactory.INSTANCE.getBonusExchangeBo().finds(query, page);
        beList = beList == null ? new ArrayList() : beList;
        ArrayList resultList = new ArrayList();
        for (BonusExchange be : beList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            BonusProduct product = this.findBonusProduct(be.getProductNo());
            if (product == null) continue;
            map.put("productNo", product.getProductNo());
            map.put("productName", product.getProductName());
            map.put("bonusNum", be.getBonusNum());
            map.put("serialnumber", be.getSerialNumber() == null ? "" : be.getSerialNumber());
            map.put("successTipLink", product.getSuccessTipLink() == null ? "" : product.getSuccessTipLink());
            map.put("successTips", product.getSuccessTips() == null ? "" : product.getSuccessTips());
            map.put("exchangeTime", be.getExchangeTime());
            map.put("giveOutType", product.getGiveOutType() == null ? "" : product.getGiveOutType());
            resultList.add(map);
        }
        resultMap.put("belist", resultList);
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultMap);
    }

    @CmdMapper(value={"/bonus/jinzuanproductexchange.do"})
    public Object jinzuanproductexchange(XLHttpRequest request, XLHttpResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isbackserialnum", false);
        String code = "00";
        String userId = "";
        String productNo = "";
        String productType = "";
        try {
            MainParam mainParam = this.getMainParam(request, response, true);
            BonusExchange exchange = new BonusExchange();
            userId = mainParam.getUserid() + "";
            exchange.setUserId(userId);
            exchange.setUserName(this.getUserName(request));
            productNo = request.getParameter("productNo", "");
            exchange.setProductNo(productNo);
            exchange.setServerId(request.getParameter("exchangeServer", "1"));
            exchange.setGameId(request.getParameter("gameId", ""));
            exchange.setExchangePlatform(request.getParameter("actNo", "nxjifenduihuan"));
            exchange.setExchangeIp("");
            exchange.setRoleId(request.getParameter("roleId", ""));
            String sessionId = request.getCookieValue("sessionid");
            String gameLevelServerId = request.getParameter("serverId", "");
            BonusProduct product = this.findBonusProduct(exchange.getProductNo());
            result.put("successTips", product.getSuccessTips());
            result.put("successTipLink", product.getSuccessTipLink());
            result.put("giveOutType", product.getGiveOutType());
            productType = product.getProductType();
            exchange = new ExchangeProductSo().deal(exchange, gameLevelServerId, sessionId, MemberShipType.JinZuan);
            result.put("serialnumber", exchange.getSerialNumber());
            code = "2".equals(exchange.getExchangeStatus()) ? "00" : exchange.getFailCause();
            String msg = "2".equals(exchange.getExchangeStatus()) ? "\u5151\u6362\u6210\u529f" : exchange.getRemark();
            result.put("code", code);
            result.put("msg", msg);
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (NiuRuntimeException e) {
            logger.error("userId[" + userId + "]\u5151\u6362\u5931\u8d25\u4ea7\u54c1[" + productNo + "],\u5931\u8d25\u4ee3\u7801[" + e.code + "]\u539f\u56e0\uff1a" + e.getMessage());
            result.put("code", e.code);
            result.put("msg", "\u5151\u6362\u5931\u8d25");
            result.put("errormsg", e.getMessage());
            result.put("serialnumber", this.lastserialnumber(productNo, productType, userId, e));
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
        catch (Exception e) {
            logger.error("userId[" + userId + "]\u5151\u6362\u5931\u8d25\u4ea7\u54c1[" + productNo + "]\u539f\u56e0\uff1a" + e.getMessage());
            result.put("code", "99");
            result.put("msg", "\u5151\u6362\u5931\u8d25");
            result.put("errormsg", e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject(0, result);
        }
    }

    @CmdMapper(value={"/bonus/getproductexchangeinfo.do"})
    public Object getProductExchangeInfo(XLHttpRequest request, XLHttpResponse response) {
        this.setInnerContentType(request, response);
        String productNos = request.getParameter("productnos");
        String msg = "";
        if (StringUtils.isEmpty(productNos)) {
            logger.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return JsonObjectUtil.getRtnAndDataJsonObject(-1, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<String> productNoList = StringUtil.getListFromString(productNos, ",");
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (String productno : productNoList) {
            resultList.add(this.getProductInfo(productno));
        }
        return JsonObjectUtil.getRtnAndDataJsonObject(0, resultList);
    }

    private Map<String, Object> getProductInfo(String productNo) {
        CacheManager cacheManager = CacheManager.GetInstance();
        String cacheKey = cacheManager.generateCacheKey(this.getClass(), productNo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("productNo", productNo);
        try {
            BonusProduct product;
            Object obj = cacheManager.get(cacheKey);
            if (obj == null) {
                product = BonusProductBT.checkProductEnoughExchange(productNo);
                cacheManager.put(cacheKey, product, 10L);
            } else {
                product = (BonusProduct)obj;
            }
            if (product == null) {
                String msg = "\u6ca1\u6709\u5bf9\u5e94\u4ea7\u54c1\u7f16\u53f7\u7684\u6709\u6548\u4fe1\u606f:" + productNo;
                logger.error(msg);
                map.put("code", -1);
                map.put("msg", msg);
                return map;
            }
            int partakeCount = (int)(product.getProductSum() - product.getProductNum());
            map.put("code", 0);
            map.put("productNum", product.getProductNum());
            map.put("partakeCount", partakeCount);
        }
        catch (Exception e) {
            String msg = "\u83b7\u53d6\u4ea7\u54c1\u4fe1\u606f\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage();
            logger.error(msg);
            map.put("code", -1);
            map.put("msg", msg);
            return map;
        }
        return map;
    }
}

